/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.InSqlConditionBuilder;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.model.PushRecordSavingStrategy;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.publish.target.lapp.model.DatacenterSyncModel;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappPublishVO;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishInfo;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfig;
import com.kingdee.bos.qing.publish.target.lapp.model.PushRecord;
import com.kingdee.bos.qing.publish.target.lapp.model.PushThumbnailInfoModel;
import com.kingdee.bos.qing.publish.target.lapp.model.ThirdPartyConfig;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.ChatRobotPushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudPushConfigModel;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.schema.model.SchemaRefType;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class LappDao {
    private static final int BLOB_SIZE = 32768;
    private IDBExcuter dbExcuter;

    public LappDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void saveConfigInfo(LappSchedulePushConfigModel pushConfigModel, int source, String userId) throws AbstractQingIntegratedException, SQLException, IOException {
        String sql = "INSERT INTO T_QING_PUSH_CONFIG_INFO (FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FCREATETIME,FUPDATETIME,FTHUMBNAILPATH,FSCHEMATYPE,FLAYOUTTYPE,FPUSHTARGET,FWARNINGRULENAME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Object[] param = new Object[16];
        Date date = new Date();
        int i = 0;
        param[i] = pushConfigModel.getId();
        param[++i] = userId;
        param[++i] = pushConfigModel.getTagId();
        param[++i] = pushConfigModel.getSourceType();
        param[++i] = pushConfigModel.getNameRule();
        param[++i] = this.schedule2Bytes(pushConfigModel.getSchedule());
        param[++i] = pushConfigModel.getName();
        param[++i] = pushConfigModel.getDescText();
        param[++i] = pushConfigModel.isOpenSchedule();
        param[++i] = date;
        param[++i] = date;
        param[++i] = pushConfigModel.getThumbnailPath();
        param[++i] = String.valueOf(source);
        param[++i] = pushConfigModel.getLayoutType();
        param[++i] = pushConfigModel.getPushTargetType();
        param[++i] = pushConfigModel.getWarningRuleName();
        this.dbExcuter.execute(sql, param);
    }

    public void saveChatRobotSchedulePushConfigInfo(ChatRobotPushConfigModel model) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUSH_CHAT_ROBOT (FID,FWEBHOOK,FCONFIGID) VALUES (?,?,?)";
        Object[] param = new Object[]{this.dbExcuter.genStringId("T_QING_PUSH_CHAT_ROBOT"), model.getWebhook(), model.getLappSchedulePushConfigModel().getId()};
        this.dbExcuter.execute(sql, param);
    }

    public void saveMissionCloudSchedulePushConfigInfo(MissionCloudPushConfigModel model) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUSH_MISSIONCLOUD (FID,FPUSHTOTARGET,FUSERIDS,FGROUPIDS,FCONFIGID) VALUES (?,?,?,?,?)";
        Object[] param = new Object[]{this.dbExcuter.genStringId("T_QING_PUSH_MISSIONCLOUD"), model.getPushToTarget(), model.getUserIds(), model.getGroupIds(), model.getLappSchedulePushConfigModel().getId()};
        this.dbExcuter.execute(sql, param);
    }

    public void updateConfigInfo(LappSchedulePushConfigModel pushConfigModel, String userId) throws AbstractQingIntegratedException, SQLException, IOException {
        String sql = "UPDATE T_QING_PUSH_CONFIG_INFO SET FNAME = ?, FNAMERULE = ?, FSCHEDULE = ?, FDESCTEXT = ?, fthumbnailpath = ?, FUPDATETIME = ?, FWARNINGRULENAME = ?, FWARNINGRULESTATUS = ? WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{pushConfigModel.getName(), pushConfigModel.getNameRule(), this.schedule2Bytes(pushConfigModel.getSchedule()), pushConfigModel.getDescText(), pushConfigModel.getThumbnailPath(), new Date(), pushConfigModel.getWarningRuleName(), pushConfigModel.getWarningRuleStatus(), pushConfigModel.getId(), userId};
        this.dbExcuter.execute(sql, param);
    }

    public void updateConfigInfoThumbnail(LappSchedulePushConfigModel pushConfigModel, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUSH_CONFIG_INFO SET fthumbnailpath = ?, FUPDATETIME = ? WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{pushConfigModel.getThumbnailPath(), new Date(), pushConfigModel.getId(), userId};
        this.dbExcuter.execute(sql, param);
    }

    public List<LappSchedulePushConfigModel> loadTimedPublishRefConfigInfo(String userId, String publishSourceEnum, PushTargetType pushTargetType, String imageFileName) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FTHUMBNAILPATH,FLAYOUTTYPE,FSCHEMATYPE,FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS FROM T_QING_PUSH_CONFIG_INFO WHERE FUSERID = ? AND FSOURCETYPE = ? AND FPUSHTARGET = ? AND FTHUMBNAILPATH like ?";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, publishSourceEnum, String.valueOf(pushTargetType.toPersistance()), '%' + imageFileName + '%'}, (ResultHandler)new ResultHandler<List<LappSchedulePushConfigModel>>(){

            public List<LappSchedulePushConfigModel> handle(ResultSet rs) throws SQLException {
                return LappDao.this.dbExcuterHandle(rs);
            }
        });
    }

    public int getTimedPublishRefTimeOfImage(String userId, String publishSourceEnum, PushTargetType pushTargetType, String imageFileName) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS COUNT FROM T_QING_PUSH_CONFIG_INFO WHERE FUSERID = ? AND FSOURCETYPE = ? AND FPUSHTARGET = ? AND FTHUMBNAILPATH like ?";
        return (Integer)this.dbExcuter.query(sql, new Object[]{userId, publishSourceEnum, String.valueOf(pushTargetType.toPersistance()), '%' + imageFileName + '%'}, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("COUNT");
                }
                return 0;
            }
        });
    }

    public void updateChatRobotSchedulePushConfigInfo(ChatRobotPushConfigModel model) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUSH_CHAT_ROBOT SET FWEBHOOK = ? WHERE FCONFIGID = ?";
        Object[] param = new Object[]{model.getWebhook(), model.getLappSchedulePushConfigModel().getId()};
        this.dbExcuter.execute(sql, param);
    }

    public void updateMissionCloudSchedulePushConfigInfo(MissionCloudPushConfigModel model) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUSH_MISSIONCLOUD SET FPUSHTOTARGET = ?, FUSERIDS = ?, FGROUPIDS = ? WHERE FCONFIGID = ?";
        Object[] param = new Object[]{model.getPushToTarget(), model.getUserIds(), model.getGroupIds(), model.getLappSchedulePushConfigModel().getId()};
        this.dbExcuter.execute(sql, param);
    }

    public void saveSchema(String configId, byte[] modelBook) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUSH_CONFIG_SCHEMA (FID,FCONFIGID,FINDEX,FCONTENT) VALUES (?,?,?,?)";
        int length = modelBook.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[4];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                String fId = this.dbExcuter.genStringId("T_QING_PUSH_CONFIG_SCHEMA");
                param[0] = fId;
                param[1] = configId;
                param[2] = i;
                param[3] = this.dbExcuter.createSqlParameterBytes(modelBook, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch(sql, params);
        }
    }

    public String saveThumbnailInfo(LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUSH_THUMBNAIL_INFO (FID,FCONFIGID,FAPEWIDTH,FAPEHEIGHT,FAPETOP,FAPELEFT,FSCOTOP,FSCOLEFT) VALUES (?,?,?,?,?,?,?,?)";
        String fid = this.dbExcuter.genStringId("T_QING_PUSH_THUMBNAIL_INFO");
        Object[] param = new Object[]{fid, pushConfigModel.getId(), pushConfigModel.getApeWidth(), pushConfigModel.getApeHeight(), pushConfigModel.getApeTop(), pushConfigModel.getApeLeft(), pushConfigModel.getScoTop(), pushConfigModel.getScoLeft()};
        this.dbExcuter.execute(sql, param);
        return fid;
    }

    public PushThumbnailInfoModel loadThumbnailInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FCONFIGID,FAPEWIDTH,FAPEHEIGHT,FAPETOP,FAPELEFT,FSCOTOP,FSCOLEFT FROM T_QING_PUSH_THUMBNAIL_INFO WHERE FCONFIGID=?";
        return (PushThumbnailInfoModel)this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<PushThumbnailInfoModel>(){

            public PushThumbnailInfoModel handle(ResultSet rs) throws SQLException {
                PushThumbnailInfoModel pushThumbnailInfoModel = null;
                if (rs.next()) {
                    pushThumbnailInfoModel = new PushThumbnailInfoModel();
                    pushThumbnailInfoModel.setId(rs.getString("FID"));
                    pushThumbnailInfoModel.setConfigId(rs.getString("FCONFIGID"));
                    pushThumbnailInfoModel.setApeHeight(rs.getInt("FAPEHEIGHT"));
                    pushThumbnailInfoModel.setApeWidth(rs.getInt("FAPEWIDTH"));
                    pushThumbnailInfoModel.setApeLeft(rs.getInt("FAPELEFT"));
                    pushThumbnailInfoModel.setApeTop(rs.getInt("FAPETOP"));
                    pushThumbnailInfoModel.setScoLeft(rs.getInt("FSCOLEFT"));
                    pushThumbnailInfoModel.setScoTop(rs.getInt("FSCOTOP"));
                }
                return pushThumbnailInfoModel;
            }
        });
    }

    public byte[] getSchemaContent(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCONTENT FROM T_QING_PUSH_CONFIG_SCHEMA WHERE FCONFIGID=? ORDER BY FINDEX";
        return (byte[])this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        os.write(rs.getBytes("FCONTENT"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    public List<LappSchedulePushConfigModel> loadConfigInfo(String userId, PushTargetType pushTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FTHUMBNAILPATH,FLAYOUTTYPE,FSCHEMATYPE,FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS FROM T_QING_PUSH_CONFIG_INFO WHERE FUSERID = ? AND FPUSHTARGET = ? ORDER BY FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, String.valueOf(pushTargetType.toPersistance())}, (ResultHandler)new ResultHandler<List<LappSchedulePushConfigModel>>(){

            public List<LappSchedulePushConfigModel> handle(ResultSet rs) throws SQLException {
                return LappDao.this.dbExcuterHandle(rs);
            }
        });
    }

    private List<LappSchedulePushConfigModel> dbExcuterHandle(ResultSet rs) throws SQLException {
        ArrayList<LappSchedulePushConfigModel> pushConfigModels = new ArrayList<LappSchedulePushConfigModel>(10);
        while (rs.next()) {
            LappSchedulePushConfigModel pushConfigModel = this.getLappSchedulePushConfigModel(rs);
            pushConfigModels.add(pushConfigModel);
        }
        return pushConfigModels;
    }

    public List<LappSchedulePushConfigModel> loadConfigInfoByTagId(String userId, String tagId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FTHUMBNAILPATH,FLAYOUTTYPE,FSCHEMATYPE,FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS FROM T_QING_PUSH_CONFIG_INFO WHERE FUSERID = ? AND FTAGID = ? ORDER BY FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, tagId}, (ResultHandler)new ResultHandler<List<LappSchedulePushConfigModel>>(){

            public List<LappSchedulePushConfigModel> handle(ResultSet rs) throws SQLException {
                return LappDao.this.dbExcuterHandle(rs);
            }
        });
    }

    public LappSchedulePushConfigModel loadConfigInfoByFid(String fid) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FTHUMBNAILPATH,FLAYOUTTYPE,FSCHEMATYPE,FPUSHTARGET,FWARNINGRULENAME,FWARNINGRULESTATUS FROM T_QING_PUSH_CONFIG_INFO WHERE FID = ?";
        return (LappSchedulePushConfigModel)this.dbExcuter.query(sql, new Object[]{fid}, (ResultHandler)new ResultHandler<LappSchedulePushConfigModel>(){

            public LappSchedulePushConfigModel handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return LappDao.this.getLappSchedulePushConfigModel(rs);
                }
                return null;
            }
        });
    }

    public List<MissionCloudPushConfigModel> loadMissionCloudConfigInfo(String userId, PushTargetType pushTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FID,C.FUSERID,C.FTAGID,C.FSOURCETYPE,C.FNAMERULE,C.FSCHEDULE,C.FNAME,C.FDESCTEXT,C.FOPENSCHEDULE,C.FTHUMBNAILPATH,C.FLAYOUTTYPE,C.FSCHEMATYPE,C.FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS,M.FPUSHTOTARGET,M.FUSERIDS,M.FGROUPIDS FROM T_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUSH_MISSIONCLOUD M ON C.FID = M.FCONFIGID WHERE FUSERID = ? AND FPUSHTARGET = ? ORDER BY FCREATETIME ASC";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, String.valueOf(pushTargetType.toPersistance())}, (ResultHandler)new ResultHandler<List<MissionCloudPushConfigModel>>(){

            public List<MissionCloudPushConfigModel> handle(ResultSet rs) throws SQLException {
                ArrayList<MissionCloudPushConfigModel> pushConfigModels = new ArrayList<MissionCloudPushConfigModel>(10);
                while (rs.next()) {
                    LappSchedulePushConfigModel pushConfigModel = LappDao.this.getLappSchedulePushConfigModel(rs);
                    MissionCloudPushConfigModel model = new MissionCloudPushConfigModel();
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                    model.setPushToTarget(rs.getInt("FPUSHTOTARGET"));
                    model.setUserIds(rs.getString("FUSERIDS"));
                    model.setGroupIds(rs.getString("FGROUPIDS"));
                    pushConfigModels.add(model);
                }
                return pushConfigModels;
            }
        });
    }

    public List<MissionCloudPushConfigModel> loadMissionCloudConfigInfoById(String userId, PushTargetType pushTargetType, String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FID,C.FUSERID,C.FTAGID,C.FSOURCETYPE,C.FNAMERULE,C.FSCHEDULE,C.FNAME,C.FDESCTEXT,C.FOPENSCHEDULE,C.FTHUMBNAILPATH,C.FLAYOUTTYPE,C.FSCHEMATYPE,C.FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS,M.FPUSHTOTARGET,M.FUSERIDS,M.FGROUPIDS FROM T_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUSH_MISSIONCLOUD M ON C.FID = M.FCONFIGID WHERE FUSERID = ? AND FPUSHTARGET = ? AND C.FID = ? ORDER BY FCREATETIME ASC";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, String.valueOf(pushTargetType.toPersistance()), configId}, (ResultHandler)new ResultHandler<List<MissionCloudPushConfigModel>>(){

            public List<MissionCloudPushConfigModel> handle(ResultSet rs) throws SQLException {
                ArrayList<MissionCloudPushConfigModel> pushConfigModels = new ArrayList<MissionCloudPushConfigModel>(10);
                while (rs.next()) {
                    LappSchedulePushConfigModel pushConfigModel = LappDao.this.getLappSchedulePushConfigModel(rs);
                    MissionCloudPushConfigModel model = new MissionCloudPushConfigModel();
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                    model.setPushToTarget(rs.getInt("FPUSHTOTARGET"));
                    model.setUserIds(rs.getString("FUSERIDS"));
                    model.setGroupIds(rs.getString("FGROUPIDS"));
                    pushConfigModels.add(model);
                }
                return pushConfigModels;
            }
        });
    }

    public List<ChatRobotPushConfigModel> loadChatRobotConfigInfo(String userId, PushTargetType pushTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FID,C.FUSERID,C.FTAGID,C.FSOURCETYPE,C.FNAMERULE,C.FSCHEDULE,C.FNAME,C.FDESCTEXT,C.FOPENSCHEDULE,C.FTHUMBNAILPATH,C.FLAYOUTTYPE,C.FSCHEMATYPE,C.FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS,R.FWEBHOOK,R.FAPPID,R.FCORPID FROM T_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUSH_CHAT_ROBOT R ON C.FID = R.FCONFIGID WHERE FUSERID = ? AND FPUSHTARGET = ? ORDER BY FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, String.valueOf(pushTargetType.toPersistance())}, (ResultHandler)new ResultHandler<List<ChatRobotPushConfigModel>>(){

            public List<ChatRobotPushConfigModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ChatRobotPushConfigModel> pushConfigModels = new ArrayList<ChatRobotPushConfigModel>(10);
                while (rs.next()) {
                    LappSchedulePushConfigModel pushConfigModel = LappDao.this.getLappSchedulePushConfigModel(rs);
                    ChatRobotPushConfigModel model = LappDao.this.getChatRobotPushConfigModel(rs);
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                    pushConfigModels.add(model);
                }
                return pushConfigModels;
            }
        });
    }

    public List<ChatRobotPushConfigModel> loadChatRobotConfigInfoById(String userId, PushTargetType pushTargetType, String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FID,C.FUSERID,C.FTAGID,C.FSOURCETYPE,C.FNAMERULE,C.FSCHEDULE,C.FNAME,C.FDESCTEXT,C.FOPENSCHEDULE,C.FTHUMBNAILPATH,C.FLAYOUTTYPE,C.FSCHEMATYPE,C.FPUSHTARGET,FCREATETIME,FWARNINGRULENAME,FWARNINGRULESTATUS,R.FWEBHOOK,R.FAPPID,R.FCORPID FROM T_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUSH_CHAT_ROBOT R ON C.FID = R.FCONFIGID WHERE FUSERID = ? AND FPUSHTARGET = ? AND C.FID = ? ORDER BY FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, String.valueOf(pushTargetType.toPersistance()), configId}, (ResultHandler)new ResultHandler<List<ChatRobotPushConfigModel>>(){

            public List<ChatRobotPushConfigModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ChatRobotPushConfigModel> pushConfigModels = new ArrayList<ChatRobotPushConfigModel>(10);
                while (rs.next()) {
                    LappSchedulePushConfigModel pushConfigModel = LappDao.this.getLappSchedulePushConfigModel(rs);
                    ChatRobotPushConfigModel model = LappDao.this.getChatRobotPushConfigModel(rs);
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                    pushConfigModels.add(model);
                }
                return pushConfigModels;
            }
        });
    }

    private LappSchedulePushConfigModel getLappSchedulePushConfigModel(ResultSet rs) throws SQLException {
        LappSchedulePushConfigModel pushConfigModel = new LappSchedulePushConfigModel();
        pushConfigModel.setId(rs.getString("FID"));
        pushConfigModel.setTagId(rs.getString("FTAGID"));
        pushConfigModel.setSourceType(rs.getString("FSOURCETYPE"));
        pushConfigModel.setNameRule(rs.getString("FNAMERULE"));
        pushConfigModel.setSchedule(this.bytes2Schedule(rs.getBytes("FSCHEDULE")));
        pushConfigModel.setName(rs.getString("FNAME"));
        pushConfigModel.setDescText(rs.getString("FDESCTEXT"));
        pushConfigModel.setOpenSchedule(rs.getBoolean("FOPENSCHEDULE"));
        pushConfigModel.setThumbnailPath(rs.getString("FTHUMBNAILPATH"));
        pushConfigModel.setLayoutType(rs.getString("FLAYOUTTYPE"));
        pushConfigModel.setSchemaType(rs.getInt("FSCHEMATYPE"));
        pushConfigModel.setUserId(rs.getString("FUSERID"));
        pushConfigModel.setPushTargetType(rs.getInt("FPUSHTARGET"));
        pushConfigModel.setCreateTime(rs.getTimestamp("FCREATETIME").getTime());
        pushConfigModel.setWarningRuleName(rs.getString("FWARNINGRULENAME"));
        boolean warningRuleStatus = rs.getString("FWARNINGRULESTATUS") == null ? true : rs.getBoolean("FWARNINGRULESTATUS");
        pushConfigModel.setWarningRuleStatus(warningRuleStatus);
        return pushConfigModel;
    }

    public LappSchedulePushConfigModel loadPushConfigById(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FCREATETIME,FUPDATETIME,FTHUMBNAILPATH,FSCHEMATYPE,FLAYOUTTYPE,FPUSHTARGET,FWARNINGRULENAME,FWARNINGRULESTATUS FROM T_QING_PUSH_CONFIG_INFO WHERE FID = ? AND FUSERID = ?";
        return (LappSchedulePushConfigModel)this.dbExcuter.query(sql, new Object[]{configId, userId}, (ResultHandler)new ResultHandler<LappSchedulePushConfigModel>(){

            public LappSchedulePushConfigModel handle(ResultSet rs) throws SQLException {
                LappSchedulePushConfigModel pushConfigModel = new LappSchedulePushConfigModel();
                if (rs.next()) {
                    pushConfigModel = LappDao.this.getLappSchedulePushConfigModel(rs);
                }
                return pushConfigModel;
            }
        });
    }

    public Map<String, LappSchedulePushConfigModel> loadPushConfigByIds(String userId, List<String> configIds) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlInIdBuilder = new StringBuilder();
        sqlInIdBuilder.append("?");
        for (int i = 1; i < configIds.size(); ++i) {
            sqlInIdBuilder.append(",?");
        }
        String sqlInId = sqlInIdBuilder.toString();
        ArrayList<String> params = new ArrayList<String>();
        params.add(userId);
        params.addAll(configIds);
        String sql = "SELECT FID,FUSERID,FTAGID,FSOURCETYPE,FNAMERULE,FSCHEDULE,FNAME,FDESCTEXT,FOPENSCHEDULE,FCREATETIME,FUPDATETIME,FTHUMBNAILPATH,FSCHEMATYPE,FLAYOUTTYPE,FPUSHTARGET,FWARNINGRULENAME,FWARNINGRULESTATUS FROM T_QING_PUSH_CONFIG_INFO WHERE FUSERID = ? AND FID IN (" + sqlInId + ")";
        return (Map)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Map<String, LappSchedulePushConfigModel>>(){

            public Map<String, LappSchedulePushConfigModel> handle(ResultSet rs) throws SQLException {
                HashMap<String, LappSchedulePushConfigModel> result = new HashMap<String, LappSchedulePushConfigModel>(16);
                while (rs.next()) {
                    LappSchedulePushConfigModel pushConfigModel = LappDao.this.getLappSchedulePushConfigModel(rs);
                    result.put(pushConfigModel.getId(), pushConfigModel);
                }
                return result;
            }
        });
    }

    public void deleteConfigInfo(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_CONFIG_INFO WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{configId, userId};
        this.dbExcuter.execute(sql, param);
    }

    public void deleteChatRobotSchedulePushConfigInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_CHAT_ROBOT WHERE FCONFIGID = ?";
        Object[] param = new Object[]{configId};
        this.dbExcuter.execute(sql, param);
    }

    public void deleteMissionCloudSchedulePushConfigInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_MISSIONCLOUD WHERE FCONFIGID = ?";
        Object[] param = new Object[]{configId};
        this.dbExcuter.execute(sql, param);
    }

    public List<PushRecord> loadAllPushRecord(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FPUSHTIME, FANALYSISID, FCONFIGID, FPUBLISHID, FERRORMESSAGE FROM T_QING_PUSH_RECORD WHERE FCONFIGID = ? AND FUSERID = ? ORDER BY FPUSHTIME DESC";
        return (List)this.dbExcuter.query(sql, new Object[]{configId, userId}, (ResultHandler)new ResultHandler<List<PushRecord>>(){

            public List<PushRecord> handle(ResultSet rs) throws SQLException {
                ArrayList<PushRecord> pushRecordModels = new ArrayList<PushRecord>(10);
                while (rs.next()) {
                    PushRecord pushRecordModel = new PushRecord();
                    pushRecordModel.setId(rs.getString("FID"));
                    pushRecordModel.setName(rs.getString("FNAME"));
                    pushRecordModel.setConfigId(rs.getString("FCONFIGID"));
                    long pushTimeStamp = rs.getTimestamp("FPUSHTIME").getTime() / 1000L;
                    pushRecordModel.setPushTime(DateUtils.timeStampToString((long)pushTimeStamp, (String)"yyyy-MM-dd HH:mm:ss"));
                    pushRecordModel.setAnalysisId(rs.getString("FANALYSISID"));
                    pushRecordModel.setPublishId(rs.getString("FPUBLISHID"));
                    pushRecordModels.add(pushRecordModel);
                }
                return pushRecordModels;
            }
        });
    }

    public Map<String, Long> loadQingFileSizeByPublishId(final List<PushRecord> pushRecordList) throws AbstractQingIntegratedException, SQLException {
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(pushRecordList.size());
        StringBuilder sql = new StringBuilder("select ffromid, ffilesize from t_qing_file_resource where ");
        sql.append(inSqlConditionBuilder.build("ffromid"));
        Object[] params = new Object[pushRecordList.size()];
        for (int i = 0; i < pushRecordList.size(); ++i) {
            params[i] = pushRecordList.get(i).getPublishId();
        }
        return (Map)this.dbExcuter.query(sql.toString(), params, (ResultHandler)new ResultHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws SQLException {
                HashMap<String, Long> qingFileSizeMap = new HashMap<String, Long>(pushRecordList.size());
                while (rs.next()) {
                    String fFromid = rs.getString("ffromid");
                    String fFilesize = rs.getString("ffilesize");
                    long fileSize = Long.parseLong(fFilesize == null ? "0" : fFilesize);
                    if (qingFileSizeMap.containsKey(fFromid)) {
                        Long fFileSize = (Long)qingFileSizeMap.get(fFromid);
                        qingFileSizeMap.put(fFromid, fileSize + fFileSize);
                        continue;
                    }
                    qingFileSizeMap.put(fFromid, fileSize);
                }
                return qingFileSizeMap;
            }
        });
    }

    public String savePushRecord(PushRecord pushRecordModel, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUSH_RECORD (FID,FCONFIGID,FANALYSISID,FNAME,FPUSHTIME,FUSERID,FPUBLISHID) VALUES (?,?,?,?,?,?,?)";
        Object[] param = new Object[7];
        String fid = this.dbExcuter.genStringId("T_QING_PUSH_RECORD");
        param[0] = fid;
        param[1] = pushRecordModel.getConfigId();
        param[2] = StringUtils.isBlank((CharSequence)pushRecordModel.getAnalysisId()) ? " " : pushRecordModel.getAnalysisId();
        param[3] = pushRecordModel.getName();
        param[4] = new Date();
        param[5] = userId;
        param[6] = StringUtils.isBlank((CharSequence)pushRecordModel.getPublishId()) ? " " : pushRecordModel.getPublishId();
        this.dbExcuter.execute(sql, param);
        return fid;
    }

    public void deletePushRecord(String id, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_RECORD WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{id, userId};
        this.dbExcuter.execute(sql, param);
    }

    public void updateScheduleState(boolean openSchedule, String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUSH_CONFIG_INFO SET FOPENSCHEDULE = ? WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{openSchedule, configId, userId};
        this.dbExcuter.execute(sql, param);
    }

    public void updateScheduleAndWarningState(boolean openSchedule, boolean warningRuleStatus, String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUSH_CONFIG_INFO SET FOPENSCHEDULE = ?, FWARNINGRULESTATUS = ? WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{openSchedule, warningRuleStatus, configId, userId};
        this.dbExcuter.execute(sql, param);
    }

    public void updateWarningState(boolean warningRuleStatus, String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUSH_CONFIG_INFO SET FWARNINGRULESTATUS = ? WHERE FID = ? AND FUSERID = ?";
        Object[] param = new Object[]{warningRuleStatus, configId, userId};
        this.dbExcuter.execute(sql, param);
    }

    public void deletePushRecordByConfigId(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_RECORD WHERE FCONFIGID = ? AND FUSERID = ?";
        Object[] param = new Object[]{configId, userId};
        this.dbExcuter.execute(sql, param);
    }

    public void deleteSchemaByConfigId(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_CONFIG_SCHEMA WHERE FCONFIGID = ?";
        this.dbExcuter.execute(sql, new Object[]{configId});
    }

    private byte[] schedule2Bytes(Schedule schedule) throws IOException {
        if (schedule == null) {
            return null;
        }
        Element xml = new Element("Schedule");
        schedule.toXml(xml);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XmlUtil.save((Element)xml, (OutputStream)outputStream);
        byte[] scheduleModelBytes = outputStream.toByteArray();
        return scheduleModelBytes;
    }

    private Schedule bytes2Schedule(byte[] scheduleBytes) throws SQLException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Schedule schedule = new Schedule();
        try {
            outputStream.write(scheduleBytes);
            if (outputStream.size() > 0) {
                Element nodeSchedule = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                schedule.fromXml(nodeSchedule);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (JDOMException e) {
            throw new SQLException(e);
        }
        catch (ScheduleModelParseException e) {
            throw new SQLException(e);
        }
        return schedule;
    }

    public byte[] loadFilterContent(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FFILTER FROM T_QING_PUSH_BILL WHERE FCONFIGID = ? ORDER BY FFILTERINDEX ASC";
        return (byte[])this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        byte[] bytes = rs.getBytes("FFILTER");
                        if (bytes == null) continue;
                        os.write(bytes);
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    public void insertBill(TimingPushBillPO bill) throws AbstractQingIntegratedException, SQLException {
        String blockSql = "INSERT INTO T_QING_PUSH_BILL(FID, FCONFIGID, FFILTER, FFILTERINDEX, FCTRLKEY) VALUES (?,?,?,?,?)";
        byte[] blockData = bill.getFilterContent();
        Integer length = blockData == null ? 1 : blockData.length;
        int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
        int contentSize = 0;
        int offset = 0;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < count; ++i) {
            Object[] param = new Object[5];
            contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
            param[0] = this.dbExcuter.genStringId("T_QING_PUSH_BILL");
            param[1] = bill.getConfigId();
            param[2] = this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize);
            param[3] = i;
            param[4] = bill.getCtrKey();
            offset += contentSize;
            params.add(param);
        }
        this.dbExcuter.executeBatch(blockSql, params);
    }

    public TimingPushBillPO loadBillInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCTRLKEY, FFILTER FROM T_QING_PUSH_BILL WHERE FCONFIGID = ? ORDER BY FFILTERINDEX ASC";
        return (TimingPushBillPO)this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<TimingPushBillPO>(){

            public TimingPushBillPO handle(ResultSet rs) throws SQLException {
                TimingPushBillPO bill = new TimingPushBillPO();
                if (rs.next()) {
                    bill.setCtrKey(rs.getString("FCTRLKEY"));
                }
                return bill;
            }
        });
    }

    public void deleteBillConfig(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_BILL WHERE FCONFIGID = ?";
        this.dbExcuter.execute(sql, new Object[]{configId});
    }

    public void deleteThumbnailInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_THUMBNAIL_INFO WHERE FCONFIGID = ?";
        this.dbExcuter.execute(sql, new Object[]{configId});
    }

    public ChatRobotPushConfigModel getChatRobotPushConfigModel(final LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FWEBHOOK FROM T_QING_PUSH_CHAT_ROBOT C WHERE C.FCONFIGID = ?";
        return (ChatRobotPushConfigModel)this.dbExcuter.query(sql, new Object[]{pushConfigModel.getId()}, (ResultHandler)new ResultHandler<ChatRobotPushConfigModel>(){

            public ChatRobotPushConfigModel handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ChatRobotPushConfigModel model = LappDao.this.getChatRobotPushConfigModel(rs);
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                    return model;
                }
                return null;
            }
        });
    }

    private ChatRobotPushConfigModel getChatRobotPushConfigModel(ResultSet rs) throws SQLException {
        ChatRobotPushConfigModel model = new ChatRobotPushConfigModel();
        model.setWebhook(rs.getString("FWEBHOOK"));
        return model;
    }

    public MissionCloudPushConfigModel getMissionCloudPushConfigModel(final LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT M.FPUSHTOTARGET,M.FUSERIDS,M.FGROUPIDS FROM T_QING_PUSH_MISSIONCLOUD M WHERE FCONFIGID=?";
        return (MissionCloudPushConfigModel)this.dbExcuter.query(sql, new Object[]{pushConfigModel.getId()}, (ResultHandler)new ResultHandler<MissionCloudPushConfigModel>(){

            public MissionCloudPushConfigModel handle(ResultSet rs) throws SQLException {
                MissionCloudPushConfigModel model = new MissionCloudPushConfigModel();
                if (rs.next()) {
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                    model.setPushToTarget(rs.getInt("FPUSHTOTARGET"));
                    model.setUserIds(rs.getString("FUSERIDS"));
                    model.setGroupIds(rs.getString("FGROUPIDS"));
                    model.setLappSchedulePushConfigModel(pushConfigModel);
                }
                return model;
            }
        });
    }

    public void saveSchemaRef(OutsideReference outsideRef, String schemaId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUSH_SCHEMA_REF (FID,FUID,FSCHEMAID,FREFTOID,FFULLPATH,FREFTYPE) VALUES(?,?,?,?,?,?)";
        Object[] param = new Object[6];
        String fid = this.dbExcuter.genStringId("T_QING_PUSH_SCHEMA_REF");
        param[0] = fid;
        param[1] = outsideRef.getUid();
        param[2] = schemaId;
        param[3] = StringUtils.isNotBlank((CharSequence)outsideRef.getRefToId()) ? outsideRef.getRefToId() : null;
        param[4] = StringUtils.isNotBlank((CharSequence)outsideRef.getRefToId()) ? null : outsideRef.getRefToFullPath();
        param[5] = SchemaRefType.valueOf(outsideRef.getRefType()).toPersistance();
        this.dbExcuter.execute(sql, param);
    }

    public List<OutsideReference> loadSchemaRef(String schemaId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FUID,FREFTOID,FFULLPATH,FREFTYPE FROM T_QING_PUSH_SCHEMA_REF WHERE FSCHEMAID=?";
        return (List)this.dbExcuter.query(sql, new Object[]{schemaId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FREFTOID"));
                    outsideRef.setRefToFullPath(rs.getString("FFULLPATH"));
                    outsideRef.setRefType(SchemaRefType.getSchemaRefType(rs.getInt("FREFTYPE")).toString());
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public void deleteSchemaRef(String schemaId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUSH_SCHEMA_REF WHERE FSCHEMAID=?";
        this.dbExcuter.execute(sql, new Object[]{schemaId});
    }

    public Boolean checkPushRecordByPublishId(String publishId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FPUSHTIME, FANALYSISID, FCONFIGID, FPUBLISHID, FERRORMESSAGE FROM T_QING_PUSH_RECORD WHERE FPUBLISHID = ? AND FUSERID = ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{publishId, userId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    public PublishInfo getPushRecordByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT A.FCREATORID, A.FCREATETIME FROM T_QING_PUBLISH A WHERE A.FID = ?";
        return (PublishInfo)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<PublishInfo>(){

            public PublishInfo handle(ResultSet rs) throws SQLException {
                PublishInfo publishInfo = new PublishInfo();
                while (rs.next()) {
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                }
                return publishInfo;
            }
        });
    }

    public List<String> loadSchemaRefListByFullPath(String fullPath) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FUID,FREFTOID,FFULLPATH,FREFTYPE FROM T_QING_PUSH_SCHEMA_REF WHERE FFULLPATH=?";
        return (List)this.dbExcuter.query(sql, new Object[]{fullPath}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refIds = new ArrayList<String>(10);
                while (rs.next()) {
                    refIds.add(rs.getString("FID"));
                }
                return refIds;
            }
        });
    }

    public void updateSchemaRefToIdByRefId(String fId, String mapId) throws SQLException, AbstractQingIntegratedException {
        String sql = "UPDATE T_QING_PUSH_SCHEMA_REF SET FREFTOID = ?, FFULLPATH = ? WHERE FID = ?";
        Object[] param = new Object[]{mapId, null, fId};
        this.dbExcuter.execute(sql, param);
    }

    public List<String> loadSchemaRefListByRefToId(String refToId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FUID,FREFTOID,FFULLPATH,FREFTYPE FROM T_QING_PUSH_SCHEMA_REF WHERE FREFTOID=?";
        return (List)this.dbExcuter.query(sql, new Object[]{refToId}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> refIds = new ArrayList<String>(10);
                while (rs.next()) {
                    refIds.add(rs.getString("FId"));
                }
                return refIds;
            }
        });
    }

    public void updateRefFullPathByRefId(String fId, String fullpath) throws SQLException, AbstractQingIntegratedException {
        String sql = "UPDATE T_QING_PUSH_SCHEMA_REF SET FREFTOID = ?, FFULLPATH = ? WHERE FID = ?";
        Object[] param = new Object[]{null, fullpath, fId};
        this.dbExcuter.execute(sql, param);
    }

    public List<String> getAllMobilePublishIds() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT A.FID FROM T_QING_PUBLISH A LEFT JOIN T_QING_PUSH_RECORD B ON A.FID = B.FPUBLISHID WHERE FTYPE = ? AND B.FPUBLISHID IS NULL";
        return (List)this.dbExcuter.query(sql, new Object[]{String.valueOf(2)}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishIds = new ArrayList<String>(10);
                while (rs.next()) {
                    publishIds.add(rs.getString("FID"));
                }
                return publishIds;
            }
        });
    }

    public List<String> getAllMobilePublishInfos(String userId, List<String> ids) throws AbstractQingIntegratedException, SQLException {
        if (ids.isEmpty()) {
            return new ArrayList<String>();
        }
        StringBuilder sqlInIdBuilder = new StringBuilder();
        sqlInIdBuilder.append("?");
        for (int i = 1; i < ids.size(); ++i) {
            sqlInIdBuilder.append(",?");
        }
        String sqlInId = sqlInIdBuilder.toString();
        String sql = "SELECT A.FID FROM T_QING_PUBLISH A WHERE A.FCREATORID = ? and A.FTYPE = ? AND A.FID IN (" + sqlInId + ")";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(String.valueOf(2));
        queryValue.addAll(ids);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishIds = new ArrayList<String>(10);
                while (rs.next()) {
                    publishIds.add(rs.getString("FID"));
                }
                return publishIds;
            }
        });
    }

    public void saveSyncInfo(DatacenterSyncModel syncModel) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_DATACENTER (FDATACENTERUUID, FSYNCSTATUS, FSYNCTIME) VALUES(?,?,?)";
        Object[] params = new Object[]{syncModel.getDatacenterUUID(), syncModel.getSyncStatus().toPersistance(), new Date(syncModel.getSyncTime())};
        this.dbExcuter.execute(sql, params);
    }

    public void updateSyncInfo(DatacenterSyncModel syncModel) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_DATACENTER SET FSYNCSTATUS = ?, FSYNCTIME = ? WHERE FDATACENTERUUID = ?";
        Object[] params = new Object[]{syncModel.getSyncStatus().toPersistance(), new Date(syncModel.getSyncTime()), syncModel.getDatacenterUUID()};
        this.dbExcuter.execute(sql, params);
    }

    public void updateSyncTime(String datacenterUUID) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_DATACENTER SET FSYNCTIME = ? WHERE FDATACENTERUUID = ?";
        Object[] params = new Object[]{new Date(), datacenterUUID};
        this.dbExcuter.execute(sql, params);
    }

    public DatacenterSyncModel getSyncInfo() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FDATACENTERUUID, FSYNCSTATUS, FSYNCTIME FROM T_QING_DATACENTER";
        return (DatacenterSyncModel)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<DatacenterSyncModel>(){

            public DatacenterSyncModel handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    DatacenterSyncModel syncModel = new DatacenterSyncModel();
                    syncModel.setDatacenterUUID(rs.getString("FDATACENTERUUID"));
                    syncModel.setSyncStatus(DatacenterSyncModel.SyncStatusEnum.fromPersistance(rs.getString("FSYNCSTATUS")));
                    syncModel.setSyncTime(rs.getDate("FSYNCTIME").getTime());
                    return syncModel;
                }
                return null;
            }
        });
    }

    public List<LappPublishVO> loadPublishInfos(String[] publishIds, final QingContext qingContext) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlInIdBuilder = new StringBuilder();
        sqlInIdBuilder.append("?");
        for (int i = 1; i < publishIds.length; ++i) {
            sqlInIdBuilder.append(",?");
        }
        String sqlInId = sqlInIdBuilder.toString();
        String sql = "SELECT P.FID, P.FTYPE, P.FTAGID, THEME.FNAME, TQTG.FNAME AS THEMEGROUPNAME, P.FCARRYDATA, FSOURCE FROM T_QING_PUBLISH P LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID where P.FID in (" + sqlInId + ")";
        return (List)this.dbExcuter.query(sql, (Object[])publishIds, (ResultHandler)new ResultHandler<List<LappPublishVO>>(){

            public List<LappPublishVO> handle(ResultSet rs) throws SQLException {
                ArrayList<LappPublishVO> lappPublishVOList = new ArrayList<LappPublishVO>(10);
                HashMap publishSourceGroupIdMap = new HashMap(16);
                while (rs.next()) {
                    LappPublishVO lappPublishVO = new LappPublishVO();
                    lappPublishVO.setId(rs.getString("FID"));
                    lappPublishVO.setPublishTargetType(Integer.parseInt(rs.getString("FTYPE")));
                    String publishSourceType = rs.getString("FSOURCE");
                    if (PublishSourceEnum.bill.name().equals(publishSourceType) || PublishSourceEnum.report.name().equals(publishSourceType) || PublishSourceEnum.control.name().equals(publishSourceType)) {
                        try {
                            lappPublishVO.setPublishSourceName(IntegratedHelper.queryFormDisplayName((String)rs.getString("FTAGID"), (String)publishSourceType, (QingContext)qingContext, (IDBExcuter)LappDao.this.dbExcuter));
                            HashMap<String, String> hashMap = new HashMap<String, String>(4);
                            hashMap.put("fTagId", rs.getString("FTAGID"));
                            hashMap.put("publishSourceType", publishSourceType);
                            publishSourceGroupIdMap.put(lappPublishVO.getId(), hashMap);
                        }
                        catch (IntegratedRuntimeException integratedRuntimeException) {
                            throw new SQLException(integratedRuntimeException);
                        }
                    } else {
                        lappPublishVO.setPublishSourceName(rs.getString("FNAME"));
                        lappPublishVO.setPublishSourceGroupName(rs.getString("THEMEGROUPNAME"));
                    }
                    lappPublishVO.setPublishSourceType(publishSourceType);
                    int n = rs.getInt("FCARRYDATA");
                    lappPublishVO.setCarryData(n == 1);
                    lappPublishVOList.add(lappPublishVO);
                }
                Map publishSourceGroupNameMap = IntegratedHelper.queryFormFullPath(publishSourceGroupIdMap.values(), (QingContext)qingContext);
                for (PublishVO publishVO : lappPublishVOList) {
                    String fTagId;
                    Map publishSourceGroupId = (Map)publishSourceGroupIdMap.get(publishVO.getId());
                    if (MapUtils.isEmpty((Map)publishSourceGroupId) || (fTagId = (String)publishSourceGroupId.get("fTagId")) == null) continue;
                    publishVO.setPublishSourceGroupName((String)publishSourceGroupNameMap.get(fTagId));
                }
                return lappPublishVOList;
            }
        });
    }

    public ThirdPartyConfig getThirdPartyConfig() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FAPPID, FAPPUSERTYPE, FAPPIMAGEFILE FROM T_QING_THIRDPARTY_CONFIG";
        return (ThirdPartyConfig)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<ThirdPartyConfig>(){

            public ThirdPartyConfig handle(ResultSet rs) throws SQLException {
                ThirdPartyConfig thirdPartyConfig = new ThirdPartyConfig();
                if (rs.next()) {
                    thirdPartyConfig.setId(rs.getString("FID"));
                    thirdPartyConfig.setAppId(rs.getString("FAPPID"));
                    thirdPartyConfig.setAppUserType(ThirdPartyConfig.AppUserType.fromPersistance(rs.getString("FAPPUSERTYPE")));
                    thirdPartyConfig.setAppImageFile(rs.getString("FAPPIMAGEFILE"));
                }
                return thirdPartyConfig;
            }
        });
    }

    public void saveThirdPartyConfig(ThirdPartyConfig thirdPartyConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_THIRDPARTY_CONFIG (FID, FAPPID, FAPPUSERTYPE, FAPPIMAGEFILE) VALUES(?,?,?,?)";
        String fId = this.dbExcuter.genStringId("T_QING_THIRDPARTY_CONFIG");
        Object[] params = new Object[]{fId, thirdPartyConfig.getAppId(), thirdPartyConfig.getAppUserType().toPersistance(), thirdPartyConfig.getAppImageFile()};
        this.dbExcuter.execute(sql, params);
        thirdPartyConfig.setId(fId);
    }

    public void updateThirdPartyConfig(ThirdPartyConfig thirdPartyConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_THIRDPARTY_CONFIG SET FAPPID = ?, FAPPUSERTYPE = ?, FAPPIMAGEFILE = ? WHERE FID = ?";
        Object[] params = new Object[]{thirdPartyConfig.getAppId(), thirdPartyConfig.getAppUserType().toPersistance(), thirdPartyConfig.getAppImageFile(), thirdPartyConfig.getId()};
        this.dbExcuter.execute(sql, params);
    }

    public void deleteThirdPartyConfig(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_THIRDPARTY_CONFIG WHERE FID = ?";
        Object[] params = new Object[]{id};
        this.dbExcuter.execute(sql, params);
    }

    public void updatePublishLappConfig(PublishLappConfig publishLappConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_PUB_LAPP_CONFIG SET FAPPTYPE = ?, FORDERID = ? WHERE FID = ?";
        Object[] params = new Object[]{String.valueOf((Object)publishLappConfig.getAppType()), publishLappConfig.getOrderId(), publishLappConfig.getId()};
        this.dbExcuter.execute(sql, params);
    }

    public String savePublishLappConfig(PublishLappConfig publishLappConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_PUB_LAPP_CONFIG (FID, FAPPTYPE, FORDERID) VALUES(?,?,?)";
        String id = this.dbExcuter.genStringId("T_QING_PUB_LAPP_CONFIG");
        Object[] params = new Object[]{id, String.valueOf((Object)publishLappConfig.getAppType()), publishLappConfig.getOrderId()};
        this.dbExcuter.execute(sql, params);
        return id;
    }

    public void deletePublishLappConfig(LappContext.AppType appType) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_LAPP_CONFIG WHERE FAPPTYPE = ?";
        Object[] params = new Object[]{String.valueOf((Object)appType)};
        this.dbExcuter.execute(sql, params);
    }

    public List<PublishLappConfig> loadPublishLappConfigs() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FAPPTYPE, FORDERID FROM T_QING_PUB_LAPP_CONFIG ORDER BY FORDERID DESC";
        return (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<PublishLappConfig>>(){

            public List<PublishLappConfig> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishLappConfig> publishLappConfigs = new ArrayList<PublishLappConfig>(10);
                while (rs.next()) {
                    PublishLappConfig publishLappConfig = new PublishLappConfig();
                    publishLappConfig.setId(rs.getString("FID"));
                    publishLappConfig.setAppType(LappContext.AppType.valueOf(rs.getString("FAPPTYPE")));
                    publishLappConfig.setOrderId(rs.getInt("FORDERID"));
                    publishLappConfigs.add(publishLappConfig);
                }
                return publishLappConfigs;
            }
        });
    }

    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(String userId, Date dateMin, Date dateMax) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME, PCI.FID AS CONFIGID,  PCI.FPUSHTARGET AS PUSHTYPE FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FUSERID=? AND SE.FMETHODNAME='pushExecute' AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=?) SE  LEFT JOIN T_QING_PUSH_CONFIG_INFO PCI ON SE.FSOURCEID=PCI.FID ";
        Object[] params = new Object[]{userId, dateMin, dateMax};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ScheduleExecuteVO>>(){

            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ScheduleExecuteVO> voList = new ArrayList<ScheduleExecuteVO>(10);
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    scheduleExecute.setSourceName(rs.getString("FSOURCENAME"));
                    String pushType = rs.getString("PUSHTYPE");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceTargetType(pushType);
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                    scheduleExecute.setSourceExist(StringUtils.isNotBlank((CharSequence)rs.getString("CONFIGID")));
                    voList.add(scheduleExecute);
                }
                return voList;
            }
        });
    }

    public ScheduleExecuteVO findById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME,  PCI.FPUSHTARGET AS PUSHTYPE FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FID=? AND SE.FMETHODNAME='pushExecute') SE  LEFT JOIN T_QING_PUSH_CONFIG_INFO PCI ON SE.FSOURCEID=PCI.FID ";
        Object[] params = new Object[]{id};
        return (ScheduleExecuteVO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ScheduleExecuteVO>(){

            public ScheduleExecuteVO handle(ResultSet rs) throws SQLException {
                ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                if (rs.next()) {
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    String pushType = rs.getString("PUSHTYPE");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceTargetType(pushType);
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    scheduleExecute.setExecuteTime(Long.valueOf(rs.getTimestamp("FEXECUTETIME").getTime()));
                    if (rs.getTimestamp("FENDTIME") != null) {
                        scheduleExecute.setEndTime(Long.valueOf(rs.getTimestamp("FENDTIME").getTime()));
                    }
                }
                return scheduleExecute;
            }
        });
    }

    public PushRecordConfig loadPushRecordConfigInfo(String userId, int pushTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fid, fuserid, fpushtargettype, fstrategy, fvalue from t_qing_push_record_config where fpushtargettype = ? and fuserid = ? ";
        Object[] params = new Object[]{Character.valueOf(String.valueOf(pushTargetType).charAt(0)), userId};
        return (PushRecordConfig)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<PushRecordConfig>(){

            public PushRecordConfig handle(ResultSet rs) throws SQLException {
                PushRecordConfig lappPushRecordConfig = new PushRecordConfig();
                if (rs.next()) {
                    lappPushRecordConfig.setId(rs.getString("fid"));
                    lappPushRecordConfig.setUserId(rs.getString("fuserid"));
                    lappPushRecordConfig.setPushTargetType(rs.getInt("fpushtargettype"));
                    int fStrategy = Integer.parseInt(rs.getString("fstrategy"));
                    lappPushRecordConfig.setStrategy(PushRecordSavingStrategy.getStrategyByIndex(fStrategy).name());
                    lappPushRecordConfig.setValue(rs.getString("fvalue"));
                    return lappPushRecordConfig;
                }
                return null;
            }
        });
    }

    public void deleteLappPushRecordConfig(PushRecordConfig lappPushRecordConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "delete from t_qing_push_record_config where fuserid = ? and fpushtargettype = ?";
        Object[] params = new Object[]{lappPushRecordConfig.getUserId(), Character.valueOf(String.valueOf(lappPushRecordConfig.getPushTargetType()).charAt(0))};
        this.dbExcuter.execute(sql, params);
    }

    public void updateLappPushRecordConfig(PushRecordConfig lappPushRecordConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "update t_qing_push_record_config set fstrategy = ?, fvalue = ? where fuserid = ? and fpushtargettype = ?";
        Object[] params = new Object[]{PushRecordSavingStrategy.getStrategyByName(lappPushRecordConfig.getStrategy()), lappPushRecordConfig.getValue(), lappPushRecordConfig.getUserId(), Character.valueOf(String.valueOf(lappPushRecordConfig.getPushTargetType()).charAt(0))};
        this.dbExcuter.execute(sql, params);
    }

    public String createLappPushRecordPKId() {
        return this.dbExcuter.genStringId("T_QING_PUSH_RECORD_STORAGE_SET");
    }

    public void saveLappPushRecordConfig(PushRecordConfig lappPushRecordConfig) throws AbstractQingIntegratedException, SQLException {
        String sql = "insert into t_qing_push_record_config (fid, fuserid, fpushtargettype, fstrategy, fvalue) values (?, ?, ?, ?, ?)";
        Object[] params = new Object[]{lappPushRecordConfig.getId(), lappPushRecordConfig.getUserId(), Character.valueOf(String.valueOf(lappPushRecordConfig.getPushTargetType()).charAt(0)), PushRecordSavingStrategy.getStrategyByName(lappPushRecordConfig.getStrategy()), lappPushRecordConfig.getValue()};
        this.dbExcuter.execute(sql, params);
    }

    public Integer loadPublishInfoCount(String configId, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT count(*) sum FROM T_QING_PUSH_RECORD WHERE FCONFIGID = ? AND FUSERID = ?";
        Object[] param = new Object[]{configId, userId};
        return (Integer)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return Integer.parseInt(rs.getString("sum"));
                }
                return 0;
            }
        });
    }

    public List<PushRecord> loadPushRecordNotInSpecifiedTime(String configId, String userId, Date date) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fid, fpublishid from T_QING_PUSH_RECORD where fconfigid = ? and fuserid = ? and fpushtime < ?";
        Object[] params = new Object[]{configId, userId, date};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<PushRecord>>(){

            public List<PushRecord> handle(ResultSet rs) throws SQLException {
                ArrayList<PushRecord> delPushRecordList = new ArrayList<PushRecord>(20);
                while (rs.next()) {
                    PushRecord pushRecord = new PushRecord();
                    String fid = rs.getString("FID");
                    pushRecord.setId(fid);
                    String fPublishid = rs.getString("FPUBLISHID");
                    if (!fPublishid.isEmpty()) {
                        pushRecord.setPublishId(fPublishid);
                    }
                    delPushRecordList.add(pushRecord);
                }
                return delPushRecordList;
            }
        });
    }

    public List<PushRecord> loadPublishInfoByMonthLimit(final String configId, String userId, Date subTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fid, fpublishid, fname from t_qing_push_record where fconfigid = ? and fuserid = ? and fpushtime < ? order by fpushtime asc";
        Object[] params = new Object[]{configId, userId, subTime};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<PushRecord>>(){

            public List<PushRecord> handle(ResultSet rs) throws SQLException {
                ArrayList<PushRecord> delPushRecordList = new ArrayList<PushRecord>(20);
                while (rs.next()) {
                    PushRecord pushRecord = new PushRecord();
                    String fid = rs.getString("FID");
                    pushRecord.setId(fid);
                    pushRecord.setConfigId(configId);
                    String fpublishid = rs.getString("FPUBLISHID");
                    String fname = rs.getString("FNAME");
                    pushRecord.setName(fname);
                    if (!fpublishid.isEmpty()) {
                        pushRecord.setPublishId(fpublishid);
                    }
                    delPushRecordList.add(pushRecord);
                }
                return delPushRecordList;
            }
        });
    }

    public List<PushRecord> selectPublishInfoByMonthLimit(String configId, String userId, List<Date> subTime, final int setValue) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FPUSHTIME, FANALYSISID, FCONFIGID, FPUBLISHID, FERRORMESSAGE FROM T_QING_PUSH_RECORD WHERE FCONFIGID = ? AND FUSERID = ? and FPUSHTIME between ? and ? ORDER BY FPUSHTIME DESC";
        Object[] params = new Object[]{configId, userId, subTime.get(1), subTime.get(0)};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<PushRecord>>(){

            public List<PushRecord> handle(ResultSet rs) throws SQLException {
                int value = setValue;
                ArrayList<PushRecord> listVO = new ArrayList<PushRecord>(10);
                while (rs.next()) {
                    PushRecord vo = new PushRecord();
                    vo.setId(rs.getString("FID"));
                    vo.setName(rs.getString("FNAME"));
                    vo.setPushTime(rs.getString("FPUSHTIME"));
                    vo.setAnalysisId(rs.getString("FANALYSISID"));
                    vo.setConfigId(rs.getString("FCONFIGID"));
                    vo.setPublishId(rs.getString("FPUBLISHID"));
                    vo.setErrorMessage(rs.getString("FERRORMESSAGE"));
                    if (value <= 0) continue;
                    listVO.add(vo);
                    --value;
                }
                return listVO;
            }
        });
    }

    public int loadPushTargetTypeByConfigId(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FPUSHTARGET FROM T_QING_PUSH_CONFIG_INFO C LEFT JOIN T_QING_PUSH_CHAT_ROBOT R ON C.FID = R.FCONFIGID WHERE R.fconfigid = ?";
        Object[] param = new Object[]{configId};
        return (Integer)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return Integer.parseInt(rs.getString("FPUSHTARGET"));
                }
                return -1;
            }
        });
    }
}

