/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.model;

public class LappContext {
    private String userId;
    private String lappUserId;
    private UserType lappUserType;
    private String corpId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLappUserId() {
        return this.lappUserId;
    }

    public void setLappUserId(String lappUserId) {
        this.lappUserId = lappUserId;
    }

    public String getLappUserType() {
        if (this.lappUserType == null) {
            return null;
        }
        return this.lappUserType.toPersistance();
    }

    public void setLappUserType(UserType lappUserType) {
        this.lappUserType = lappUserType;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public static enum AppType {
        yzj(UserType.YZJ_OPENID),
        dingdingoffline(UserType.DINGDING_OFFLINE_CORPID_USERID),
        wxqyh(UserType.WXQYH_CORPID_USERID),
        missioncloud(UserType.MISSION_CLOUD_PHONE),
        welink(UserType.WELINK_CORPID_USERID),
        wxxcx(UserType.WXXCX_PHONE),
        thirdparty(UserType.THIRD_PARTY),
        jdy(UserType.JDY_USERID);

        private UserType userType;

        private AppType(UserType userType) {
            this.userType = userType;
        }

        public UserType toPersistance() {
            return this.userType;
        }

        public static AppType getAppTypeByUserType(UserType currentUserType) {
            for (AppType appType : AppType.values()) {
                if (appType.toPersistance() != currentUserType) continue;
                return appType;
            }
            return null;
        }
    }

    public static enum UserType {
        YZJ_OPENID("10"),
        DINGDING_CORPID_USERID("20"),
        WXQYH_CORPID_USERID("30"),
        MISSION_CLOUD_PHONE("40"),
        ROBOT_PUSH("50"),
        DINGDING_OFFLINE_CORPID_USERID("60"),
        WELINK_CORPID_USERID("70"),
        WXXCX_PHONE("80"),
        ALL("90"),
        THIRD_PARTY("99"),
        JDY_USERID("A0");

        private String id;

        private UserType(String id) {
            this.id = id;
        }

        public String toPersistance() {
            return this.id;
        }
    }
}

