/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushDomain;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.ChatRobotSchedulePushDomain;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissonCloudSchedulePushDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class LappSchedulePushDomainFactory {
    private static Map<PushTargetType, Constructor<? extends AbstractLappSchedulePushDomain>> LAPP_SCHEDULE_PUSH_DOMAIN_CLASS_MAP = new HashMap<PushTargetType, Constructor<? extends AbstractLappSchedulePushDomain>>();

    public static AbstractLappSchedulePushDomain createDomain(PushTargetType pushTargetType, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        Constructor<? extends AbstractLappSchedulePushDomain> constructor = LAPP_SCHEDULE_PUSH_DOMAIN_CLASS_MAP.get(pushTargetType);
        if (constructor == null) {
            return null;
        }
        try {
            return constructor.newInstance(qingContext, tx, dbExcuter, scheduleEngine);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void register(PushTargetType pushTargetType, Class<? extends AbstractLappSchedulePushDomain> clazz) {
        try {
            Constructor<? extends AbstractLappSchedulePushDomain> constructor = clazz.getConstructor(QingContext.class, ITransactionManagement.class, IDBExcuter.class, IScheduleEngine.class);
            LAPP_SCHEDULE_PUSH_DOMAIN_CLASS_MAP.put(pushTargetType, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        LappSchedulePushDomainFactory.register(PushTargetType.YZJ_ROBOT, ChatRobotSchedulePushDomain.class);
        LappSchedulePushDomainFactory.register(PushTargetType.WXQYH_ROBOT, ChatRobotSchedulePushDomain.class);
        LappSchedulePushDomainFactory.register(PushTargetType.MISSION_CLOUD_SERVICE_ACCOUNT, MissonCloudSchedulePushDomain.class);
        LappSchedulePushDomainFactory.register(PushTargetType.DINGDING_ROBOT, ChatRobotSchedulePushDomain.class);
    }
}

