/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.publish.model.PushTargetType;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.dingding.DingDingRobotPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.wxqyh.WxqyhRobotPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.yzj.YZJRobotPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudPushMessageService;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class PushMessageServiceFactory {
    private static Map<PushTargetType, Constructor<? extends AbstractPushMessageService>> robotPushMessageServiceClassMap = new HashMap<PushTargetType, Constructor<? extends AbstractPushMessageService>>();

    public static void registPushMessageServcie(PushTargetType pushTargetType, Class<? extends AbstractPushMessageService> clazz) {
        try {
            Constructor<? extends AbstractPushMessageService> constructor = clazz.getConstructor(QingContext.class, ITransactionManagement.class, IDBExcuter.class, IScheduleEngine.class);
            robotPushMessageServiceClassMap.put(pushTargetType, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static AbstractPushMessageService createPushMessageServcie(PushTargetType pushTargetType, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        Constructor<? extends AbstractPushMessageService> constructor = robotPushMessageServiceClassMap.get(pushTargetType);
        if (constructor == null) {
            return null;
        }
        try {
            return constructor.newInstance(qingContext, tx, dbExcuter, scheduleEngine);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PushMessageServiceFactory.registPushMessageServcie(PushTargetType.YZJ_ROBOT, YZJRobotPushMessageService.class);
        PushMessageServiceFactory.registPushMessageServcie(PushTargetType.WXQYH_ROBOT, WxqyhRobotPushMessageService.class);
        PushMessageServiceFactory.registPushMessageServcie(PushTargetType.MISSION_CLOUD_SERVICE_ACCOUNT, MissionCloudPushMessageService.class);
        PushMessageServiceFactory.registPushMessageServcie(PushTargetType.DINGDING_ROBOT, DingDingRobotPushMessageService.class);
    }
}

