/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push.chatrobot;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.model.AbstractPushMessageModel;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageResult;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.chatrobot.ChatRobotPushConfigModel;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;

public abstract class AbstractChatRobotMessageService
extends AbstractPushMessageService {
    public AbstractChatRobotMessageService(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private ChatRobotPushConfigModel getPushConfigModel(LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, ExecuteSqlException {
        try {
            ChatRobotPushConfigModel model = this.getLappDao().getChatRobotPushConfigModel(pushConfigModel);
            return model;
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to load chatrobot config model", e);
        }
    }

    @Override
    public AbstractPushMessageResult doPush(String lappEntranceUrl, LappSchedulePushConfigModel pushConfigModel, String thumbnailFileName, String analysisId, String publishId) throws AbstractQingException {
        ChatRobotPushConfigModel model = this.getPushConfigModel(pushConfigModel);
        this.tryToAddSystemTimeForPushName(pushConfigModel);
        String webhook = model.getWebhook();
        AbstractPushMessageResult pushMessageResult = null;
        AbstractPushMessageModel pushMessageModel = this.getPushModel(model, lappEntranceUrl, thumbnailFileName);
        String result = null;
        String pushMessage = JsonUtil.encodeToString((Object)pushMessageModel);
        result = HttpUtil.post((String)webhook, null, (String)pushMessage);
        LogUtil.info((String)("webhook: " + webhook + ", pushMessageModel: " + pushMessage));
        try {
            pushMessageResult = (AbstractPushMessageResult)JsonUtil.decodeFromString((String)result, this.getPushResult().getClass());
        }
        catch (Exception e) {
            LogUtil.error((String)("send message error: " + result + ", param: " + pushMessageModel));
            throw new LappException(Messages.getMLS((String)"pushError", (String)"\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\u53ef\u80fd\u662f\u540d\u79f0\u6216\u8005\u63cf\u8ff0\u4e2d\u5b58\u5728\u7279\u6b8a\u5b57\u7b26", (Messages.ProjectName)Messages.ProjectName.QING_THEME), e, 4300999);
        }
        if (pushMessageResult.getErrorCode() != 0) {
            LogUtil.error((String)("send message error: " + result + ", param: " + pushMessageModel));
            this.deleteGarbage(pushConfigModel, analysisId, publishId);
        }
        return pushMessageResult;
    }
}

