/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp.push.missioncloud;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.publish.target.lapp.exception.ExecuteSqlException;
import com.kingdee.bos.qing.publish.target.lapp.exception.LappException;
import com.kingdee.bos.qing.publish.target.lapp.exception.OOSConfigNotFoundException;
import com.kingdee.bos.qing.publish.target.lapp.model.AbstractPushMessageModel;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.LappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractLappSchedulePushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageResult;
import com.kingdee.bos.qing.publish.target.lapp.push.AbstractPushMessageService;
import com.kingdee.bos.qing.publish.target.lapp.push.PushMessageResult;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudImgTextPushModel;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudPushConfigModel;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudUploadImgTextModel;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissionCloudUploadImgTextResult;
import com.kingdee.bos.qing.publish.target.lapp.push.missioncloud.MissonCloudServiceAccount;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.URLUtil;
import java.sql.SQLException;

public class MissionCloudPushMessageService
extends AbstractPushMessageService {
    private ILappStrategy lappStrategy;

    public MissionCloudPushMessageService(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    @Override
    public AbstractPushMessageModel getPushModel() {
        return new MissionCloudUploadImgTextModel();
    }

    @Override
    public AbstractPushMessageResult getPushResult() {
        return new PushMessageResult();
    }

    @Override
    public String getWebpageUrl(AbstractLappSchedulePushConfigModel model, String lappEntranceUrl) {
        String webpageUrl = URLUtil.appendParamToUrl((String)lappEntranceUrl, (String)"appType", (String)LappContext.AppType.missioncloud.toString());
        return webpageUrl;
    }

    @Override
    public AbstractPushMessageResult doPush(String lappEntranceUrl, LappSchedulePushConfigModel pushConfigModel, String thumbnailFileName, String analysisId, String publishId) throws AbstractQingException {
        MissionCloudPushConfigModel model = this.getPushConfigModel(pushConfigModel);
        this.tryToAddSystemTimeForPushName(pushConfigModel);
        MissonCloudServiceAccount serviceAccount = this.getLappStrategyImpl().getMissonCloudServiceAccount();
        if (serviceAccount == null) {
            throw new OOSConfigNotFoundException();
        }
        String pushServerUrl = serviceAccount.getPushServerUrl();
        String uploadImageTextUrl = pushServerUrl + "/api/bus/uploadImgText?accessToken=" + serviceAccount.getAccessToken();
        AbstractPushMessageResult pushMessageResult = null;
        AbstractPushMessageModel pushMessageModel = this.getPushModel(model, lappEntranceUrl, thumbnailFileName);
        String result = null;
        try {
            String pushMessage = JsonUtil.encodeToString((Object)pushMessageModel);
            result = HttpUtil.post((String)uploadImageTextUrl, null, (String)pushMessage);
            LogUtil.info((String)("uploadImageTextUrl: " + uploadImageTextUrl + ", pushMessageModel: " + pushMessage));
            pushMessageResult = (MissionCloudUploadImgTextResult)JsonUtil.decodeFromString((String)result, MissionCloudUploadImgTextResult.class);
            pushMessageResult = (AbstractPushMessageResult)JsonUtil.decodeFromString((String)result, MissionCloudUploadImgTextResult.class);
            if (pushMessageResult.getErrorCode() == 0) {
                String mediaId = ((MissionCloudUploadImgTextResult)pushMessageResult).getMediaId();
                String pushImageTextUrl = pushServerUrl + "/api/bus/imgTextPushMsg?accessToken=" + serviceAccount.getAccessToken();
                MissionCloudImgTextPushModel imgTextPushModel = new MissionCloudImgTextPushModel();
                imgTextPushModel.setAppKey(serviceAccount.getAppKey());
                imgTextPushModel.setSid(serviceAccount.getSid());
                imgTextPushModel.setUserIds(model.getUserIds());
                imgTextPushModel.setGroupIds(model.getGroupIds());
                imgTextPushModel.setMediaId(mediaId);
                pushMessage = JsonUtil.encodeToString((Object)imgTextPushModel);
                result = HttpUtil.post((String)pushImageTextUrl, null, (String)pushMessage);
                if (pushMessageResult.getErrorCode() != 0) {
                    LogUtil.error((String)("mission cloud push image text error: " + result + ", param: " + pushMessageModel));
                    this.deleteGarbage(pushConfigModel, analysisId, publishId);
                }
            } else {
                LogUtil.error((String)("mission cloud upload image text error: " + result + ", param: " + pushMessageModel));
                this.deleteGarbage(pushConfigModel, analysisId, publishId);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("send message error: " + result + ", param: " + pushMessageModel));
            throw new LappException(e);
        }
        return pushMessageResult;
    }

    private MissionCloudPushConfigModel getPushConfigModel(LappSchedulePushConfigModel pushConfigModel) throws AbstractQingIntegratedException, ExecuteSqlException {
        try {
            MissionCloudPushConfigModel model = this.getLappDao().getMissionCloudPushConfigModel(pushConfigModel);
            return model;
        }
        catch (SQLException e) {
            throw new ExecuteSqlException("fail to load chatrobot config model", e);
        }
    }

    private ILappStrategy getLappStrategyImpl() {
        this.lappStrategy = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
        if (this.lappStrategy == null) {
            throw new RuntimeException("cannot found the implement of ILappStrategy.");
        }
        return this.lappStrategy;
    }
}

