/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.thumbnail.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishScheduleModelException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.publish.thumbnail.dao.ThumbnailInfoDao;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailInfo;
import com.kingdee.bos.qing.publish.thumbnail.model.ThumbnailVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.AbstractJobParam;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.jdom2.JDOMException;

public class ThumbnailDomain {
    protected QingContext qingContext;
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    protected IScheduleEngine scheduleEngine;
    private ThumbnailInfoDao thumbnailInfoDao;
    private PublishInfoDao publishDao;
    private SchemaManageDao schemaManageDao;

    public ThumbnailDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
        this.scheduleEngine = scheduleEngine;
    }

    public SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (null == this.publishDao) {
            this.publishDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishDao;
    }

    protected ThumbnailInfoDao getThumbnailInfoDao() {
        if (null == this.thumbnailInfoDao) {
            this.thumbnailInfoDao = new ThumbnailInfoDao(this.dbExcuter);
        }
        return this.thumbnailInfoDao;
    }

    public ThumbnailVO saveThumbnailInfoWithoutTx(ThumbnailInfo thumbnailInfo, String userId, boolean overWrite) throws PersistentModelParseException, PersistentModelTooModernException, PublishException, AbstractQingIntegratedException, SQLException, ScheduleEngineException, JDOMException, IOException, ScheduleModelParseException {
        PublishPO publishPO;
        ThumbnailVO vo = new ThumbnailVO();
        Schedule schedule = thumbnailInfo.getSchedule();
        boolean isSchedule = schedule != null && schedule.getPeriod() != null;
        String publishId = thumbnailInfo.getPublishId();
        String analysisId = thumbnailInfo.getAnalysisId();
        if (overWrite) {
            this.deleteByPublishIdWithoutTx(publishId);
        }
        if ((publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId)) == null) {
            throw new PublishNotFoundException();
        }
        String schemaId = thumbnailInfo.getSchemaId();
        ModelBook modelBook = null;
        if (schemaId == null) {
            schemaId = this.dbExcuter.genStringId("T_QING_SASchema");
            modelBook = thumbnailInfo.getModelBook();
        } else {
            schemaId = this.dbExcuter.genStringId("T_QING_SASchema");
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(thumbnailInfo.getSchemaId());
            modelBook = ModelBookUtil.fromByte(schemaContent);
        }
        this.getSchemaManageDao().insertSchemaContentAndRef(schemaId, modelBook);
        this.saveJob(analysisId, publishId, publishPO.getName(), schedule, userId);
        String thumbnailId = this.getThumbnailInfoDao().saveThumbnailInfo(thumbnailInfo, publishId, schemaId, analysisId);
        vo.setThumbnailInfoId(thumbnailId);
        vo.setConAvailable(isSchedule ? LappHelper.isConnAvailable() : true);
        return vo;
    }

    public ThumbnailVO saveThumbnailInfo(ThumbnailInfo thumbnailInfo, String userId, boolean overWrite) throws AbstractQingIntegratedException, PublishException, PersistentModelParseException, PersistentModelTooModernException {
        try {
            this.tx.beginRequired();
            ThumbnailVO thumbnailVO = this.saveThumbnailInfoWithoutTx(thumbnailInfo, userId, overWrite);
            return thumbnailVO;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        catch (ScheduleModelParseException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        catch (JDOMException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        catch (IOException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    private void saveJob(String analysisId, String publishId, String publishName, Schedule schedule, String userId) throws AbstractQingIntegratedException, ScheduleModelParseException, ScheduleEngineException {
        if (schedule == null || schedule.getPeriod() == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("JobType", "updateLappThumbnail");
        params.put("analysisId", analysisId);
        params.put("userId", userId);
        params.put("publishId", publishId);
        params.put("publishName", publishName);
        AbstractJobParam jobParam = this.scheduleEngine.createJobParam(params);
        this.scheduleEngine.saveJob(this.qingContext, this.qingContext.getUserId(), this.qingContext.getSystemVarStringValue(SystemVarType.ORG_ID), this.qingContext.getTenantId(), null, schedule, jobParam);
    }

    public void deleteByPublishIdWithoutTx(String publishId) throws AbstractQingIntegratedException, SQLException, ScheduleEngineException, PublishException, PersistentModelParseException, PersistentModelTooModernException {
        ThumbnailInfo model = this.loadThumbnailInfoByPublishId(publishId);
        if (null != model) {
            this.getThumbnailInfoDao().deleteThumbnailInfo(publishId);
            this.getSchemaManageDao().deleteSchemaContent(model.getSchemaId());
            this.scheduleEngine.deleteJob(this.qingContext, null, model.getAnalysisId());
        }
    }

    public ThumbnailInfo loadThumbnailInfoByAnalysisId(String analysisId) throws PublishScheduleModelException, AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException {
        ThumbnailInfo model = this.getThumbnailInfoDao().getThumbnailModelByAnalysisId(analysisId);
        if (model != null) {
            byte[] schemaContent = this.getSchemaManageDao().loadSchemaContent(model.getSchemaId());
            ModelBook modelBook = ModelBookUtil.fromByte(schemaContent);
            model.setModelBook(modelBook);
        }
        return model;
    }

    public ThumbnailInfo loadThumbnailInfoByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, PublishScheduleModelException, PublishNotFoundException {
        SchemaBO schemaBO;
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
        if (publishPO == null) {
            throw new PublishNotFoundException();
        }
        ThumbnailInfo model = this.getThumbnailInfoDao().getThumbnailModelByPublishId(publishId);
        if (model == null && (schemaBO = this.getSchemaManageDao().findSchemaById(publishPO.getSchemaId())) != null && schemaBO.getSource() == 1) {
            model = new ThumbnailInfo();
            model.setAnalysisId(null);
            model.setPublishId(publishId);
            model.setApertureLeft(0);
            model.setApertureTop(0);
            model.setApertureHeight(720);
            model.setApertureWidth(360);
            model.setScrollLeft(0);
            model.setScrollTop(0);
            model.setSchemaId(publishPO.getSchemaId());
            model.setSchedule(null);
        }
        return model;
    }

    public ThumbnailInfo loadThumbnailInfoForExport(String publishId) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, PublishScheduleModelException, PublishNotFoundException {
        PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
        if (publishPO == null) {
            throw new PublishNotFoundException();
        }
        return this.getThumbnailInfoDao().getThumbnailModelByPublishId(publishId);
    }

    public void saveOrUpdateThumbnailInfo(ThumbnailInfo thumbnailInfo, String userId) throws PublishException, AbstractQingIntegratedException, PersistentModelParseException, PersistentModelTooModernException {
        try {
            String publishId = thumbnailInfo.getPublishId();
            ThumbnailInfo model = this.getThumbnailInfoDao().getThumbnailModelByPublishId(publishId);
            if (model == null) {
                this.saveThumbnailInfo(thumbnailInfo, userId, false);
            } else {
                this.updateThumbnailInfo(thumbnailInfo, userId);
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void updateThumbnailInfo(ThumbnailInfo thumbnailInfo, String userId) throws AbstractQingIntegratedException, PublishException {
        try {
            this.tx.beginRequired();
            String publishId = thumbnailInfo.getPublishId();
            String analysisId = thumbnailInfo.getAnalysisId();
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
            if (publishPO == null) {
                throw new PublishNotFoundException();
            }
            Schedule schedule = thumbnailInfo.getSchedule();
            this.getThumbnailInfoDao().updateThumbnailSchedule(schedule, analysisId);
            this.scheduleEngine.deleteJob(this.qingContext, null, analysisId);
            this.saveJob(analysisId, publishId, publishPO.getName(), schedule, userId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (PublishException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        catch (ScheduleModelParseException e) {
            this.tx.markRollback();
            throw new PublishException((Throwable)e);
        }
        finally {
            this.tx.end();
        }
    }

    public void updateThumbnailSchema(String analysisId, String schemaId) throws AbstractQingIntegratedException, SQLException {
        this.getThumbnailInfoDao().updateThumbnailSchema(analysisId, schemaId);
    }
}

