/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.subject.domain;

import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.thread.ListenableFutureCallback;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.entity.EntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.runtime.ISubjectPrepareDataCallBack;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.linkage.ILinkageSourceSupporter;
import com.kingdee.bos.qing.linkage.LinkageSourceDomainFactory;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.vo.SaveMessageVo;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelEntityDestroyedException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelEntityDestroyedOwnerException;
import com.kingdee.bos.qing.preparedata.exception.SubjectPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.subject.ExtractEntityCallBackImpl;
import com.kingdee.bos.qing.preparedata.task.SubjectEntityExtractTask;
import com.kingdee.bos.qing.schedule.model.Schedule;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.subject.model.SubjectBO;
import com.kingdee.bos.qing.subject.model.SubjectDataBO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom2.Element;

public class SubjectRuntimeDomain {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    private IThemeDao iThemeDao;
    private IThemeGroupDao iThemeGroupDao;
    private ISubjectDao iSubjectDao;
    private MessageDomain messageDomain;

    public SubjectRuntimeDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    protected ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    private MessageDomain getMessageDomain() {
        if (this.messageDomain == null) {
            this.messageDomain = new MessageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.messageDomain;
    }

    public ThemePO getThemeByID(String themeId) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().getThemeByID(themeId);
    }

    public SubjectDataBO findNewData(String userId, String themeId) throws AbstractQingIntegratedException, SQLException {
        return this.getSubjectDao().findNewData(userId, themeId);
    }

    private static Map<String, AbstractEntity> buildEntityNameMap(Box box) {
        HashMap<String, AbstractEntity> entityNamesMap = new HashMap<String, AbstractEntity>(box.getEntities().size());
        for (AbstractEntity entity : box.getEntities()) {
            entityNamesMap.put(entity.getName(), entity);
        }
        return entityNamesMap;
    }

    public LinkageContext getLinkageContext(Box box) {
        HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(box.getSources().size());
        HashMap<String, List<AbstractEntity>> sourcesEntityMap = new HashMap<String, List<AbstractEntity>>();
        for (AbstractSource source : box.getSources()) {
            sourcesMap.put(source.getName(), source);
        }
        for (AbstractEntity entity : box.getEntities()) {
            List subEntities;
            if (entity instanceof Entity && this.isNeedCollectLinkageFormInfo(entity, sourcesMap)) {
                this.putSourcesEntityMap(entity, ((Entity)entity).getSource(), sourcesEntityMap);
                continue;
            }
            if (!(entity instanceof UnionEntity) || (subEntities = ((UnionEntity)entity).getChildren()).isEmpty() || !this.isNeedCollectLinkageFormInfo((AbstractEntity)subEntities.get(0), sourcesMap)) continue;
            String entitySourceName = ((Entity)subEntities.get(0)).getSource();
            this.putSourcesEntityMap(entity, entitySourceName, sourcesEntityMap);
        }
        return this.collectLinkageFormInfo(sourcesEntityMap, sourcesMap);
    }

    private void putSourcesEntityMap(AbstractEntity entity, String entitySourceName, Map<String, List<AbstractEntity>> sourcesEntityMap) {
        List<AbstractEntity> entityList = sourcesEntityMap.get(entitySourceName);
        if (CollectionUtils.isEmpty(entityList)) {
            entityList = new ArrayList<AbstractEntity>();
            entityList.add(entity);
            sourcesEntityMap.put(entitySourceName, entityList);
        } else {
            entityList.add(entity);
        }
    }

    private boolean isNeedCollectLinkageFormInfo(AbstractEntity entity, Map<String, AbstractSource> sourcesMap) {
        String entitySourceName = ((Entity)entity).getSource();
        AbstractSource entitySource = sourcesMap.get(entitySourceName);
        ILinkageSourceSupporter iLinkageSourceSupporter = LinkageSourceDomainFactory.getLinkageSourceDomain(entitySource);
        return iLinkageSourceSupporter != null;
    }

    private LinkageContext collectLinkageFormInfo(Map<String, List<AbstractEntity>> sourcesEntityMap, Map<String, AbstractSource> sourcesMap) {
        LinkageContext linkageContext = new LinkageContext();
        for (Map.Entry<String, List<AbstractEntity>> entry : sourcesEntityMap.entrySet()) {
            AbstractSource entitySource = sourcesMap.get(entry.getKey());
            ILinkageSourceSupporter iLinkageSourceSupporter = LinkageSourceDomainFactory.getLinkageSourceDomain(entitySource);
            if (iLinkageSourceSupporter == null) continue;
            iLinkageSourceSupporter.collectLinkageFormInfo(this.qingContext, linkageContext, entry.getValue());
        }
        return linkageContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubjectDataBO prepareData(Box box, ThemePO themePo, String ownerId, ISubjectPrepareDataCallBack backFunction, boolean isSaveModel, boolean startBySchedule) throws InterruptedException, AbstractDataSourceException, SQLException, AbstractQingIntegratedException, SubjectDataModelingException, SubjectPrepareDataException, QingLockRequireException {
        String userId = this.qingContext.getUserId();
        SubjectDataBO dataBO = new SubjectDataBO();
        dataBO.setCreateTime(new Date());
        dataBO.setThemeID(themePo.getThemeID());
        if (backFunction != null) {
            backFunction.setTotalEntity(box.getEntities().size());
        }
        if (box.getEntities().isEmpty()) {
            if (!ownerId.equals(userId)) throw new SubjectModelEntityDestroyedException();
            throw new SubjectModelEntityDestroyedOwnerException();
        }
        ArrayList<IQingFile> dataFileAccesses = new ArrayList<IQingFile>();
        TraceSpan traceSpan = null;
        try {
            traceSpan = TracerUtil.create((String)Messages.getMLS((QingContext)this.qingContext, (String)"subjectExtractData", (String)"\u4e1a\u52a1\u4e3b\u9898\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".prepareData");
            this.doExecuteDirectModelEntity(box, backFunction);
            this.doExecuteExtractEntity(box, themePo, isSaveModel, startBySchedule, dataBO, dataFileAccesses, backFunction, ownerId);
        }
        catch (SQLException e) {
            try {
                FileFactory.clearFile(dataFileAccesses);
                throw e;
                catch (InterruptedException e2) {
                    FileFactory.clearFile(dataFileAccesses);
                    throw e2;
                }
                catch (AbstractQingIntegratedException e3) {
                    FileFactory.clearFile(dataFileAccesses);
                    throw e3;
                }
                catch (DataSourcePersistenceException e4) {
                    FileFactory.clearFile(dataFileAccesses);
                    throw e4;
                }
                catch (SubjectDataModelingException e5) {
                    FileFactory.clearFile(dataFileAccesses);
                    throw e5;
                }
                catch (AbstractDataSourceException e6) {
                    FileFactory.clearFile(dataFileAccesses);
                    throw e6;
                }
                catch (QingLockRequireException e7) {
                    FileFactory.clearFile(dataFileAccesses);
                    throw e7;
                }
            }
            catch (Throwable throwable) {
                TracerUtil.close(traceSpan);
                throw throwable;
            }
        }
        TracerUtil.close((TraceSpan)traceSpan);
        return dataBO;
    }

    private void doExecuteDirectModelEntity(Box box, ISubjectPrepareDataCallBack backFunction) {
        for (AbstractEntity entity : box.getEntities()) {
            if (entity.hasExtractModel() || backFunction == null) continue;
            backFunction.startOneEntity();
            backFunction.finishOneEntity();
        }
    }

    private List<AbstractEntity> extractModelEntity(Box box, Map<String, IQingFile> qingFileMap, ThemePO themePo, boolean isSaveModel) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        boolean isSchedule = this.isSchedule(box);
        for (AbstractEntity entity : box.getEntities()) {
            IQingFile dataFile = this.createExtractDataFile(themePo, isSaveModel, isSchedule, entity);
            qingFileMap.put(entity.getName(), dataFile);
            if (!entity.hasExtractModel()) continue;
            entities.add(entity);
        }
        return entities;
    }

    private void doExecuteExtractEntity(Box box, ThemePO themePo, boolean isSaveModel, boolean startBySchedule, SubjectDataBO dataBO, List<IQingFile> dataFileAccesses, ISubjectPrepareDataCallBack backFunction, String ownerId) throws InterruptedException, SubjectDataModelingException, AbstractQingIntegratedException, QingLockRequireException, AbstractDataSourceException, SQLException {
        SubjectBO subjectBO = this.buildSubjectBO(box, themePo, ownerId);
        StringBuffer warmingMessage = new StringBuffer();
        AtomicReference<Object> exceptionMessage = new AtomicReference<Object>(null);
        int size = box.getEntities().size();
        HashMap<String, IQingFile> qingFileMap = new HashMap<String, IQingFile>(size);
        List<AbstractEntity> extractModelEntityList = this.extractModelEntity(box, qingFileMap, themePo, isSaveModel);
        int extractSize = extractModelEntityList.size();
        HashMap<String, String> dataFiles = new HashMap<String, String>(size);
        this.handleDataFile(dataFileAccesses, dataFiles, qingFileMap);
        AbstractEntity entityExecuteInlocal = null;
        CountDownLatch latch = new CountDownLatch(0);
        if (extractSize > 0) {
            entityExecuteInlocal = extractModelEntityList.remove(extractSize - 1);
            latch = new CountDownLatch(extractSize - 1);
        }
        List<SubjectEntityExtractTask> rejectedTask = this.extractAsyncInThreadPool(qingFileMap, extractModelEntityList, latch, backFunction, subjectBO, warmingMessage, exceptionMessage);
        this.executeRejectedTask(rejectedTask, latch, warmingMessage);
        this.extractEntityInLocal(qingFileMap, backFunction, subjectBO, warmingMessage, entityExecuteInlocal);
        latch.await();
        this.checkException(exceptionMessage);
        dataBO.setDataFile(dataFiles);
        dataBO.setUpdateTime(new Date());
        dataBO.setWarmingMessage(warmingMessage.length() > 0 ? warmingMessage.toString() : null);
        if (isSaveModel && this.isSchedule(box)) {
            String boxModelFile = this.saveBoxModelFile(box);
            if (null != boxModelFile) {
                dataBO.setBoxModelFile(boxModelFile);
            }
            this.saveSubjectDataBo(dataBO, dataFileAccesses, ownerId);
            if (!startBySchedule) {
                String sourceName = themePo.getThemeName();
                String messageTitle = Messages.getMLS((QingContext)this.qingContext, (String)"messageTitleQuartzSuccess", (String)"\u201c$param5\u201d\u5df2\u751f\u6210\u4e00\u4efd\u8c03\u5ea6\u6570\u636e\u6587\u4ef6", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING).replace("$param5", sourceName);
                this.saveMessage(Collections.singletonList(themePo.getUserID()), messageTitle, themePo.getThemeID(), BizTypeEnum.THEME_SUCCESS);
            }
        }
    }

    private String saveBoxModelFile(final Box box) {
        IQingFile qingFile = FileFactory.newPersistentFile((QingContext)this.qingContext, null, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_QS);
        try {
            qingFile.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    XmlUtil.save((Element)box.toXml(), (OutputStream)outputStream);
                }
            }, true);
            return qingFile.getName();
        }
        catch (IOException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private SubjectBO buildSubjectBO(Box box, ThemePO themePo, String ownerId) {
        SubjectBO subjectBO = new SubjectBO();
        subjectBO.setBox(box);
        subjectBO.setThemeID(themePo.getThemeID());
        subjectBO.setOwnerId(ownerId);
        HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(box.getSources().size());
        for (AbstractSource source : box.getSources()) {
            sourcesMap.put(source.getName(), source);
        }
        subjectBO.setSourcesMap(sourcesMap);
        Map<String, AbstractEntity> entityNamesMap = SubjectRuntimeDomain.buildEntityNameMap(box);
        subjectBO.setEntityNamesMap(entityNamesMap);
        return subjectBO;
    }

    private void handleDataFile(List<IQingFile> dataFileAccesses, Map<String, String> dataFiles, Map<String, IQingFile> qingFileMap) {
        Set<Map.Entry<String, IQingFile>> qingFileMapKeys = qingFileMap.entrySet();
        for (Map.Entry<String, IQingFile> entry : qingFileMapKeys) {
            IQingFile file = entry.getValue();
            dataFileAccesses.add(file);
            dataFiles.put(entry.getKey(), file.getName());
        }
    }

    private void checkException(AtomicReference<Throwable> atomicReference) throws AbstractQingIntegratedException, QingLockRequireException, AbstractDataSourceException, SubjectDataModelingException, InterruptedException {
        Throwable cause = null;
        cause = atomicReference.get();
        if (cause != null) {
            if (cause instanceof AbstractQingIntegratedException) {
                throw (AbstractQingIntegratedException)cause;
            }
            if (cause instanceof QingLockRequireException) {
                throw (QingLockRequireException)cause;
            }
            if (cause instanceof AbstractDataSourceException) {
                throw (AbstractDataSourceException)cause;
            }
            if (cause instanceof SubjectDataModelingException) {
                throw (SubjectDataModelingException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
        }
    }

    private List<SubjectEntityExtractTask> extractAsyncInThreadPool(Map<String, IQingFile> qingFileMap, List<AbstractEntity> entityList, CountDownLatch latch, ISubjectPrepareDataCallBack backFunction, SubjectBO subjectBO, StringBuffer warmingMessage, AtomicReference<Throwable> exceptionMessage) throws InterruptedException {
        ArrayList<SubjectEntityExtractTask> rejectedTask = new ArrayList<SubjectEntityExtractTask>(entityList.size());
        for (AbstractEntity entity : entityList) {
            ServerRequestInvokeContext.staticCheckInterrupt();
            IQingFile dataFile = qingFileMap.get(entity.getName());
            SubjectEntityExtractTask subjectEntityExtractTask = new SubjectEntityExtractTask(this.qingContext, entity, subjectBO, dataFile, backFunction);
            ExtractEntityCallBackImpl callback = new ExtractEntityCallBackImpl(latch, warmingMessage, exceptionMessage);
            try {
                ThreadPoolManage.excuteThreadWithContextAndCallback((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_QS_WRITER_TASK_HANDLER, (QingContext)this.qingContext, (Callable)subjectEntityExtractTask, (ListenableFutureCallback)callback);
            }
            catch (RejectedExecutionException e) {
                rejectedTask.add(subjectEntityExtractTask);
            }
        }
        return rejectedTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRejectedTask(List<SubjectEntityExtractTask> rejectedTask, CountDownLatch latch, StringBuffer warmingMessage) throws AbstractDataSourceException, AbstractQingIntegratedException, QingLockRequireException, InterruptedException, AbstractSourceException {
        for (SubjectEntityExtractTask task : rejectedTask) {
            try {
                String result = task.call();
                if (!StringUtils.isNotEmpty((CharSequence)result)) continue;
                warmingMessage.append(result);
            }
            finally {
                latch.countDown();
            }
        }
    }

    private void extractEntityInLocal(Map<String, IQingFile> qingFileMap, ISubjectPrepareDataCallBack backFunction, SubjectBO subjectBO, StringBuffer warmingMessage, AbstractEntity entity) throws InterruptedException, AbstractQingIntegratedException, AbstractSourceException, QingLockRequireException, AbstractDataSourceException {
        if (entity == null) {
            return;
        }
        ServerRequestInvokeContext.staticCheckInterrupt();
        IQingFile dataFile = qingFileMap.get(entity.getName());
        SubjectEntityExtractTask subjectEntityExtractTask = new SubjectEntityExtractTask(this.qingContext, entity, subjectBO, dataFile, backFunction);
        String result = subjectEntityExtractTask.call();
        warmingMessage.append(result);
    }

    private boolean isSchedule(Box box) {
        Schedule schedule = box.getSchedule();
        return schedule != null && schedule.getPeriod() != null;
    }

    private IQingFile createExtractDataFile(ThemePO themePo, boolean isSaveModel, boolean isSchedule, AbstractEntity entity) {
        IQingFile dataFile = null;
        if (isSchedule && isSaveModel) {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setDisplayName(entity.getAlias());
            resourceInfo.setFromId(themePo.getThemeID());
            resourceInfo.setFromType(ResourceFromType.THEMESCHEDULE);
            dataFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_QS);
        } else {
            dataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
        }
        return dataFile;
    }

    public String checkPermission(Box box) throws UnSupportDataSourceException {
        Set<String> noPermissionExceptionSet = this.traverseEntity(box, CollectType.PERMISSION);
        if (!noPermissionExceptionSet.isEmpty()) {
            String paramMessage = StringUtils.join((Object[])noPermissionExceptionSet.toArray(), (char)',');
            return String.format(Messages.getMLS((QingContext)this.qingContext, (String)"NoEntityPermission", (String)"\u60a8\u5c1a\u672a\u83b7\u5f97\u5b9e\u4f53(%s)\u7684\u6743\u9650", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING), paramMessage);
        }
        return null;
    }

    public String checkSupportQingAnalysis(Box box) throws UnSupportDataSourceException {
        Set<String> notSupportQingAnalysis = this.traverseEntity(box, CollectType.SUPPORT);
        if (!notSupportQingAnalysis.isEmpty()) {
            String paramMessage = StringUtils.join((Object[])notSupportQingAnalysis.toArray(), (char)',');
            return String.format(Messages.getMLS((QingContext)this.qingContext, (String)"entityNotSupportQingAnalysis", (String)"\u4e1a\u52a1\u5b9e\u4f53\u3010 %s \u3011\u672a\u5f00\u542f\u201c\u652f\u6301\u8f7b\u5206\u6790\u201d\u8bbe\u7f6e\u9879\uff0c\u8bf7\u5728\u5f00\u53d1\u5e73\u53f0\u7684\u5bf9\u5e94\u8868\u5355\u4e2d\u8fdb\u884c\u8bbe\u7f6e  ", (Messages.ProjectName)Messages.ProjectName.QING_THEME), paramMessage);
        }
        return null;
    }

    private Set<String> traverseEntity(Box box, CollectType collectType) throws UnSupportDataSourceException {
        HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(box.getSources().size());
        for (AbstractSource source : box.getSources()) {
            sourcesMap.put(source.getName(), source);
        }
        int size = box.getEntities().size();
        HashSet<String> resultSet = new HashSet<String>(size);
        for (AbstractEntity entity : box.getEntities()) {
            UnionEntity unionEntity;
            AbstractSource source = null;
            if (entity instanceof Entity) {
                source = (AbstractSource)sourcesMap.get(((Entity)entity).getSource());
                this.collectResult(collectType, resultSet, source, (Entity)entity);
                continue;
            }
            if (!(entity instanceof UnionEntity) || (unionEntity = (UnionEntity)entity).getEntityType() != EntityType.BIZ_UNION) continue;
            List entityChildren = unionEntity.getChildren();
            for (Entity child : entityChildren) {
                source = (AbstractSource)sourcesMap.get(child.getSource());
                this.collectResult(collectType, resultSet, source, child);
            }
        }
        return resultSet;
    }

    private void collectResult(CollectType collectType, Set<String> resultSet, AbstractSource source, Entity entity) throws UnSupportDataSourceException {
        AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomain((AbstractSource)source);
        switch (collectType) {
            case SUPPORT: {
                this.collectNonSupport(resultSet, entity, domain);
                break;
            }
            case PERMISSION: {
                this.collectNonPermission(resultSet, entity, domain);
                break;
            }
        }
    }

    private void collectNonSupport(Set<String> notSupportQingAnalysis, Entity entity, AbstractDataSourceDomain domain) {
        try {
            domain.checkSupportQingAnalysis(this.qingContext, entity);
        }
        catch (EntityNotSupportQingAnalysisException e) {
            notSupportQingAnalysis.add(e.getEntityFullPath());
        }
    }

    private void collectNonPermission(Set<String> noPermissionExceptionSet, Entity entity, AbstractDataSourceDomain domain) {
        try {
            domain.checkEntityPermission(this.qingContext, entity);
        }
        catch (NoEntityPermissionException e) {
            noPermissionExceptionSet.add(e.getEntityFullPath());
        }
    }

    public Box loadModelIncludePreset(String userID, String themeID) throws AbstractQingIntegratedException, ModelParseException, SQLException, EncryptedLicenseCheckException {
        return this.getSubjectDao().loadSubjectModelIncludePreset(userID, themeID);
    }

    private void saveSubjectDataBo(SubjectDataBO dataBO, List<IQingFile> dataFiles, String ownerId) throws AbstractQingIntegratedException, SQLException {
        List<Object> oldDataFilePaths = new ArrayList();
        String oldBoxFile = null;
        try {
            ISubjectDao subjectDao = this.getSubjectDao();
            String string = dataBO.getThemeID();
            List<String> oldDataIds = subjectDao.findAllSubjectDataIds(ownerId, string);
            oldDataFilePaths = subjectDao.findAllDataPath(string);
            oldBoxFile = subjectDao.findScheduleBoxFile(string);
            this.tx.beginRequired();
            subjectDao.saveSubjectDataBO(ownerId, dataBO);
            for (String dataId : oldDataIds) {
                subjectDao.deleteSubjectData(dataId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            FileFactory.clearFile(dataFiles);
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            FileFactory.clearFile(dataFiles);
            throw e;
        }
        finally {
            this.tx.end();
        }
        for (String string : oldDataFilePaths) {
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)string);
            fileUpdater.delete();
        }
        if (null != oldBoxFile) {
            IQingFileUpdater boxFileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)oldBoxFile);
            boxFileUpdater.delete();
        }
    }

    protected void saveMessage(List<String> receiverIdList, String messageTitle, String bizId, BizTypeEnum bizTypeEnum) {
        if (CollectionUtils.isEmpty(receiverIdList)) {
            return;
        }
        SaveMessageVo saveMessageVo = new SaveMessageVo();
        saveMessageVo.setMessageLevel(MessageLevelTypeEnum.NORMAL_LEVEL);
        saveMessageVo.setMessageType(MessageTypeEnum.BIZ_NEWS);
        saveMessageVo.setMessageTitle(messageTitle);
        saveMessageVo.setBizId(bizId);
        saveMessageVo.setBizType(bizTypeEnum);
        saveMessageVo.setReceiverIdList(receiverIdList);
        try {
            this.getMessageDomain().saveMessageWithTx(saveMessageVo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum CollectType {
        PERMISSION,
        SUPPORT;

    }
}

