/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qingReport.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.qingReport.common.QingAnlaysisReportRPCFactory;
import com.kingdee.bos.qingReport.server.cache.QingAnalysisFilterCache;
import com.kingdee.bos.qingReport.server.service.IQingAnalysisReportService;
import com.kingdee.util.Base64Encoder;
import java.util.UUID;

public class QingAnalysisFilterSynCacheUtil {
    private static final String separator = ";";

    public static String cacheFilterForClient(String tag, String filter) throws BOSException {
        IQingAnalysisReportService service = QingAnlaysisReportRPCFactory.getCurrentService();
        service.cacheFilter(tag, filter);
        return tag;
    }

    public static String getTagForClient() {
        String serviceUrl = QingAnlaysisReportRPCFactory.getCurrentServiceUrl();
        if (StringUtil.isEmptyString((String)serviceUrl)) {
            serviceUrl = "";
        }
        String tag = UUID.randomUUID().toString() + separator + serviceUrl;
        return Base64Encoder.byteArrayToBase64((byte[])tag.getBytes());
    }

    public static void removeFilterForClient(String key) throws BOSException {
        IQingAnalysisReportService service = QingAnlaysisReportRPCFactory.getCurrentService();
        service.removeFilter(key);
    }

    public static String getTagForServer() {
        String tag = UUID.randomUUID().toString() + separator + "";
        return Base64Encoder.byteArrayToBase64((byte[])tag.getBytes());
    }

    public static String getServiceurlByTag(String tag) {
        try {
            byte[] array = Base64Encoder.base64ToByteArray((String)tag);
            String str = new String(array);
            String[] split = str.split(separator);
            if (split.length == 2) {
                return split[1];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFilter(String key) throws BOSException {
        String url = QingAnalysisFilterSynCacheUtil.getServiceurlByTag(key);
        if (StringUtil.isEmptyString((String)url)) {
            return QingAnalysisFilterCache.getFilter(key);
        }
        IQingAnalysisReportService server = QingAnlaysisReportRPCFactory.getServerByUrl(url);
        return server.getFilter(key);
    }

    public static void removeFilter(String tag) throws BOSException {
        String url = QingAnalysisFilterSynCacheUtil.getServiceurlByTag(tag);
        if (StringUtil.isEmptyString((String)url)) {
            QingAnalysisFilterCache.removeFilter(tag);
            return;
        }
        IQingAnalysisReportService server = QingAnlaysisReportRPCFactory.getServerByUrl(url);
        server.removeFilter(tag);
    }

    public static String cacheFilter(String tag, String filter) {
        QingAnalysisFilterCache.cacheFilter(tag, filter);
        return tag;
    }
}

