/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IDaemonJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.IServiceInstanceIdGenerator;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobGlobalQueue;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobUtils;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.core.TriggerLoader;
import com.kingdee.bos.service.job.ext.JobDump;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.Event;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClusterStateManager
implements IJobHandler,
ICoreJobHandler,
IDaemonJobHandler {
    private static final long serialVersionUID = 820800631382049043L;
    private static final String VERSION = "8.5.1";
    private static Logger log = Logger.getLogger((String)ClusterStateManager.class.getName());
    private static final HashMap<String, ClusterStateManager> managers = new HashMap(4);
    public static final String CLUSTER = "cluster@";
    private final String dc;
    private volatile boolean isReady = false;
    private String token = UUID.randomUUID().toString();
    private volatile ClusterState state = new ClusterState();
    private boolean errorIsReported = false;
    static final Event OnCleanUp = new Event("OnCleanUp");

    public static ClusterStateManager get(Context ctx) {
        return ClusterStateManager.get(ctx.getAIS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterStateManager get(String dc) {
        ClusterStateManager cm;
        HashMap<String, ClusterStateManager> hashMap = managers;
        synchronized (hashMap) {
            cm = managers.get(dc);
            if (cm == null) {
                cm = ClusterStateManager.init(dc);
                if (cm == null) {
                    throw new RuntimeException("init ClusterStateManager for datacenter {" + dc + "} failed!");
                }
                managers.put(dc, cm);
            }
        }
        return cm;
    }

    private static ClusterStateManager init(String dc) {
        ClusterStateManager m = new ClusterStateManager(dc);
        try {
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)m, false);
            cfg.priority = Integer.MIN_VALUE;
            Job job = new Job(null, "cluster state manager of {" + dc + "}", cfg, (Object)Boolean.TRUE, new Timestamp(System.currentTimeMillis() + Configuration.jobLoaderDelay() / 2L));
            JobManager.instance().add(job);
            log.info((Object)("ClusterStateManager of {" + dc + "} is created!"));
        }
        catch (Throwable t) {
            log.error((Object)("init cluster state manager of {" + dc + "} failed!"), t);
            return null;
        }
        JobLoader.init(dc);
        TriggerLoader.init(dc);
        return m;
    }

    public static boolean isReady(String dc) {
        ClusterStateManager cm = ClusterStateManager.get(dc);
        return cm.isReady();
    }

    private ClusterStateManager(String dc) {
        this.dc = dc;
    }

    public void pauseUntilRefresh() {
        this.isReady = false;
    }

    public Timestamp dbNow() {
        return new Timestamp(System.currentTimeMillis());
    }

    public Timestamp dbNow(int offset) {
        return new Timestamp(System.currentTimeMillis() + (long)offset);
    }

    public Timestamp toLocalTime(Date dbTime) {
        if (dbTime == null) {
            return null;
        }
        return new Timestamp(dbTime.getTime());
    }

    public Timestamp toDbTime(Date localTime) {
        if (localTime == null) {
            return null;
        }
        return new Timestamp(localTime.getTime());
    }

    private void refresh() throws Throwable {
        try (Connection cn = DbConnector.getConnection(this.dc);){
            this.beat(cn);
            this.calcHashRange(cn);
            this.cleanup(cn);
        }
    }

    private void beat(Connection cn) throws BOSException {
        IServiceInstanceIdGenerator g = Configuration.serviceInstanceIdGenerator();
        String instanceId = g.getInstanceId();
        String sql = "update T_JOB_SERVICE set flastUpdateTime=GETDATE(),fversion=?,FTHREAD_COUNT=?,fclustername=?,FDATACENTER=?,FROLE=?,FTOKEN=?,FRPCURL=? where finstanceId=?";
        int[] types = new int[]{12, 4, 12, 12, 12, 12, 12, 12};
        Object[] values = new Object[]{VERSION, RunningJobs.size(this.dc), Configuration.clusterName(), this.dc, JobGlobalQueue.myRole(), this.token, Configuration.getRpcUrl(), instanceId};
        int i = SQL.executeUpdate(cn, sql, types, values);
        if (i == 0) {
            int capacity = Configuration.getServiceCapacity();
            sql = "insert into T_JOB_SERVICE( finstanceId, fserverId, flocalIPs,  fhostName, feasInsName, fclustername, flastUpdateTime, fcapacity,fversion,FDATACENTER,FROLE,FTOKEN,FRPCURL)values(?,?,?,?,?,?,GETDATE(),?,?,?,?,?,?)";
            types = new int[]{12, 12, 12, 12, 12, 12, 4, 12, 12, 12, 12, 12};
            values = new Object[]{instanceId, g.getServerId(), g.getLocalIpAddresses(), g.getLocalHostName(), g.getEasInstanceName(), Configuration.clusterName(), capacity, VERSION, this.dc, JobGlobalQueue.myRole(), this.token, Configuration.getRpcUrl()};
            SQL.executeUpdate(cn, sql, types, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcHashRange(Connection cn) throws SQLException {
        ArrayList<String> serviceInstanceList = new ArrayList<String>();
        ArrayList<String> sameVersionInstanceList = new ArrayList<String>();
        ArrayList<String> sameVersionClusterList = new ArrayList<String>();
        String sql = "select finstanceId, fserverId,fversion,fclustername,FTHREAD_COUNT from T_JOB_SERVICE order by finstanceId";
        Statement smt = cn.createStatement();
        Statement ps = null;
        try {
            Object o;
            String s4;
            String s3;
            String s2;
            String s;
            ResultSet rs = smt.executeQuery(sql);
            IServiceInstanceIdGenerator g = Configuration.serviceInstanceIdGenerator();
            String instanceId = g.getInstanceId();
            String serverId = g.getServerId();
            String clusterId = CLUSTER + Configuration.clusterName();
            int c1 = 0;
            int c2 = 0;
            int c3 = 0;
            int c4 = 0;
            int p1 = 0;
            int p2 = 0;
            int p3 = 0;
            int p4 = 0;
            int runningThreads = 0;
            while (rs.next()) {
                s = rs.getString(1);
                serviceInstanceList.add(s);
                s2 = rs.getString(2);
                s3 = rs.getString(3);
                s4 = CLUSTER + rs.getString(4);
                if (VERSION.equals(s3)) {
                    ++c3;
                    ++p3;
                    sameVersionInstanceList.add(s);
                    if (!sameVersionClusterList.contains(s4)) {
                        sameVersionClusterList.add(s4);
                    }
                }
                if ((o = rs.getObject(5)) != null) {
                    runningThreads += Integer.parseInt(o.toString());
                }
                ++p1;
                ++c1;
                if (s2 != null && s2.equals(serverId)) {
                    ++p2;
                    ++c2;
                }
                if (s4.equals(clusterId)) {
                    ++p4;
                    ++c4;
                }
                if (!s.equals(instanceId)) continue;
                break;
            }
            while (rs.next()) {
                s = rs.getString(1);
                serviceInstanceList.add(s);
                s2 = rs.getString(2);
                s3 = rs.getString(3);
                s4 = CLUSTER + rs.getString(4);
                if (VERSION.equals(s3)) {
                    sameVersionInstanceList.add(s);
                    if (!sameVersionClusterList.contains(s4)) {
                        sameVersionClusterList.add(s4);
                    }
                    ++c3;
                }
                if ((o = rs.getObject(5)) != null) {
                    runningThreads += Integer.parseInt(o.toString());
                }
                ++c1;
                if (s2 != null && s2.equals(serverId)) {
                    ++c2;
                }
                if (!s4.equals(clusterId)) continue;
                ++c4;
            }
            String[] serviceInstances = serviceInstanceList.toArray(new String[serviceInstanceList.size()]);
            String[] sameVersionInstances = sameVersionInstanceList.toArray(new String[sameVersionInstanceList.size()]);
            String[] sameVersionClusters = sameVersionClusterList.toArray(new String[sameVersionClusterList.size()]);
            int interval = 1999 / c1;
            int gMinHash = (p1 - 1) * interval + 0;
            int gMaxHash = p1 * interval - 1 + 0;
            if (p1 == c1) {
                gMaxHash = 1999;
            }
            int jobLoadingInterval = c3 * Configuration.persistantJobCheckInterval();
            int jobLoadingOffset = (p3 - 1) * Configuration.persistantJobCheckInterval();
            interval = c2 > 0 ? 1999 / c2 : 0;
            int sMinHash = (p2 - 1) * interval + 0;
            int sMaxHash = p2 * interval - 1 + 0;
            if (p2 == c2) {
                sMaxHash = 1999;
            }
            interval = c4 > 0 ? 1999 / c4 : 0;
            int cMinHash = (p4 - 1) * interval + 0;
            int cMaxHash = p4 * interval - 1 + 0;
            if (p4 == c4) {
                cMaxHash = 1999;
            }
            this.state = new ClusterState(gMinHash, gMaxHash, sMinHash, sMaxHash, cMinHash, cMaxHash, serviceInstances, sameVersionInstances, sameVersionClusters, jobLoadingOffset, jobLoadingInterval);
            if (runningThreads == 0) {
                Timestamp time = this.dbNow(-2 * Configuration.clusterBeatSignalInterval() * 1000);
                sql = "update t_job_thread set fcount=0 where fcount>0 and ftime<?";
                ps = cn.prepareStatement(sql);
                ps.setTimestamp(1, time);
                ps.execute();
            }
        }
        finally {
            smt.close();
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Connection cn) throws SQLException {
        Date now;
        String sql = "select flastUpdateTime from T_JOB_SERVICE where finstanceId=?";
        try (PreparedStatement psm = SQL.prepareStatement(cn, sql, new int[]{12}, new Object[]{Configuration.instanceId()});){
            ResultSet rs = psm.executeQuery();
            rs.next();
            now = (Date)rs.getObject(1);
        }
        Timestamp timeout = new Timestamp(now.getTime() - (long)Configuration.clusterBeatSignalTimeout());
        sql = "select finstanceId from T_JOB_SERVICE where flastUpdateTime<=?";
        psm = SQL.prepareStatement(cn, sql, new int[]{93}, new Object[]{timeout});
        try {
            ResultSet rs = psm.executeQuery();
            while (rs.next()) {
                String instanceId = rs.getString(1);
                CleanUpInactiveNode handler = new CleanUpInactiveNode(this.dc, instanceId);
                Job job = new Job(null, "clean up job service {" + instanceId + "}", handler, null, false, true);
                job.setScheduledTime(new Date(System.currentTimeMillis() + 10000L));
                JobManager.instance().add(job);
            }
        }
        finally {
            psm.close();
        }
    }

    public String getDc() {
        return this.dc;
    }

    public int getGMinHash() {
        return this.state.gMinHash;
    }

    public int getGMaxHash() {
        return this.state.gMaxHash;
    }

    public int getSMinHash() {
        return this.state.sMinHash;
    }

    public int getSMaxHash() {
        return this.state.sMaxHash;
    }

    public int getCMinHash() {
        return this.state.cMinHash;
    }

    public int getCMaxHash() {
        return this.state.cMaxHash;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public String[] getServiceInstanceIds() {
        return this.state.serviceInstances;
    }

    public String[] getSameVersionServiceInstanceIds() {
        if (!Configuration.isEnable()) {
            try (Connection cn = DbConnector.getConnection(this.dc);){
                this.calcHashRange(cn);
            }
            catch (Throwable t) {
                log.error((Object)"scheduler server is disable, calcHashRange error", t);
            }
        }
        return this.state.sameVersionInstances;
    }

    public String[] getSameVersionServiceClusters() {
        return this.state.sameVersionClusters;
    }

    public int getJobLoadingInterval() {
        return this.state.jobLoadingInterval;
    }

    @Override
    public Object execute(Job job) throws Exception {
        try {
            log.info((Object)("clusterstatemanager execute dc:" + this.dc));
            Boolean first = (Boolean)job.getParameters();
            if (first.booleanValue()) {
                log.info((Object)("check and add jobservice table" + this.dc));
                String sql = "select COUNT(1) as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_JOB_SERVICE'";
                HashMap data = (HashMap)SQL.executeQuery(this.dc, sql).get(0);
                if (Integer.parseInt(data.get("c").toString()) == 0) {
                    if (!this.errorIsReported) {
                        log.warn((Object)("datacenter {" + this.dc + "} has no job service's tables!"));
                        this.errorIsReported = true;
                    }
                    return new Delay(180);
                }
                log.info((Object)("check and add scheduler field , dc: " + this.dc));
                sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FVERSION' AND KSQL_COL_TABNAME='T_JOB_SERVICE'";
                if (SQL.executeQuery(this.dc, sql).size() == 0) {
                    sql = "alter table t_job_service add FVERSION varchar(10)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FTHREAD_COUNT' AND KSQL_COL_TABNAME='T_JOB_SERVICE'").size() == 0) {
                    sql = "alter table t_job_service add FTHREAD_COUNT int";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FCLUSTERNAME' AND KSQL_COL_TABNAME='T_JOB_SERVICE'").size() == 0) {
                    sql = "alter table t_job_service add FCLUSTERNAME varchar(100)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FDATACENTER' AND KSQL_COL_TABNAME='T_JOB_SERVICE'").size() == 0) {
                    sql = "alter table t_job_service add FDATACENTER varchar(100)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FROLE' AND KSQL_COL_TABNAME='T_JOB_SERVICE'").size() == 0) {
                    sql = "alter table t_job_service add FROLE varchar(100)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FTOKEN' AND KSQL_COL_TABNAME='T_JOB_SERVICE'").size() == 0) {
                    sql = "alter table t_job_service add FTOKEN varchar(36)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select KSQL_TABNAME as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_JOB_THREAD'").size() == 0) {
                    sql = "CREATE TABLE T_JOB_THREAD(fname varchar(60) not null, fcount int not null, ftime DateTime not null, CONSTRAINT PK_JOB_THREAD PRIMARY KEY(fname))";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME='FMUTEX' AND KSQL_COL_TABNAME='T_JOB_INST'").size() == 0) {
                    sql = "alter table T_JOB_INST add FMUTEX varchar(100)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_TRIGGER' and ksql_col_name='FCLUSTER'").size() == 0) {
                    sql = "alter table T_JOB_TRIGGER add FCLUSTER VARCHAR(30)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_INST' and ksql_col_name='FCLUSTER'").size() == 0) {
                    sql = "alter table T_JOB_INST add FCLUSTER VARCHAR(30)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_DEF' and ksql_col_name='FCLUSTER'").size() == 0) {
                    sql = "alter table T_JOB_DEF add FCLUSTER VARCHAR(30)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_INSTHST' and ksql_col_name='FCLUSTER'").size() == 0) {
                    sql = "alter table T_JOB_INSTHST add FCLUSTER VARCHAR(30)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_TRIGGER' and ksql_col_name='FSELECTEDSERVER'").size() == 0) {
                    sql = "alter table T_JOB_TRIGGER add FSELECTEDSERVER VARCHAR(50)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_TRIGGER' and ksql_col_name='FLASTJOBINST'").size() == 0) {
                    sql = "alter table T_JOB_TRIGGER add FLASTJOBINST VARCHAR(44)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from ksql_usercolumns where ksql_col_tabname='T_JOB_DEF' and ksql_col_name='FSERVICETYPE'").size() == 0) {
                    sql = "alter table T_JOB_DEF add FSERVICETYPE VARCHAR(50)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FRPCURL' and ksql_col_tabname='T_JOB_SERVICE'").size() == 0) {
                    sql = "alter table T_JOB_SERVICE add FRPCURL varchar(50)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FCOSTTIME' and ksql_col_tabname='T_JOB_INST'").size() == 0) {
                    sql = "alter table T_JOB_INST add FCOSTTIME int";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FCOSTTIME' and ksql_col_tabname='T_JOB_INSTHST'").size() == 0) {
                    sql = "alter table T_JOB_INSTHST add FCOSTTIME int";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select KSQL_TABNAME as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_JOB_SERVERCONFIG'").size() == 0) {
                    sql = " CREATE TABLE T_JOB_SERVERCONFIG(  FSERVICETYPE VARCHAR(50) not null,   FSERVERS VARCHAR(500) )";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FINWORKINGDAY' and ksql_col_tabname='T_JOB_TRIGGER'").size() == 0) {
                    sql = "alter table T_JOB_TRIGGER add FINWORKINGDAY char(1)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FISFIRELASTMISSEDJOB' and ksql_col_tabname='T_JOB_TRIGGER'").size() == 0) {
                    sql = "alter table T_JOB_TRIGGER add FISFIRELASTMISSEDJOB char(1)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FRUNTIMEOUT' and ksql_col_tabname='T_JOB_DEF'").size() == 0) {
                    sql = "alter table T_JOB_DEF add FRUNTIMEOUT INT NOT NULL DEFAULT 0";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select 1 from ksql_usercolumns where ksql_col_name='FJOBTYPE' and ksql_col_tabname='T_JOB_INST'").size() == 0) {
                    sql = "alter table T_JOB_INST add FJOBTYPE varchar(50)";
                    SQL.executeUpdate(this.dc, sql);
                }
                if (SQL.executeQuery(this.dc, sql = "select * from KSQL_INDEXES where KSQL_INDNAME ='IX_T_JOB_SERVERCONFIG'").size() == 0) {
                    sql = " create unique index IX_T_JOB_SERVERCONFIG  on T_JOB_SERVERCONFIG (FSERVICETYPE)";
                    SQL.executeUpdate(this.dc, sql);
                }
                this.createUpgradeJobDef();
                this.createDumpJobDef();
                this.createInstCostTimeDef();
                JobUtils.updateIsolationBoundary(this.dc);
                log.info((Object)("ClusterStateManger for datacenter {" + this.dc + "} is initiated!"));
            }
            this.refresh();
            this.isReady = true;
            log.info((Object)("refresh job instance of {" + this.dc + "} at " + new Timestamp(System.currentTimeMillis())));
            this.errorIsReported = false;
            return new Delay(Boolean.FALSE, Configuration.clusterBeatSignalInterval());
        }
        catch (Throwable t) {
            if (!this.errorIsReported) {
                log.error((Object)("refresh background service instance of {" + this.dc + "} failed!"), t);
                this.errorIsReported = true;
            }
            log.error((Object)("refresh background service instance of {" + this.dc + "} failed!"), t);
            this.isReady = false;
            return new Delay(Boolean.TRUE, 180);
        }
    }

    private void createInstCostTimeDef() throws BOSException {
        String uuid = "927dab7a-56a8-4934-acb6-80ddcc2cd4d1";
        String defid = uuid + "BGJOBDEF";
        String triggerid = uuid + "BGJOBTRI";
        String sql = "select 1 from t_job_def where fjobdefid='" + defid + "'";
        if (SQL.executeQuery(this.dc, sql).size() == 0) {
            sql = "INSERT INTO T_JOB_DEF(fjobdefid, ftitle, fispersistent, fhandlerwrapper, fpriority, fissmalljob, fmissedtimeout, fjobisolationlevel, fcreateUserID, fcreateTime, fupdateUserID,fupdateTime) values(?,?,?,?,?,?,?,?,?,getdate(),?,getdate())";
            int[] types = new int[]{12, 12, 12, 12, 4, 12, 4, 12, 12, 12};
            Object[] values = new Object[]{defid, "~\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b\u6267\u884c\u8017\u65f6\u7edf\u8ba1", "Y", "interface:com.kingdee.bos.service.job.ext.BackgroundJobInstCostTime", new Integer(500), "N", new Integer(-1), "none", "00000000-0000-0000-0000-00000000000013B7DE7F", "00000000-0000-0000-0000-00000000000013B7DE7F"};
            SQL.executeUpdate(this.dc, sql, types, values);
            SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
            String schedule = sdf.format(new Timestamp(System.currentTimeMillis() + 60000L));
            sql = "insert into t_job_trigger(fid,fjobdefid,fvalidatetime,fexpiredtime,fpulsesource, fscheduleplan,fusecalendar,fhashcode,fisolationboundary,fisvalid, fisautoload,ftriggeredcount) values(?,?,?,?,?,?,?,?,?,?,?,?)";
            types = new int[]{12, 12, 93, 93, 12, 12, 12, 4, 12, 12, 12, 4};
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp expired = new Timestamp(System.currentTimeMillis() + 1471228928L);
            values = new Object[]{triggerid, defid, now, expired, "timer", "ONETIME:" + schedule, "N", new Integer(1), "none", "Y", "Y", new Integer(0)};
            SQL.executeUpdate(this.dc, sql, types, values);
            log.info((Object)("BackgroundJobInstCostTime job def and trigger for {" + this.dc + "} is created!"));
        }
    }

    private void createUpgradeJobDef() throws BOSException {
        String uuid = "c45c8760-e404-46da-83de-269dab109684";
        String defid = uuid + "BGJOBDEF";
        String triggerid = uuid + "BGJOBTRI";
        String sql = "select 1 from t_job_def where fjobdefid='" + defid + "'";
        if (SQL.executeQuery(this.dc, sql).size() == 0) {
            sql = "INSERT INTO T_JOB_DEF(fjobdefid, ftitle, fispersistent, fhandlerwrapper, fpriority, fissmalljob, fmissedtimeout, fjobisolationlevel, fcreateUserID, fcreateTime, fupdateUserID,fupdateTime) values(?,?,?,?,?,?,?,?,?,getdate(),?,getdate())";
            int[] types = new int[]{12, 12, 12, 12, 4, 12, 4, 12, 12, 12};
            Object[] values = new Object[]{defid, "~\u540e\u53f0\u4e8b\u52a1\u5347\u7ea7", "Y", "interface:com.kingdee.bos.workflow.store.util.BackgroundJobUpgrade", new Integer(500), "N", new Integer(-1), "none", "00000000-0000-0000-0000-00000000000013B7DE7F", "00000000-0000-0000-0000-00000000000013B7DE7F"};
            SQL.executeUpdate(this.dc, sql, types, values);
            SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
            String schedule = sdf.format(new Timestamp(System.currentTimeMillis() + 3600000L));
            sql = "insert into t_job_trigger(fid,fjobdefid,fvalidatetime,fexpiredtime,fpulsesource, fscheduleplan,fusecalendar,fhashcode,fisolationboundary,fisvalid, fisautoload,ftriggeredcount) values(?,?,?,?,?,?,?,?,?,?,?,?)";
            types = new int[]{12, 12, 93, 93, 12, 12, 12, 4, 12, 12, 12, 4};
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp expired = new Timestamp(System.currentTimeMillis() + 1471228928L);
            values = new Object[]{triggerid, defid, now, expired, "timer", "ONETIME:" + schedule, "N", new Integer(1), "none", "Y", "Y", new Integer(0)};
            SQL.executeUpdate(this.dc, sql, types, values);
            log.info((Object)("BackgroundJobUpgrade job def and trigger for {" + this.dc + "} is created!"));
        }
    }

    private void createDumpJobDef() throws BOSException {
        ArrayList rs;
        String uuid = "fffc8760-e404-3389-83de-269dab109684";
        String defid = uuid + "BGJOBDEF";
        String triggerid = uuid + "BGJOBTRI";
        String sql = "select 1 from t_job_def where fjobdefid=?";
        int[] types = new int[]{12};
        Object[] values = new Object[]{defid};
        if (SQL.executeQuery(this.dc, sql, types, values).size() == 0) {
            sql = "INSERT INTO T_JOB_DEF(fjobdefid, ftitle, fispersistent, fhandlerwrapper, fpriority, fissmalljob, fmissedtimeout, fjobisolationlevel, fcreateUserID, fcreateTime, fupdateUserID,fupdateTime) values(?,?,?,?,?,?,?,?,?,getdate(),?,getdate())";
            types = new int[]{12, 12, 12, 12, 4, 12, 4, 12, 12, 12};
            values = new Object[]{defid, "~\u540e\u53f0\u4e8b\u52a1\u8f6c\u50a8", "Y", "interface:" + JobDump.class.getName(), new Integer(500), "N", new Integer(-1), JobIsolationLevel.Server.toString(), "00000000-0000-0000-0000-00000000000013B7DE7F", "00000000-0000-0000-0000-00000000000013B7DE7F"};
            SQL.executeUpdate(this.dc, sql, types, values);
            log.info((Object)("BackgroundJobUpgrade job def for {" + this.dc + "} is created!"));
        }
        if ((rs = SQL.executeQuery(this.dc, sql = "select flasttriggeredtime from t_job_trigger where fid=?", types = new int[]{12}, values = new Object[]{triggerid})).size() == 0) {
            String schedule = "EVERYDAY:0 0 3 * * ? *";
            sql = "insert into t_job_trigger(fid,fjobdefid,fvalidatetime,fexpiredtime,fpulsesource, fscheduleplan,fusecalendar,fhashcode,fisolationboundary,fisvalid, fisautoload,ftriggeredcount) values(?,?,?,?,?,?,?,?,?,?,?,?)";
            types = new int[]{12, 12, 93, 93, 12, 12, 12, 4, 12, 12, 12, 4};
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp expired = new Timestamp(System.currentTimeMillis() + 3153600000000L);
            values = new Object[]{triggerid, defid, now, expired, "timer", schedule, "N", new Integer(1), "none", "Y", "Y", new Integer(0)};
            SQL.executeUpdate(this.dc, sql, types, values);
            log.info((Object)("BackgroundJobUpgrade job trigger for {" + this.dc + "} is created!"));
        } else {
            Map map = (Map)rs.get(0);
            Timestamp lastTriggerTime = (Timestamp)map.get("flasttriggeredtime");
            if (lastTriggerTime == null || lastTriggerTime.before(new Timestamp(System.currentTimeMillis() - 86400000L))) {
                sql = "update t_job_trigger set fisolationboundary=?, fhashcode=?, fholderid=null where fid=?";
                types = new int[]{12, 4, 12};
                values = new Object[]{"none", new Integer(1), triggerid};
                SQL.executeUpdate(this.dc, sql, types, values);
            }
            log.info((Object)("BackgroundJobUpgrade job trigger for {" + this.dc + "} is updated!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dump() {
        Object[] array;
        StringBuffer sb = new StringBuffer();
        HashMap<String, ClusterStateManager> hashMap = managers;
        synchronized (hashMap) {
            array = managers.values().toArray();
        }
        for (int i = 0; i < array.length; ++i) {
            ClusterStateManager m = (ClusterStateManager)array[i];
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(m.getDc()).append(":").append(m.isReady()).append(";");
        }
        return sb.toString();
    }

    public static String validate(Context ctx, String isolationBoundary) {
        if (isolationBoundary == null) {
            return null;
        }
        ClusterStateManager cm = ClusterStateManager.get(ctx);
        for (String id : cm.getSameVersionServiceInstanceIds()) {
            if (!id.equals(isolationBoundary)) continue;
            return isolationBoundary;
        }
        return null;
    }

    private static class CleanUpInactiveNode
    implements IJobHandler {
        private static final long serialVersionUID = -907844837367496859L;
        private final String dc;
        private final String instanceId;

        CleanUpInactiveNode(String dc, String instanceId) {
            this.dc = dc;
            this.instanceId = instanceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(Job job) throws Exception {
            try (Connection cn = DbConnector.getConnection(this.dc);){
                String sql = "delete from T_JOB_SERVICE where finstanceId='" + this.instanceId + "'";
                try (Statement smt = cn.createStatement();){
                    int i = this.executeUpdate(sql, smt);
                    if (i > 0) {
                        OnCleanUp.raise(new EventParam(cn, this.instanceId));
                    }
                }
            }
            return null;
        }

        private int executeUpdate(String sql, Statement smt) throws SQLException {
            return smt.executeUpdate(sql);
        }
    }

    public static class EventParam {
        public final Connection cn;
        public final String instanceId;

        public EventParam(Connection cn, String instanceId) {
            this.cn = cn;
            this.instanceId = instanceId;
        }
    }

    private static class ClusterState {
        final int gMinHash;
        final int gMaxHash;
        final int sMinHash;
        final int sMaxHash;
        final int cMinHash;
        final int cMaxHash;
        final String[] serviceInstances;
        final String[] sameVersionInstances;
        final String[] sameVersionClusters;
        final int jobLoadingOffset;
        final int jobLoadingInterval;

        private ClusterState(int gMinHash, int gMaxHash, int sMinHash, int sMaxHash, int cMinHash, int cMaxHash, String[] serviceInstances, String[] sameVersionInstances, String[] sameVersionClusters, int jobLoadingOffset, int jobLoadingInterval) {
            this.gMinHash = gMinHash;
            this.gMaxHash = gMaxHash;
            this.sMinHash = sMinHash;
            this.sMaxHash = sMaxHash;
            this.cMinHash = cMinHash;
            this.cMaxHash = cMaxHash;
            this.serviceInstances = serviceInstances;
            this.sameVersionInstances = sameVersionInstances;
            this.sameVersionClusters = sameVersionClusters;
            this.jobLoadingOffset = jobLoadingOffset;
            this.jobLoadingInterval = jobLoadingInterval;
        }

        private ClusterState(int jobLoadingOffset, int jobLoadingInterval) {
            this(-1, -1, -1, -1, -1, -1, new String[0], new String[0], new String[0], jobLoadingOffset, jobLoadingInterval);
        }

        private ClusterState() {
            this(0, 0);
        }
    }
}

