/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.TriggerComparator;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class TriggerAndJobs {
    final TreeSet timeTriggers = new TreeSet(new TriggerComparator());
    final HashMap allTriggers = new HashMap();
    final HashMap groupTriggers = new HashMap();
    final HashMap allJobs = new HashMap();
    final HashMap groupJobs = new HashMap();
    final HashMap calendars = new HashMap();

    HashMap getTriggerGroup(String group, boolean createIfNotExists) {
        HashMap g = (HashMap)this.groupTriggers.get(group);
        if (g == null && createIfNotExists) {
            g = new HashMap();
            this.groupTriggers.put(group, g);
        }
        return g;
    }

    HashMap getJobGroup(String group, boolean createIfNotExists) {
        HashMap g = (HashMap)this.groupJobs.get(group);
        if (g == null && createIfNotExists) {
            g = new HashMap();
            this.groupJobs.put(group, g);
        }
        return g;
    }

    void addTrigger(TriggerWrapper tw) {
        this.allTriggers.put(tw.key, tw);
        this.getTriggerGroup(tw.trigger.getKey().getGroup(), true).put(tw.trigger.getKey().getName(), tw);
    }

    boolean removeTrigger(TriggerWrapper tw) {
        String group = tw.trigger.getKey().getGroup();
        String name = tw.trigger.getKey().getName();
        String key = tw.key;
        if (this.allTriggers.containsKey(key)) {
            this.allTriggers.remove(key);
            this.getTriggerGroup(group, true).remove(name);
            this.timeTriggers.remove(tw);
            return true;
        }
        return false;
    }

    boolean existsTrigger(TriggerWrapper tw) {
        return this.allTriggers.containsKey(tw.key);
    }

    boolean existsTrigger(Trigger t) {
        return this.allTriggers.containsKey(TriggerWrapper.getTriggerNameKey(t));
    }

    boolean existsTrigger(String group, String name) {
        return this.allTriggers.containsKey(TriggerWrapper.getTriggerNameKey(group, name));
    }

    void addJob(JobWrapper jw) {
        this.allJobs.put(jw.key, jw);
        this.getJobGroup(jw.jobDetail.getKey().getGroup(), true).put(jw.jobDetail.getKey().getName(), jw);
    }

    boolean removeJob(JobWrapper jw) {
        if (this.allJobs.containsKey(jw.key)) {
            this.allJobs.remove(jw.key);
            this.getJobGroup(jw.jobDetail.getKey().getGroup(), true).remove(jw.jobDetail.getKey().getName());
            return true;
        }
        return false;
    }

    boolean existsJob(JobDetail jb) {
        return this.allJobs.containsKey(JobWrapper.getJobNameKey(jb));
    }

    boolean existsJob(String group, String name) {
        return this.allJobs.containsKey(JobWrapper.getJobNameKey(group, name));
    }

    JobWrapper getTriggerJob(TriggerWrapper tw) {
        return (JobWrapper)this.allJobs.get(tw.jobKey);
    }

    List getTriggersForJob(String jobKey, boolean triggerType) {
        ArrayList<Object> ar = new ArrayList<Object>();
        for (TriggerWrapper tw : this.allTriggers.values()) {
            if (!tw.jobKey.equals(jobKey)) continue;
            if (triggerType) {
                ar.add(tw.trigger);
                continue;
            }
            ar.add(tw);
        }
        return ar;
    }

    TriggerWrapper getTrigger(String key) {
        return (TriggerWrapper)this.allTriggers.get(key);
    }

    TriggerWrapper getTrigger(String group, String name) {
        return this.getTrigger(TriggerWrapper.getTriggerNameKey(group, name));
    }

    JobWrapper getJob(JobDetail job) {
        return (JobWrapper)this.allJobs.get(JobWrapper.getJobNameKey(job));
    }

    JobWrapper getJob(String group, String name) {
        return (JobWrapper)this.allJobs.get(JobWrapper.getJobNameKey(group, name));
    }

    JobWrapper getJob(String jobKey) {
        return (JobWrapper)this.allJobs.get(jobKey);
    }

    Calendar getCalendar(String name) {
        return (Calendar)this.calendars.get(name);
    }
}

