/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.celleditors;

import com.kingdee.bos.tool.celleditors.EnumerateCellEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;

public class BooleanCellEditor
extends EnumerateCellEditor {
    private static final List values = new ArrayList();
    private boolean isStringValue = false;

    public BooleanCellEditor(Composite parent) {
        this(parent, 8);
    }

    public BooleanCellEditor(Composite parent, ILabelProvider provider) {
        this(parent, provider, 8);
    }

    public BooleanCellEditor(Composite parent, int style) {
        this(parent, (ILabelProvider)new LabelProvider(), style);
    }

    public BooleanCellEditor(Composite parent, ILabelProvider provider, int style) {
        super(parent, values, (ILabelProvider)new LabelProvider(), style);
    }

    @Override
    public Object doGetValue() {
        Object val = super.doGetValue();
        assert (val instanceof Boolean);
        if (this.isStringValue) {
            return val.toString();
        }
        return val;
    }

    @Override
    public void doSetValue(Object value) {
        Boolean tempValue;
        if (value instanceof String) {
            this.isStringValue = true;
            tempValue = Boolean.valueOf((String)value);
        } else {
            this.isStringValue = false;
            tempValue = value instanceof Boolean ? (Boolean)value : (value instanceof Integer ? this.getBooleanValue((Integer)value) : Boolean.FALSE);
        }
        super.doSetValue(tempValue);
    }

    private Boolean getBooleanValue(int index) {
        if (index >= 0 && index < values.size()) {
            return (Boolean)values.get(index);
        }
        return Boolean.FALSE;
    }

    static {
        values.add(Boolean.TRUE);
        values.add(Boolean.FALSE);
    }
}

