/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.validators;

import com.kingdee.bos.tool.validators.CommonValidator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class StringValidator
implements ICellEditorValidator {
    public static final String REGULAR_EXP_A_LOWERCASE_CHAR = "[a-z]";
    public static final String REGULAR_EXP_A_UPPERCASE_CHAR = "[A-Z]";
    public static final String REGULAR_EXP_A_ALPHA_CHAR = "[a-zA-Z]";
    public static final String REGULAR_EXP_A_DIGIT = "[0-9]";
    public static final String REGULAR_EXP_A_ALNUM_CHAR = "[a-zA-Z0-9]";
    public static final String REGULAR_EXP_A_XDIGIT = "[0-9a-fA-F]";
    public static final String REGULAR_EXP_JAVA_IDENTIFIER = "[_$a-zA-Z][_$a-zA-Z0-9]*";
    public static final String REGULAR_EXP_JAVA_IDENTIFIER_LOWERINITIAL = "[a-z][_$a-zA-Z0-9]*";
    public static final String REGULAR_EXP_JAVA_IDENTIFIER_UPPERINITIAL = "[A-Z][_$a-zA-Z0-9]*";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.validators.StringValidator");
    private boolean nullable;
    private boolean isRegxSet;
    private String regularExpress;
    private Pattern pattern;

    public StringValidator() {
        this(true);
    }

    public StringValidator(boolean isNullable) {
        this.nullable = isNullable;
    }

    public String isValid(Object value) {
        return CommonValidator.isValid(value, this.nullable, 5, new Object[]{this.pattern});
    }

    public void setNullable(boolean isNullable) {
        this.nullable = isNullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setRegularExpress(String regex) {
        if (regex == null) {
            this.regularExpress = null;
            this.pattern = null;
            this.isRegxSet = false;
        } else {
            this.compile(regex);
        }
    }

    public String getRegularExpress() {
        return this.regularExpress;
    }

    private void compile(String regex) {
        try {
            this.pattern = Pattern.compile(regex);
            this.regularExpress = regex;
            this.isRegxSet = true;
        }
        catch (PatternSyntaxException ex) {
            logger.error((Object)"Bad regular expression", (Throwable)ex);
        }
    }
}

