/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard;

import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.wizard.Messages;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.wizard.BaseWizard");

    public BaseWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected boolean validateBeforeFinish() {
        return true;
    }

    protected boolean canRunForked() {
        return true;
    }

    public boolean performFinish() {
        if (!this.validateBeforeFinish()) {
            return false;
        }
        WorkspaceRunnable op = new WorkspaceRunnable();
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                logger.error((Object)Messages.BaseWizard_CaoZuoShiBai, (Throwable)e);
                ToolBasePlugin.log(e);
            } else {
                logger.error((Object)Messages.BaseWizard_CaoZuoShiBai, cause);
                ToolBasePlugin.log(cause);
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.BaseWizard_CuoWu, (String)Messages.BaseWizard_CaoZuoShiBaiQingJianChaRiZhi);
        }
        catch (InterruptedException e) {
            logger.error((Object)Messages.BaseWizard_CaoZuoBeiZhongDuan, (Throwable)e);
            ToolBasePlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.BaseWizard_CuoWu, (String)Messages.BaseWizard_CaoZuoZhongDuanQingJianChaRiZhi);
        }
        return true;
    }

    protected abstract void finishPage(IProgressMonitor var1) throws InterruptedException, IDEException;

    private class WorkspaceRunnable
    implements IRunnableWithProgress {
        private WorkspaceRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                BaseWizard.this.finishPage(monitor);
            }
            catch (IDEException e) {
                throw new InvocationTargetException((Throwable)((Object)e));
            }
        }
    }
}

