/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.ext.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.eas.basedata.person.app.PersonToWFAdapter;
import java.util.ArrayList;
import java.util.Map;

public class WfPersonAdapter
extends PersonToWFAdapter {
    private static final long serialVersionUID = -6000060506766531643L;

    public Group[] getAllGroups(Context context) throws WfParticipantException {
        String sql = "select fid, fname from T_WFR_GROUP order by fname";
        try {
            ArrayList list = SQL.executeQuery((Context)context, (String)sql);
            Group[] groups = new Group[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                groups[i] = this.toGroup(context, item);
            }
            return groups;
        }
        catch (BOSException e) {
            throw new WfParticipantException("retrieve groups failed!", (Throwable)e);
        }
    }

    public Person[] getPersonsFromGroup(Context context, String groupId) throws WfParticipantException {
        String sql = "select u.fid, u.fname_" + context.getLocale() + " as fname, u.fpersonid  from t_wfr_group_member g inner join t_pm_user u on g.fuserid=u.fid where g.fgroupid='" + groupId + "'";
        try {
            ArrayList list = SQL.executeQuery((Context)context, (String)sql);
            Person[] persons = new Person[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                persons[i] = this.toPerson(context, item);
            }
            return persons;
        }
        catch (BOSException e) {
            throw new WfParticipantException("retrieve groups failed!", (Throwable)e);
        }
    }

    public Group[] getGroupArrayByEmployeeId(Context ctx, String userId) throws WfParticipantException {
        String sql = "select fid, fname from t_wfr_group_member inner join t_wfr_group on fgroupid=fid where fuserid='" + userId + "'";
        try {
            ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
            Group[] group = new Group[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                group[i] = this.toGroup(ctx, item);
            }
            return group;
        }
        catch (BOSException e) {
            throw new WfParticipantException("retrieve groups failed!", (Throwable)e);
        }
    }

    public Person[] getPersonByEmployeeId(Context ctx, String employeeId) throws WfParticipantException {
        Person[] persons = super.getPersonByEmployeeId(ctx, employeeId);
        if (persons != null && persons.length > 0) {
            return persons;
        }
        Person p = this.getPersonByUserId(ctx, employeeId);
        if (p == null) {
            return new Person[0];
        }
        return new Person[]{p};
    }

    private Group toGroup(Context context, Map item) {
        Group g = new Group();
        g.setGroupId((String)item.get("fid"));
        g.setGroupName(context.getLocale(), (String)item.get("fname"));
        return g;
    }

    private Person toPerson(Context context, Map item) {
        Person g = new Person();
        g.setUserId((String)item.get("fid"));
        g.setUserName(context.getLocale(), (String)item.get("fname"));
        g.setEmployeeName(context.getLocale(), (String)item.get("fname"));
        String personId = (String)item.get("fpersonid");
        if (personId == null) {
            personId = (String)item.get("fid");
        }
        g.setEmployeeId(personId);
        return g;
    }

    public Person getPersonByUserId(Context context, String userId) throws WfParticipantException {
        Person p = super.getPersonByUserId(context, userId);
        if (p != null && p.getEmployeeId() != null) {
            return p;
        }
        String sql = "select fid, fname_" + context.getLocale() + " as fname, fpersonid  from t_pm_user where fid='" + userId + "'";
        try {
            ArrayList list = SQL.executeQuery((Context)context, (String)sql);
            if (list.size() == 0) {
                return null;
            }
            Map item = (Map)list.get(0);
            return this.toPerson(context, item);
        }
        catch (BOSException e) {
            throw new WfParticipantException("retrieve groups failed!", (Throwable)e);
        }
    }
}

