/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.billdigest.BillDigestUtil;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.DevolveDenialException;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.enhanced.Abstracts;
import com.kingdee.bos.workflow.define.enhanced.IAbstractActivity;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.ext.AbstractWfNextPersonExt;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfNextPersonExt;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.ApproveAssignmentInfo;
import com.kingdee.bos.workflow.monitor.BillDigestFactory;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.SummaryProxy;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.monitor.WfProcessDiagram;
import com.kingdee.bos.workflow.monitor.app.DynamicWfService;
import com.kingdee.bos.workflow.monitor.util.SignatureUtil;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.participant.ParticipantBlock;
import com.kingdee.bos.workflow.participant.ParticipantCase;
import com.kingdee.bos.workflow.participant.ParticipantUnit;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ProcessParamUtils;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfBizObjUtils;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.myeas.IMyPhrase;
import com.kingdee.eas.base.myeas.MyPhraseCollection;
import com.kingdee.eas.base.myeas.MyPhraseFactory;
import com.kingdee.eas.base.myeas.MyPhraseInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.portal.web.util.Md5Util;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ApproveUtil {
    static final Logger logger = Logger.getLogger(ApproveUtil.class);
    private static Random random = new SecureRandom();
    private static final String NO_BILL_URL = "/easweb/webviews/workflow/nobill.html";
    private static boolean isInitialize = false;
    private static boolean basPatchIsOld = true;
    private IWfNextPersonExt ext;
    private Context ctx;

    private static void init() {
        if (!isInitialize) {
            try {
                AttachmentInfo.class.getMethod("setAttachType", String.class);
                basPatchIsOld = false;
            }
            catch (NoSuchMethodException e) {
                basPatchIsOld = true;
            }
            isInitialize = true;
        }
    }

    private static int getRandomInt() {
        return random.nextInt();
    }

    public static ApproveAssignmentInfo getApproveConfig(Context ctx, String assignId) throws Exception {
        return ApproveUtil.getApproveConfigInner(ctx, assignId, false);
    }

    public static ApproveAssignmentInfo getApproveConfigFromProcessCenter(Context ctx, String assignId) throws Exception {
        return ApproveUtil.getApproveConfigInner(ctx, assignId, true);
    }

    private static ApproveAssignmentInfo getApproveConfigInner(Context ctx, String assignId, boolean isFromProcessCenter) throws Exception {
        ApproveUtil.init();
        ApproveAssignmentInfo cfg = new ApproveAssignmentInfo();
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        ApproveUtil.setAssignAttributes(ctx, cfg, assign);
        ApproveUtil.generateBillEditURL(ctx, cfg, svc, assign);
        ApproveUtil.getAttachmentCount(ctx, cfg);
        if (!isFromProcessCenter || ApproveUtil.needMessageDigest(cfg)) {
            ApproveUtil.getMessageDigest(ctx, cfg, assign);
            ApproveUtil.getBillAttachmentInfo(ctx, cfg);
        }
        ProcessDef processDef = svc.getProcessDefByDefineHashValue(assign.getProcDefHashValue());
        ApproveUtil.getExtendedAttributes(ctx, cfg, svc, assign, processDef);
        ApproveUtil.setForNotBosRuntime(ctx, cfg);
        ApproveUtil.findNextActs(ctx, cfg, svc, assign, processDef);
        ApproveUtil.getParams(ctx, cfg);
        return cfg;
    }

    private static void getAttachmentCount(Context ctx, ApproveAssignmentInfo cfg) {
        String sql = "SELECT count(*) as count FROM T_BAS_BoAttchAsso where FBOID = ?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cfg.billId});
            if (rowSet.next()) {
                cfg.attachmentCount = rowSet.getInt("count");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void getBillAttachmentInfo(Context ctx, ApproveAssignmentInfo cfg) {
        AttachmentCollection attachCollect = null;
        try {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getRemoteInstance();
            String[] attchIDs = iBoAttchAsso.getAttchIDsByBoID(cfg.billId);
            if (attchIDs != null && attchIDs.length > 0) {
                IAttachment iAttachment = AttachmentFactory.getRemoteInstance();
                String selectFields = "id,name,simpleName,size,attachid";
                if (!basPatchIsOld) {
                    selectFields = selectFields + ",attachTypeEnum";
                }
                StringBuffer oql = new StringBuffer("select " + selectFields + " where id in (");
                for (int i = 0; i < attchIDs.length; ++i) {
                    oql.append("'" + attchIDs[i] + "'");
                    if (i >= attchIDs.length - 1) continue;
                    oql.append(",");
                }
                oql.append(")");
                oql.append(" order by createtime asc");
                attachCollect = iAttachment.getAttachmentCollection(oql.toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u6d41\u7a0b\u4e2d\u5fc3-\u663e\u793a\u5355\u636e\u6458\u8981\u573a\u666f\u83b7\u53d6\u5355\u636e\u9644\u4ef6\u62a5\u9519", (Throwable)e);
        }
        ArrayList returnList = new ArrayList();
        if (attachCollect != null && attachCollect.size() > 0) {
            for (int i = 0; i < attachCollect.size(); ++i) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("id", attachCollect.get(i).getId().toString());
                data.put("name", attachCollect.get(i).get("name"));
                data.put("simpleName", attachCollect.get(i).get("simpleName"));
                data.put("size", attachCollect.get(i).get("size"));
                if (!basPatchIsOld) {
                    data.put("attachTypeEnum", attachCollect.get(i).get("attachTypeEnum"));
                }
                returnList.add(data);
            }
        }
        cfg.billAttachments = returnList;
    }

    private static boolean needMessageDigest(ApproveAssignmentInfo cfg) {
        if (!cfg.billIsReadOnly) {
            return false;
        }
        if (NO_BILL_URL.equals(cfg.billEditUrl)) {
            return true;
        }
        String url = cfg.billEditUrl;
        return url.indexOf("dynamicForm") < 0 && url.indexOf("pureWFBillUrl") < 0 && url.indexOf("BillServlet?formID") < 0 && url.indexOf("dynamicPage") < 0;
    }

    private static void getParams(Context ctx, ApproveAssignmentInfo cfg) throws BOSException, EASBizException {
        String confirmBeforeSubmit = ParamManager.getParamValue((Context)ctx, null, (String)"enableMultiapproveConfirm");
        cfg.confirmBeforeSubmit = "true".equals(confirmBeforeSubmit);
        String isOpenMessageSendOnUI = ParamManager.getParamValue((Context)ctx, null, (String)"isOpenMessageSendOnUI");
        cfg.isOpenMessageSendOnUI = "true".equals(isOpenMessageSendOnUI);
        String isNeedDefaultOption = ParamManager.getParamValue((Context)ctx, null, (String)"BS_MESSAGE_MASKDEFAULTOPINION");
        cfg.isNeedDefaultOption = "true".equals(isNeedDefaultOption);
    }

    private static void getMessageDigest(Context ctx, ApproveAssignmentInfo cfg, AssignmentInfo assign) throws Exception {
        try {
            if (cfg.messageDigest == null || cfg.messageDigest.trim().length() == 0) {
                String billId = assign.getBizObjectIds();
                SummaryProxy proxy = BillDigestFactory.getLocalInstance(ctx).getSummaryByUUIDAndDigType(billId, 2, assign.getAssignmentId());
                if (proxy != null) {
                    proxy.setEntryIds(null);
                    cfg.messageDigest = JSONUtils.convertObjectToJson((Context)ctx, (Object)proxy);
                } else {
                    cfg.messageDigest = BillDigestUtil.getDigest((Context)ctx, (String)billId, (String)"wf");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public String getDigest(String assignId) throws Exception {
        Context ctx = this.ctx;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo info = svc.getAssignmentById(assignId);
        ApproveAssignmentInfo cfg = new ApproveAssignmentInfo();
        ApproveUtil.getMessageDigest(ctx, cfg, info);
        return cfg.messageDigest;
    }

    private static void findNextActs(Context ctx, ApproveAssignmentInfo cfg, IEnactmentService svc, AssignmentInfo assign, ProcessDef processDef) throws BOSException, WfException, Exception {
        ApproveUtil util = new ApproveUtil(ctx);
        if (cfg.alwaysSetNextPersons || cfg.mustShowPostActivities || cfg.shouldCheckNextPartipants) {
            ArrayList nextActs = new ArrayList();
            String associatedLine = "";
            if (!StringUtils.isEmpty((String)cfg.approveValue)) {
                String[] items = StringUtils.split((String)cfg.approveValue, (String)":");
                for (int i = 0; i < items.length; ++i) {
                    String line;
                    String[] itemRow = StringUtils.split((String)items[i], (String)";");
                    String type = itemRow.length == 2 ? "\u5168\u90e8" : itemRow[2];
                    String string = line = itemRow.length < 4 ? "" : itemRow[3];
                    if (!"agree".equalsIgnoreCase(type) && !type.equals("\u540c\u610f") && !"all".equalsIgnoreCase(type) && !type.equals("\u5168\u90e8")) continue;
                    associatedLine = line;
                    break;
                }
            }
            util.findNextActsAndPersons(svc, assign, processDef, associatedLine, nextActs);
            cfg.nextActs = nextActs;
        }
    }

    private static void setForNotBosRuntime(Context ctx, ApproveAssignmentInfo cfg) {
        boolean isBosRuntime = ConfigLoader.getConfig4Server().isBosRuntime();
        if (!isBosRuntime) {
            cfg.disablePassAround = true;
            cfg.attachmentMode = "10";
            cfg.allowAppendActivity = false;
            cfg.mustShowPostActivities = false;
            cfg.allowDeliver = false;
            cfg.canSpecifyNextPerformer = false;
            cfg.dynamicSign = false;
            cfg.alwaysSetNextPersons = false;
            cfg.shouldCheckNextPartipants = false;
        }
        if (ApproveUtil.isCheckPermission(ctx)) {
            cfg.allowAppendActivity = true;
        }
    }

    private static MultiApproveCollection loadSaveMultiApproveInfo(Context ctx, AssignmentInfo assign) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (assignment='" + assign.getAssignmentId() + "')");
        String oql = buffer.toString();
        IMultiApprove m = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveCollection multiApproves = m.getMultiApproveCollection(oql);
        return multiApproves;
    }

    private static String getDefaultOpinion(ProcessDef def, ApproveActivityDef actDef, String opinion) throws WfException {
        ActualParameterCollection aParams = actDef.getActualParameters();
        if (aParams != null) {
            for (int i = 0; i < aParams.size(); ++i) {
                DataFieldDef dfDef;
                ActualParameterDef param = aParams.get(i);
                String name = param.getDataFieldName((ActivityDef)actDef);
                if (name == null || !name.startsWith("defaultOpinion") || (dfDef = def.getDataFieldDef(param.getExpr())) == null) continue;
                opinion = dfDef.getInitValue();
                break;
            }
        }
        return opinion;
    }

    private static String getDefaultOpinion(ProcessDef def, ManualDecisionActivityDef actDef, String opinion) throws WfException {
        ActualParameterCollection aParams = actDef.getActualParameters();
        if (aParams != null) {
            for (int i = 0; i < aParams.size(); ++i) {
                DataFieldDef dfDef;
                ActualParameterDef param = aParams.get(i);
                String name = param.getDataFieldName((ActivityDef)actDef);
                if (name == null || !name.startsWith("defaultOpinion") || (dfDef = def.getDataFieldDef(param.getExpr())) == null) continue;
                opinion = dfDef.getInitValue();
                break;
            }
        }
        return opinion;
    }

    private static void getExtendedAttributes(Context ctx, ApproveAssignmentInfo cfg, IEnactmentService svc, AssignmentInfo assign, ProcessDef processDef) throws Exception {
        String tmp;
        boolean allowmanualcc;
        String actId = assign.getActInstId();
        Map a = svc.getExtendedAttributesFromActivityInst(actId);
        cfg.notifyNextByMail = Boolean.parseBoolean((String)a.get("isSendMail"));
        cfg.notifyNextBySMS = Boolean.parseBoolean((String)a.get("isSendSMS"));
        cfg.attachmentMode = (String)a.get("attachMode");
        cfg.allowJumpTo = Boolean.parseBoolean((String)a.get("jumpTo"));
        cfg.allowKickBack = Boolean.parseBoolean((String)a.get("kickBack"));
        cfg.mustUploadAttachment = Boolean.parseBoolean((String)a.get("mustUploadAttachment"));
        cfg.allowAppendActivity = ApproveUtil.isCheckPermission(ctx) ? true : Boolean.parseBoolean((String)a.get("appendActivity"));
        cfg.isAppended = Boolean.parseBoolean((String)a.get("isAppended"));
        cfg.dynamicSign = Boolean.parseBoolean((String)a.get("IsDynamicSign"));
        cfg.allowCC = allowmanualcc = Boolean.parseBoolean((String)a.get("allowmanualcc"));
        cfg.needApproveOpinion = Boolean.parseBoolean((String)a.get("ApproveNoteIsNeed"));
        String s = (String)a.get("customUIStatus");
        cfg.billIsReadOnly = s == null || s.length() == 0 || s.equalsIgnoreCase("findview") || s.equalsIgnoreCase("view");
        cfg.riskInsight = (String)a.get("riskInsight");
        ProcessDef def = processDef;
        ActivityDef actDef = def.getActivityDef(assign.getActDefId());
        Abstracts procAbs = processDef.getAbstract();
        Abstracts actiAbs = null;
        if (actDef instanceof IAbstractActivity) {
            actiAbs = ((IAbstractActivity)actDef).getAbstract();
        }
        String procInstId = assign.getProcInstId();
        ProcessInstInfo procInstInfo = svc.getProcessInstInfo(procInstId);
        String parentInstId = procInstInfo.getParentProcInstId();
        while (procAbs == null && parentInstId != null) {
            ProcessInstInfo parentInfo = svc.getProcessInstInfo(parentInstId);
            ProcessDef parentDef = svc.getProcessDefByDefineHashValue(parentInfo.getProcDefHashValue());
            procAbs = parentDef.getAbstract();
            parentInstId = parentInfo.getParentProcInstId();
        }
        Locale locale = ctx.getLocale();
        String absStr = "";
        if (procAbs != null && (tmp = procAbs.getContent(locale)) != null) {
            absStr = tmp.trim();
        }
        if (actiAbs != null && (tmp = actiAbs.getContent(locale)) != null) {
            if (actiAbs.getType() == 0) {
                absStr = absStr + tmp.trim();
            } else if (actiAbs.getType() == 1) {
                absStr = tmp.trim();
            }
        }
        if (absStr.length() == 0) {
            cfg.absStr = null;
        } else {
            absStr = absStr.replaceAll("<strong>", "<b>");
            absStr = absStr.replaceAll("</strong>", "</b>");
            absStr = absStr.replaceAll("<em>", "<i>");
            absStr = absStr.replaceAll("</em>", "</i>");
            cfg.absStr = (absStr = ApproveUtil.parseMessage(absStr, svc.getProcessContext(procInstId, true), procInstInfo, locale, svc, processDef)) != null ? absStr.trim() : absStr;
        }
        String opinion = "";
        MultiApproveCollection multiApproves = ApproveUtil.loadSaveMultiApproveInfo(ctx, assign);
        if (multiApproves == null || multiApproves.size() <= 0) {
            if (actDef instanceof ApproveActivityDef) {
                opinion = ApproveUtil.getDefaultOpinion(def, (ApproveActivityDef)actDef, opinion);
            } else if (actDef instanceof ManualDecisionActivityDef) {
                opinion = ApproveUtil.getDefaultOpinion(def, (ManualDecisionActivityDef)actDef, opinion);
            }
        } else {
            opinion = multiApproves.get(0).getOpinion(ctx.getLocale());
            cfg.id = multiApproves.get(0).getId().toString();
            cfg.notifyNextByMail = multiApproves.get(0).isIsMailNotifyNext();
            cfg.notifyNextBySMS = multiApproves.get(0).isIsMobelNotifyNext();
            cfg.approveResult = multiApproves.get(0).getIsPass().getValue();
            cfg.handlerOpinion = multiApproves.get(0).getHandlerOpinion();
        }
        cfg.defaultOpinion = opinion;
        String decisions = "";
        if (actDef instanceof ApproveActivityDef) {
            cfg.mustShowPostActivities = ((ApproveActivityDef)actDef).isMustShowParticipantsCheckList();
            cfg.canSpecifyNextPerformer = ((ApproveActivityDef)actDef).canSpecifyNextActivityPerformer();
            cfg.allowDeliver = ((ApproveActivityDef)actDef).getAllowAssignNextPerformer();
            cfg.showAllEmptyManpowerActivites = ((ApproveActivityDef)actDef).isShowAllEmptyManpowerActivites();
            cfg.shouldCheckNextPartipants = Boolean.parseBoolean((String)a.get("nextPerson")) || ((ApproveActivityDef)actDef).isMustShowParticipantsCheckList();
            decisions = ((ApproveActivityDef)actDef).getManualDecisionItems(ctx.getLocale());
            if (StringUtils.isEmpty((String)decisions) && StringUtils.isEmpty((String)(decisions = ((ApproveActivityDef)actDef).getManualDecisionItems()))) {
                decisions = ((ApproveActivityDef)actDef).getManualDecisionItems(new Locale("l2"));
            }
            if (StringUtils.isEmpty((String)decisions)) {
                ExtendedAttributeCollection eac = actDef.getActivityHeader().getExtendedAttributes();
                ExtendedAttributeDef ead = eac.get("manualDecisionItems");
                decisions = ead != null ? ead.getValue() : null;
            }
            cfg.approveValue = decisions;
        } else if (actDef instanceof ManualDecisionActivityDef) {
            cfg.mustShowPostActivities = ((ManualDecisionActivityDef)actDef).isMustShowParticipantsCheckList();
            cfg.canSpecifyNextPerformer = ((ManualDecisionActivityDef)actDef).canSpecifyNextActivityPerformer();
            cfg.allowDeliver = ((ManualDecisionActivityDef)actDef).getAllowAssignNextPerformer();
            cfg.showAllEmptyManpowerActivites = ((ManualDecisionActivityDef)actDef).isShowAllEmptyManpowerActivites();
            cfg.shouldCheckNextPartipants = Boolean.parseBoolean((String)a.get("nextPerson")) || ((ManualDecisionActivityDef)actDef).isMustShowParticipantsCheckList();
        }
        String nextPersonSceneName = (String)a.get("nextPersonSceneName");
        cfg.alwaysSetNextPersons = Boolean.parseBoolean((String)a.get("alwaysSetNextPersons"));
        boolean alwaysSetNextPersons = ConfigLoader.getConfig4Server().getBoolean("always.set.next.persons", assign.getBizObjectIds(), "false");
        if (alwaysSetNextPersons) {
            cfg.alwaysSetNextPersons = alwaysSetNextPersons;
        }
        if (cfg.alwaysSetNextPersons) {
            cfg.canSpecifyNextPerformer = true;
        }
        ActivityPersonsInfo[] allPostActPersons = null;
        if (!cfg.alwaysSetNextPersons && !"gaoji".equals(nextPersonSceneName)) {
            boolean needSetNextPersons = false;
            allPostActPersons = svc.getPostActivitysPersonsByActInstID(assign.getActInstId(), ctx.getCaller().toString(), true, null);
            StringBuffer bf = new StringBuffer();
            for (int i = 0; i < allPostActPersons.length; ++i) {
                ActivityPersonsInfo info = allPostActPersons[i];
                if (info.getPersons().length > 0) continue;
                needSetNextPersons = true;
            }
            if (!needSetNextPersons) {
                cfg.shouldCheckNextPartipants = false;
            }
        }
    }

    private static void generateBillEditURL(Context ctx, ApproveAssignmentInfo cfg, IEnactmentService svc, AssignmentInfo assign) throws Exception {
        String s;
        URLInfo urlInfo = ProcessCenterUtil.getEditUrlInfoByAssign((String)assign.getAssignmentId(), (Context)ctx);
        if (urlInfo != null && StringUtils.isEmpty((String)urlInfo.getErrorMsg())) {
            if (!StringUtils.isEmpty((String)urlInfo.getURL())) {
                StringBuffer buff = new StringBuffer(urlInfo.getURL());
                if (buff.indexOf("proInstId") < 0) {
                    ApproveUtil.appendParam(buff, "proInstId", cfg.procInstId, true);
                }
                ApproveUtil.appendParam(buff, "checkCode", Md5Util.encode((String)buff.toString()), false);
                ApproveUtil.appendParam(buff, "Owner", "0", false);
                boolean isShowBillBtn = ProcessParamUtils.isSatisfyThisParam((Context)ctx, (String)assign.getProcDefId(), (String)"approvePageShowBillBtn");
                if (!isShowBillBtn) {
                    ApproveUtil.appendParam(buff, "hasToolbar", "false", false);
                }
                cfg.isShowBillBtn = isShowBillBtn;
                cfg.billEditUrl = buff.toString();
            } else {
                cfg.billEditUrl = NO_BILL_URL;
            }
        }
        cfg.billIsReadOnly = (s = ApproveUtil.getUIStatus(svc, assign)) == null || s.length() == 0 || s.equalsIgnoreCase("findview") || s.equalsIgnoreCase("view");
    }

    private static void setAssignAttributes(Context ctx, ApproveAssignmentInfo cfg, AssignmentInfo assign) throws WfException {
        cfg.assignId = assign.getAssignmentId();
        cfg.actInstId = assign.getActInstId();
        cfg.billId = assign.getBizObjectIds();
        if (cfg.billId == null || cfg.billId.length() == 0) {
            Locale l = ctx.getLocale();
            throw new RuntimeException("\u4efb\u52a1\u6ca1\u6709\u5173\u8054\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u5b9a\u4e49\uff08" + assign.getActDefName(l) + " - " + assign.getProcDefName(l) + "\uff09\uff01");
        }
        cfg.procDefHashCode = assign.getProcDefHashValue();
        cfg.procInstId = assign.getProcInstId();
        cfg.title = assign.getSubject(ctx.getLocale());
        cfg.procdefId = assign.getProcDefId();
    }

    private static String getAbstract(Context ctx, ApproveAssignmentInfo cfg, AssignmentInfo assignInfo) throws Exception {
        String tmp;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        String procInstId = assignInfo.getProcInstId();
        ProcessInstInfo procInstInfo = service.getProcessInstInfo(procInstId);
        ProcessDef processDef = service.getProcessDefByDefineHashValue(assignInfo.getProcDefHashValue());
        ActivityDef actDef = processDef.getActivityDef(assignInfo.getActDefId());
        Abstracts procAbs = processDef.getAbstract();
        Abstracts actiAbs = null;
        if (actDef instanceof IAbstractActivity) {
            actiAbs = ((IAbstractActivity)actDef).getAbstract();
        }
        String parentInstId = procInstInfo.getParentProcInstId();
        while (procAbs == null && parentInstId != null) {
            ProcessInstInfo parentInfo = service.getProcessInstInfo(parentInstId);
            ProcessDef parentDef = service.getProcessDefByDefineHashValue(parentInfo.getProcDefHashValue());
            procAbs = parentDef.getAbstract();
            parentInstId = parentInfo.getParentProcInstId();
        }
        Locale locale = ctx.getLocale();
        String absStr = "";
        if (procAbs != null && (tmp = procAbs.getContent(locale)) != null) {
            absStr = tmp.trim();
        }
        if (actiAbs != null && (tmp = actiAbs.getContent(locale)) != null) {
            if (actiAbs.getType() == 0) {
                absStr = absStr + tmp.trim();
            } else if (actiAbs.getType() == 1) {
                absStr = tmp.trim();
            }
        }
        if (absStr.length() == 0) {
            return null;
        }
        absStr = absStr.replaceAll("<strong>", "<b>");
        absStr = absStr.replaceAll("</strong>", "</b>");
        absStr = absStr.replaceAll("<em>", "<i>");
        absStr = absStr.replaceAll("</em>", "</i>");
        return (absStr = ApproveUtil.parseMessage(absStr, service.getProcessContext(assignInfo.getProcInstId(), true), procInstInfo, locale, service, processDef)) != null ? absStr.trim() : absStr;
    }

    private static String parseMessage(String message, Map processContext, ProcessInstInfo procInstInfo, Locale locale, IEnactmentService service, ProcessDef processDef) throws Exception {
        if (message == null) {
            return "";
        }
        Iterator it = processContext.keySet().iterator();
        DataFieldCollection dc = processDef.getDataFields();
        while (it.hasNext()) {
            String dataFieldName = it.next().toString();
            DataFieldDef dfd = dc.getByName(dataFieldName);
            if (dfd != null && (dfd.getDataType().equals(BasicType.BIZOBJ) || dfd.getDataType().equals(BasicType.APPROVERESULT))) continue;
            Object dataFieldVal = processContext.get(dataFieldName);
            String dataFieldValStr = dataFieldVal != null ? dataFieldVal.toString() : "";
            message = StringUtils.replace((String)message, (String)("@@" + dataFieldName), (String)StringUtils.cnulls((String)dataFieldValStr));
        }
        if ((message = WfBizObjUtils.replaceBizObjValue((Map)processContext, (ProcessDef)processDef, (DataFieldCollection)dc, (String)message)).indexOf("<%") != -1) {
            HashMap<String, Object> replaceMap = new HashMap<String, Object>();
            StringTokenizer token = new StringTokenizer(message, "<%");
            while (token.hasMoreTokens()) {
                Object obj;
                String temp = token.nextToken();
                if (temp.indexOf("%>") != -1) {
                    temp = temp.substring(0, temp.lastIndexOf("%>"));
                }
                if ((obj = service.evelScript(temp, procInstInfo, locale)) == null) continue;
                replaceMap.put(temp, obj);
            }
            for (String key : replaceMap.keySet()) {
                Object value = replaceMap.get(key);
                message = StringUtils.replace((String)message, (String)("<%" + key + "%>"), (String)value.toString());
            }
        }
        return message;
    }

    public static String getEditUrl(Context ctx, String billId, String UIStatus) {
        BOSUuid id = BOSUuid.read((String)billId);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo billObject = loader.getEntity(id.getType());
        if (billObject == null) {
            throw new IllegalArgumentException("BillObject is null");
        }
        String s = "edit";
        if (UIStatus == null || UIStatus.length() == 0 || UIStatus.equalsIgnoreCase("findview") || UIStatus.equalsIgnoreCase("view")) {
            s = "view";
        }
        try {
            String url = "";
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] instInfos = svc.getProcessInstanceByHoldedObjectId(billId);
            logger.info((Object)("instInfos.length = " + instInfos.length));
            if (instInfos.length == 0) {
                instInfos = svc.getAllProcessInstancesByBizobjId(billId);
            }
            boolean flag = false;
            for (int k = 0; k < instInfos.length; ++k) {
                String hashValue = instInfos[k].getProcDefHashValue();
                ProcessDef def = svc.getProcessDefByDefineHashValue(hashValue);
                ActivityCollection ac = def.getActivitys();
                ActivityDef actDef = null;
                for (int i = 0; i < ac.size(); ++i) {
                    actDef = ac.get(i);
                    ExtendedAttributeDef extend = actDef.getActivityHeader().getExtendedAttributes().get("isWebBillApprove");
                    if (extend == null || !"true".equalsIgnoreCase(extend.getValue())) continue;
                    ExtendedAttributeDef extend1 = actDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                    String string = url = extend1 != null ? extend1.getValue() : "";
                    if (StringUtils.isEmpty((String)url)) continue;
                    flag = true;
                    break;
                }
                if (flag) break;
            }
            if (!StringUtils.isEmpty((String)url)) {
                return url;
            }
            String waf2url = ApproveUtil.getWAF2SolutionURL(billObject, s, ctx, billId);
            if (!StringUtils.isEmpty((String)waf2url)) {
                return waf2url;
            }
            String editUiPk = StoreUtils.getWebUI((String)billId, (Context)ctx);
            String web_dynamic = billObject.getExtendedProperty("web_dynamic");
            if (billObject.isDynamic() && !"1".equalsIgnoreCase(web_dynamic) && !StringUtils.isEmpty((String)editUiPk)) {
                url = "/winlet/edit/editUIProxy.jsf?uipk=" + editUiPk;
            } else {
                String editUi;
                if (!StringUtils.isEmpty((String)editUiPk)) {
                    url = StoreUtils.webUIName2URL((String)editUiPk);
                }
                if (StringUtils.isEmpty((String)url) && !StringUtils.isEmpty((String)(editUi = billObject.getExtendedProperty("editUI")))) {
                    url = ApproveUtil.getURLfromEditUI(ctx, editUi);
                }
            }
            if (StringUtils.isEmpty((String)url)) {
                return "webviews/workflow/nobill.html";
            }
            return url;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "webviews/workflow/nobill.html";
        }
    }

    private static String getAppSolutionID(String pk, IObjectValue model, String viewtype, Context ctx) {
        BOSObjectType type = null;
        if (pk == null && model.get("id") != null) {
            pk = model.get("id").toString();
        }
        if (pk == null) {
            return null;
        }
        type = BOSUuid.read((String)pk).getType();
        try {
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            ICoreBillBase iBillBase = (ICoreBillBase)obj;
            return iBillBase.getAppSolutionID((IObjectPK)new ObjectUuidPK(pk), model, viewtype);
        }
        catch (BOSException e) {
            logger.error((Object)("invoke getAppSolutionID error" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("invoke getAppSolutionID error" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public static IObjectValue getObjectValueById(Context ctx, String billId) throws WfException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk);
        }
        catch (DataAccessException e) {
            logger.warn((Object)("createObjectValueByBoId throw DataAccessException error " + e.getMessage()));
            throw new WfException((Throwable)e, true);
        }
        catch (SQLException e) {
            logger.warn((Object)("createObjectValueByBoId throw SQLException error " + e.getMessage()));
            throw new WfException((Throwable)e, true);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return model;
    }

    private static String getWAF2SolutionURL(EntityObjectInfo entityObjectInfo, String type, Context ctx, String billId) {
        String entityName = entityObjectInfo.getFullName();
        String appid = null;
        String url = null;
        String className = entityObjectInfo.getObjectValueClass();
        try {
            IObjectValue objValue = ApproveUtil.getObjectValueById(ctx, billId);
            if (objValue instanceof CoreBillBaseInfo) {
                appid = ApproveUtil.getAppSolutionID(null, (IObjectValue)((CoreBillBaseInfo)objValue), type, ctx);
            }
        }
        catch (Exception objValue) {
            // empty catch block
        }
        if (appid != null && !"".equals(appid)) {
            url = ApproveUtil.getURLByAppID(appid, type, entityName);
        }
        if (url == null || "".equals(url)) {
            StringBuffer querySql = new StringBuffer("select fid FID from t_dyn_appsolution A where (fapptype='bizbill' or fapptype='bizunit') and fmainentity ='" + entityName + "'");
            querySql.append(" AND  FMENULONGNUMBER not like '%cust!%'");
            try {
                SQLExecutor se = new SQLExecutor(querySql.toString());
                IRowSet rs = se.executeSQL();
                while (rs.next() && (url = ApproveUtil.getURLByAppID(appid = rs.getString("FID"), type, entityName)) == null) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private static String getURLByAppID(String appid, String type, String entityName) {
        String url = ApproveUtil.getDynamicEditUrl(appid, type, entityName);
        if ((url == null || "".equals(url)) && "view".equals(type)) {
            url = ApproveUtil.getDynamicEditUrl(appid, "edit", entityName);
        }
        return url;
    }

    private static String getDynamicEditUrl(String appid, String type, String entityName) {
        String sql = "select  FWEBUIOBJECTNAME,FISDEFAULT,fentityobjectname,FISDEFAULT from  T_DYN_DynamicConfigure  where fpagetype ='" + type + "'  and fdependID is null ";
        sql = sql + " and FAPPSOLUTIONID='" + appid + "'";
        sql = sql + " and fpkg <> 'com.kingdee.eas.fi.vc.vc'";
        sql = sql + " and fentityobjectname = '" + entityName + "'";
        sql = sql + " order by T_DYN_DynamicConfigure.FISDEFAULT desc,FLASTMETAUPDATETIME asc ";
        try {
            SQLExecutor se = new SQLExecutor(sql);
            IRowSet rs = se.executeSQL();
            String uipk = null;
            String FISDEFAULT = null;
            while (rs.next()) {
                uipk = rs.getString("FWEBUIOBJECTNAME");
                FISDEFAULT = rs.getString("FISDEFAULT");
                if (!"1".equals(FISDEFAULT)) continue;
                return ApproveUtil.getDynamicEditUrl(uipk);
            }
            if (uipk != null && !"".equals(uipk)) {
                return ApproveUtil.getDynamicEditUrl(uipk);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getDynamicEditUrl(String uipk) {
        return "/dynamicForm.do?event=initialize&method=initalize&uipk=" + uipk;
    }

    private static String getURLfromEditUI(Context ctx, String editUi) throws BOSException {
        String o = null;
        MetaDataPK metaPK = MetaDataPK.create((String)editUi);
        IObjectValue objVal = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).get(MetaDataTypeList.UIOBJECT, (IMetaDataPK)metaPK);
        if (objVal != null) {
            o = objVal.getExtendedProperty("url");
        }
        String url = o == null ? "" : o.toString().trim();
        return url;
    }

    private static String getUIStatus(IEnactmentService service, AssignmentInfo assignInfo) throws Exception {
        ActivityInstInfo instInfo = service.getActivityInstByActInstId(assignInfo.getActInstId());
        ActivityDef def = service.getActDefByActInstInfo(instInfo);
        ExtendedAttributeCollection extendAttrCol = def.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef value = extendAttrCol.get("customUIStatus");
        return value == null ? "" : value.getValue();
    }

    public static void appendParam(StringBuffer buffer, String key, String value, boolean encode) throws Exception {
        if (value == null) {
            return;
        }
        if (encode) {
            value = URLEncoder.encode(value, "utf-8");
        }
        buffer.append(buffer.indexOf("?") < 0 ? "?" : "&");
        buffer.append(key + "=" + value);
    }

    public List findPostParticipants(String assignId, String associatedLine) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        ArrayList nextActs = new ArrayList();
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        ProcessDef def = svc.getProcessDefByDefineHashValue(assign.getProcDefHashValue());
        this.findNextActsAndPersons(svc, assign, def, associatedLine, nextActs);
        return nextActs;
    }

    private HashMap[] searchNextActs(AssignmentInfo assign, String associatedLine) throws BOSException {
        WfProcessDiagram diag = new WfProcessDiagram(this.ctx, associatedLine);
        String[] actIds = new String[]{assign.getActInstId()};
        HashMap[] acts = diag.findNextManpownerActivities(actIds);
        return acts;
    }

    private void initNextPersonExt(AssignmentInfo assign) {
        String billId = assign.getBizObjectIds();
        this.ext = ConfigLoader.getConfig4Server().getWfNextPersonExt(this.ctx, billId);
        if (this.ext == null) {
            this.ext = new AbstractWfNextPersonExt(this.ctx);
        }
    }

    private void findNextActsAndPersons(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, String associatedLine, ArrayList nextActs) throws BOSException, WfException, Exception {
        this.initNextPersonExt(assign);
        HashMap[] acts = this.searchNextActs(assign, associatedLine);
        if (acts.length == 0) {
            return;
        }
        this.calcAllNextParticipants(svc, assign, def, nextActs, acts);
    }

    private void calcAllNextParticipants(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, ArrayList nextActs, HashMap[] acts) throws Exception {
        IPerson personInstance = PersonFactory.getLocalInstance((Context)this.ctx);
        WfEngine engine = WfEngine.getEngine((Context)this.ctx);
        WfProcess procInst = engine.getProcessInst(assign.getProcInstId());
        for (int k = 0; k < acts.length; ++k) {
            String temp;
            int j;
            ActivityDef actDef = (ActivityDef)acts[k].get("actDef");
            if (!(actDef instanceof ManpowerActivityDef)) {
                HashMap[] subActs = (HashMap[])acts[k].get("subActivities");
                this.calcAllNextParticipants(svc, assign, def, nextActs, subActs);
                continue;
            }
            ManpowerActivityDef manActDef = (ManpowerActivityDef)actDef;
            if (this.ext.isIgnore(manActDef, assign.getAssignmentId(), null)) continue;
            String key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)manActDef);
            List personIds = (List)svc.getProcessContext(assign.getProcInstId(), key);
            List persons = new ArrayList();
            if (personIds != null && personIds.size() != 0) {
                persons = this.retrieveParticipants(svc, personIds);
            }
            LinkedHashMap<String, String> candidateselected = new LinkedHashMap<String, String>();
            if (persons != null) {
                for (int i = 0; i < persons.size(); ++i) {
                    Person p = (Person)persons.get(i);
                    if (p.getEmployeeId() == null) continue;
                    candidateselected.put(p.getEmployeeId(), p.getEmployeeName(this.ctx.getLocale()));
                }
            }
            LinkedHashMap<String, String> candidates = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> newcandidates = new LinkedHashMap<String, String>();
            List _newparticipants = this.getParticipant(manActDef);
            LinkedHashMap participants = new LinkedHashMap();
            LinkedHashMap<String, String> userCandidates = new LinkedHashMap<String, String>();
            HashSet<Integer> conditionPerson = new HashSet<Integer>();
            for (j = 0; j < _newparticipants.size(); ++j) {
                try {
                    String script;
                    ParticipantDef prtcpntDef = (ParticipantDef)_newparticipants.get(j);
                    if (StringUtils.isEmpty((String)prtcpntDef.getScriptRef()) || !ScriptUtil.evalCondition((String)(script = def.getScripts().get(prtcpntDef.getScriptRef()).getScriptContent()), (ProcessContext)procInst.getProcessContext(), (ProcessDef)def)) continue;
                    conditionPerson.add(j);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            for (j = 0; j < _newparticipants.size(); ++j) {
                if (conditionPerson.size() > 0 && !conditionPerson.contains(j)) continue;
                HashMap<String, Object> participant = new HashMap<String, Object>();
                ParticipantDef prtcpntDef = (ParticipantDef)_newparticipants.get(j);
                ParticipantType participantType = prtcpntDef.getParticipantType();
                String id = prtcpntDef.getID().toString();
                try {
                    String script;
                    if (!StringUtils.isEmpty((String)prtcpntDef.getScriptRef()) && !ScriptUtil.evalCondition((String)(script = def.getScripts().get(prtcpntDef.getScriptRef()).getScriptContent()), (ProcessContext)procInst.getProcessContext(), (ProcessDef)def)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                try {
                    if (ParticipantType.HUMAN.equals((Object)participantType)) {
                        String personid = prtcpntDef.getParticipantValue();
                        PersonInfo person = personInstance.getPersonInfo((IObjectPK)new ObjectUuidPK(personid));
                        newcandidates.put(personid, person.getName(this.ctx.getLocale()));
                        candidates.put(personid, person.getName(this.ctx.getLocale()));
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (ParticipantType.USER.equals((Object)participantType)) {
                    String userId = prtcpntDef.getParticipantValue();
                    userCandidates.put(userId, prtcpntDef.getName());
                    candidates.put(userId, prtcpntDef.getName());
                    continue;
                }
                ProcessDef process = (ProcessDef)prtcpntDef.getContainer().getContainer();
                String text = com.kingdee.eas.base.multiapprove.ParticipantUtils.getParticipantName((ParticipantDef)prtcpntDef, (ProcessDef)process, (Locale)this.ctx.getLocale(), (Context)this.ctx);
                participant.put("name", text);
                ArrayList<String> participantids = new ArrayList<String>();
                participantids.add(id);
                List person = null;
                try {
                    person = this.participantsToPersons(svc, assign, def, manActDef, participantids);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                LinkedHashMap<String, String> candidate = new LinkedHashMap<String, String>();
                if (person != null) {
                    for (int i = 0; i < person.size(); ++i) {
                        Person p = (Person)person.get(i);
                        if (p.getEmployeeId() == null) {
                            candidates.put(p.getUserId(), p.getUserName(this.ctx.getLocale()));
                            continue;
                        }
                        candidate.put(p.getEmployeeId(), p.getEmployeeName(this.ctx.getLocale()));
                        candidates.put(p.getEmployeeId(), p.getEmployeeName(this.ctx.getLocale()));
                    }
                }
                participant.put("person", candidate);
                participants.put(actDef.getID().toString() + id, participant);
            }
            if (newcandidates.size() > 0) {
                HashMap<String, Object> participant = new HashMap<String, Object>();
                temp = "\u804c\u5458";
                if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
                    temp = "Employee";
                } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
                    temp = "\u8077\u54e1";
                }
                participant.put("name", temp);
                participant.put("person", newcandidates);
                participants.put(actDef.getID().toString() + k, participant);
            }
            if (userCandidates.size() > 0) {
                HashMap<String, Object> participant = new HashMap<String, Object>();
                temp = "\u7528\u6237";
                if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l1")) {
                    temp = "User";
                } else if (this.ctx.getLocale().getLanguage().equalsIgnoreCase("l3")) {
                    temp = "\u7528\u6236";
                }
                participant.put("name", temp);
                participant.put("person", userCandidates);
                participants.put(actDef.getID().toString() + k + 1, participant);
            }
            HashMap nextAct = this.assembleActAndPersonInfo(def, manActDef, key, candidates, participants, candidateselected);
            nextActs.add(nextAct);
        }
    }

    private List getParticipant(ManpowerActivityDef actDef) throws WfException {
        ParticipantCollection includeCol = new ParticipantCollection();
        ParticipantBlock block = new ParticipantBlock((ActivityDef)actDef);
        List caseList = block.getChildren();
        ArrayList<ParticipantDef> list = new ArrayList<ParticipantDef>();
        ArrayList<ParticipantDef> conditionParticipantIdList = new ArrayList<ParticipantDef>();
        int n = caseList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantCase pCase = (ParticipantCase)caseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                includeCol.addObject(def.getID(), (Object)def);
            }
        }
        for (int k = 0; k < includeCol.size(); ++k) {
            conditionParticipantIdList.add(includeCol.get(k));
        }
        Iterator iter = null;
        for (Object e : conditionParticipantIdList) {
            ParticipantDef participant = null;
            if (!(e instanceof ParticipantDef)) continue;
            participant = (ParticipantDef)e;
            list.add(participant);
        }
        return list;
    }

    private HashMap assembleActAndPersonInfo(ProcessDef def, ManpowerActivityDef manActDef, String key, Map candidates, Map participants, Map candidateselected) {
        HashMap<String, Object> nextAct = new HashMap<String, Object>();
        nextAct.put("persons", candidates);
        nextAct.put("count", String.valueOf(candidates.size()));
        nextAct.put("actKey", key);
        nextAct.put("actId", manActDef.getID());
        String actName = this.generateActName(def, manActDef);
        nextAct.put("actName", actName);
        nextAct.put("isAllPersonAsPerformer", manActDef.isAllPersonAsPerformer());
        nextAct.put("participants", participants);
        nextAct.put("candidateselected", candidateselected);
        return nextAct;
    }

    private String generateActName(ProcessDef def, ManpowerActivityDef manActDef) {
        ProcessDef current = (ProcessDef)manActDef.getContainer();
        String actName = manActDef.getName(this.ctx.getLocale());
        return actName;
    }

    private Map eliminateDuplicatedPersons(List persons) {
        LinkedHashMap<String, String> candidates = new LinkedHashMap<String, String>();
        for (int i = 0; i < persons.size(); ++i) {
            Person p = (Person)persons.get(i);
            candidates.put(p.getEmployeeId(), p.getEmployeeName(this.ctx.getLocale()));
        }
        return candidates;
    }

    private List calcParticipants(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, String key, ManpowerActivityDef manActDef) throws Exception {
        List personIds = (List)svc.getProcessContext(assign.getProcInstId(), key);
        List persons = personIds == null || personIds.size() == 0 ? this.estimateParticipants(svc, assign, def, manActDef) : this.retrieveParticipants(svc, personIds);
        return persons;
    }

    private List retrieveParticipants(IEnactmentService svc, List personIds) throws Exception {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (int i = 0; i < personIds.size(); ++i) {
            String personId = (String)personIds.get(i);
            Person[] tmp = svc.getPersonByPersonID(personId);
            for (int j = 0; j < tmp.length; ++j) {
                persons.add(tmp[j]);
            }
        }
        return persons;
    }

    private List estimateParticipants(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, ManpowerActivityDef manActDef) throws Exception {
        ArrayList participants = this.getParticipantDefs(assign, manActDef);
        List persons = this.participantsToPersons(svc, assign, def, manActDef, participants);
        this.appendAdditionalPersons(svc, assign, manActDef, persons);
        return persons;
    }

    private void appendAdditionalPersons(IEnactmentService svc, AssignmentInfo assign, ManpowerActivityDef manActDef, List persons) throws Exception {
        String[] addedPersons = this.ext.getAddedCandidates(manActDef, assign.getAssignmentId(), null);
        if (addedPersons != null) {
            for (int i = 0; i < addedPersons.length; ++i) {
                Person[] tmp = svc.getPersonByPersonID(addedPersons[i]);
                for (int j = 0; j < tmp.length; ++j) {
                    persons.add(tmp[j]);
                }
            }
        }
    }

    private List participantsToPersons(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, ManpowerActivityDef manActDef, ArrayList participants) throws WfException {
        String hashCode = ((ProcessDef)manActDef.getContainer()).getHashValue();
        List persons = hashCode.equals(def.getHashValue()) ? svc.getPersonsByParticipants(assign.getProcInstId(), manActDef.getID(), (List)participants) : svc.getPersonsByDefParticipants(hashCode, manActDef.getID(), (List)participants, this.ctx.getCaller().toString());
        return persons;
    }

    private ArrayList getParticipantDefs(AssignmentInfo assign, ManpowerActivityDef manActDef) {
        ArrayList<String> participants = new ArrayList<String>();
        ParticipantCollection pc = manActDef.getParticipants();
        for (int i = 0; i < pc.size(); ++i) {
            ParticipantDef p = pc.get(i);
            if (this.ext.isIgnore(p, assign.getAssignmentId(), null)) continue;
            participants.add(p.getID());
        }
        return participants;
    }

    public String save(Map approve, List nextActs) throws Exception {
        this.checkSave(approve);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String assignId = (String)approve.get("assignId");
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        this.saveAndSignatureApproveBill(approve, assignId, assign.getBizObjectIds());
        this.saveNextActsPersons(nextActs, svc, assign);
        MultiApproveInfo info = this.generateApproveInfo(approve, assignId, assign);
        info.setStatus(MultiApproveStatusEnum.TEMPORARILYSAVE);
        if (info.getId() != null) {
            MultiApproveFactory.getLocalInstance((Context)this.ctx).save((CoreBaseInfo)info);
        } else {
            MultiApproveFactory.getLocalInstance((Context)this.ctx).addnew((CoreBaseInfo)info);
        }
        return info.getId().toString();
    }

    private void checkSave(Map approve) throws Exception {
        String assignId = (String)approve.get("assignId");
        MultiApproveCollection coll = MultiApproveFactory.getLocalInstance((Context)this.ctx).getMultiApproveCollection(" where assignment = '" + assignId + "'");
        if (coll.size() > 0 && coll.get(0).getStatus() == MultiApproveStatusEnum.SUBMIT) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1\u5df2\u5ba1\u6279\uff0c\u65e0\u9700\u518d\u6b21\u4fdd\u5b58");
        }
    }

    public String submit(Map approve, List nextActs) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String assignId = (String)approve.get("assignId");
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        String operation = (String)approve.get("operation");
        Object logPk = null;
        if ("approve".equals(operation)) {
            this.saveAndSignatureApproveBill(approve, assignId, assign.getBizObjectIds());
            String multiApproveId = this.approve(approve, nextActs, svc, assignId, assign);
            try {
                String ccPersonIds;
                String result = ParamManager.getParamValue((Context)this.ctx, null, (String)"IgnoreEditState");
                if ("true".equalsIgnoreCase(result)) {
                    String isReadOnly = (String)approve.get("isReadOnly");
                    String billIsChanged = "true".equals(isReadOnly) ? "false" : "true";
                    svc.setProcessContext(assign.getProcInstId(), "$approveBillEdit" + assignId, (Object)billIsChanged);
                }
                if (!StringUtils.isEmpty((String)(ccPersonIds = (String)approve.get("ccPersonIds")))) {
                    svc.setProcessContext(assign.getProcInstId(), "$ccPersonIds" + assignId, (Object)ccPersonIds);
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf\u51fa\u9519" + e.getMessage()), (Throwable)e);
            }
            return multiApproveId;
        }
        if ("deliver".equals(operation)) {
            return this.deliver(approve, svc, assignId, assign);
        }
        if ("kickBack".equals(operation)) {
            return this.kickBack(approve, svc, assignId, assign);
        }
        if ("jumpTo".equals(operation)) {
            return this.jumpTo(approve, svc, assignId, assign);
        }
        if ("submitNext".equals(operation)) {
            return this.submitNext(approve, svc, assignId, assign);
        }
        throw new Exception("Invalid Operation!");
    }

    private void setCCMessage() {
    }

    public String batchSubmit(String assignIds, Map<String, Object> approve) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        try {
            this.signatureBatchApproveBills(approve, assignIds);
        }
        catch (Exception e) {
            throw new Exception("\u5904\u7406CA\u8ba4\u8bc1\u9a8c\u7b7e\u5931\u8d25\uff01");
        }
        int i = 0;
        for (String assignId : assignIds.split(";")) {
            AssignmentInfo assign = svc.getAssignmentById(assignId);
            WfAssignmentState state = assign.getState();
            if (state == WfAssignmentState.ACCEPTED || state == WfAssignmentState.ASSIGNED) {
                this.approve(approve, null, svc, assignId, assign);
            }
            if (state != WfAssignmentState.COMPLETED) continue;
            ++i;
        }
        if (i > 0) {
            return "ERROR";
        }
        return "OK";
    }

    public String batchSubmits(String assignIds, String billIds, Map<String, Object> approve, List nextActs) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        try {
            this.signatureBatchApproveBillsNew(approve, billIds, assignIds);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception("\u5904\u7406CA\u8ba4\u8bc1\u9a8c\u7b7e\u5931\u8d25\uff01", e);
        }
        int i = 0;
        for (String assignId : assignIds.split(";")) {
            AssignmentInfo assign = svc.getAssignmentById(assignId);
            WfAssignmentState state = assign.getState();
            if (state == WfAssignmentState.ACCEPTED || state == WfAssignmentState.ASSIGNED) {
                this.batchApprove(approve, nextActs, svc, assignId, assign);
            }
            if (state != WfAssignmentState.COMPLETED) continue;
            ++i;
        }
        if (i > 0) {
            return "ERROR";
        }
        return "OK";
    }

    String kickBack(Map approve, IEnactmentService svc, String assignId, AssignmentInfo assign) throws Exception {
        IDynamicWfService.JumpTarget target = this.getTarget(approve, assign);
        target.handlerContent = this.getResource("dynamicKickBack");
        new DynamicWfService(this.ctx).kickBack(target);
        return "OK";
    }

    private IDynamicWfService.JumpTarget getTarget(Map approve, AssignmentInfo assign) {
        Map data = (Map)approve.get("target");
        IDynamicWfService.JumpTarget target = IDynamicWfService.JumpTarget.from((Map)data);
        target.assignment = assign;
        boolean isSendSMS = "true".equals(approve.get("isSendSMS"));
        boolean isSendMail = "true".equals(approve.get("isSendMail"));
        target.comment = (String)approve.get("opinion");
        target.sendMail = isSendMail;
        target.sendSMS = isSendSMS;
        target.handlerOpinion = 0;
        return target;
    }

    private String getResource(String key) {
        String RES = ApproveUtil.class.getName();
        ResourceBundle res = ResourceBundle.getBundle(RES, this.ctx.getLocale());
        return res.getString(key);
    }

    String jumpTo(Map approve, IEnactmentService svc, String assignId, AssignmentInfo assign) throws Exception {
        IDynamicWfService.JumpTarget target = this.getTarget(approve, assign);
        target.handlerContent = this.getResource("dynamicJumpTo");
        new DynamicWfService(this.ctx).jumpTo(target);
        return "OK";
    }

    String deliver(Map approve, IEnactmentService svc, String assignId, AssignmentInfo assign) throws Exception {
        String RES = ApproveUtil.class.getName();
        ResourceBundle res = ResourceBundle.getBundle(RES, this.ctx.getLocale());
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        PersonInfo currentPerson = currentUserInfo.getPerson();
        String personId = (String)approve.get("delegateId");
        String opinion = (String)approve.get("opinion");
        Person[] persons = svc.getPersonByPersonID(personId);
        if (persons == null || persons.length == 0) {
            throw new Exception(res.getString("employeeNoReferenceUser"));
        }
        if (currentPerson.getId().toString().equals(personId)) {
            throw new Exception(res.getString("canNotDeliverToTheSamePerson"));
        }
        Locale[] locales = ApplicationUtil.getContextLocales((Context)this.ctx);
        HashMap<Locale, String> opinionMap = new HashMap<Locale, String>();
        for (int i = 0; i < locales.length; ++i) {
            Locale local = locales[i];
            String data = opinion + "\n" + ResourceBundle.getBundle(RES, local).getString("deliver.user") + currentUserInfo.getName(local);
            opinionMap.put(local, data);
        }
        try {
            IWfUtil util = WfFacadeUtilFactory.createRemoteWfUtil();
            util.forward(assignId, persons[0].getUserId(), opinionMap, opinion);
            return "OK";
        }
        catch (DevolveDenialException e) {
            throw new Exception(res.getString("DevolveDenial"), e);
        }
        catch (WfException e) {
            throw new Exception(res.getString("deliverFailed"), e);
        }
    }

    String submitNext(Map approve, IEnactmentService svc, String assignId, AssignmentInfo assign) throws Exception {
        this.appendActivities(approve, assignId);
        this.approve(approve, null, svc, assignId, assign);
        return "OK";
    }

    private void appendActivities(Map approve, String assignId) throws Exception {
        String[] performIds = ((String)approve.get("performIds")).split(",");
        String[] performNames = ((String)approve.get("performNames")).split(",");
        IDynamicWfService.DynamicActivityDef[] acts = new IDynamicWfService.DynamicActivityDef[performIds.length];
        for (int i = 0; i < performIds.length; ++i) {
            IDynamicWfService.DynamicActivityDef act = new IDynamicWfService.DynamicActivityDef();
            act.isSendSMS = "true".equals(approve.get("isSendSMS"));
            act.isSendMail = "true".equals(approve.get("isSendMail"));
            act.allowSubmitNextPerformer = true;
            act.allowAppend = true;
            IDynamicWfService.Performer p = new IDynamicWfService.Performer(performIds[i], performNames[i].trim());
            act.performers = new IDynamicWfService.Performer[]{p};
            acts[i] = act;
        }
        String mode = "true".equals(approve.get("assistant")) ? "2" : "1";
        new DynamicWfService(this.ctx).appendActivity(assignId, acts, mode, "2", false);
    }

    private String approve(Map approve, List nextActs, IEnactmentService svc, String assignId, AssignmentInfo assign) throws Exception {
        this.saveNextActsPersons(nextActs, svc, assign);
        MultiApproveInfo info = this.generateApproveInfo(approve, assignId, assign);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        info.setInputType(InputType.PROC_CENTER);
        try {
            MultiApproveFactory.getLocalInstance((Context)this.ctx).submit((CoreBaseInfo)info);
            return info.getId().toString();
        }
        catch (AlreadyInProcessQueueException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private MultiApproveInfo generateApproveInfo(Map approve, String assignId, AssignmentInfo assign) {
        String id;
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assignId);
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assignId);
        info.setExtendedProperty("isAddNew", "isAddNew");
        boolean isSendSMS = "true".equals(approve.get("isSendSMS"));
        boolean isSendMail = "true".equals(approve.get("isSendMail"));
        info.setIsMailNotifyNext(isSendMail);
        info.setIsMobelNotifyNext(isSendSMS);
        String opinion = (String)approve.get("opinion");
        info.setOpinion(opinion, new Locale("L1"));
        info.setOpinion(opinion, new Locale("L2"));
        info.setOpinion(opinion, new Locale("L3"));
        String result = (String)approve.get("approveResult");
        info.setIsPass(ApproveResult.getEnum((String)result));
        String handlerOpinion = (String)approve.get("handlerOpinion");
        info.setHandlerOpinion(Integer.parseInt(handlerOpinion));
        String handlerContent = (String)approve.get("handlerContent");
        info.setHandlerContent(handlerContent);
        String esignatureid = (String)approve.get("esignatureid");
        if (esignatureid != null && esignatureid.length() > 0) {
            info.setEsignatureId(esignatureid);
        }
        if ((id = (String)approve.get("id")) != null && id.length() > 0) {
            info.setId(BOSUuid.read((String)id));
        }
        return info;
    }

    private void saveNextActsPersons(List nextActs, IEnactmentService svc, AssignmentInfo assign) throws BOSException, SQLException {
        if (nextActs != null) {
            for (int i = 0; i < nextActs.size(); ++i) {
                Map act = (Map)nextActs.get(i);
                String key = (String)act.get("actKey");
                Map persons = (Map)act.get("persons");
                ArrayList personIds = new ArrayList();
                for (Map.Entry person : persons.entrySet()) {
                    if (person.getValue() == null || "".equals(person.getValue())) continue;
                    personIds.add(person.getKey());
                }
                svc.setProcessContext(assign.getProcInstId(), key, personIds);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private HashMap<String, String> getProcinstids(String procinstId, IEnactmentService svc) throws BOSException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map[] getKickBackTargets(String assignId) throws Exception {
        DynamicWfService svc = new DynamicWfService(this.ctx);
        IDynamicWfService.JumpTarget[] targets = svc.getKickBackTargets(assignId);
        Map[] list = new Map[targets.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = targets[i].toMap();
        }
        return list;
    }

    public Map[] getJumpToTargets(String assignId) throws Exception {
        DynamicWfService svc = new DynamicWfService(this.ctx);
        IDynamicWfService.JumpTarget[] targets = svc.getJumpToTargets(assignId);
        Map[] list = new Map[targets.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = targets[i].toMap();
        }
        return list;
    }

    public ApproveUtil(Context ctx) {
        this.ctx = ctx;
    }

    public Map checkPerson(List list) throws Exception {
        if (list == null || list.size() == 0) {
            return null;
        }
        HashMap rtn = new HashMap();
        ArrayList<Map> error = new ArrayList<Map>();
        ArrayList<Map> ok = new ArrayList<Map>();
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Map d = (Map)list.get(i);
            Person[] tmp = svc.getPersonByPersonID(d.get("value") + "");
            if (tmp == null || tmp.length == 0) {
                error.add(d);
                continue;
            }
            ok.add(d);
        }
        rtn.put("ok", ok);
        rtn.put("error", error);
        return rtn;
    }

    public boolean myPhraseDelete(String id) {
        boolean rtn = false;
        if (!StringUtils.isEmpty((String)id)) {
            try {
                IMyPhrase service = MyPhraseFactory.getLocalInstance((Context)this.ctx);
                service.delete((IObjectPK)new ObjectUuidPK(id));
                rtn = true;
            }
            catch (Exception e) {
                logger.error((Object)"delete my phrase error", (Throwable)e);
            }
        }
        return rtn;
    }

    public String myPhraseSave(String id, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return id;
        }
        try {
            IMyPhrase service = MyPhraseFactory.getLocalInstance((Context)this.ctx);
            IUser userService = UserFactory.getLocalInstance((Context)this.ctx);
            if (StringUtils.isEmpty((String)id)) {
                UserInfo userInfo = userService.getUserInfo(this.ctx.getCaller());
                String number = "MyPhrase_" + ApproveUtil.getRandomInt();
                MyPhraseInfo info = null;
                MyPhraseCollection infos = service.getMyPhraseCollection("where creator.id = '" + this.ctx.getCaller() + "' and number='" + number + "'");
                while (infos.size() > 0) {
                    number = "MyPhrase_" + ApproveUtil.getRandomInt();
                    infos = service.getMyPhraseCollection("where creator.id = '" + this.ctx.getCaller() + "' and number='" + number + "'");
                }
                info = new MyPhraseInfo();
                info.setNumber(number);
                info.setName(content);
                info.setCreator(userInfo);
                service.addnew((CoreBaseInfo)info);
                id = info.getId() + "";
            } else {
                MyPhraseInfo info = service.getMyPhraseInfo((IObjectPK)new ObjectUuidPK(id));
                if (info != null) {
                    info.setName(content);
                    service.update((IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"save my phrase error", (Throwable)e);
        }
        return id;
    }

    public String myPhraseGetAllHtml() throws IOException {
        return ApproveUtil.getMyPhraseContent(this.ctx);
    }

    public static String getMyPhraseContent(Context ctx) throws IOException {
        StringBuilder builder = new StringBuilder();
        String adminId = "00000000-0000-0000-0000-00000000000013B7DE7F";
        String sql = "select top 100 fid,fname_" + ctx.getLocale() + " as fname from T_BD_MYPHRASE where fcreatorid='" + ctx.getCaller() + "' or fcreatorid='" + adminId + "' order by FLastUpdateTime desc";
        String RES = ApproveUtil.class.getName();
        ResourceBundle res = ResourceBundle.getBundle(RES, ctx.getLocale());
        String lblDelete = res.getString("lblDelete");
        String lblNoPhrase = res.getString("lblNoPhrase");
        try {
            ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
            if (list.size() > 0) {
                for (Object o : list) {
                    Map map = (Map)o;
                    String id = (String)map.get("fid");
                    String phraseStr = (String)map.get("fname");
                    if (phraseStr == null || phraseStr.length() == 0) continue;
                    String label = phraseStr;
                    int MAX = 40;
                    label = ApproveUtil.getSubString(label, 40);
                    builder.append("<li ><a href='javascript:void(0);' myphraseid='").append(id).append("' contenthash='").append(phraseStr.hashCode()).append("' title='").append(phraseStr).append("'><div style='clear:both'><div class='myPhrase-text'>").append(label).append("</div><div class='myPhrase-delete' title='").append(lblDelete).append("'></div></div></a></li>");
                }
            } else {
                builder.append("<li ><a href='javascript:void(0);'  title=''>(").append(lblNoPhrase).append(")</a></li>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.toString();
    }

    private static final String getSubString(String value, int max) {
        if (max < 5) {
            return value;
        }
        char[] c = value.toCharArray();
        int[] cl = new int[c.length];
        char[] ci = new char[c.length + 3];
        for (int i = 0; i < c.length; ++i) {
            ci[i] = c[i];
            cl[i] = (c[i] > '\u0100' ? 2 : 1) + (i > 0 ? cl[i - 1] : 0);
            if (cl[i] <= max) continue;
            while (cl[i - 1] > max - 3 && --i != 0) {
            }
            ci[i] = 46;
            ci[i + 1] = 46;
            ci[i + 2] = 46;
            value = new String(ci, 0, i + 3);
            break;
        }
        return value;
    }

    private static final String getCheckCode(String url) {
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.cp.eip.mc.web.WfWafUtil");
            Method m1 = clazz.getMethod("extractParamValues4MD5", String.class);
            String paramValues = (String)m1.invoke(clazz, url);
            Method m2 = clazz.getMethod("getMD5", String.class);
            String md5Result = (String)m2.invoke(clazz, paramValues);
            return md5Result;
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6checkcode\u51fa\u9519 in ApproveUtil wf_monitor", (Throwable)e);
            return "";
        }
    }

    private void saveAndSignatureApproveBill(Map approveMap, String tAssignmentId, String tBillId) throws Exception {
        String isSignatureApprove = (String)approveMap.get("isSignatureApprove");
        if ("true".equals(isSignatureApprove)) {
            ArrayList<String> tBillIdList;
            String tPlainText = (String)approveMap.get("plainText");
            String tSignature = (String)approveMap.get("signature");
            String tCAType = SignatureUtil.getCATypeByAssign(tAssignmentId);
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)this.ctx);
            BOSObjectType bosType = BOSUuid.read((String)tBillId).getType();
            if (tCAType.equals(SignatureUtil.CHECK_ONLY) || tCAType.equals(SignatureUtil.BOTH)) {
                tBillIdList = new ArrayList<String>();
                tBillIdList.add(tBillId);
                iEASSignature.checkSignature(bosType, tBillIdList);
                this.saveApprove(approveMap);
                String isReadOnly = (String)approveMap.get("isReadOnly");
                if (!"true".equals(isReadOnly)) {
                    iEASSignature.checkSignature(bosType, tBillIdList);
                }
            }
            if (tCAType.equals(SignatureUtil.SIGN_ONLY) || tCAType.equals(SignatureUtil.BOTH)) {
                if (tCAType.equals(SignatureUtil.SIGN_ONLY)) {
                    this.saveApprove(approveMap);
                }
                if (tPlainText.indexOf("CANOTSIGNATURE") <= -1) {
                    iEASSignature.checkSignature4Web(tPlainText, tSignature, bosType.toString());
                    tBillIdList = new ArrayList();
                    tBillIdList.add(tBillId);
                    ArrayList<String> tSignaList = new ArrayList<String>();
                    tSignaList.add(tSignature);
                    iEASSignature.checkSignature4Web(tBillIdList, tSignaList, bosType.toString());
                    iEASSignature.saveSignature4Web(tSignature, tPlainText, tBillId, bosType.toString());
                }
            }
        } else {
            this.saveApprove(approveMap);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveApprove(Map approveMap) throws Exception {
        String isReadOnly;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String ccPersonIds = (String)approveMap.get("ccPersonIds");
        String ccPersonName = (String)approveMap.get("personName");
        if (!StringUtils.isEmpty((String)ccPersonIds)) {
            String assignId = (String)approveMap.get("assignId");
            WfEngine wfengine = WfEngine.getEngine((Context)this.ctx);
            WfAssignment assign = wfengine.getAssignment(assignId);
            svc.setProcessContext(assign.getProcInstId(), "$ccPersonIds" + assignId, (Object)ccPersonIds);
            svc.setProcessContext(assign.getProcInstId(), "$ccPersonName" + assignId, (Object)ccPersonName);
        }
        if ("true".equals(isReadOnly = (String)approveMap.get("isReadOnly"))) return false;
        try {
            HashMap dataMap;
            BOSObjectType bostype;
            Class objectValueClass;
            IObjectValue bizModel;
            String jsonString = (String)approveMap.get("model");
            if (jsonString == null || (bizModel = (IObjectValue)JSONUtils.convertJsonToObject((Context)this.ctx, (String)jsonString, (Class)(objectValueClass = this.getBizObjectValueClass(this.ctx, bostype = (dataMap = JSONUtils.convertJsonToObject((Context)this.ctx, (String)jsonString)).get("bosType") != null ? BOSObjectType.create((String)((String)dataMap.get("bosType"))) : BOSUuid.read((String)((String)dataMap.get("id"))).getType())))) == null || !(bizModel instanceof CoreBaseInfo)) return true;
            MultiApproveFactory.getRemoteInstance().bizSubmit((CoreBaseInfo)bizModel);
            return true;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private Class getBizObjectValueClass(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        String clzObjectValueName = entityObjectInfo.getObjectValueClass();
        Class<?> clzObjectValue = null;
        try {
            clzObjectValue = Class.forName(clzObjectValueName);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("can't find " + clzObjectValueName);
        }
        return clzObjectValue;
    }

    private static boolean isCheckPermission(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"IS_SHOW_APPENDACTIVITY");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u7279\u6b8a\u6743\u9650\u8bbe\u7f6e\u51fa\u9519   " + e.getMessage()));
        }
        return false;
    }

    private void signatureBatchApproveBills(Map approveMap, String tAssignmentIds) throws Exception {
        String isSignatureApprove = (String)approveMap.get("isSignatureApprove");
        if ("true".equals(isSignatureApprove)) {
            String tSignatures;
            String tBillId = "";
            String tAssignmentId = "";
            ArrayList<String> tBillIdList = new ArrayList<String>();
            if (tAssignmentIds == null || "".equals(tAssignmentIds)) {
                throw new BOSException("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\u5355\u636eid!");
            }
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            for (String assignId : tAssignmentIds.split(";")) {
                AssignmentInfo assign = svc.getAssignmentById(assignId);
                tAssignmentId = assignId;
                tBillId = assign.getBizObjectIds();
                tBillIdList.add(tBillId);
            }
            String tCAType = SignatureUtil.getCATypeByAssign(tAssignmentId);
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)this.ctx);
            BOSObjectType bosType = BOSUuid.read((String)tBillId).getType();
            if (tCAType.equals(SignatureUtil.CHECK_ONLY) || tCAType.equals(SignatureUtil.BOTH)) {
                iEASSignature.checkSignature(bosType, tBillIdList);
            }
            if ((tSignatures = (String)approveMap.get("plainSignatureMap")) == null || "".equals(tSignatures)) {
                throw new BOSException("\u83b7\u53d6\u7684\u7b7e\u540d\u5bc6\u6587\u4fe1\u606f\u4e3a\u7a7a!");
            }
            ArrayList<String> tSignatureList = new ArrayList<String>();
            for (String tSignature : tSignatures.split(",")) {
                tSignatureList.add(tSignature);
            }
            if (tCAType.equals(SignatureUtil.SIGN_ONLY) || tCAType.equals(SignatureUtil.BOTH)) {
                iEASSignature.checkSignature4Web(tBillIdList, tSignatureList, bosType.toString());
                iEASSignature.saveSignature4Web(tSignatureList, tBillIdList, bosType.toString());
            }
        }
    }

    private void signatureBatchApproveBillsNew(Map approveMap, String billIds, String tAssignmentIds) throws Exception {
        String isSignatureApprove = (String)approveMap.get("isSignatureApprove");
        if ("true".equals(isSignatureApprove)) {
            String tSignatures;
            String tBillId = "";
            String tAssignmentId = "";
            ArrayList<String> tBillIdList = new ArrayList<String>();
            if (billIds == null || "".equals(billIds)) {
                throw new BOSException("\u672a\u83b7\u53d6\u5230\u5355\u636eid!");
            }
            if (tAssignmentIds == null || "".equals(tAssignmentIds)) {
                throw new BOSException("\u672a\u83b7\u53d6\u5230\u5355\u636eid!");
            }
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            for (String billId : billIds.split(";")) {
                tBillIdList.add(billId);
                tBillId = billId;
            }
            tAssignmentId = tAssignmentIds.split(";")[0];
            String tCAType = SignatureUtil.getCATypeByAssign(tAssignmentId);
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)this.ctx);
            BOSObjectType bosType = BOSUuid.read((String)tBillId).getType();
            if (tCAType.equals(SignatureUtil.CHECK_ONLY) || tCAType.equals(SignatureUtil.BOTH)) {
                iEASSignature.checkSignature(bosType, tBillIdList);
            }
            if ((tSignatures = (String)approveMap.get("plainSignatureMap")) == null || "".equals(tSignatures)) {
                throw new BOSException("\u83b7\u53d6\u7684\u7b7e\u540d\u5bc6\u6587\u4fe1\u606f\u4e3a\u7a7a!");
            }
            ArrayList<String> tSignatureList = new ArrayList<String>();
            for (String tSignature : tSignatures.split(",")) {
                tSignatureList.add(tSignature);
            }
            if (tCAType.equals(SignatureUtil.SIGN_ONLY) || tCAType.equals(SignatureUtil.BOTH)) {
                iEASSignature.checkSignature4Web(tBillIdList, tSignatureList, bosType.toString());
                iEASSignature.saveSignature4Web(tSignatureList, tBillIdList, bosType.toString());
            }
        }
    }

    private String batchApprove(Map approve, List nextActs, IEnactmentService svc, String assignId, AssignmentInfo assign) throws Exception {
        this.saveNextActsPersons(nextActs, svc, assign);
        MultiApproveInfo info = this.generateApproveInfo(approve, assignId, assign);
        info.setExtendedProperty("workflowLog_batchSubmit", "true");
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        info.setInputType(InputType.PROC_CENTER);
        try {
            MultiApproveFactory.getLocalInstance((Context)this.ctx).submit((CoreBaseInfo)info);
            return info.getId().toString();
        }
        catch (AlreadyInProcessQueueException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

