/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.client.SysContext;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WfProcessDiagram {
    private static final Logger logger = CoreUIObject.getLogger(WfProcessDiagram.class);
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_ALL_NEXT = 1;
    public static final int MODE_NEXT_ONLY = 2;
    static Collator collator = Collator.getInstance(Locale.CHINA);
    IEnactmentService svc;
    HashSet visited;
    ArrayList starActivities;
    ProcessDef topProcessDef;
    ManpowerActivityDef firstActDef;
    Locale locale;
    String associationLine;
    private static final Locale defaultLocale = new Locale("l2");

    public void setTopProcessDef(ProcessDef topProcessDef) {
        this.topProcessDef = topProcessDef;
        logger.error((Object)("---\u8bbe\u7f6e\u6d41\u7a0b\u5b9a\u4e49---:" + topProcessDef.getHashValue()), (Throwable)new Exception());
    }

    public WfProcessDiagram() throws BOSException {
        this((Context)null);
    }

    public WfProcessDiagram(String associationLine) throws BOSException {
        this(null, associationLine);
    }

    public WfProcessDiagram(Context ctx) throws BOSException {
        this.svc = ctx != null ? EnactmentServiceFactory.createEnactService((Context)ctx) : EnactmentServiceFactory.createRemoteEnactService();
        this.visited = new HashSet();
        this.starActivities = new ArrayList();
        this.locale = ctx != null ? ctx.getLocale() : SysContext.getSysContext().getLocale();
    }

    public WfProcessDiagram(Context ctx, String associationLine) throws BOSException {
        this(ctx);
        this.associationLine = associationLine;
        if (this.associationLine != null) {
            this.associationLine = this.associationLine.trim();
            if (this.associationLine.length() == 0) {
                this.associationLine = null;
            }
        }
    }

    public ProcessDef getTopProcessDef() {
        return this.topProcessDef;
    }

    public ArrayList getStartActivities() {
        return this.starActivities;
    }

    public IEnactmentService getService() {
        return this.svc;
    }

    public HashMap[] findNextManpownerActivities(String[] actInstIds) throws BOSException {
        return this.findNextManpownerActivities(actInstIds, 0);
    }

    public List<ActivityInstInfo> getActInstList(String[] actInstIds) throws BOSException {
        return this.svc.getActivityInstByActInstIds(actInstIds);
    }

    public HashMap[] findNextManpownerActivities(List<ActivityInstInfo> activityInstInfoList, int mode) throws BOSException {
        this.visited.clear();
        this.starActivities.clear();
        this.firstActDef = null;
        ArrayList result = new ArrayList();
        block5: for (int i = 0; i < activityInstInfoList.size(); ++i) {
            boolean requireAll;
            ActivityInstInfo actInst = activityInstInfoList.get(i);
            ProcessDef procDef = null;
            String hashCode = actInst.getProcDefHashValue();
            if (this.topProcessDef != null && this.topProcessDef.getHashValue().equals(hashCode)) {
                procDef = this.topProcessDef;
            }
            if (procDef == null) {
                procDef = this.svc.getProcessDefByDefineHashValue(hashCode);
                if (this.topProcessDef == null) {
                    this.topProcessDef = procDef;
                }
            }
            ManpowerActivityDef start = (ManpowerActivityDef)procDef.getActivityDef(actInst.getActDefId());
            ExtendedAttributeDef nextPersondef = start.getActivityHeader().getExtendedAttributes().get("nextPerson");
            boolean nextPerson = false;
            if (nextPersondef != null) {
                nextPerson = Boolean.parseBoolean(nextPersondef.getValue());
            }
            switch (mode) {
                case 0: {
                    if (start.canSpecifyNextActivityPerformer()) {
                        requireAll = start.isShowAllManpowerActivities() || start.isShowAllEmptyManpowerActivites();
                        break;
                    }
                    if (!start.isMustShowParticipantsCheckList() && !procDef.getProcessHeader().isCheckPostActivitiesPerson() && !nextPerson) continue block5;
                    requireAll = false;
                    break;
                }
                case 1: {
                    requireAll = true;
                    break;
                }
                case 2: {
                    requireAll = false;
                    break;
                }
                default: {
                    requireAll = false;
                }
            }
            this.findNextManpownerActivities((ActivityDef)start, requireAll, actInst.getProcInstId(), result, this.associationLine, true);
            this.starActivities.add(start);
        }
        this.setDefaultActivityDef(result);
        return this.sortActivityList(result);
    }

    public HashMap[] findNextManpownerActivities(String[] actInstIds, int mode) throws BOSException {
        this.visited.clear();
        this.starActivities.clear();
        this.firstActDef = null;
        ArrayList result = new ArrayList();
        List actInstList = this.svc.getActivityInstByActInstIds(actInstIds);
        block5: for (int i = 0; i < actInstList.size(); ++i) {
            boolean requireAll;
            ActivityInstInfo actInst = (ActivityInstInfo)actInstList.get(i);
            ProcessDef procDef = null;
            String hashCode = actInst.getProcDefHashValue();
            if (this.topProcessDef != null && this.topProcessDef.getHashValue().equals(hashCode)) {
                procDef = this.topProcessDef;
            }
            if (procDef == null) {
                procDef = this.svc.getProcessDefByDefineHashValue(hashCode);
                if (this.topProcessDef == null) {
                    this.topProcessDef = procDef;
                }
            }
            ManpowerActivityDef start = (ManpowerActivityDef)procDef.getActivityDef(actInst.getActDefId());
            ExtendedAttributeDef nextPersondef = start.getActivityHeader().getExtendedAttributes().get("nextPerson");
            boolean nextPerson = false;
            if (nextPersondef != null) {
                nextPerson = Boolean.parseBoolean(nextPersondef.getValue());
            }
            switch (mode) {
                case 0: {
                    if (start.canSpecifyNextActivityPerformer()) {
                        requireAll = start.isShowAllManpowerActivities() || start.isShowAllEmptyManpowerActivites();
                        break;
                    }
                    if (!start.isMustShowParticipantsCheckList() && !procDef.getProcessHeader().isCheckPostActivitiesPerson() && !nextPerson) continue block5;
                    requireAll = false;
                    break;
                }
                case 1: {
                    requireAll = true;
                    break;
                }
                case 2: {
                    requireAll = false;
                    break;
                }
                default: {
                    requireAll = false;
                }
            }
            this.findNextManpownerActivities((ActivityDef)start, requireAll, actInst.getProcInstId(), result, this.associationLine, true);
            this.starActivities.add(start);
        }
        this.setDefaultActivityDef(result);
        return this.sortActivityList(result);
    }

    public HashMap[] findDirectNextManpownerActivities(ProcessDef processDef) throws BOSException {
        this.visited.clear();
        this.starActivities.clear();
        this.firstActDef = null;
        ArrayList result = new ArrayList();
        this.topProcessDef = processDef;
        ActivityCollection actClctn = processDef.getStartupActivities();
        for (int i = 0; i < actClctn.size(); ++i) {
            ManpowerActivityDef start;
            ActivityDef actDef = actClctn.get(i);
            if (!(actDef instanceof ManpowerActivityDef) || !(start = (ManpowerActivityDef)actDef).canSpecifyNextActivityPerformer() && !processDef.getProcessHeader().isCheckPostActivitiesPerson()) continue;
            boolean requireAll = false;
            this.findNextManpownerActivities((ActivityDef)start, requireAll, null, result, null, true);
            this.starActivities.add(start);
        }
        this.setDefaultActivityDef(result);
        return this.sortActivityList(result);
    }

    public HashMap[] findNextManpownerActivities(ProcessDef processDef) throws BOSException {
        return this.findNextManpownerActivities(processDef, true);
    }

    public HashMap[] findNextManpownerActivities(ProcessDef processDef, boolean check) throws BOSException {
        return this.findNextManpownerActivities(processDef, check, true);
    }

    public HashMap[] findNextManpownerActivities(ProcessDef processDef, boolean check, boolean isNextPerformer) throws BOSException {
        this.visited.clear();
        this.starActivities.clear();
        this.firstActDef = null;
        ArrayList result = new ArrayList();
        this.topProcessDef = processDef;
        ActivityCollection actClctn = processDef.getStartupActivities();
        for (int i = 0; i < actClctn.size(); ++i) {
            ActivityDef actDef = actClctn.get(i);
            if (!(actDef instanceof ManpowerActivityDef)) continue;
            ManpowerActivityDef start = (ManpowerActivityDef)actDef;
            if (check && !start.canSpecifyNextActivityPerformer() && !processDef.getProcessHeader().isCheckPostActivitiesPerson()) continue;
            boolean requireAll = true;
            if (isNextPerformer) {
                requireAll = start.isShowAllManpowerActivities() || start.isShowAllEmptyManpowerActivites();
            }
            this.findNextManpownerActivities((ActivityDef)start, requireAll, null, result, null, isNextPerformer);
            this.starActivities.add(start);
        }
        this.setDefaultActivityDef(result);
        return this.sortActivityList(result);
    }

    public ManpowerActivityDef getFirstManpowerActivityDef() {
        return this.firstActDef;
    }

    private HashMap[] sortActivityList(ArrayList activities) {
        HashMap[] list = activities.toArray(new HashMap[activities.size()]);
        for (int i = 0; i < list.length; ++i) {
            HashMap item = list[i];
            ArrayList subActivities = (ArrayList)item.get("subActivities");
            if (subActivities == null) {
                ManpowerActivityDef actDef = (ManpowerActivityDef)item.get("actDef");
                if (this.firstActDef != null) continue;
                this.firstActDef = actDef;
                continue;
            }
            item.put("subActivities", this.sortActivityList(subActivities));
        }
        return list;
    }

    private boolean setDefaultActivityDef(ArrayList activities) {
        for (int i = 0; i < activities.size(); ++i) {
            HashMap item = (HashMap)activities.get(i);
            ArrayList subActivities = (ArrayList)item.get("subActivities");
            if (subActivities == null) {
                ManpowerActivityDef actDef;
                this.firstActDef = actDef = (ManpowerActivityDef)item.get("actDef");
                item.put("expand", "true");
                return true;
            }
            boolean b = this.setDefaultActivityDef(subActivities);
            if (!b) continue;
            item.put("expand", "true");
            return true;
        }
        return false;
    }

    private boolean findNextManpownerActivitiesInSubflow(SubflowActivityDef subflowActDef, boolean requireAll, ArrayList result, boolean isNextPerformer) throws BOSException {
        String subProcessDefID = subflowActDef.getSubflowId();
        ProcessDefInfo subProcessDefInfo = this.svc.getProcessDefInfo(subProcessDefID);
        if (subProcessDefInfo == null) {
            return false;
        }
        boolean found = false;
        ProcessDef subProcessDef = this.svc.getProcessDefByDefineHashValue(subProcessDefInfo.getMd5HashValue());
        ActivityCollection allActs = subProcessDef.getActivitys();
        ArrayList temp = new ArrayList();
        for (ActivityDef actDef : allActs) {
            if (!(actDef instanceof StartActivityDef) || !this.findNextManpownerActivities(actDef, requireAll, null, temp, null, isNextPerformer)) continue;
            found = true;
        }
        if (temp.size() > 0) {
            HashMap act = this.activityDef2HashMap((ActivityDef)subflowActDef);
            act.put("subActivities", temp);
            result.add(act);
        }
        return found;
    }

    private boolean findNextManpownerActivitiesInParentflow(String subProcInstId, boolean requireAll, ArrayList result, boolean isNextPerformer) throws BOSException {
        ProcessInstInfo procInstInfo = this.svc.getProcessInstInfo(subProcInstId);
        String parentActInstId = procInstInfo.getParentActInstId();
        if (parentActInstId == null) {
            return false;
        }
        ActivityInstInfo actInst = this.svc.getActivityInstByActInstId(parentActInstId);
        ActivityDef actDef = this.svc.getActDefByActInstInfo(actInst);
        String procInstId = actInst.getProcInstId();
        boolean found = this.findNextManpownerActivitiesDirectly(actDef, requireAll, procInstId, result, null, isNextPerformer);
        return found;
    }

    private boolean findNextManpownerActivitiesDirectly(ActivityDef actDef, boolean requireAll, String procInstId, ArrayList result, String associationLine, boolean isNextPerformer) throws BOSException {
        TransitionDef tran;
        boolean found = false;
        ActivityCollection activities = null;
        if (associationLine != null && (tran = actDef.getOutgoingTransitions().get(associationLine)) != null) {
            activities = new ActivityCollection(null);
            activities.set(tran.getTo().getID(), tran.getTo());
        }
        if (activities == null) {
            activities = actDef.getPostActivities();
        }
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef next = activities.get(i);
            String key = WfProcessDiagram.getActivityDefGUID(next);
            if (this.visited.contains(key)) continue;
            this.visited.add(key);
            if (next instanceof ManpowerActivityDef) {
                ExtendedAttributeDef ead = next.getActivityHeader().getExtendedAttributes().get("notAllowChangePerformers");
                if (!isNextPerformer || ead == null || !"true".equals(ead.getValue())) {
                    result.add(this.activityDef2HashMap(next));
                    found = true;
                }
                if (!requireAll) continue;
            }
            if (!this.findNextManpownerActivities(next, requireAll, procInstId, result, null, isNextPerformer)) continue;
            found = true;
        }
        return found;
    }

    private static String getActivityDefGUID(ActivityDef actDef) {
        return actDef.getID() + ":" + actDef.getContainer().getID();
    }

    private boolean findNextManpownerActivities(ActivityDef actDef, boolean requireAll, String procInstId, ArrayList result, String associationLine, boolean isNextPerformer) throws BOSException {
        if (actDef instanceof EndActivityDef) {
            if (procInstId != null) {
                return this.findNextManpownerActivitiesInParentflow(procInstId, requireAll, result, isNextPerformer);
            }
            return false;
        }
        boolean found = false;
        if (actDef instanceof SubflowActivityDef) {
            found = this.findNextManpownerActivitiesInSubflow((SubflowActivityDef)actDef, requireAll, result, isNextPerformer);
            if (!requireAll && found) {
                return true;
            }
        }
        if (this.findNextManpownerActivitiesDirectly(actDef, requireAll, procInstId, result, associationLine, isNextPerformer)) {
            found = true;
        }
        return found;
    }

    public HashMap activityDef2HashMap(ActivityDef actDef) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("id", actDef.getID());
        String name = actDef.getName(this.locale);
        if (name == null || name.length() == 0) {
            name = actDef.getName(defaultLocale);
        }
        item.put("name", name);
        item.put("processName", ((ProcessDef)actDef.getContainer()).getName(this.locale));
        item.put("processId", actDef.getContainer().getID());
        item.put("actDef", (String)actDef);
        return item;
    }
}

