/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.monitor.BillDigestInfo;
import com.kingdee.bos.workflow.monitor.BillDigestScriptCollection;
import com.kingdee.bos.workflow.monitor.BillDigestScriptInfo;
import com.kingdee.bos.workflow.monitor.EditConfigCollection;
import com.kingdee.bos.workflow.monitor.EditConfigInfo;
import com.kingdee.bos.workflow.monitor.EntrySummaryProxy;
import com.kingdee.bos.workflow.monitor.EntryValue;
import com.kingdee.bos.workflow.monitor.ISummaryProxy;
import com.kingdee.bos.workflow.monitor.NavDataInfo;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.bos.workflow.monitor.SummaryProxy;
import com.kingdee.bos.workflow.monitor.ValueMappingCollection;
import com.kingdee.bos.workflow.monitor.ValueMappingInfo;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.app.AbstractBillDigestControllerBean;
import com.kingdee.bos.workflow.monitor.app.SelectorBuilder;
import com.kingdee.bos.workflow.monitor.app.SummaryBuilder;
import com.kingdee.bos.workflow.monitor.app.SummaryCache;
import com.kingdee.bos.workflow.monitor.util.BillDigestScriptUtils;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillDigestControllerBean
extends AbstractBillDigestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.monitor.app.BillDigestControllerBean");
    private static final String relateSql = "select FSRCOBJECTID ,FDESTOBJECTID from T_BOT_RELATION where FDESTOBJECTID = ? UNION select FSRCOBJECTID ,FDESTOBJECTID from T_BOT_RELATION where FSRCOBJECTID = ? ";

    public Result save(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        if (colls != null && !colls.isEmpty()) {
            BillDigestInfo info = (BillDigestInfo)colls.getObject(0);
            String pk = info.getMetadataPK();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("metadataPK", (Object)pk));
            this.delete(ctx, filter);
            SummaryCache.removeFromCache(pk);
            SelectorBuilder.clear();
        }
        Result ret = super.save(ctx, colls);
        return ret;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        FilterItemCollection items = filter.getFilterItems();
        for (int i = 0; i < items.size(); ++i) {
            FilterItemInfo item = items.get(i);
            SummaryCache.removeFromCache((String)item.getCompareValue());
        }
        return super._delete(ctx, filter);
    }

    @Override
    protected SummaryInfo _getSummaryByPK(Context ctx, String pk) throws BOSException {
        return this.innerGetSummary(ctx, pk);
    }

    private SummaryInfo innerGetSummary(Context ctx, String pk, int digType, String assignId) throws BOSException {
        String schemaID = null;
        if (!StringUtils.isEmpty((String)assignId)) {
            String procDefID = BillDigestUtils.getProcDefByActDefId(assignId, ctx);
            schemaID = BillDigestUtils.getDistributeSchemaID(ctx, procDefID);
        }
        if (schemaID == null) {
            schemaID = BillDigestUtils.getDefaultSchemaId(ctx, pk);
        }
        if (schemaID == null) {
            return null;
        }
        SummaryInfo cache = SummaryCache.getFromCache(schemaID + "&" + pk);
        if (cache != null && 2 != digType) {
            return cache;
        }
        EntityObjectInfo entity = this.loadEntity(ctx, pk);
        if (entity == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("schema", (Object)schemaID));
        filter.getFilterItems().add(new FilterItemInfo("metadataPK", (Object)pk));
        filter.getFilterItems().add(new FilterItemInfo("billDigestType", (Object)digType));
        filter.getFilterItems().add(new FilterItemInfo("billDigestType", (Object)0));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("index");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        sorter = new SorterItemInfo("propertyGroup");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("valuemapping.value"));
        selector.add(new SelectorItemInfo("valuemapping.alias"));
        selector.add(new SelectorItemInfo("editConfig.actDefId"));
        selector.add(new SelectorItemInfo("editConfig.procDefId"));
        selector.add(new SelectorItemInfo("script.content"));
        view.setSelector(selector);
        CoreBaseCollection col = this.getCollection(ctx, view);
        if (col != null && !col.isEmpty()) {
            boolean isOaBill = BillDigestUtils.isOABill(ctx, entity.getType());
            SummaryInfo summary = new SummaryInfo();
            summary.setMetadataPK(pk);
            summary.setShcemaId(schemaID);
            summary.setOABill(isOaBill);
            this.createEntrys(summary, col);
            for (int i = 0; i < col.size(); ++i) {
                SummaryItemInfo item;
                BillDigestInfo digest = (BillDigestInfo)col.get(i);
                if (StringUtils.isEmpty((String)digest.getPropertyName()) || (item = BillDigestUtils.createSummaryItem(digest, entity)) == null) continue;
                String group = item.getGroup();
                if (!StringUtils.isEmpty((String)group) && summary.getEntry(group) == null) {
                    this.createEntry(ctx, entity, group, summary);
                }
                summary.addSummaryItem(item);
                if (digest.isCalculateField()) {
                    summary.setHasUserDefineField(true);
                }
                if (digest.getEditConfig() == null || digest.getEditConfig().size() <= 0) continue;
                summary.setEditConfig(true);
            }
            if (1 == digType) {
                SummaryCache.storeToCache(schemaID + "&" + pk, summary);
            }
            return summary;
        }
        return null;
    }

    private SummaryInfo innerGetSummary(Context ctx, String pk) throws BOSException {
        EntityObjectInfo entity = this.loadEntity(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("metadataPK", (Object)pk));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("propertyGroup");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        sorter = new SorterItemInfo("index");
        sorter.setSortType(SortType.ASCEND);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("valuemapping.value"));
        selector.add(new SelectorItemInfo("valuemapping.alias"));
        selector.add(new SelectorItemInfo("editConfig.actDefId"));
        selector.add(new SelectorItemInfo("editConfig.procDefId"));
        view.setSelector(selector);
        view.getSorter().add(sorter);
        CoreBaseCollection col = this.getCollection(ctx, view);
        if (col != null && !col.isEmpty()) {
            SummaryInfo summary = new SummaryInfo();
            summary.setMetadataPK(pk);
            this.createEntrys(summary, col);
            for (int i = 0; i < col.size(); ++i) {
                SummaryItemInfo item;
                BillDigestInfo digest = (BillDigestInfo)col.get(i);
                if (StringUtils.isEmpty((String)digest.getPropertyName()) || (item = this.createSummaryItem(digest, entity)) == null) continue;
                String group = item.getGroup();
                if (!StringUtils.isEmpty((String)group) && summary.getEntry(group) == null) {
                    this.createEntry(ctx, entity, group, summary);
                }
                summary.addSummaryItem(item);
            }
            return summary;
        }
        return null;
    }

    private SummaryInfo innerGetSummary2(Context ctx, String pk) throws BOSException {
        SummaryInfo summary = this.innerGetSummary(ctx, pk);
        if (summary == null) {
            SummaryBuilder builder = new SummaryBuilder();
            EntityObjectInfo entity = this.loadEntity(ctx, pk);
            summary = builder.createSummary(ctx, entity);
        }
        return summary;
    }

    private SummaryInfo innerGetSummary2(Context ctx, String pk, int digType, String assignID) throws BOSException {
        SummaryInfo summary = this.innerGetSummary(ctx, pk, digType, assignID);
        if (summary == null && 2 != digType) {
            String billPK = BillDigestUtils.getMetadataPKByEntryMetadataPK(ctx, pk);
            if (!StringUtils.isEmpty((String)billPK)) {
                summary = this.innerGetSummary(ctx, billPK, digType, assignID);
            }
            if (summary != null) {
                EntityObjectInfo billEntity = this.loadEntity(ctx, billPK);
                List<SummaryInfo> entrys = summary.getEntrys();
                for (int i = 0; i < entrys.size(); ++i) {
                    LinkPropertyInfo property;
                    EntityObjectInfo entryEntity;
                    SummaryInfo entrySummaryInfo = entrys.get(i);
                    PropertyInfo tempObject = billEntity.getPropertyByNameRuntime(entrySummaryInfo.getName());
                    if (!(tempObject instanceof LinkPropertyInfo) || !pk.equalsIgnoreCase((entryEntity = (property = (LinkPropertyInfo)tempObject).getRelationship().getSupplierObject()).getFullName())) continue;
                    summary = entrySummaryInfo;
                    break;
                }
            } else {
                SummaryBuilder builder = new SummaryBuilder();
                EntityObjectInfo entity = this.loadEntity(ctx, pk);
                summary = builder.createSummary(ctx, entity);
            }
        }
        return summary;
    }

    private void createEntry(Context ctx, EntityObjectInfo entity, String group, SummaryInfo summary) {
        EntityObjectInfo subEntity = this.loadEntry(entity, group);
        if (subEntity != null) {
            BillDigestInfo digest = new BillDigestInfo();
            digest.setMetadataPK(entity.getFullName());
            digest.setPropertyGroup(group);
            digest.setAlias(subEntity.getAlias());
            try {
                this.addnew(ctx, digest);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.createEntry(summary, digest);
        }
    }

    private void createEntrys(SummaryInfo summary, CoreBaseCollection col) {
        for (int i = 0; i < col.size(); ++i) {
            BillDigestInfo digest = (BillDigestInfo)col.get(i);
            this.createEntry(summary, digest);
        }
    }

    private void createEntry(SummaryInfo summary, BillDigestInfo digest) {
        if (StringUtils.isEmpty((String)digest.getPropertyName())) {
            if (StringUtils.isEmpty((String)digest.getPropertyGroup())) {
                String alias = digest.getAlias();
                summary.setAlias(alias);
                summary.setOABill(digest.isIsOABill());
                summary.setIsMobileApprove(digest.isIsMobileApprove());
                summary.setNeedValidate(digest.isNeedValidate());
            } else {
                String group = digest.getPropertyGroup();
                String[] strings = StringUtils.split((String)group, (String)".");
                SummaryInfo parent = summary;
                for (String str : strings) {
                    String entryName = !StringUtils.isEmpty((String)parent.getName()) ? parent.getName() + "." + str : str;
                    SummaryInfo entry = parent.getEntry(entryName);
                    if (entry == null) {
                        entry = new SummaryInfo();
                        entry.setName(entryName);
                        parent.addEntry(entry);
                    }
                    parent = entry;
                }
                parent.setAlias(digest.getAlias());
                parent.setPreviewNum(digest.getPreviewNum());
                parent.setSortedType(digest.getSortedType());
            }
        }
    }

    private SummaryItemInfo createSummaryItem(BillDigestInfo digest, EntityObjectInfo entity) {
        PropertyInfo property;
        String group = digest.getPropertyGroup();
        String name = digest.getPropertyName();
        if (!StringUtils.isEmpty((String)group)) {
            entity = this.loadEntry(entity, group);
        }
        if ((property = this.getProperty(entity, name)) != null || digest.isCalculateField()) {
            SummaryItemInfo item = new SummaryItemInfo();
            item.setName(name);
            item.setGroup(digest.getPropertyGroup());
            item.setDigType(digest.getBillDigestType().getValue());
            item.setEditable(digest.isEditable());
            item.setShowFormate(digest.getShowFormate());
            item.setPrewNum(digest.getPreviewNum());
            item.setShowIfNull(digest.isShowIfNull());
            item.setIsSortedItem(digest.isIsSortedItem());
            item.setCanSummary(digest.isCanSummary());
            String alias = digest.getAlias();
            item.setUserDefine(digest.isCalculateField());
            item.setAlias(alias);
            item.setPreview(digest.isPreview());
            item.setDigType(digest.getBillDigestType().getValue());
            item.setFontColor(digest.getFontColor());
            if (property != null) {
                if (StringUtils.isEmpty((String)alias) || "null".equalsIgnoreCase(alias)) {
                    alias = property.getAlias();
                }
                if (property instanceof OwnPropertyInfo) {
                    DataType type2 = ((OwnPropertyInfo)property).getDataType();
                    if (DataType.ENUM.equals((Object)type2)) {
                        String ref = ((OwnPropertyInfo)property).getMetaDataRef();
                        if (!StringUtils.isEmpty((String)ref)) {
                            item.setProperty((OwnPropertyInfo)property);
                        }
                    } else if (DataType.BOOLEAN.equals((Object)type2) || DataType.FLOAT.equals((Object)type2) || DataType.DOUBLE.equals((Object)type2) || DataType.DECIMAL.equals((Object)type2) || DataType.DATE.equals((Object)type2) || DataType.TIME.equals((Object)type2) || DataType.TIMESTAMP.equals((Object)type2)) {
                        item.setProperty((OwnPropertyInfo)property);
                    }
                }
            }
            item.getValueMapping().addCollection(digest.getValuemapping());
            item.setEditConfig(digest.getEditConfig());
            item.getScript().addCollection(digest.getScript());
            return item;
        }
        return null;
    }

    @Override
    protected SummaryProxy _getSummaryByUUID(Context ctx, String uuid, String assignID) throws BOSException {
        BOSUuid bosuuid = BOSUuid.read((String)uuid);
        BOSObjectType type = bosuuid.getType();
        IMetaDataPK pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(type);
        SummaryInfo summary = this.innerGetSummary2(ctx, pk.getFullName());
        if (summary == null) {
            return null;
        }
        assignID = this.getActDefIDByAssignId(ctx, assignID);
        try {
            ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            SelectorItemCollection selectors = SelectorBuilder.getSelector(summary, 0);
            CoreBaseInfo dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid), selectors);
            if (dataObj == null) {
                throw new RuntimeException("can't find record : " + uuid);
            }
            SummaryProxy proxy = new SummaryProxy();
            proxy.setdefault(summary.isdefault());
            proxy.setId(uuid);
            proxy.setAlias(summary.getAlias());
            List<SummaryItemInfo> items = summary.getSummaryItems();
            for (SummaryItemInfo item : items) {
                Object value = this.getValue(ctx, item, (IObjectValue)dataObj);
                if (item.getProperty() != null) {
                    proxy.addItem(item.getAlias(), value, this.digestIsEditable(item, assignID), item.getName(), item.getProperty().getDataType(), item.getFontColor());
                    continue;
                }
                proxy.addItem(item.getAlias(), value, this.digestIsEditable(item, assignID), item.getName(), null, item.getFontColor());
            }
            this.createEntryProxys(ctx, proxy, summary, (IObjectValue)dataObj, 0, assignID, null);
            return proxy;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Boolean digestIsEditable(SummaryItemInfo item, String assignID) {
        if (StringUtils.isEmpty((String)assignID)) {
            return false;
        }
        EditConfigCollection collection = item.getEditConfig();
        if (collection.size() == 0 || collection == null) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EditConfigInfo info = (EditConfigInfo)iterator.next();
            if (!assignID.equals(info.getActdefid())) continue;
            return true;
        }
        return false;
    }

    private void createEntryProxys(Context ctx, ISummaryProxy parent, SummaryInfo summary, IObjectValue dataObj, int digType, String actDefId, HashMap param) throws BOSException {
        List<SummaryInfo> entrys = summary.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            SummaryInfo entry = entrys.get(i);
            String name = entry.getName();
            EntrySummaryProxy entryProxy = new EntrySummaryProxy();
            entryProxy.setGroup(name);
            entryProxy.setAlias(entry.getAlias());
            parent.addEntry(entryProxy);
            String rName = this.getRelativeName(summary, entry);
            List<IObjectValue> list = this.getEntryValue(dataObj, rName);
            List<SummaryItemInfo> items = entry.getSummaryItems();
            Object flag = param.get("_hasUserDefineField");
            if (1 == digType) {
                items = this.getPreviewItems(entry);
            }
            Object uuid = null;
            IObjectValue entryValue = null;
            for (int j = 0; j < list.size(); ++j) {
                IObjectValue value = list.get(j);
                EntryValue eValue = new EntryValue();
                eValue.setId(value.getString("id"));
                if (Boolean.TRUE == flag) {
                    entryValue = BillDigestScriptUtils.getBillDataByIdAndBosType(ctx, value.getString("id"), null);
                    param.put("_entry", entryValue);
                }
                for (SummaryItemInfo item : items) {
                    Object vo = null;
                    if (item.isUserDefine()) {
                        Map result;
                        BillDigestScriptCollection sc = item.getScript();
                        BillDigestScriptInfo info = sc.get(0);
                        if (info != null && info.getContent() != null && Boolean.TRUE == (result = BillDigestScriptUtils._excuteScript(ctx, info.getContent(), param)).get("success")) {
                            vo = result.get("msg");
                        }
                    } else {
                        vo = this.getValue(ctx, item, value);
                    }
                    if (!item.getShowIfNull().booleanValue() && vo == null) continue;
                    if (item.getProperty() != null) {
                        eValue.addItem(item.getAlias(), vo, this.digestIsEditable(item, actDefId), item.getName(), item.getProperty().getDataType(), item.getFontColor(), item.isCanSummary());
                        continue;
                    }
                    eValue.addItem(item.getAlias(), vo, this.digestIsEditable(item, actDefId), item.getName(), null, item.getFontColor(), item.isCanSummary());
                }
                entryProxy.addValue(eValue);
                if (entry.getEntrys() == null || entry.getEntrys().size() <= 0) continue;
                this.createEntryProxys(ctx, eValue, entry, value, digType, actDefId, param);
            }
        }
    }

    private String getRelativeName(SummaryInfo parent, SummaryInfo entry) {
        String pName = parent.getName();
        String eName = entry.getName();
        if (StringUtils.isEmpty((String)pName)) {
            return eName;
        }
        if (eName.startsWith(pName + ".")) {
            return eName.substring(pName.length() + 1);
        }
        return eName;
    }

    private String getAlias(SummaryInfo summary, String group) {
        SummaryInfo _entry = summary.getEntry(group);
        if (_entry != null) {
            return _entry.getAlias();
        }
        return "";
    }

    private List<SummaryItemInfo> getPreviewItems(SummaryInfo entry) {
        List<SummaryItemInfo> results = new ArrayList<SummaryItemInfo>();
        List<SummaryItemInfo> items = entry.getSummaryItems();
        for (SummaryItemInfo item : items) {
            if (!item.isPreview()) continue;
            results.add(item);
        }
        if (results.isEmpty() && (results = items).size() > 4) {
            results = results.subList(0, 4);
        }
        return results;
    }

    private PropertyInfo getProperty(EntityObjectInfo entity, String propertyName) {
        String[] split = StringUtils.split((String)propertyName, (String)".");
        if (split.length > 1) {
            for (int i = 0; i < split.length - 1; ++i) {
                LinkPropertyInfo property = (LinkPropertyInfo)entity.getPropertyByName(split[i]);
                if (property == null) {
                    logger.error((Object)("can't find property " + split[i] + "in " + entity.getFullName()));
                } else {
                    entity = property.getRelationship().getSupplierObject();
                }
                if (!this.isEmptyMD((AbstractMDValue)entity)) continue;
                logger.error((Object)("can't find entity " + split[i] + "in " + entity.getFullName()));
            }
        }
        if (this.isEmptyMD((AbstractMDValue)entity)) {
            return null;
        }
        return entity.getPropertyByName(split[split.length - 1]);
    }

    private EntityObjectInfo loadEntry(EntityObjectInfo parent, String entryName) {
        String[] split = StringUtils.split((String)entryName, (String)".");
        EntityObjectInfo entity = parent;
        for (int i = 0; i < split.length; ++i) {
            LinkPropertyInfo property = (LinkPropertyInfo)entity.getPropertyByName(split[i]);
            if (property == null) {
                logger.error((Object)("can't find property " + entryName + "in " + parent.getFullName()));
                continue;
            }
            entity = property.getRelationship().getSupplierObject();
            if (!this.isEmptyMD((AbstractMDValue)entity)) continue;
            logger.error((Object)("can't find entry " + entryName + "in " + parent.getFullName()));
        }
        return entity;
    }

    private EntityObjectInfo loadEntity(Context ctx, String pk) {
        MetaDataPK mdpk;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)(mdpk = MetaDataPK.create((String)pk)));
        if (this.isEmptyMD((AbstractMDValue)entity)) {
            logger.error((Object)("loadEntity by pk :" + pk + " Error "));
            return null;
        }
        return entity;
    }

    private boolean isEmptyMD(AbstractMDValue amd) {
        if (amd == null) {
            return true;
        }
        IStateManager sm = amd.getStateManager();
        if (sm == null) {
            return true;
        }
        if (sm instanceof IProxyStateManager) {
            sm = ((IProxyStateManager)sm).getNoProxyDelegate();
        }
        return sm instanceof DynamicStateManager && ((DynamicStateManager)sm).isNull();
    }

    @Override
    protected List _getEntry(Context ctx, String parentid, String group, String entryID, int digType, String assignID) throws BOSException {
        ArrayList<SummaryProxy> list = new ArrayList<SummaryProxy>();
        BOSUuid bosuuid = BOSUuid.read((String)parentid);
        BOSObjectType type = bosuuid.getType();
        IMetaDataPK pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(type);
        String actDefId = null;
        if (pk == null) {
            throw new RuntimeException("can't find metadatapk for  : " + parentid + " . " + group);
        }
        SummaryInfo summary = this.innerGetSummary2(ctx, pk.getFullName(), digType, assignID);
        SelectorItemCollection selector = SelectorBuilder.getSelector(summary, group, digType);
        actDefId = this.getActDefIDByAssignId(ctx, assignID);
        try {
            ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            SorterItemCollection sortCol = new SorterItemCollection();
            List<SummaryInfo> entrys = summary.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                SummaryInfo summaryInfo = entrys.get(i);
                List<SummaryItemInfo> summaryItems = summaryInfo.getSummaryItems();
                String sortedType = summaryInfo.getSortedType();
                if (StringUtils.isEmpty((String)sortedType)) continue;
                for (int j = 0; j < summaryItems.size(); ++j) {
                    SummaryItemInfo summaryItemInfo = summaryItems.get(j);
                    boolean flag = summaryItemInfo.getIsSortedItem();
                    if (!flag) continue;
                    SorterItemInfo sorterItemInfo = new SorterItemInfo(summaryInfo.getName() + "." + summaryItemInfo.getName());
                    if ("0".equals(sortedType)) {
                        sorterItemInfo.setSortType(SortType.ASCEND);
                    } else if ("1".equals(sortedType)) {
                        sorterItemInfo.setSortType(SortType.DESCEND);
                    }
                    sortCol.add(sorterItemInfo);
                }
            }
            CoreBaseInfo dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid), selector, sortCol);
            if ((dataObj = this.getEntryValue((IObjectValue)dataObj, group, entryID)) == null) {
                throw new RuntimeException("can't find record : " + parentid + " . " + group);
            }
            summary = summary.getEntry(group);
            SummaryProxy proxy = new SummaryProxy();
            proxy.setdefault(summary.isdefault());
            proxy.setId(parentid);
            proxy.setAlias(summary.getAlias());
            List<SummaryItemInfo> items = summary.getSummaryItems();
            IObjectValue _head = null;
            IObjectValue _entryHead = null;
            IObjectValue _entry = null;
            HashMap<String, Boolean> param = new HashMap<String, Boolean>();
            if (summary.isHasUserDefineField()) {
                _head = BillDigestScriptUtils.getBillDataByIdAndBosType(ctx, parentid, type);
                _entryHead = BillDigestScriptUtils.getBillDataByIdAndBosType(ctx, entryID, null);
                param.put("_hasUserDefineField", true);
            } else {
                param.put("_hasUserDefineField", false);
            }
            _entry = BillDigestScriptUtils.getBillDataByIdAndBosType(ctx, entryID, null);
            param.put("_head", (Boolean)_head);
            param.put("_entryHead", (Boolean)_entryHead);
            param.put("_entry", (Boolean)_entry);
            for (SummaryItemInfo item : items) {
                Object value = null;
                if (item.isUserDefine()) {
                    BillDigestScriptCollection sc = item.getScript();
                    BillDigestScriptInfo info = sc.get(0);
                    if (info == null || info.getContent() == null) continue;
                    Map result = BillDigestScriptUtils._excuteScript(ctx, info.getContent(), param);
                    if (Boolean.TRUE.equals(result.get("success"))) {
                        value = result.get("msg");
                    }
                } else {
                    value = this.getValue(ctx, item, (IObjectValue)dataObj);
                }
                if (!item.getShowIfNull().booleanValue() && (value == null || value.toString().trim().length() == 0)) continue;
                if (item.getProperty() != null) {
                    proxy.addItem(item.getAlias(), value, this.digestIsEditable(item, actDefId), item.getName(), item.getProperty().getDataType(), item.getFontColor());
                } else {
                    proxy.addItem(item.getAlias(), value, this.digestIsEditable(item, actDefId), item.getName(), null, item.getFontColor());
                }
                if (item.getEditConfig() == null || item.getEditConfig().size() <= 0) continue;
                proxy.setEditConfig(true);
            }
            this.createEntryProxys(ctx, proxy, summary, (IObjectValue)dataObj, digType, actDefId, param);
            list.add(proxy);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private Object getValue(Context ctx, SummaryItemInfo item, IObjectValue parent) throws BOSException {
        String name = item.getName();
        String[] splits = StringUtils.split((String)name, (String)".");
        Object value = parent;
        for (String split : splits) {
            if (!(value instanceof IObjectValue)) continue;
            value = value.get(split);
        }
        if (value != null) {
            value = this.translateValue(ctx, item, value, item.getShowFormate());
        }
        if (value != null && value instanceof String) {
            value = ((String)value).replaceAll("\"", "&quot;");
        }
        return value;
    }

    private Object translateValue(Context ctx, SummaryItemInfo item, Object value, String formater) {
        ValueMappingCollection mappings = item.getValueMapping();
        if (!mappings.isEmpty()) {
            for (int i = 0; i < mappings.size(); ++i) {
                ValueMappingInfo mapping = mappings.get(i);
                if (!value.toString().equals(mapping.getValue())) continue;
                return mapping.getAlias();
            }
        } else {
            OwnPropertyInfo property = item.getProperty();
            if (property != null) {
                DataType type2 = property.getDataType();
                if (DataType.BOOLEAN.equals((Object)type2)) {
                    value = this.toBoolean(value);
                } else if (DataType.ENUM.equals((Object)type2)) {
                    BizEnumInfo type = property.getEnumType(MDHostType.RUNTIME);
                    if (type == null) {
                        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                        type = loader.getEnum((IMetaDataPK)MetaDataPK.create((String)property.getMetaDataRef()));
                    }
                    if (type != null && type.isDynamic()) {
                        DynamicEnum de = DynamicEnum.getEnum((String)property.getMetaDataRef(), (Object)value);
                        if (de != null) {
                            value = de.getAlias();
                        } else {
                            value = null;
                            logger.error((Object)("[BillDigest] error to get DynamicEnum:" + property.getMetaDataRef() + "; value:" + value));
                        }
                    } else {
                        value = BillDigestControllerBean.getEnumValue(type, property.getMetaDataRef(), value);
                    }
                } else if (DataType.FLOAT.equals((Object)type2) || DataType.DOUBLE.equals((Object)type2) || DataType.DECIMAL.equals((Object)type2)) {
                    value = this.translateNumber(value, formater);
                } else if (DataType.DATE.equals((Object)type2) || DataType.TIME.equals((Object)type2) || DataType.TIMESTAMP.equals((Object)type2)) {
                    value = this.translateTime(value, formater);
                } else if (DataType.BOSUUID.equals((Object)type2)) {
                    value = value.toString();
                    item.setProperty(null);
                }
            }
        }
        return value;
    }

    public Object translateTime(Object obj, String formater) {
        if (obj instanceof Date && formater != null) {
            SimpleDateFormat df = new SimpleDateFormat(formater);
            try {
                return df.format((Date)obj);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return obj;
    }

    public Object translateNumber(Object obj, String formater) {
        if (obj instanceof BigDecimal && formater != null) {
            DecimalFormat formatter = new DecimalFormat(formater);
            formatter.setRoundingMode(RoundingMode.HALF_UP);
            try {
                return formatter.format(obj);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return obj;
    }

    private String toBoolean(Object value) {
        Boolean bv = Boolean.FALSE;
        if (value instanceof Integer) {
            bv = (Integer)value == 0 ? Boolean.TRUE : Boolean.FALSE;
        } else if (value instanceof String) {
            bv = Boolean.valueOf((String)value);
        } else if (value instanceof Boolean) {
            bv = (Boolean)value;
        }
        if (bv.booleanValue()) {
            return "\u662f";
        }
        return "\u5426";
    }

    private static Object getEnumValue(BizEnumInfo enumInfo, String refTypeInfo, Object value) {
        BizEnumValueType type = enumInfo.getDataType();
        Object result = null;
        try {
            Class<?> refEnum = Class.forName(refTypeInfo);
            Class[] paraTypes = null;
            Object[] args = null;
            if (type == BizEnumValueType.INTEGER) {
                paraTypes = new Class[]{Integer.TYPE};
                args = new Object[]{TypeConversionUtils.objToInteger((Object)value)};
            } else if (type == BizEnumValueType.STRING) {
                paraTypes = new Class[]{String.class};
                args = new Object[]{TypeConversionUtils.objToString((Object)value)};
            } else if (type == BizEnumValueType.FLOAT) {
                paraTypes = new Class[]{Float.TYPE};
                args = new Object[]{TypeConversionUtils.objToFFloat((Object)value)};
            } else if (type == BizEnumValueType.LONG) {
                paraTypes = new Class[]{Long.TYPE};
                args = new Object[]{TypeConversionUtils.objToLLong((Object)value)};
            } else if (type == BizEnumValueType.DOUBLE) {
                paraTypes = new Class[]{Double.TYPE};
                args = new Object[]{TypeConversionUtils.objToDDouble((Object)value)};
            }
            Method method = refEnum.getMethod("getEnum", paraTypes);
            result = method.invoke(null, args);
            if (result instanceof Enum) {
                result = ((Enum)result).getAlias();
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return result;
    }

    private List<IObjectValue> getEntryValue(IObjectValue parent, String entryName) {
        String[] splits = StringUtils.split((String)entryName, (String)".");
        List<IObjectValue> list = new LinkedList<IObjectValue>();
        list.add(parent);
        for (int i = 0; i < splits.length; ++i) {
            list = this.getObjects(list, splits[i]);
        }
        return list;
    }

    private IObjectValue getEntryValue(IObjectValue parent, String entryName, String entryID) {
        List<IObjectValue> list = this.getEntryValue(parent, entryName);
        for (int i = 0; i < list.size(); ++i) {
            IObjectValue value = list.get(i);
            if (value.get("id") == null || !value.get("id").toString().equals(entryID)) continue;
            return value;
        }
        return null;
    }

    private List<IObjectValue> getObjects(List<IObjectValue> parents, String key) {
        LinkedList<IObjectValue> values = new LinkedList<IObjectValue>();
        for (int i = 0; i < parents.size(); ++i) {
            IObjectValue parent = parents.get(i);
            Object object = parent.get(key);
            if (!(object instanceof IObjectCollection)) continue;
            IObjectCollection col = (IObjectCollection)object;
            for (int j = 0; j < col.size(); ++j) {
                values.add(col.getObject(j));
            }
        }
        return values;
    }

    @Override
    protected SummaryProxy _getSummaryByUUIDAndDigType(Context ctx, String uuid, int digType, String assignID) throws BOSException {
        BOSUuid bosuuid = BOSUuid.read((String)uuid);
        BOSObjectType type = bosuuid.getType();
        IMetaDataPK pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(type);
        SummaryInfo summary = this.innerGetSummary2(ctx, pk.getFullName(), digType, assignID);
        if (summary == null) {
            return null;
        }
        String actDefId = null;
        actDefId = this.getActDefIDByAssignId(ctx, assignID);
        try {
            String adjustid;
            String oldFid;
            String contentId;
            ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            SelectorItemCollection selectors = SelectorBuilder.getSelector(summary, digType);
            SorterItemCollection sortCol = new SorterItemCollection();
            List<SummaryInfo> entrys = summary.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                SummaryInfo summaryInfo = entrys.get(i);
                List<SummaryItemInfo> summaryItems = summaryInfo.getSummaryItems();
                String sortedType = summaryInfo.getSortedType();
                if (StringUtils.isEmpty((String)sortedType)) continue;
                for (int j = 0; j < summaryItems.size(); ++j) {
                    SummaryItemInfo summaryItemInfo = summaryItems.get(j);
                    boolean flag = summaryItemInfo.getIsSortedItem();
                    if (!flag) continue;
                    SorterItemInfo sorterItemInfo = new SorterItemInfo(summaryInfo.getName() + "." + summaryItemInfo.getName());
                    if ("0".equals(sortedType)) {
                        sorterItemInfo.setSortType(SortType.ASCEND);
                    } else if ("1".equals(sortedType)) {
                        sorterItemInfo.setSortType(SortType.DESCEND);
                    }
                    sortCol.add(sorterItemInfo);
                }
            }
            CoreBaseInfo dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid), selectors, sortCol);
            if (dataObj == null) {
                throw new RuntimeException("can't find record : " + uuid);
            }
            SummaryProxy proxy = new SummaryProxy();
            proxy.setdefault(summary.isdefault());
            proxy.setId(uuid);
            proxy.setAlias(summary.getAlias());
            proxy.setMobileApprove(summary.getIsMobileApprove());
            proxy.setNeedValidate(summary.getNeedValidate());
            proxy.setEditConfig(summary.isEditConfig());
            List<SummaryItemInfo> items = summary.getSummaryItems();
            IObjectValue head = null;
            HashMap<String, Boolean> param = new HashMap<String, Boolean>();
            if (summary.isHasUserDefineField()) {
                head = BillDigestScriptUtils.getBillDataByIdAndBosType(ctx, uuid, type);
                param.put("_hasUserDefineField", true);
                param.put("_head", (Boolean)head);
            } else {
                param.put("_hasUserDefineField", false);
            }
            for (SummaryItemInfo item : items) {
                Object value = null;
                if (item.isUserDefine()) {
                    Map result;
                    BillDigestScriptCollection sc = item.getScript();
                    BillDigestScriptInfo info = sc.get(0);
                    if (info != null && info.getContent() != null && Boolean.TRUE.equals((result = BillDigestScriptUtils._excuteScript(ctx, info.getContent(), param)).get("success"))) {
                        value = result.get("msg");
                    }
                } else {
                    value = this.getValue(ctx, item, (IObjectValue)dataObj);
                }
                if (!item.getShowIfNull().booleanValue() && (value == null || value.toString().trim().length() == 0)) continue;
                if (item.getProperty() != null) {
                    proxy.addItem(item.getAlias(), value, this.digestIsEditable(item, actDefId), item.getName(), item.getProperty().getDataType(), item.getFontColor(), item.isCanSummary());
                    continue;
                }
                proxy.addItem(item.getAlias(), value, this.digestIsEditable(item, actDefId), item.getName(), null, item.getFontColor(), item.isCanSummary());
            }
            this.createEntryProxys(ctx, proxy, summary, (IObjectValue)dataObj, digType, actDefId, param);
            if (summary.isOABill() && !StringUtils.isEmpty((String)(contentId = this.getContentId(ctx, uuid)))) {
                proxy.setContentId(contentId);
                if (proxy.getAttachmentCount() < 1) {
                    proxy.setAttachmentCount(1);
                }
            }
            if (digType != 2) {
                String entryIds = this.GetEntryIds(proxy);
                proxy.setEntryIds(entryIds);
                int count = this.getAttachmentCount(ctx, uuid, entryIds);
                proxy.setAttachmentCount(count);
            }
            if (!StringUtils.isEmpty((String)(oldFid = this.getOldOaCount(ctx, uuid)))) {
                proxy.setContentId(oldFid);
                proxy.setAttachmentCount(1);
            }
            if (!StringUtils.isEmpty((String)(adjustid = this.getadjustid(ctx, uuid)))) {
                proxy.setAdjustId(adjustid);
                proxy.setAttachmentCount(1);
            }
            if ("FF66566A".equals(type.toString())) {
                proxy.setBillType("1");
            }
            proxy.setIfEdit(this.getIfEdit(ctx, assignID));
            String permissionMode = "";
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            Object assign = null;
            try {
                if (!StringUtils.isEmpty((String)assignID)) {
                    WfUtil util = new WfUtil(ctx);
                    permissionMode = util.getApproveActPermissionMode(assignID);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            proxy.setAttachPermission(permissionMode);
            String procid = "";
            if (assign != null) {
                procid = assign.getProcDefId();
            }
            String editUrlFormbos = this.getMbosUrl(ctx, procid, actDefId);
            proxy.setEditUrlFormbos(editUrlFormbos);
            String imgUrl = this.getImageUrl(ctx, uuid, type.toString());
            proxy.setImageUrl(imgUrl);
            if (!StringUtils.isEmpty((String)imgUrl)) {
                proxy.setBillType("2");
            }
            return proxy;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String GetEntryIds(SummaryProxy proxy) {
        String entryIds = "";
        List<EntrySummaryProxy> list = proxy.getEntrys();
        for (int i = 0; i < list.size(); ++i) {
            EntrySummaryProxy e = list.get(i);
            List<EntryValue> elist = e.getValues();
            for (int j = 0; j < elist.size(); ++j) {
                EntryValue yy = elist.get(j);
                String id = yy.getId();
                entryIds = StringUtils.isEmpty((String)entryIds) ? "'" + id + "'" : entryIds + ",'" + id + "'";
            }
        }
        return entryIds;
    }

    private String getImageUrl(Context ctx, String billID, String Type2) {
        String imgurl = "";
        IBillImageFacade billimage = null;
        Method method = null;
        try {
            billimage = (IBillImageFacade)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType("12BB55F7"));
            Class[] clz = new Class[]{String.class, Boolean.TYPE, Boolean.TYPE};
            Object[] objz = new Object[]{billID, false, true};
            method = billimage.getClass().getMethod("getImageURL", clz);
            int transaction = 3;
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)billimage);
            return (String)txInvoker.invoke(method, objz, transaction);
        }
        catch (BOSException e) {
            logger.error((Object)("[BillDigest]fail to get image URL,case by BizException  " + e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("[BillDigest]fail to get image URL  \uff1afail to getMethod  IBillImageFacade.getImageURL() " + e.getMessage()));
        }
        catch (Throwable e) {
            logger.error((Object)("[BillDigest]fail to get image URL  \uff1a" + e.getMessage()));
        }
        return imgurl;
    }

    private String getMbosUrl(Context ctx, String procid, String actDefId) {
        String url = "";
        try {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW  ");
            sql.append(" WHERE actDefId in ('" + actDefId + "')");
            if (!StringUtils.isEmpty((String)procid)) {
                sql.append(" and procdefid in ('" + procid + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[0])).next()) {
                url = rowSet.getString("url");
            }
            System.out.println("log for workflow   getmbosurl === " + url);
        }
        catch (Exception e) {
            logger.error((Object)("[BillDigestControllerBean] fail to getmbosUrl; " + e.getMessage()));
            System.out.println("[BillDigestControllerBean] fail to getmbosUrl; " + e.getMessage());
        }
        return url;
    }

    private void getRelatedBill(Context ctx, SummaryProxy proxy) {
        String billId = proxy.getId();
        try {
            NavDataInfo info;
            Set idSet;
            Set keys;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)relateSql, (Object[])new Object[]{billId, billId});
            HashMap srcIds = new HashMap();
            HashMap destIds = new HashMap();
            while (rs.next()) {
                HashSet<String> idSet2;
                String tempId = rs.getString(1);
                BOSObjectType temBosType = this.getBillBOSType(tempId);
                if (tempId != null && !billId.equals(tempId)) {
                    if (srcIds.get(temBosType) == null) {
                        idSet2 = new HashSet<String>();
                        idSet2.add(tempId);
                        srcIds.put(temBosType, idSet2);
                    } else {
                        ((Set)srcIds.get(temBosType)).add(tempId);
                    }
                }
                if ((tempId = rs.getString(2)) == null || billId.equals(tempId)) continue;
                if (destIds.get(temBosType) == null) {
                    idSet2 = new HashSet();
                    idSet2.add(tempId);
                    destIds.put(temBosType, idSet2);
                    continue;
                }
                ((Set)destIds.get(temBosType)).add(tempId);
            }
            HashSet<NavDataInfo> bills = new HashSet<NavDataInfo>();
            if (srcIds.size() > 0) {
                keys = srcIds.keySet();
                for (BOSObjectType key : keys) {
                    idSet = (Set)srcIds.get(key);
                    info = this.getNavData(ctx, key, idSet, "1");
                    bills.add(info);
                }
            }
            if (destIds.size() > 0) {
                keys = destIds.keySet();
                for (BOSObjectType key : keys) {
                    idSet = (Set)srcIds.get(key);
                    info = this.getNavData(ctx, key, idSet, "0");
                    bills.add(info);
                }
            }
            proxy.setRelateBills(bills);
        }
        catch (BOSException e) {
            logger.info((Object)"\u83b7\u53d6\u4e0a\u4e0b\u6e38\u5355\u636e\u5931\u8d25", (Throwable)e);
        }
        catch (SQLException e) {
            logger.info((Object)"\u83b7\u53d6\u4e0a\u4e0b\u6e38\u5355\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private BOSObjectType getBillBOSType(String billId) {
        BOSUuid bosuuid = BOSUuid.read((String)billId);
        BOSObjectType type = bosuuid.getType();
        return type;
    }

    private NavDataInfo getNavData(Context ctx, BOSObjectType key, Set<String> idSet, String navType) throws BOSException {
        String tempId = StringUtils.arrayToString((Object[])idSet.toArray(), (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("id", (Object)tempId, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)key);
        viewInfo.setFilter(filterBill);
        viewInfo.setSelector(selectors);
        CoreBaseCollection cols = base.getCollection(viewInfo);
        NavDataInfo info = new NavDataInfo();
        info.setBosType(key.toString());
        info.setNavType(navType);
        info.setBillName(BillDigestControllerBean.getEntityNameByBOSType(ctx, key));
        for (int i = 0; i < cols.size(); ++i) {
            String bill = cols.get(i).get("id") + "!" + cols.get(i).get("number");
            info.getBills().add(bill);
        }
        return info;
    }

    public static String getEntityNameByBOSType(Context ctx, BOSObjectType bosType) {
        ConfigMDUtil.setContextToThread((Context)ctx);
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = mdLoader.getEntity(bosType);
        return entityInfo.getAlias() == null ? entityInfo.getName() : entityInfo.getAlias();
    }

    public static String getEntityInfoByBOSType(Context ctx, BOSObjectType bosType) {
        ConfigMDUtil.setContextToThread((Context)ctx);
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = mdLoader.getEntity(bosType);
        return entityInfo.getName() == null ? "\u5355\u636e" : entityInfo.getName();
    }

    private String getIfEdit(Context ctx, String assignId) {
        String ifEdit = "false";
        return ifEdit;
    }

    private int getAttachmentCount(Context ctx, String billId, String entryIds) {
        if (!BOSUuid.isValid((String)billId, (boolean)true)) {
            return 0;
        }
        entryIds = StringUtils.isEmpty((String)entryIds) ? "'" + billId + "'" : entryIds + ",'" + billId + "'";
        int attCount = 0;
        int entryAttCount = 0;
        try {
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS attCount FROM T_BAS_Attachment att ");
            sql.append(" INNER JOIN T_BAS_BoAttchAsso baa ON att.FID = baa.FAttachmentID ");
            sql.append(" WHERE baa.FBoID in (" + entryIds + ")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[0]);
            if (rowSet.next()) {
                attCount = rowSet.getInt("attCount");
            }
            try {
                StringBuffer sql1 = new StringBuffer(" select   COUNT(*) AS attCount from t_fme_document a,t_fme_busidoc b where a.fdocumentid=b.FDocumentID and b.FBusinessID= ?");
                IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])new String[]{billId});
                if (rowSet1.next()) {
                    entryAttCount = rowSet1.getInt("attCount");
                }
            }
            catch (Exception e) {
                entryAttCount = 0;
            }
            return attCount + entryAttCount;
        }
        catch (Exception e) {
            logger.error((Object)e);
            attCount = -1;
            return attCount + entryAttCount;
        }
    }

    private String getadjustid(Context ctx, String billID) {
        String fid = "";
        String sql = "SELECT tbb.fadjustid   FROM T_BAS_Attachment att  INNER JOIN T_BAS_BoAttchAsso baa ON att.FID = baa.FAttachmentID   INNER JOIN t_bg_bgform tbb ON tbb.fadjustid = baa.FBoID   WHERE tbb.fid = ?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{billID});
            if (rowSet.next()) {
                fid = rowSet.getString("fadjustid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fid;
    }

    private String getOldOaCount(Context ctx, String billID) {
        String fid = "";
        String SQL2 = "select fid  from T_BAS_BillAttachment  WHERE FBillId='" + billID + "'";
        String SQL22 = "select fid  from T_CP_DocDispatch WHERE FID='" + billID + "'";
        String SQL3 = "select fid  from T_CP_DocReceive WHERE FID='" + billID + "'";
        String SQL1 = "select FID from T_CM_DocumentContent WHERE FID = '" + billID + "'";
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)SQL2.toString());
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
            if (!StringUtils.isEmpty((String)fid)) {
                return fid;
            }
            rowset = DbUtil.executeQuery((Context)ctx, (String)SQL1.toString());
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
            if (!StringUtils.isEmpty((String)fid)) {
                return fid;
            }
            rowset = DbUtil.executeQuery((Context)ctx, (String)SQL22);
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
            if (!StringUtils.isEmpty((String)fid)) {
                return fid;
            }
            rowset = DbUtil.executeQuery((Context)ctx, (String)SQL3);
            while (rowset.next()) {
                fid = rowset.getString("fid");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return fid;
        }
        return fid;
    }

    private String getContentId(Context ctx, String billID) {
        BOSUuid bosuuid = BOSUuid.read((String)billID);
        BOSObjectType type = bosuuid.getType();
        String FTabelName = null;
        StringBuffer querySql = new StringBuffer("select top 1 FTableName from T_BAS_FormEntity where FBosType='");
        querySql.append(type).append("' and ");
        querySql.append(" FFormID  in (select fid from t_bas_form where FTemplateID");
        querySql.append("  in ('tqAoxLV0TguihBZ6eqU8bZp+rpI=','C/T4g3UCStmKrMRuH4ErO5p+rpI=')) ");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            while (rowset.next()) {
                FTabelName = rowset.getString("FTableName");
            }
            if (!StringUtils.isEmpty(FTabelName)) {
                String contendId = null;
                String sql = "select FDocContentId from " + FTabelName + " where FID='" + billID + "'";
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowset.next()) {
                    contendId = rowset.getString("FDocContentId");
                }
                return contendId;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public String getActDefIDByAssignId(Context ctx, String assId) throws BOSException {
        if (assId == null) {
            return null;
        }
        try {
            Object factdefid = null;
            String sql = "select top 1  FACTDEFID from T_WFR_Assign where FASSIGNID =?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{assId});
            if (rowSet.next()) {
                return rowSet.getString("FACTDEFID");
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u901a\u8fc7\u4efb\u52a1\u83b7\u53d6\u6d3b\u52a8\u5b9a\u4e49\u5931\u8d25", (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    protected void _saveBillAssign(Context ctx, String metaDataPk, String isShowInMobile) throws BOSException {
        String delSql = "delete from T_bill_assign where FMETADATAPK=?";
        Object[] delepara = new Object[]{metaDataPk};
        DbUtil.execute((Context)ctx, (String)delSql, (Object[])delepara);
        String insertSql = "insert into T_bill_assign (FMETADATAPK,FISSHOWINMOBILE) values (?,?)";
        Object[] para = new Object[]{metaDataPk, isShowInMobile};
        DbUtil.execute((Context)ctx, (String)insertSql, (Object[])para);
    }
}

