/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.monitor.BillDigestCollection;
import com.kingdee.bos.workflow.monitor.BillDigestInfo;
import com.kingdee.bos.workflow.monitor.BillDigestSchemaInfo;
import com.kingdee.bos.workflow.monitor.EntrySummaryProxy;
import com.kingdee.bos.workflow.monitor.EntryValue;
import com.kingdee.bos.workflow.monitor.ISummaryProxy;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.bos.workflow.monitor.SummaryProxy;
import com.kingdee.bos.workflow.monitor.app.AbstractBillDigestSchemaControllerBean;
import com.kingdee.bos.workflow.monitor.app.BillDigestControllerBean;
import com.kingdee.bos.workflow.monitor.app.SelectorBuilder;
import com.kingdee.bos.workflow.monitor.app.SummaryBuilder;
import com.kingdee.bos.workflow.monitor.app.SummaryCache;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BillDigestSchemaControllerBean
extends AbstractBillDigestSchemaControllerBean {
    private static final long serialVersionUID = 1143043656555849545L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.monitor.app.BillDigestSchemaControllerBean");
    private static final String defaultSchemaId = "00000000-0000-0000-0000-0000000000003CCF0566";
    private static final String RESXNAME = "com.kingdee.bos.workflow.monitor.app.BillDigestSchemaResx";
    private static final String MANUAL_DEFAULT_LOGITEM = "manual_default_logitem";
    private static final String DELETE = "Delete";
    private static final String ALIAS = "Alias";

    @Override
    protected List _getSummarysByPk(Context ctx, String metaDataPk) throws BOSException {
        EntityObjectInfo entity = BillDigestUtils.loadEntity(ctx, metaDataPk);
        if (entity == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String querySql = "select a.fschemaid from (select distinct FMETADATAPK ,fschemaid  from T_WM_BillDigest ) a left outer JOIN T_WM_BillDigestSchema b on a.fschemaid = b.fid where a.fmetadatapk = '" + metaDataPk + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)querySql, CompareType.INNER));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("billdigest.*"));
        selector.add(new SelectorItemInfo("billdigest.script.*"));
        selector.add(new SelectorItemInfo("billdigest.valueMapping.*"));
        selector.add(new SelectorItemInfo("billdigest.editConfig.*"));
        view.setSelector(selector);
        SorterItemInfo sorter1 = new SorterItemInfo("isDefault");
        SorterItemInfo sorter2 = new SorterItemInfo("billdigest.index");
        sorter1.setSortType(SortType.DESCEND);
        sorter2.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter2);
        view.getSorter().add(sorter1);
        CoreBaseCollection col = this.getCollection(ctx, view);
        if (col != null && !col.isEmpty()) {
            ArrayList<SummaryInfo> shcemList = new ArrayList<SummaryInfo>();
            for (int j = 0; j < col.size(); ++j) {
                BillDigestSchemaInfo shcema = (BillDigestSchemaInfo)col.get(j);
                BillDigestCollection digestcols = shcema.getBilldigest();
                SummaryInfo summary = new SummaryInfo();
                summary.setMetadataPK(metaDataPk);
                summary.setShcemaId(shcema.getId().toString());
                summary.setdefault(shcema.isIsDefault());
                summary.setAlias(shcema.getShcema_alias());
                BillDigestUtils.createEntrys(summary, (IObjectCollection)digestcols);
                for (int i = 0; i < digestcols.size(); ++i) {
                    SummaryItemInfo item;
                    BillDigestInfo digest = digestcols.get(i);
                    if (!metaDataPk.equals(digest.getMetadataPK()) || StringUtils.isEmpty((String)digest.getPropertyName()) || (item = BillDigestUtils.createSummaryItem(digest, entity)) == null) continue;
                    String group = item.getGroup();
                    if (!StringUtils.isEmpty((String)group) && summary.getEntry(group) == null) {
                        BillDigestUtils.createEntry(ctx, entity, group, summary);
                    }
                    summary.addSummaryItem(item);
                }
                shcemList.add(summary);
            }
            return shcemList;
        }
        return null;
    }

    public Result save(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        if (colls != null && !colls.isEmpty()) {
            BillDigestSchemaInfo info = (BillDigestSchemaInfo)colls.getObject(0);
            String pk = info.getBillMetadataPk();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billMetadataPk", (Object)pk));
            IObjectPK[] pklist = this.getPKList(ctx, filter, null);
            this.delete(ctx, pklist);
            BillDigestUtils.removeBillDigestSchemaCache(colls);
            SelectorBuilder.clear();
        }
        Result ret = super.save(ctx, colls);
        return ret;
    }

    @Override
    protected SummaryProxy _getSummaryByUUIDAndDigType(Context ctx, String uuid, int digType, String assignID) throws BOSException {
        BOSUuid bosuuid = BOSUuid.read((String)uuid);
        BOSObjectType type = bosuuid.getType();
        IMetaDataPK pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(type);
        SummaryInfo summary = this.innerGetSummary2(ctx, pk.getFullName(), digType, assignID);
        if (summary == null) {
            return null;
        }
        String actDefId = null;
        actDefId = BillDigestUtils.getActDefIDByAssignId(ctx, assignID);
        try {
            String contentId;
            ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            SelectorItemCollection selectors = SelectorBuilder.getSelector(summary, digType);
            CoreBaseInfo dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid), selectors);
            if (dataObj == null) {
                throw new RuntimeException("can't find record : " + uuid);
            }
            SummaryProxy proxy = new SummaryProxy();
            proxy.setdefault(summary.isdefault());
            proxy.setId(uuid);
            proxy.setAlias(summary.getAlias());
            proxy.setMobileApprove(summary.getIsMobileApprove());
            proxy.setNeedValidate(summary.getNeedValidate());
            List<SummaryItemInfo> items = summary.getSummaryItems();
            for (SummaryItemInfo item : items) {
                Object value = BillDigestUtils.getValue(ctx, item, (IObjectValue)dataObj);
                if (!item.getShowIfNull().booleanValue() && value == null) continue;
                if (item.getProperty() != null) {
                    proxy.addItem(item.getAlias(), value, BillDigestUtils.digestIsEditable(item, actDefId), item.getName(), item.getProperty().getDataType(), item.getFontColor());
                } else {
                    proxy.addItem(item.getAlias(), value, BillDigestUtils.digestIsEditable(item, actDefId), item.getName(), null, item.getFontColor());
                }
                if (item.getEditConfig() == null || item.getEditConfig().size() <= 0) continue;
                proxy.setEditConfig(true);
            }
            this.createEntryProxys(ctx, proxy, summary, (IObjectValue)dataObj, digType, actDefId);
            proxy.setAttachmentCount(BillDigestUtils.getAttachmentCount(ctx, uuid));
            if (summary.isOABill() && !StringUtils.isEmpty((String)(contentId = BillDigestUtils.getContentId(ctx, uuid)))) {
                proxy.setContentId(contentId);
                if (proxy.getAttachmentCount() < 1) {
                    proxy.setAttachmentCount(1);
                }
            }
            int aCount = proxy.getAttachmentCount();
            String oldFid = BillDigestUtils.getOldOaCount(ctx, uuid);
            if (!StringUtils.isEmpty((String)oldFid)) {
                proxy.setContentId(oldFid);
                proxy.setAttachmentCount(1);
            }
            proxy.setIfEdit(BillDigestUtils.getIfEdit(ctx, assignID));
            return proxy;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void createEntryProxys(Context ctx, ISummaryProxy parent, SummaryInfo summary, IObjectValue dataObj, int digType, String actDefId) throws BOSException {
        List<SummaryInfo> entrys = summary.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            SummaryInfo entry = entrys.get(i);
            String name = entry.getName();
            EntrySummaryProxy entryProxy = new EntrySummaryProxy();
            entryProxy.setGroup(name);
            entryProxy.setAlias(entry.getAlias());
            parent.addEntry(entryProxy);
            String rName = BillDigestUtils.getRelativeName(summary, entry);
            List<IObjectValue> list = BillDigestUtils.getEntryValue(dataObj, rName);
            List<SummaryItemInfo> items = entry.getSummaryItems();
            if (1 == digType) {
                items = BillDigestUtils.getPreviewItems(entry);
            }
            for (int j = 0; j < list.size(); ++j) {
                IObjectValue value = list.get(j);
                EntryValue eValue = new EntryValue();
                eValue.setId(value.getString("id"));
                for (SummaryItemInfo item : items) {
                    Object vo = BillDigestUtils.getValue(ctx, item, value);
                    if (item.getShowIfNull().booleanValue() && vo == null) continue;
                    if (item.getProperty() != null) {
                        eValue.addItem(item.getAlias(), vo, BillDigestUtils.digestIsEditable(item, actDefId), item.getName(), item.getProperty().getDataType(), item.getFontColor());
                        continue;
                    }
                    eValue.addItem(item.getAlias(), vo, BillDigestUtils.digestIsEditable(item, actDefId), item.getName(), null, item.getFontColor());
                }
                entryProxy.addValue(eValue);
                if (entry.getEntrys() == null || entry.getEntrys().size() <= 0) continue;
                this.createEntryProxys(ctx, eValue, entry, dataObj, digType, actDefId);
            }
        }
    }

    private SummaryInfo innerGetSummary2(Context ctx, String pk, int digType, String assignID) throws BOSException {
        SummaryInfo summary = this.innerGetSummary(ctx, pk, digType, assignID);
        if (summary == null && 2 != digType) {
            SummaryBuilder builder = new SummaryBuilder();
            EntityObjectInfo entity = BillDigestUtils.loadEntity(ctx, pk);
            summary = builder.createSummary(ctx, entity);
        }
        return summary;
    }

    private SummaryInfo innerGetSummary(Context ctx, String pk, int digType, String assignId) throws BOSException {
        String procDefID = BillDigestUtils.getProcDefByActDefId(assignId, ctx);
        String schemaID = BillDigestUtils.getDistributeSchemaID(ctx, procDefID);
        SummaryInfo cache = SummaryCache.getFromCache(schemaID + pk);
        if (cache != null && 2 != digType) {
            return cache;
        }
        EntityObjectInfo entity = BillDigestUtils.loadEntity(ctx, pk);
        if (entity == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("schema", (Object)schemaID));
        filter.getFilterItems().add(new FilterItemInfo("metadataPK", (Object)pk));
        filter.getFilterItems().add(new FilterItemInfo("billDigestType", (Object)digType));
        filter.getFilterItems().add(new FilterItemInfo("billDigestType", (Object)0));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("propertyGroup");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        sorter = new SorterItemInfo("index");
        sorter.setSortType(SortType.ASCEND);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("valuemapping.value"));
        selector.add(new SelectorItemInfo("valuemapping.alias"));
        selector.add(new SelectorItemInfo("editConfig.actDefId"));
        selector.add(new SelectorItemInfo("editConfig.procDefId"));
        view.setSelector(selector);
        view.getSorter().add(sorter);
        BillDigestControllerBean ejb = new BillDigestControllerBean();
        CoreBaseCollection col = ejb.getCollection(ctx, view);
        if (col != null && !col.isEmpty()) {
            SummaryInfo summary = new SummaryInfo();
            summary.setMetadataPK(pk);
            BillDigestUtils.createEntrys(summary, (IObjectCollection)col);
            for (int i = 0; i < col.size(); ++i) {
                SummaryItemInfo item;
                BillDigestInfo digest = (BillDigestInfo)col.get(i);
                if (StringUtils.isEmpty((String)digest.getPropertyName()) || (item = BillDigestUtils.createSummaryItem(digest, entity)) == null) continue;
                String group = item.getGroup();
                if (!StringUtils.isEmpty((String)group) && summary.getEntry(group) == null) {
                    BillDigestUtils.createEntry(ctx, entity, group, summary);
                }
                summary.addSummaryItem(item);
            }
            SummaryCache.storeToCache(pk + summary.getMetadataPK(), summary);
            return summary;
        }
        return null;
    }

    @Override
    protected List _getEntry(Context ctx, String parentid, String group, String entryID, int digType, String assignID) throws BOSException {
        ArrayList<SummaryProxy> list = new ArrayList<SummaryProxy>();
        BOSUuid bosuuid = BOSUuid.read((String)parentid);
        BOSObjectType type = bosuuid.getType();
        IMetaDataPK pk = MDContextFactory.getSystemMDContext().entityMapping.getProperty(type);
        String actDefId = null;
        if (pk == null) {
            throw new RuntimeException("can't find metadatapk for  : " + parentid + " . " + group);
        }
        SummaryInfo summary = this.innerGetSummary2(ctx, pk.getFullName(), digType, assignID);
        SelectorItemCollection selector = SelectorBuilder.getSelector(summary, group, digType);
        actDefId = BillDigestUtils.getActDefIDByAssignId(ctx, assignID);
        try {
            ICoreBase base = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
            CoreBaseInfo dataObj = base.getValue((IObjectPK)new ObjectUuidPK(bosuuid), selector);
            dataObj = BillDigestUtils.getEntryValue((IObjectValue)dataObj, group, entryID);
            if (dataObj == null) {
                throw new RuntimeException("can't find record : " + parentid + " . " + group);
            }
            summary = summary.getEntry(group);
            SummaryProxy proxy = new SummaryProxy();
            proxy.setdefault(summary.isdefault());
            proxy.setId(parentid);
            proxy.setAlias(summary.getAlias());
            List<SummaryItemInfo> items = summary.getSummaryItems();
            for (SummaryItemInfo item : items) {
                Object value = BillDigestUtils.getValue(ctx, item, (IObjectValue)dataObj);
                if (item.getShowIfNull().booleanValue() && value == null) continue;
                if (item.getProperty() != null) {
                    proxy.addItem(item.getAlias(), value, BillDigestUtils.digestIsEditable(item, actDefId), item.getName(), item.getProperty().getDataType(), item.getFontColor());
                } else {
                    proxy.addItem(item.getAlias(), value, BillDigestUtils.digestIsEditable(item, actDefId), item.getName(), null, item.getFontColor());
                }
                if (item.getEditConfig() == null || item.getEditConfig().size() <= 0) continue;
                proxy.setEditConfig(true);
            }
            this.createEntryProxys(ctx, proxy, summary, (IObjectValue)dataObj, digType, actDefId);
            list.add(proxy);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected void _saveShemaDistribute(Context ctx, String shcemaId, List procDefIds) throws BOSException {
        if (shcemaId == null || procDefIds == null || procDefIds.size() == 0) {
            return;
        }
        Connection cn = null;
        PreparedStatement ps = null;
        String deleSql = "delete from T_WM_BILLDIGESTDITRIBUTR where FPROCDEFID = ? ";
        String insertSql = "insert into T_WM_BILLDIGESTDITRIBUTR (FPROCDEFID,FBILLDIGESTSCHEMAID) values (?,?)";
        try {
            int i;
            cn = WfDbUtil.getConnection((Context)ctx);
            ps = cn.prepareStatement(deleSql);
            for (i = 0; i < procDefIds.size(); ++i) {
                ps.setString(1, (String)procDefIds.get(i));
                ps.addBatch();
            }
            ps.executeBatch();
            ps = cn.prepareStatement(insertSql);
            for (i = 0; i < procDefIds.size(); ++i) {
                ps.setString(1, (String)procDefIds.get(i));
                ps.setString(2, shcemaId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    @Override
    protected void _delShemaDistribute(Context ctx, String schemaId, List procDefIds) throws BOSException {
        if (schemaId == null || procDefIds == null || procDefIds.size() == 0) {
            return;
        }
        Connection cn = null;
        PreparedStatement ps = null;
        String delSql = "delete from T_WM_BILLDIGESTDITRIBUTR where FPROCDEFID = ? ";
        try {
            cn = WfDbUtil.getConnection((Context)ctx);
            WfDbUtil.getConnection((Context)ctx);
            ps = cn.prepareStatement(delSql);
            for (int i = 0; i < procDefIds.size(); ++i) {
                ps.setString(1, (String)procDefIds.get(i));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    @Override
    protected List _getShemaDistribute(Context ctx, String metadataPk, String schemaId) throws BOSException {
        String querySql = "select a.FPROCDEFID,a.FBILLDIGESTSCHEMAID from T_WM_BILLDIGESTDITRIBUTR a where a.FBILLDIGESTSCHEMAID = ?";
        Connection cn = null;
        PreparedStatement ps = null;
        ArrayList<String> tempProdefIds = null;
        try {
            cn = WfDbUtil.getConnection((Context)ctx);
            ps = cn.prepareStatement(querySql);
            ps.setString(1, schemaId);
            ResultSet rt = ps.executeQuery();
            tempProdefIds = new ArrayList<String>();
            while (rt.next()) {
                tempProdefIds.add(rt.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        ArrayList<String> prodefIds = new ArrayList<String>();
        for (String procDefId : tempProdefIds) {
            if (defaultSchemaId.equals(procDefId) && BillDigestUtils.modifyProc(procDefId, metadataPk)) {
                prodefIds.add(procDefId);
                continue;
            }
            prodefIds.add(procDefId);
        }
        List infos = BillDigestUtils.getProcDefByProcDefId(ctx, prodefIds);
        return infos;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        FilterItemCollection filterItems = filter.getFilterItems();
        Iterator iterator = filterItems.iterator();
        FilterItemInfo filterItemInfo = null;
        String id = null;
        while (iterator.hasNext()) {
            filterItemInfo = (FilterItemInfo)iterator.next();
            String propertyName = filterItemInfo.getPropertyName();
            if (!propertyName.equalsIgnoreCase("id")) continue;
            id = (String)filterItemInfo.getCompareValue();
            break;
        }
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            if (!StringUtils.isEmpty(id)) {
                String sql = "select FALIAS_L2 from T_WM_BILLDIGEST where fschemaid= ?";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
                String alias = "";
                if (executeQuery.next()) {
                    alias = executeQuery.getString("FALIAS_L2");
                }
                if (!StringUtils.isEmpty((String)alias)) {
                    SummaryInfo summary = new SummaryInfo();
                    summary.setAlias(alias);
                    summary.setShcemaId(id);
                    ObjectUuidPK retPk = new ObjectUuidPK(id);
                    appLog = AppLogFactory.getLocalInstance((Context)ctx);
                    appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)retPk, summary, DELETE);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BillDigestSchema Operation.", (Throwable)e);
        }
        IObjectPK[] objectPKs = super._delete(ctx, filter);
        if (StringUtils.isEmpty((String)id)) {
            return objectPKs;
        }
        String deleteSql = "delete from T_WM_BILLDIGESTDITRIBUTR where fbilldigestschemaid = ?";
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = WfDbUtil.getConnection((Context)ctx);
            ps = cn.prepareStatement(deleteSql);
            ps.setString(1, id);
            ps.addBatch();
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException("\u5220\u9664\u6d41\u7a0b\u5206\u914d\u5f02\u5e38");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for BOTMapping Operation.", (Throwable)e);
        }
        return objectPKs;
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, SummaryInfo summary, String methodName) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, this.getBOSType(), pk, summary.getAlias(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)ALIAS, (Locale)ctx.getLocale()) + ":" + summary.getAlias() + "; id:" + summary.getShcemaId() + ")");
        return appLogId;
    }
}

