/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.monitor.DynamicOperationInfo;
import com.kingdee.bos.workflow.monitor.IDynamicOperationService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicOperationService
extends AbstractBOSObject
implements IDynamicOperationService {
    private static final Logger logger = Logger.getLogger(DynamicOperationService.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"DYOPFADE");

    public DynamicOperationService() {
    }

    public DynamicOperationService(Context ctx) {
        super(ctx);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewDynamicOperationInfo(DynamicOperationInfo info) {
        if (info == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstate = null;
        try {
            String sql = "insert into t_wfr_dynamicOp values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            conn = EJBFactory.getConnection((Context)this.getContext());
            pstate = conn.prepareStatement(sql);
            pstate.setString(1, info.getId());
            pstate.setString(2, info.getType());
            pstate.setString(3, info.getBillId());
            pstate.setString(4, info.getProcInstId());
            pstate.setString(5, info.getActInstId());
            pstate.setString(6, info.getActName());
            pstate.setString(7, info.getTargetActId());
            pstate.setString(8, info.getTargetActName());
            pstate.setString(9, info.getComment(new Locale("l1")));
            pstate.setString(10, info.getComment(new Locale("l2")));
            pstate.setString(11, info.getComment(new Locale("l3")));
            pstate.setString(12, info.getCreatorId());
            pstate.setString(13, info.getCreatorName());
            pstate.setTimestamp(14, info.getCreateTime());
            pstate.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DynamicOperationService.cleanup(null, pstate, conn);
                throw throwable;
            }
            DynamicOperationService.cleanup(null, pstate, conn);
        }
        DynamicOperationService.cleanup(null, pstate, conn);
    }

    @Override
    public List<Map<String, String>> getDynamicOperationListByBillId(String billId) {
        List<Map<String, String>> list = null;
        IEnactmentService service = null;
        ProcessInstInfo[] instInfoArray = null;
        String procInstId = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
            instInfoArray = service.getAllProcessInstancesByBizobjId(billId);
        }
        catch (WfException e) {
            logger.error((Object)("\u83b7\u53d6IEnactmentService\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u6839\u636e\u5355\u636eid\u83b7\u53d6\u6240\u6709\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        if (instInfoArray != null && instInfoArray.length > 0) {
            procInstId = instInfoArray.length == 1 ? instInfoArray[0].getProcInstId() : this.getLatestProcInstIdByInstInfoArray(instInfoArray);
        }
        if (StringUtils.isEmpty(procInstId)) {
            list = this.getDynamicOperationListByProcInstId(procInstId);
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getDynamicOperationListByAssignId(String assignId) {
        List<Map<String, String>> list = null;
        IEnactmentService service = null;
        AssignmentInfo info = null;
        try {
            service = EnactmentServiceFactory.createEnactService((Context)this.getContext());
            info = service.getAssignmentById(assignId);
        }
        catch (WfException e) {
            logger.error((Object)("\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6IEnactmentService\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        if (info != null) {
            String procInstId = info.getProcInstId();
            list = this.getDynamicOperationListByProcInstId(procInstId);
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, String>> getDynamicOperationListByProcInstId(String procInstId) {
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        ArrayList list;
        block5: {
            list = null;
            conn = null;
            st = null;
            rs = null;
            try {
                if (StringUtils.isEmpty((String)procInstId)) break block5;
                conn = EJBFactory.getConnection((Context)this.getContext());
                String sql = "select * from t_wfr_dynamicOp where fprocInstId=?";
                st = conn.prepareStatement(sql);
                st.setString(1, procInstId);
                rs = st.executeQuery();
                HashMap<String, String> itemMap = null;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                list = new ArrayList();
                while (rs.next()) {
                    itemMap = new HashMap<String, String>();
                    itemMap.put("id", rs.getString("fid"));
                    itemMap.put("type", rs.getString("FType"));
                    itemMap.put("billId", rs.getString("FBillId"));
                    itemMap.put("procInstId", rs.getString("FProcInstId"));
                    itemMap.put("actInstId", rs.getString("FActInstId"));
                    itemMap.put("actName", rs.getString("FActName"));
                    itemMap.put("targetActId", rs.getString("FTargetActId"));
                    itemMap.put("targetActName", rs.getString("FTargetActName"));
                    itemMap.put("comment_l1", rs.getString("FCOMMENT_L1"));
                    itemMap.put("comment_l2", rs.getString("FCOMMENT_L2"));
                    itemMap.put("comment_l3", rs.getString("FCOMMENT_L3"));
                    itemMap.put("creatorId", rs.getString("FCreatorId"));
                    itemMap.put("creatorName", rs.getString("FCreatorName"));
                    Timestamp createTime = rs.getTimestamp("FCreateTime");
                    String createTimeStr = format.format(createTime);
                    itemMap.put("createTime", createTimeStr);
                    list.add(itemMap);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DynamicOperationService.cleanup(rs, st, conn);
                    throw throwable;
                }
                DynamicOperationService.cleanup(rs, st, conn);
            }
        }
        DynamicOperationService.cleanup(rs, st, conn);
        return list;
    }

    private String getLatestProcInstIdByInstInfoArray(ProcessInstInfo[] instInfoArray) {
        String procInstId = null;
        int latestSign = 0;
        Timestamp latest = instInfoArray[0].getCreatedTime();
        for (int i = 0; i < instInfoArray.length; ++i) {
            Timestamp time = instInfoArray[i].getCreatedTime();
            if (time.compareTo(latest) <= 0) continue;
            latest = time;
            latestSign = i;
        }
        procInstId = instInfoArray[latestSign].getProcInstId();
        return procInstId;
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception _) {
                logger.error((Object)_.getMessage(), (Throwable)_);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception _) {
                logger.error((Object)_.getMessage(), (Throwable)_);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception _) {
                logger.error((Object)_.getMessage(), (Throwable)_);
            }
            cn = null;
        }
    }
}

