/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.bos.workflow.monitor.util.BillDigestUtils;
import com.kingdee.util.StringUtils;

public class SummaryBuilder {
    private static final String defaultSchemaId = "00000000-0000-0000-0000-0000000000003CCF0566";

    public SummaryInfo createSummary(Context ctx, EntityObjectInfo entity) {
        PropertyInfo property;
        int i;
        boolean isOaBill = BillDigestUtils.isOABill(ctx, entity.getType());
        SummaryInfo summary = new SummaryInfo();
        summary.setMetadataPK(entity.getFullName());
        summary.setAlias(entity.getAlias());
        summary.setIsMobileApprove(true);
        summary.setOABill(isOaBill);
        summary.setShcemaId(defaultSchemaId);
        PropertyCollection properties = entity.getInheritedNoDuplicatedPropertiesRuntime();
        int size = properties.size();
        if (size > 20) {
            size = 20;
        }
        for (i = 0; i < size; ++i) {
            property = properties.get(i);
            if (!(property instanceof OwnPropertyInfo)) continue;
            SummaryItemInfo item = this.createItem((OwnPropertyInfo)property);
            summary.addSummaryItem(item);
        }
        for (i = 0; i < properties.size(); ++i) {
            LinkPropertyInfo lp;
            property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || !this.isEntry(lp = (LinkPropertyInfo)property)) continue;
            SummaryInfo entry = this.createEntrySummary(lp);
            summary.addEntry(entry);
        }
        return summary;
    }

    private SummaryInfo createEntrySummary(LinkPropertyInfo lp) {
        SummaryInfo summary = new SummaryInfo();
        summary.setAlias(lp.getAlias());
        summary.setName(lp.getName());
        EntityObjectInfo entry = lp.getRelationship().getSupplierObject();
        PropertyCollection properties = entry.getInheritedNoDuplicatedPropertiesRuntime();
        int size = properties.size();
        if (size > 20) {
            size = 20;
        }
        for (int i = 0; i < size; ++i) {
            PropertyInfo property = properties.get(i);
            if (!(property instanceof OwnPropertyInfo)) continue;
            SummaryItemInfo item = this.createItem(lp.getName(), (OwnPropertyInfo)property);
            summary.addSummaryItem(item);
        }
        return summary;
    }

    private SummaryItemInfo createItem(OwnPropertyInfo property) {
        return this.createItem("", property);
    }

    private SummaryItemInfo createItem(String group, OwnPropertyInfo property) {
        SummaryItemInfo item = new SummaryItemInfo();
        item.setGroup(group);
        item.setName(property.getName());
        item.setAlias(property.getAlias());
        DataType type2 = property.getDataType();
        if (DataType.ENUM.equals((Object)type2)) {
            BizEnumInfo type = property.getEnumType(MDHostType.RUNTIME);
            String ref = property.getMetaDataRef();
            if (type != null && !StringUtils.isEmpty((String)ref)) {
                item.setProperty(property);
            }
        } else if (DataType.BOOLEAN.equals((Object)type2)) {
            item.setProperty(property);
        } else if (DataType.FLOAT.equals((Object)type2) || DataType.DOUBLE.equals((Object)type2) || DataType.DECIMAL.equals((Object)type2)) {
            item.setProperty(property);
            item.setShowFormate("###,##0.00");
        } else if (DataType.DATE.equals((Object)type2) || DataType.TIME.equals((Object)type2) || DataType.TIMESTAMP.equals((Object)type2)) {
            item.setProperty(property);
            item.setShowFormate("yyyy-MM-dd");
        }
        item.setDigType(0);
        return item;
    }

    private boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }
}

