/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.monitor.app.AbstractWfMonitorImageUIFacade;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class WfMonitorImageUIFacadeDemo
extends AbstractWfMonitorImageUIFacade {
    protected Context ctx;

    public WfMonitorImageUIFacadeDemo(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public final String getActTips(String procInstId, String actDefId, String actInstIds) throws Exception {
        String[] ids = actInstIds == null || actInstIds.length() == 0 ? null : actInstIds.split(";");
        return this.getActTips(procInstId, actDefId, ids);
    }

    @Override
    public String getActTips(String procInstId, String actDefId, String[] actInstIds) throws Exception {
        if (procInstId == null || procInstId.length() == 0 || actDefId == null || actDefId.length() == 0) {
            return "";
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        if (actInstIds != null) {
            return this.getActivityPerformers(svc, actInstIds);
        }
        return this.getParticipants(svc, procInstId, actDefId);
    }

    protected final String getParticipants(IEnactmentService svc, String procInstId, String actDefId) throws Exception {
        ArrayList designatedPersons;
        String key;
        Object o;
        ProcessInstInfo pInfo = null;
        ProcessDefInfo pdInfo = null;
        if (!procInstId.endsWith("WFPRCDEF")) {
            pInfo = svc.getProcessInstInfo(procInstId);
        } else {
            pdInfo = svc.getProcessDefInfo(procInstId);
        }
        ProcessDef pDef = svc.getProcessDefByDefineHashValue(pInfo == null ? pdInfo.getMd5HashValue() : pInfo.getProcDefHashValue());
        ActivityDef aDef = pDef.getActivityDef(actDefId);
        if (!(aDef instanceof ManpowerActivityDef)) {
            return null;
        }
        HashSet<Object> s = new HashSet<Object>();
        if (pInfo != null && (o = svc.getProcessContext(procInstId, key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)aDef))) instanceof ArrayList && (designatedPersons = (ArrayList)o).size() > 0) {
            ArrayList persons = PostParticipantUtil.queryPerson("id", "id,number,name", designatedPersons, "com.kingdee.eas.basedata.person.app.F7PersonQuery", "name", this.ctx);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < persons.size(); ++i) {
                Object name = ((HashMap)persons.get(i)).get("name");
                if (s.contains(name)) continue;
                s.add(name);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(name);
            }
            return "\u6307\u5b9a\u7684\u53c2\u4e0e\u4eba: " + sb.toString();
        }
        ArrayList<String> pList = new ArrayList<String>();
        ParticipantCollection participants = ((ManpowerActivityDef)aDef).getParticipants();
        for (int i = 0; i < participants.size(); ++i) {
            pList.add(participants.get(i).getID());
        }
        List persons = pInfo == null ? svc.getPersonsByDefParticipants(pdInfo.getMd5HashValue(), actDefId, pList, this.ctx.getCaller().toString()) : svc.getPersonsByParticipants(procInstId, actDefId, pList);
        StringBuffer sb = new StringBuffer();
        Locale l = this.ctx.getLocale();
        Locale l2 = new Locale("l2");
        int count = 0;
        for (Person person : persons) {
            String name = person.getUserName(l);
            if (name == null) {
                name = person.getUserName(l2);
            }
            if (name == null) {
                name = person.getEmployeeId();
            }
            if (s.contains(name)) continue;
            s.add(name);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name);
            if (++count <= 50) continue;
            sb.append(", \u7b49...");
            break;
        }
        return "\u4f30\u7b97\u7684\u53c2\u4e0e\u4eba: " + sb.toString();
    }

    protected final String getActivityPerformers(IEnactmentService svc, String[] actInstIds) throws Exception {
        ProcessInstInfo procInstInfo = null;
        ActivityDef aDef = null;
        StringBuffer sb = new StringBuffer();
        sb.append("\u8be5\u6d3b\u52a8\u5b58\u5728<font color='blue'>" + actInstIds.length + "</font>\u6b21\u5b9e\u4f8b.");
        for (int i = 0; i < actInstIds.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append("<br>\u7b2c").append(i + 1).append("\u6b21\u5b9e\u4f8b\u6267\u884c\u4eba: ");
            AssignmentInfo[] assignments = svc.getAssignmentByActInstId(actInstIds[i]);
            if (assignments.length == 0) {
                if (procInstInfo == null) {
                    ActivityInstInfo aInfo = svc.getActivityInstByActInstId(actInstIds[i]);
                    procInstInfo = svc.getProcessInstInfo(aInfo.getProcInstId());
                    aDef = svc.getProcessDefByDefineHashValue(procInstInfo.getProcDefHashValue()).getActivityDef(aInfo.getActDefId());
                }
                StringBuffer usernames = new StringBuffer();
                if (procInstInfo.getParentProcInstId() == null) {
                    boolean isFirst = false;
                    ActivityCollection acts = aDef.getPreviousActivities();
                    for (int j = 0; j < acts.size(); ++j) {
                        if (!(acts.get(j) instanceof StartActivityDef)) continue;
                        isFirst = true;
                    }
                    if (isFirst) {
                        usernames.append(procInstInfo.getInitiatorName(this.ctx.getLocale()));
                    }
                }
                if (usernames.length() <= 0) continue;
                sb.append("<font color='green'>{\u53d1\u8d77\u4eba- ").append(usernames).append("}</font>");
                continue;
            }
            String s = this.getPerformerNames(assignments, WfAssignmentState.COMPLETED);
            if (s.length() > 0) {
                sb.append("<font color='green'>{\u5df2\u5904\u7406 - ").append(s).append("}</font>");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.ASSIGNED)).length() > 0) {
                sb.append("<font color='blue'>{\u5f85\u5904\u7406 - ").append(s).append("}</font>");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.CANCELED)).length() > 0) {
                sb.append("<font color='silver'>{\u5df2\u64a4\u6d88 - ").append(s).append("}</font>");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.REJECTED)).length() > 0) {
                sb.append("<font color='red'>{\u5df2\u62d2\u7edd - ").append(s).append("}</font>");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.PROCESSING)).length() == 0) {
                s = this.getPerformerNames(assignments, WfAssignmentState.ACCEPTED);
            }
            if (s.length() <= 0) continue;
            sb.append("{\u5904\u7406\u4e2d - ").append(s).append("}");
        }
        return sb.toString();
    }

    protected final String getPerformerNames(AssignmentInfo[] assignments, WfAssignmentState state) throws Exception {
        IUser user = null;
        StringBuffer usernames = new StringBuffer();
        for (int j = 0; j < assignments.length; ++j) {
            AssignmentInfo assignment = assignments[j];
            if (!state.equals((Object)assignment.getState())) continue;
            String name = assignment.getUserName(this.ctx.getLocale());
            if (name == null) {
                if (user == null) {
                    user = UserFactory.getLocalInstance((Context)this.ctx);
                }
                if ((name = user.getUserInfo("select name where id='" + assignment.getUserId() + "'").getName(this.ctx.getLocale())) == null) {
                    name = assignment.getUserId();
                }
            }
            if (usernames.indexOf(name) > -1) continue;
            if (usernames.length() > 0) {
                usernames.append(",");
            }
            usernames.append(name);
        }
        return usernames.toString();
    }
}

