/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.caldate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.statsa.caldate.CalworkCalenderInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SAWorkCalendarUtil {
    private static final String SAKEY = "_SA";
    private static Logger log = Logger.getLogger(SAWorkCalendarUtil.class);
    private static final SimpleDateFormat sdfYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private static ConcurrentHashMap<String, CalworkCalenderInfo> workCalenderMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> orgCalenderRelationMap = new ConcurrentHashMap();

    public static boolean existWorkCalendar(Context ctx, int day) throws BOSException {
        Timestamp end = new Timestamp(System.currentTimeMillis());
        Calendar cCalendar = Calendar.getInstance();
        cCalendar.add(5, -day);
        Timestamp begin = new Timestamp(cCalendar.getTimeInMillis());
        String sql = "select 1 from T_WorkCalendar a where a.FOrgUnitID = '00000000-0000-0000-0000-000000000000CCE7AED4' and a.fstartworkdate <= ? and a.fendworkdate >=?";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{93, 93}, (Object[])new Object[]{begin, end});
        if (list == null || list.size() == 0) {
            String startDate = sdfYMMDD.format(begin);
            String endDate = sdfYMMDD.format(end);
            throw new BOSException("\u6ca1\u6709\u7ef4\u62a4\u5de5\u4f5c\u65e5\u5386\uff0c\u8bf7\u5148\u7ef4\u62a4" + startDate + "\u5230" + endDate + "\u76f8\u5e94\u65e5\u671f\u7684\u96c6\u56e2\u5de5\u4f5c\u65e5\u5386");
        }
        return true;
    }

    public static BigDecimal calExecuteTime(Context ctx, Date startTime, Date endTime) throws BOSException {
        return SAWorkCalendarUtil.calExecuteTime(ctx, startTime, endTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BigDecimal calExecuteTime(Context ctx, Date startTime, Date endTime, String orgId) throws BOSException {
        String calenderId = SAWorkCalendarUtil.getWorkCalendarId(ctx, orgId);
        if (calenderId == null) {
            throw new BOSException("\u6839\u636e\u7ec4\u7ec7id:" + orgId + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5de5\u4f5c\u65e5\u5386");
        }
        String key = ctx.getAIS() + SAKEY + calenderId;
        CalworkCalenderInfo workCalenderInfo = workCalenderMap.get(key);
        if (workCalenderInfo != null) return workCalenderInfo.calWorkTime(startTime, endTime, "M");
        Class<SAWorkCalendarUtil> clazz = SAWorkCalendarUtil.class;
        synchronized (SAWorkCalendarUtil.class) {
            try {
                workCalenderInfo = new CalworkCalenderInfo(calenderId, ctx);
            }
            catch (Exception e) {
                throw new BOSException("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386:" + calenderId + "\u51fa\u9519", (Throwable)e);
            }
            workCalenderMap.put(key, workCalenderInfo);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return workCalenderInfo.calWorkTime(startTime, endTime, "M");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWorkCalendarId(Context ctx, String orgId) throws BOSException {
        String workCalendarId = null;
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            if (orgCalenderRelationMap.get(orgId) != null) {
                return orgCalenderRelationMap.get(orgId);
            }
            Class<SAWorkCalendarUtil> clazz = SAWorkCalendarUtil.class;
            synchronized (SAWorkCalendarUtil.class) {
                String sql = "select a.fid from T_WorkCalendar a where a.FOrgUnitID = ? ";
                ArrayList result = SQL.executeQuery((Context)ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{"00000000-0000-0000-0000-000000000000CCE7AED4"});
                if (result.size() > 0) {
                    Map map = (Map)result.get(0);
                    workCalendarId = (String)map.get("fid");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        if (orgCalenderRelationMap.get(orgId) != null) {
            return orgCalenderRelationMap.get(orgId);
        }
        Class<SAWorkCalendarUtil> clazz = SAWorkCalendarUtil.class;
        synchronized (SAWorkCalendarUtil.class) {
            String adminSql = "select FLongNumber from T_Org_Admin where fid = ?";
            ArrayList result = SQL.executeQuery((Context)ctx, (String)adminSql, (int[])new int[]{12}, (Object[])new Object[]{orgId});
            if (result.size() > 0) {
                Map map = (Map)result.get(0);
                String longNumber = (String)map.get("flongnumber");
                StringBuffer calenderSql = new StringBuffer();
                calenderSql.append(" select top 1 a.fid as fid from T_WorkCalendar a, T_Org_Admin b ");
                calenderSql.append(" where a.FOrgUnitID = b.fid and b.fnumber in ").append(SAWorkCalendarUtil.coverToInSql(longNumber));
                calenderSql.append(" order by b.flongnumber desc");
                ArrayList calendarResult = SQL.executeQuery((Context)ctx, (String)calenderSql.toString());
                if (calendarResult.size() > 0) {
                    Map calenderMap = (Map)calendarResult.get(0);
                    workCalendarId = (String)calenderMap.get("fid");
                }
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            {
                if (workCalendarId != null) {
                    orgCalenderRelationMap.put(orgId, workCalendarId);
                }
                return workCalendarId;
            }
        }
    }

    public static String coverToInSql(String longNumber) {
        StringTokenizer tokenizer = new StringTokenizer(longNumber, "!", false);
        StringBuffer numberInsql = new StringBuffer("(");
        while (tokenizer.hasMoreElements()) {
            numberInsql.append("'").append(tokenizer.nextToken()).append("',");
        }
        numberInsql.deleteCharAt(numberInsql.lastIndexOf(","));
        numberInsql.append(")");
        return numberInsql.toString();
    }

    public static void clearWorkCalender() {
        workCalenderMap.clear();
        orgCalenderRelationMap.clear();
    }
}

