/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.md5;
import com.kingdee.bos.workflow.metas.SAAssignFactory;
import com.kingdee.bos.workflow.metas.SAAssignInfo;
import com.kingdee.bos.workflow.metas.SAProcInstInfo;
import com.kingdee.bos.workflow.statsa.caldate.SAWorkCalendarUtil;
import com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncMange;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SAAssignDATASync {
    private Context ctx;
    private static Logger log = Logger.getLogger(SAAssignDATASync.class);
    public static Set columnSet = null;

    public SAAssignDATASync(Context ctx) {
        this.ctx = ctx;
    }

    public static Set getColumns(IRowSet rowSet) throws SQLException {
        if (columnSet == null) {
            HashSet<String> set = new HashSet<String>();
            int columns = rowSet.getMetaData().getColumnCount();
            for (int index = 1; index <= columns; ++index) {
                String columnName = rowSet.getMetaData().getColumnName(index);
                if (columnName.indexOf("_") > 0) {
                    columnName = columnName.substring(0, columnName.indexOf("_"));
                }
                set.add(columnName.toUpperCase());
            }
            columnSet = set;
        }
        return columnSet;
    }

    public boolean synData(SAProcInstInfo tSAProcInstInfo) throws BOSException {
        String procInstId = tSAProcInstInfo.getProcInstID().toString();
        try {
            CoreBaseCollection tCoreCollection = new CoreBaseCollection();
            String language = LocaleUtils.getShortCode((Locale)this.ctx.getLocale());
            StringBuffer tSql = new StringBuffer();
            tSql.append(" select  FASSIGNID  ,FSubject_" + language + " FSubject,FSTATE ,FPERSONUSERID ,FPersonUserName_l1,FPersonUserName_l2,FPersonUserName_l3,FPERSONEMPID , ");
            tSql.append(" FPersonEmpName_l1,FPersonEmpName_l2,FPersonEmpName_l3,FACTINSTID ,FACTDEFID ,FActdefName_l1,FActdefName_l2,FActdefName_l3,FPROCINSTID , ");
            tSql.append(" FPROCDEFID ,FProcdefName_l1,FProcdefName_l2,FProcdefName_l3, FENDTIME ,FLASTSTATETIME ,FCREATEDTIME , ");
            tSql.append(" FBIZPACKAGE ,FBIZFUNCTION ,FBIZOPERATION ,FBIZOBJID  ,FPRIORITY ,FIsSendMsg  ");
            tSql.append(" from t_wfr_assignview  ");
            tSql.append(" where FSTATE=16 and fprocinstid = '" + procInstId + "' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tSql.toString());
            while (rowSet.next()) {
                CoreBaseInfo assignInfo = this.createSAAssignInfo(tSAProcInstInfo, rowSet);
                if (assignInfo == null) continue;
                tCoreCollection.add(assignInfo);
            }
            if (tCoreCollection.size() > 0) {
                SAAssignFactory.getLocalInstance((Context)this.ctx).addnewBatchData(tCoreCollection);
            }
        }
        catch (Exception e) {
            throw new BOSException("\u540c\u6b65\u6d41\u7a0b\uff1a" + procInstId + "\u5bf9\u5e94\u7684\u4efb\u52a1\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        return true;
    }

    private CoreBaseInfo createSAAssignInfo(SAProcInstInfo tSAProcInstInfo, IRowSet rowSet) throws SQLException, BOSException {
        SAAssignInfo tSAAssignInfo = new SAAssignInfo();
        SAUtil.setPropertyForRowSet(this.ctx, rowSet, SAAssignDATASync.getColumns(rowSet), (CoreBaseInfo)tSAAssignInfo, tSAAssignInfo.getBOSType());
        tSAAssignInfo.setId(BOSUuid.create((BOSObjectType)tSAAssignInfo.getBOSType()));
        tSAAssignInfo.setBillBostype(tSAProcInstInfo.getBillBostype());
        tSAAssignInfo.setBillBostypeName(tSAProcInstInfo.getBillBostypeName());
        tSAAssignInfo.setInitiatorID(tSAProcInstInfo.getInitiatorID());
        tSAAssignInfo.setInitiatorName(tSAProcInstInfo.getInitiatorName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        tSAAssignInfo.setInitiatorName(tSAProcInstInfo.getInitiatorName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        tSAAssignInfo.setInitiatorName(tSAProcInstInfo.getInitiatorName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        tSAAssignInfo.setAssignHashID(this.createNewAssignHashId(tSAAssignInfo.getProcdefID().toString(), tSAAssignInfo.getActdefID().toString(), tSAProcInstInfo.getBillBostype(), tSAAssignInfo.getPersonEmpID().toString()));
        String adminOrg = this.getAdminOrg(tSAAssignInfo.getPersonEmpID().toString());
        BigDecimal executeTime = SAWorkCalendarUtil.calExecuteTime(this.ctx, tSAAssignInfo.getCreatedTime(), tSAAssignInfo.getEndTime(), adminOrg);
        if (executeTime.doubleValue() < 1.0) {
            return null;
        }
        tSAAssignInfo.setExecuteTime(executeTime);
        return tSAAssignInfo;
    }

    private BOSUuid createNewAssignHashId(String procDefId, String actDefId, String bostype, String personId) {
        String uuid = "";
        try {
            md5 md = new md5(procDefId + actDefId + bostype + personId);
            md.processString();
            String hashValue = md.getStringDigest();
            uuid = hashValue.substring(0, 8) + "-" + hashValue.substring(8, 12) + "-" + hashValue.substring(12, 16) + "-" + hashValue.substring(16, 20) + "-" + hashValue.substring(20) + "WFASGHSH";
            return BOSUuid.read((String)uuid);
        }
        catch (Exception e) {
            if (!SAProcessDATASyncMange.logIsClose) {
                log.error((Object)("\u751f\u6210assignHash  uuid\u62a5\u9519:" + uuid), (Throwable)e);
            }
            return BOSUuid.read((String)personId);
        }
    }

    private String getAdminOrg(String personId) {
        String adminOrg = null;
        try {
            StringBuffer tSql = new StringBuffer();
            tSql.append(" select a.fadminorgunitid from T_ORG_Position a ,T_ORG_PositionMember b  ");
            tSql.append(" where a.fid = b.fpositionid and b.fisprimary = 1 ");
            tSql.append(" and b.fpersonid = '" + personId + "' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tSql.toString());
            if (rowSet.next()) {
                adminOrg = rowSet.getString("fadminorgunitid");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adminOrg;
    }
}

