/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleAdapter;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ScriptFunction;
import com.kingdee.bos.workflow.define.ScriptFunctionUtil;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfExecutionObject;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.engine.core.ThreadCache;
import com.kingdee.bos.workflow.exception.FatalInterruptException;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.CCParticipantBlock;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.ParticipantBlock;
import com.kingdee.bos.workflow.participant.ParticipantCase;
import com.kingdee.bos.workflow.participant.ParticipantUnit;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.bos.workflow.security.IPermissionProvider;
import com.kingdee.bos.workflow.util.PermissionUtil;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfBizObjUtils;
import com.kingdee.bos.workflow.util.WfRoleInvoke;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.bos.workflow.wfdesigner.WfFunctionInfo;
import com.kingdee.bos.workflow.wfdesigner.service.IWorkFlowDefineService;
import com.kingdee.eas.basedata.person.app.PersonToWFAdapter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ParticipantHelper {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.ParticipantHelper");

    public static List getPersonsByParticipants(WfExecutionObject wfExecObj, ActivityDef actDef, String procInstID) throws WfException {
        ParticipantCase pCase;
        int i;
        long start = System.currentTimeMillis();
        ParticipantCollection includeCol = new ParticipantCollection();
        ParticipantCollection excludeCol = new ParticipantCollection();
        ParticipantBlock block = new ParticipantBlock(actDef);
        ArrayList<ParticipantCase> executeCaseList = new ArrayList<ParticipantCase>();
        List caseList = block.getChildren();
        ArrayList<Person> rtnList = new ArrayList<Person>();
        int n = caseList.size();
        for (i = 0; i < n; ++i) {
            WfProcess procInst;
            String script;
            pCase = (ParticipantCase)caseList.get(i);
            if (pCase.isDefault() || !ScriptUtil.evalCondition(script = pCase.getCondition().getScriptDefWrapper().getScriptDef().getScriptContent(), (procInst = wfExecObj.getWfEngine().getProcessInst(procInstID)).getProcessContext(), procInst.getDefinition())) continue;
            executeCaseList.add(pCase);
        }
        if (executeCaseList.size() == 0) {
            executeCaseList.add(block.getDefaultCase());
        }
        n = executeCaseList.size();
        for (i = 0; i < n; ++i) {
            pCase = (ParticipantCase)executeCaseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                includeCol.clear();
                excludeCol.clear();
                includeCol.addObject(def.getID(), (Object)def);
                if (pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef() != null) {
                    excludeCol.addObject(def.getID(), (Object)pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef());
                }
                List includeList = ParticipantHelper.getPersonsByParticipants(wfExecObj, includeCol);
                List excludeList = ParticipantHelper.getPersonsByParticipants(wfExecObj, excludeCol);
                for (int index = 0; index < includeList.size(); ++index) {
                    Person inPerson = (Person)includeList.get(index);
                    if (excludeList.size() != 0 && excludeList.contains(inPerson)) continue;
                    rtnList.add(inPerson);
                }
            }
        }
        long end = System.currentTimeMillis();
        long span = end - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cacu participant cost:" + span));
        }
        return ParticipantHelper.distinctPersons(rtnList);
    }

    public static List getPersonsByParticipant(WfExecutionObject wfExecObj, ActivityDef actDef, String procInstID) throws WfException {
        long start = System.currentTimeMillis();
        ParticipantCollection excludeCol = new ParticipantCollection();
        ParticipantBlock block = new ParticipantBlock(actDef);
        List caseList = block.getChildren();
        ArrayList rtnList = new ArrayList();
        int n = caseList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantCase pCase = (ParticipantCase)caseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                excludeCol.clear();
                if (pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef() != null) {
                    excludeCol.addObject(def.getID(), (Object)pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef());
                }
                List excludeList = ParticipantHelper.getPersonsByParticipants(wfExecObj, excludeCol);
                int l = excludeList.size();
                for (int k = 0; k < l; ++k) {
                    rtnList.add(excludeList.get(k));
                }
            }
        }
        long end = System.currentTimeMillis();
        long span = end - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cacu participant cost:" + span));
        }
        return ParticipantHelper.distinctPersons(rtnList);
    }

    public static List getPersonsByParticipants(WfEngine wfEngine, String procDefHash, String activityId, String currentUserId, boolean isForEvent) throws WfException {
        ManpowerActivityDef def;
        ProcessDef procDef = wfEngine.getProcessDef(procDefHash);
        ActivityDef actDef = procDef.getActivityDef(activityId);
        if (isForEvent && actDef instanceof ManpowerActivityDef && !StringUtils.isEmpty((String)(def = (ManpowerActivityDef)actDef).getRefEventActDefId())) {
            actDef = procDef.getActivityDef(def.getRefEventActDefId());
        }
        long start = System.currentTimeMillis();
        ParticipantCollection includeCol = new ParticipantCollection();
        ParticipantCollection excludeCol = new ParticipantCollection();
        ParticipantBlock block = new ParticipantBlock(actDef);
        ArrayList<ParticipantCase> executeCaseList = new ArrayList<ParticipantCase>();
        ArrayList rtnList = new ArrayList();
        executeCaseList.add(block.getDefaultCase());
        int n = executeCaseList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantCase pCase = (ParticipantCase)executeCaseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                int k;
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def2 = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                includeCol.addObject(def2.getID(), (Object)def2);
                if (pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef() != null) {
                    excludeCol.addObject(def2.getID(), (Object)pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef());
                }
                List includeList = ParticipantHelper.getPersonsByParticipants(wfEngine, procDefHash, activityId, includeCol, currentUserId);
                List excludeList = ParticipantHelper.getPersonsByParticipants(wfEngine, procDefHash, activityId, excludeCol, currentUserId);
                int l = excludeList.size();
                for (k = 0; k < l; ++k) {
                    Person person = (Person)excludeList.get(k);
                    if (!includeList.contains(person)) continue;
                    includeList.remove(person);
                }
                l = includeList.size();
                for (k = 0; k < l; ++k) {
                    rtnList.add(includeList.get(k));
                }
            }
        }
        long end = System.currentTimeMillis();
        long span = end - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cacu participant cost:" + span));
        }
        return ParticipantHelper.distinctPersons(rtnList);
    }

    public static List getPersonsByParticipant(WfEngine wfEngine, String procDefHash, String activityId, String currentUserId, boolean isForEvent) throws WfException {
        ManpowerActivityDef def;
        ProcessDef procDef = wfEngine.getProcessDef(procDefHash);
        ActivityDef actDef = procDef.getActivityDef(activityId);
        if (isForEvent && actDef instanceof ManpowerActivityDef && !StringUtils.isEmpty((String)(def = (ManpowerActivityDef)actDef).getRefEventActDefId())) {
            actDef = procDef.getActivityDef(def.getRefEventActDefId());
        }
        long start = System.currentTimeMillis();
        ParticipantCollection excludeCol = new ParticipantCollection();
        ParticipantBlock block = new ParticipantBlock(actDef);
        ArrayList rtnList = new ArrayList();
        List caseList = block.getChildren();
        int n = caseList.size();
        for (int i = 0; i < n; ++i) {
            ParticipantCase pCase = (ParticipantCase)caseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def2 = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                if (pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef() != null) {
                    excludeCol.addObject(def2.getID(), (Object)pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef());
                }
                List excludeList = ParticipantHelper.getPersonsByParticipants(wfEngine, procDefHash, activityId, excludeCol, currentUserId);
                int l = excludeList.size();
                for (int k = 0; k < l; ++k) {
                    rtnList.add(excludeList.get(k));
                }
            }
        }
        long end = System.currentTimeMillis();
        long span = end - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cacu participant cost:" + span));
        }
        return ParticipantHelper.distinctPersons(rtnList);
    }

    public static List getPersonsByParticipants(WfEngine wfEngine, String procDefHash, String activityId, ParticipantCollection participants) throws WfException {
        return ParticipantHelper.getPersonsByParticipants(wfEngine, procDefHash, activityId, participants, null);
    }

    public static List getPersonsByParticipants(WfEngine wfEngine, String procDefHash, String activityId, ParticipantCollection participants, String currentUserId) throws WfException {
        ProcessDef procDef = wfEngine.getProcessDef(procDefHash);
        ActivityDef actDef = procDef.getActivityDef(activityId);
        ArrayList<Person> persons = new ArrayList<Person>();
        for (ParticipantDef participantDef : participants) {
            List<Person> ps;
            String billId;
            Object obj;
            String orgPropertyName;
            ParticipantType type = participantDef.getParticipantType();
            String orgId = participantDef.getParticipantValue();
            if (ParticipantHelper.isOrgVariable(orgId)) continue;
            if (type == ParticipantType.USER) {
                ParticipantHelper.getPersonsByUser(null, wfEngine, persons, participantDef);
                continue;
            }
            if (type == ParticipantType.HUMAN) {
                ParticipantHelper.getPersonsByHuman(null, wfEngine, persons, participantDef);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                ParticipantHelper.getPersonByOrgMember(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                ParticipantHelper.getPersonByOrgAllMember(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (type == ParticipantType.POSITION) {
                ParticipantHelper.getPersonByPosition(null, wfEngine, persons, participantDef);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                ParticipantHelper.getPersonByPrincipal(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                ParticipantHelper.getPersonByOrgPermissionOwner(wfEngine, persons, participantDef, actDef, orgId);
                continue;
            }
            if (type == ParticipantType.RELATION) {
                ReferenceHumanType refType = participantDef.getReferenceHumanType();
                if (ReferenceHumanType.POSITION.equals((Object)refType)) {
                    ParticipantHelper.computePositionAimPerson(wfEngine, persons, participantDef);
                    continue;
                }
                if (ReferenceHumanType.PROCESS_INITIATOR.equals((Object)refType)) {
                    if (currentUserId == null) {
                        currentUserId = wfEngine.context().getCaller().toString();
                    }
                    Person me = wfEngine.getPariticipantProvider().getPersonByUserId(wfEngine.context(), currentUserId);
                    ParticipantHelper.computeAimPerson(null, wfEngine, persons, participantDef, new Person[]{me});
                    continue;
                }
                if (!ReferenceHumanType.EMPLOYEE.equals((Object)refType)) continue;
                Person[] rtn = wfEngine.getPariticipantProvider().getPersonByEmployeeId(wfEngine.context(), participantDef.getReferenceHumanId());
                if (rtn == null || rtn.length == 0) {
                    Person p = new Person();
                    p.setEmployeeId(participantDef.getReferenceHumanId());
                    rtn = new Person[]{p};
                }
                ParticipantHelper.computeAimPerson(null, wfEngine, persons, participantDef, rtn);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ROLE || participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER || participantDef.getParticipantType() == ParticipantType.VARIANT) continue;
            if (participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY)) {
                ParticipantHelper.getPersonByProcResponsibility(wfEngine, procDef, persons);
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.ALL)) {
                if (currentUserId == null) {
                    currentUserId = wfEngine.context().getCaller().toString();
                }
                Person me = wfEngine.getPariticipantProvider().getPersonByUserId(wfEngine.context(), currentUserId);
                persons.add(me);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByOrgJob(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (ParticipantType.GROUP.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByGroup(null, wfEngine, persons, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantDef.getParticipantType())) {
                wfEngine.getPariticipantProvider().getOrgAllMember(wfEngine.context(), orgId);
                continue;
            }
            if (ParticipantType.PROCESS_EXECUTOR.equals((Object)participantDef.getParticipantType())) continue;
            if (ParticipantType.WFROLE.equals((Object)participantDef.getParticipantType())) {
                String roleId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                obj = ThreadCache.get("PROCESSCTX");
                billId = null;
                if (obj != null) {
                    billId = (String)((Map)obj).get("_BILL_ID_");
                }
                if ((ps = WfRoleInvoke.getInstance().getRolePersons(wfEngine.context(), roleId, billId, orgPropertyName)) == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFROLE_GROUP.equals((Object)participantDef.getParticipantType())) {
                String roleGroupId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                obj = ThreadCache.get("PROCESSCTX");
                billId = null;
                if (obj != null) {
                    billId = (String)((Map)obj).get("_BILL_ID_");
                }
                if ((ps = WfRoleInvoke.getInstance().getRoleGroupPersons(wfEngine.context(), roleGroupId, billId, orgPropertyName)) == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFFunction.equals((Object)participantDef.getParticipantType())) continue;
            throw new WfException("NOT SUPPORT." + participantDef.getParticipantType().getName());
        }
        return ParticipantHelper.distinctPersons(persons);
    }

    public static List getPersonsByParticipants(WfEngine wfEngine, String procDefHash, String activityId, ParticipantCollection participants, String currentUserId, IObjectValue bizBillObject) throws WfException {
        ProcessDef procDef = wfEngine.getProcessDef(procDefHash);
        ActivityDef actDef = procDef.getActivityDef(activityId);
        ArrayList<Person> persons = new ArrayList<Person>();
        boolean init = false;
        Map map = new HashMap();
        for (ParticipantDef participantDef : participants) {
            List ps;
            WfRoleAdapter roleAdapter;
            String orgPropertyName;
            Person me;
            String orgId;
            ParticipantType type = participantDef.getParticipantType();
            if (type == ParticipantType.WFFunction && !init) {
                try {
                    log.error((Object)("wf:getPersonsByParticipants billOBJ:" + bizBillObject));
                    map = ParticipantHelper.getProcessPropMap(procDef, wfEngine, bizBillObject);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                init = true;
            }
            if (ParticipantHelper.isOrgVariable(orgId = participantDef.getParticipantValue())) continue;
            if (type == ParticipantType.USER) {
                ParticipantHelper.getPersonsByUser(null, wfEngine, persons, participantDef);
                continue;
            }
            if (type == ParticipantType.HUMAN) {
                ParticipantHelper.getPersonsByHuman(null, wfEngine, persons, participantDef);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                ParticipantHelper.getPersonByOrgMember(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                ParticipantHelper.getPersonByOrgAllMember(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (type == ParticipantType.POSITION) {
                ParticipantHelper.getPersonByPosition(null, wfEngine, persons, participantDef);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                ParticipantHelper.getPersonByPrincipal(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (type == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                ParticipantHelper.getPersonByOrgPermissionOwner(wfEngine, persons, participantDef, actDef, orgId);
                continue;
            }
            if (type == ParticipantType.RELATION) {
                if (ReferenceHumanType.POSITION.equals((Object)participantDef.getReferenceHumanType())) {
                    ParticipantHelper.computePositionAimPerson(wfEngine, persons, participantDef);
                    continue;
                }
                if (currentUserId == null) {
                    currentUserId = wfEngine.context().getCaller().toString();
                }
                me = wfEngine.getPariticipantProvider().getPersonByUserId(wfEngine.context(), currentUserId);
                if (!ReferenceHumanType.PROCESS_VARIABLE.equals((Object)participantDef.getReferenceHumanType())) {
                    ParticipantHelper.computeAimPerson(null, wfEngine, persons, participantDef, new Person[]{me});
                    continue;
                }
                ParticipantHelper.computeProcessVariablePerson(wfEngine, persons, participantDef, procDef, bizBillObject);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ROLE || participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER || participantDef.getParticipantType() == ParticipantType.VARIANT) continue;
            if (participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY)) {
                ParticipantHelper.getPersonByProcResponsibility(wfEngine, procDef, persons);
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.ALL)) {
                if (currentUserId == null) {
                    currentUserId = wfEngine.context().getCaller().toString();
                }
                me = wfEngine.getPariticipantProvider().getPersonByUserId(wfEngine.context(), currentUserId);
                persons.add(me);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByOrgJob(null, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (ParticipantType.GROUP.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByGroup(null, wfEngine, persons, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantDef.getParticipantType())) {
                wfEngine.getPariticipantProvider().getOrgAllMember(wfEngine.context(), orgId);
                continue;
            }
            if (ParticipantType.PROCESS_EXECUTOR.equals((Object)participantDef.getParticipantType())) continue;
            if (ParticipantType.WFROLE.equals((Object)participantDef.getParticipantType())) {
                String roleId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                roleAdapter = new WfRoleAdapter();
                ps = null;
                try {
                    ps = roleAdapter.getRolePersons(wfEngine.context(), roleId, bizBillObject, orgPropertyName, false);
                }
                catch (Exception e) {
                    log.error((Object)("\u63d0\u4ea4\u65f6\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba--\u5de5\u4f5c\u6d41\u89d2\u8272\u62a5\u9519--" + e.getMessage()), (Throwable)e);
                }
                if (ps == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFROLE_GROUP.equals((Object)participantDef.getParticipantType())) {
                String roleGroupId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                roleAdapter = new WfRoleAdapter();
                ps = null;
                try {
                    ps = roleAdapter.getRolePersons(wfEngine.context(), roleGroupId, bizBillObject, orgPropertyName, true);
                }
                catch (Exception e) {
                    log.error((Object)("\u63d0\u4ea4\u65f6\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba--\u5de5\u4f5c\u6d41\u89d2\u8272\u7ec4\u62a5\u9519--" + e.getMessage()), (Throwable)e);
                }
                if (ps == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFFunction.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.invokeFunction(map, persons, wfEngine, participantDef);
                continue;
            }
            throw new WfException("NOT SUPPORT." + participantDef.getParticipantType().getName());
        }
        return ParticipantHelper.distinctPersons(persons);
    }

    private static Map getProcessPropMap(ProcessDef procDef, WfEngine wfEngine, IObjectValue bizBillObject) throws WfException {
        HashMap<String, IObjectValue> boMap = new HashMap<String, IObjectValue>();
        Context ctx = wfEngine.context();
        ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)procDef.getStartupActivities().get(0);
        BOSObjectType bosType = new BOSObjectType(procDef.getBillBostype());
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        boMap.put(entity.getName(), bizBillObject);
        return ParticipantHelper.getProcessPropMapInner(manpowerActivityDef, ctx, boMap, bizBillObject);
    }

    private static Map getProcessPropMapInner(ManpowerActivityDef manpowerActDef, Context ctx, Map boMap, IObjectValue bizBillObject) {
        ApplicationDef appDef = manpowerActDef.getRelatedApplication();
        HashMap<String, FormalParameterDef> paramDefMap = new HashMap<String, FormalParameterDef>();
        Map paramValueMap = new HashMap();
        FormalParameterCollection formalParms = appDef.getFormalParameters();
        ActualParameterCollection actualParamCol = manpowerActDef.getActualParameters();
        FormalParameterDef bizObjParamDef = null;
        for (int i = 0; i < formalParms.size(); ++i) {
            FormalParameterDef paramDef = formalParms.get(i);
            if (!paramDef.getMode().equals((Object)FormalParameterMode.OUT) && !paramDef.getMode().equals((Object)FormalParameterMode.INOUT) || paramDef.getBoId() == null || paramDef.getBoId().equals("")) continue;
            if (!paramDef.getDataType().equals(BasicType.BIZOBJ)) {
                paramDefMap.put(paramDef.getID(), paramDef);
                continue;
            }
            bizObjParamDef = paramDef;
            boMap.put(paramDef.getName(), bizBillObject);
            paramDefMap.put(paramDef.getID(), paramDef);
        }
        try {
            paramValueMap = ScriptUtil.evalPropertyExpr(paramDefMap, boMap, ctx, null);
        }
        catch (WfException e) {
            e.printStackTrace();
        }
        for (FormalParameterDef paramDef : paramDefMap.values()) {
            ActualParameterDef actualParam;
            DataFieldDef dataField;
            if (paramDef.getDataType().equals(BasicType.BIZOBJ) || paramDef.getIndex() >= actualParamCol.size() || (dataField = (actualParam = (ActualParameterDef)actualParamCol.getObject(paramDef.getIndex())).getDataField()) == null) continue;
            String dataName = dataField.getName();
            Object paramValue = paramValueMap.get(paramDef.getID());
            boMap.put(dataName, paramValue);
        }
        return boMap;
    }

    private static void invokeFunction(Map map, List persons, WfEngine wfEngine, ParticipantDef participantDef) throws WfException {
        String script = null;
        String scriptFunctionId = participantDef.getParticipantValue();
        if (!StringUtils.isEmpty((String)scriptFunctionId)) {
            script = ParticipantHelper.getString(wfEngine, scriptFunctionId, script);
        } else {
            log.error((Object)"\u5de5\u4f5c\u6d41\u51fd\u6570\u53c2\u4e0e\u4eba\u7c7b\u578b\u7684\u51fd\u6570ID\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((String)script)) {
            Interpreter interpreter = new Interpreter(wfEngine.context());
            interpreter.setProperyExprOwnerNullIgore(true);
            Object rtnVal = null;
            try {
                Map curMap = ParticipantHelper.getMap(participantDef, map, interpreter);
                rtnVal = interpreter.eval(script, curMap);
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
            ParticipantHelper.getReturnVal(persons, null, rtnVal);
        } else {
            log.error((Object)("\u6839\u636efunctionId[" + scriptFunctionId + "]\u6240\u627e\u5230\u7684\u811a\u672c\u4e3a\u7a7a"));
        }
    }

    private static Map getMap(ParticipantDef participantDef, Map paramValueMap, Interpreter interpreter) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map exParDefMap = participantDef.getExParDefMap();
        String formalName = (String)exParDefMap.get("FormalName");
        String actualName = (String)exParDefMap.get("ActualName");
        String[] formalNames = formalName.split(";");
        String[] actualNames = actualName.split(";");
        for (int i = 0; i < formalNames.length; ++i) {
            if (paramValueMap.containsKey(actualNames[i])) {
                map.put(formalNames[i], paramValueMap.get(actualNames[i]));
                continue;
            }
            map.put(formalNames[i], interpreter.eval(actualNames[i], paramValueMap));
        }
        return map;
    }

    public static List getPersonsByParticipants(WfExecutionObject wfExecObj, ParticipantCollection participants) throws WfException {
        LowTimer lowTimer = new LowTimer();
        ArrayList<Person> persons = new ArrayList<Person>();
        Iterator iterator = participants.iterator();
        if (wfExecObj == null) {
            return new ArrayList();
        }
        WfEngine wfEngine = wfExecObj.getWfEngine();
        while (iterator.hasNext()) {
            List<Person> ps;
            String billId;
            String orgPropertyName;
            ParticipantDef participantDef = (ParticipantDef)iterator.next();
            String orgId = ParticipantHelper.getOrgID(participantDef.getParticipantValue(), wfExecObj, participantDef);
            if (participantDef.getParticipantType() == ParticipantType.USER) {
                ParticipantHelper.getPersonsByUser(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.HUMAN) {
                ParticipantHelper.getPersonsByHuman(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                ParticipantHelper.getPersonByOrgMember(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                ParticipantHelper.getPersonByOrgAllMember(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.POSITION) {
                ParticipantHelper.getPersonByPosition(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                ParticipantHelper.getPersonByPrincipal(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                ParticipantHelper.getPersonByOrgPermissionOwner(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.RELATION) {
                ParticipantDef pdef = ParticipantHelper.getParticipantDef4Position(wfExecObj, participantDef);
                if (ReferenceHumanType.POSITION.equals((Object)pdef.getReferenceHumanType())) {
                    ParticipantHelper.computePositionAimPerson(wfEngine, persons, pdef);
                    continue;
                }
                ParticipantHelper.getPersonByRelation(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ROLE) {
                ParticipantHelper.getPersonByRole(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER) {
                ParticipantHelper.getPersonByPermissionOwner(wfExecObj, persons);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.VARIANT) {
                ParticipantHelper.getPersonByVariant(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY)) {
                ParticipantHelper.getPersonByProcResponsibility(wfExecObj, persons);
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.ALL)) {
                ParticipantHelper.getPersonByALL(wfExecObj, persons, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByOrgJob(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (ParticipantType.GROUP.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByGroup(wfExecObj, wfExecObj.getWfEngine(), persons, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantDef.getParticipantType())) {
                wfEngine.getPariticipantProvider().getOrgAllMember(wfEngine.context(), orgId);
                continue;
            }
            if (ParticipantType.PROCESS_EXECUTOR.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByProcessExecutor(wfExecObj, persons, participantDef);
                continue;
            }
            if (ParticipantType.WFROLE.equals((Object)participantDef.getParticipantType())) {
                String roleId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                billId = ParticipantHelper.getBillId(wfExecObj, wfEngine);
                ps = WfRoleInvoke.getInstance().getRolePersons(wfEngine.context(), roleId, billId, orgPropertyName);
                if (ps == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFROLE_GROUP.equals((Object)participantDef.getParticipantType())) {
                String roleGroupId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                billId = ParticipantHelper.getBillId(wfExecObj, wfEngine);
                ps = WfRoleInvoke.getInstance().getRoleGroupPersons(wfEngine.context(), roleGroupId, billId, orgPropertyName);
                if (ps == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFFunction.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.invokeFunction(wfExecObj, persons, wfEngine, participantDef);
                continue;
            }
            throw new WfException("NOT SUPPORT." + participantDef.getParticipantType().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("inner getPersonsByParticipants cacu cost " + lowTimer.msValue() + "ms,  participants.size " + participants.size()));
        }
        return ParticipantHelper.distinctPersons(persons);
    }

    private static ParticipantDef getParticipantDef4Position(WfExecutionObject wfExecObj, ParticipantDef participantDef) throws WfException {
        if (participantDef.getReferenceHumanType() == ReferenceHumanType.PROCESS_VARIABLE) {
            WfProcess procInst = null;
            if (wfExecObj instanceof WfActivity) {
                procInst = ((WfActivity)wfExecObj).container();
            } else if (wfExecObj instanceof WfProcess) {
                procInst = (WfProcess)wfExecObj;
            }
            if (procInst == null) {
                return participantDef;
            }
            ParticipantDef pdef = new ParticipantDef(null, participantDef.toElement());
            String dataFieldId = pdef.getReferenceHumanId();
            DataFieldDef dataField = procInst.getDefinition().getDataFieldDef(dataFieldId);
            String dataFieldName = null;
            dataFieldName = !StringUtils.isEmpty((String)pdef.getName()) ? pdef.getName() : dataField.getName();
            Object variantObj = procInst.getProcessContext().getDataFieldValue(dataFieldName);
            if (variantObj instanceof String || variantObj instanceof BOSUuid) {
                String bosType = null;
                try {
                    bosType = ParticipantHelper.getbosType(variantObj.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ("74AE612E".equals(bosType)) {
                    pdef.setReferenceHumanId(variantObj.toString());
                    pdef.setReferenceHumanType(ReferenceHumanType.POSITION);
                    if (pdef.getRelationType() == RelationType.PRIMARY_POSITION_SUPERVISOR) {
                        pdef.setRelationType(RelationType.SUPERVISOR);
                    }
                    if (pdef.getRelationType() == RelationType.PRIMARY_POSITION_INDIRECT_SUPERVISOR) {
                        pdef.setRelationType(RelationType.INDIRECTSUPERVISOR);
                    }
                    return pdef;
                }
            }
        }
        return participantDef;
    }

    private static String getBillId(WfExecutionObject wfExecObj, WfEngine wfEngine) throws WfException {
        String instId = null;
        if (wfExecObj instanceof WfProcess) {
            instId = ((WfProcess)wfExecObj).getId();
        } else if (wfExecObj instanceof WfActivity) {
            instId = ((WfActivity)wfExecObj).getProcInstId();
        } else if (wfExecObj instanceof WfAssignment) {
            instId = ((WfAssignment)wfExecObj).getProcInstId();
        }
        return wfEngine.getBizObjIdByProcessInstanceId(instId);
    }

    private static void invokeFunction(WfExecutionObject wfExecObj, List persons, WfEngine wfEngine, ParticipantDef participantDef) throws WfException {
        String script = null;
        String scriptFunctionId = participantDef.getParticipantValue();
        if (!StringUtils.isEmpty((String)scriptFunctionId)) {
            script = ParticipantHelper.getString(wfEngine, scriptFunctionId, script);
        } else {
            log.error((Object)(wfExecObj.getId() + "\u5de5\u4f5c\u6d41\u51fd\u6570\u53c2\u4e0e\u4eba\u7c7b\u578b\u7684\u51fd\u6570ID\u4e3a\u7a7a"));
        }
        if (!StringUtils.isEmpty((String)script)) {
            WfProcess wfProcess = ParticipantHelper.getWfProcess(wfExecObj);
            Interpreter interpreter = new Interpreter(wfEngine.context());
            interpreter.setProperyExprOwnerNullIgore(true);
            Object rtnVal = null;
            try {
                Map map = ParticipantHelper.getMap(participantDef, wfProcess);
                rtnVal = interpreter.eval(script, map);
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
            }
            ParticipantHelper.getReturnVal(persons, wfProcess, rtnVal);
        } else {
            log.error((Object)("\u6839\u636efunctionId[" + scriptFunctionId + "]\u6240\u627e\u5230\u7684\u811a\u672c\u4e3a\u7a7a"));
        }
    }

    private static void getReturnVal(List persons, WfProcess wfProcess, Object rtnVal) {
        if (rtnVal != null) {
            if (rtnVal instanceof Person) {
                persons.add(rtnVal);
            } else if (rtnVal instanceof List) {
                persons.addAll((Collection)rtnVal);
            } else if (rtnVal instanceof Person[]) {
                persons.addAll(Arrays.asList((Person[])rtnVal));
            } else if (wfProcess != null) {
                log.error((Object)("\u6d41\u7a0b\u5b9e\u4f8bID[" + wfProcess.getId() + "]\u6267\u884c\u5de5\u4f5c\u6d41\u51fd\u6570\u8fd4\u56de\u503c\u4e0d\u662fperson"));
            }
        } else if (wfProcess != null) {
            log.error((Object)("\u6d41\u7a0b\u5b9e\u4f8bID[" + wfProcess.getId() + "]\u6267\u884c\u5de5\u4f5c\u6d41\u51fd\u6570\u8fd4\u56de\u503c\u4e3a\u7a7a"));
        }
    }

    private static Map getMap(ParticipantDef participantDef, WfProcess wfProcess) throws WfException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map exParDefMap = participantDef.getExParDefMap();
        String formalName = (String)exParDefMap.get("FormalName");
        String actualName = (String)exParDefMap.get("ActualName");
        String[] formalNames = formalName.split(";");
        String[] actualNames = actualName.split(";");
        for (int i = 0; i < formalNames.length; ++i) {
            map.put(formalNames[i], wfProcess.getDataField(actualNames[i]));
        }
        return map;
    }

    private static String getString(WfEngine wfEngine, String scriptFunctionId, String script) {
        try {
            IWorkFlowDefineService service = (IWorkFlowDefineService)BOSObjectFactory.createBOSObject((Context)wfEngine.context(), (String)"com.kingdee.bos.workflow.wfdesigner.service.WorkFlowDefineService");
            WfFunctionInfo tWfFunctionInfo = service.getWfFunctionInfoById(scriptFunctionId);
            ScriptFunction sf = ScriptFunctionUtil.parse((String)tWfFunctionInfo.getContent());
            script = sf.getScript();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return script;
    }

    private static ArrayList distinctPersons(List persons) {
        LinkedHashMap<String, Person> mapPerson = new LinkedHashMap<String, Person>();
        int size = persons.size();
        for (int i = 0; i < size; ++i) {
            String key;
            Person person = (Person)persons.get(i);
            if (person == null || StringUtils.isEmpty((String)person.getUserId()) || mapPerson.containsKey(key = person.getUserId() + "_" + person.getEmployeeId())) continue;
            mapPerson.put(key, person);
        }
        return new ArrayList(mapPerson.values());
    }

    private static void getPersonByALL(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef) throws WfException {
        String initiatorId = ParticipantHelper.getInitialtorId(wfExecObj);
        Person person = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByUserId(wfExecObj.getWfEngine().context(), initiatorId);
        persons.add(person);
    }

    private static void getPersonByOrgJob(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef, String orgID) throws WfException {
        Person[] personArray = new Person[]{};
        try {
            personArray = wfEngine.getPariticipantProvider().getAdminOrgUnitJobHolders(wfEngine.context(), orgID, participantDef.getParticipantValue());
        }
        catch (Throwable e) {
            throw new FatalInterruptException("ParticipantProvider getOrgAllMember error!", e);
        }
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7[" + orgID + "]\u7684\u5c97\u4f4d[" + participantDef.getParticipantValue() + "]\u5bf9\u5e94\u4eba\u5458\u8fd4\u56de\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonByGroup(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef) throws WfException {
        Person[] personArray = new Person[]{};
        try {
            personArray = wfEngine.getPariticipantProvider().getPersonsFromGroup(wfEngine.context(), participantDef.getParticipantValue());
        }
        catch (Throwable e) {
            throw new FatalInterruptException("ParticipantProvider getGroupMember error!", e);
        }
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u7ec4[" + participantDef.getParticipantValue() + "]\u7684\u53c2\u4e0e\u4eba\u8fd4\u56de\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    public static boolean isOrgVariable(String orgDefineValue) {
        return orgDefineValue != null && orgDefineValue.indexOf("WFDAFDEF") > 0;
    }

    private static String getOrgID(String orgDefineValue, WfExecutionObject wfExecObj, ParticipantDef participantDef) throws WfException {
        if (StringUtils.isEmpty((String)orgDefineValue)) {
            throw new WfException("participantDef error");
        }
        String orgID = null;
        if (orgDefineValue.indexOf("WFDAFDEF") > 0) {
            Object participantVar = null;
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            participantVar = procInst.getProcessContext().getDataFieldValue(participantDef.getName());
            orgID = ParticipantHelper.getOrgIDByVariant(participantVar);
        } else if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantDef.getParticipantType())) {
            if (participantDef.getPerformDatafieldId() == null) {
                orgID = participantDef.getOrgID();
            } else {
                Object variantObj;
                String variantId = participantDef.getOrgID();
                WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
                DataFieldDef dataField = procInst.getDefinition().getDataFieldDef(variantId);
                orgID = dataField != null ? ((variantObj = procInst.getProcessContext().getDataFieldValue(dataField.getName())) != null ? ParticipantHelper.getOrgIDByVariant(variantObj) : variantId) : variantId;
            }
        } else {
            orgID = orgDefineValue;
        }
        return orgID;
    }

    private static String getOrgIDByVariant(Object variantObj) {
        String orgValue = "";
        if (variantObj == null) {
            return orgValue;
        }
        if (variantObj.getClass().getName().equals("com.kingdee.eas.basedata.org.AdminOrgUnitInfo")) {
            Class<?> owner = variantObj.getClass();
            try {
                Method method = owner.getMethod("getId", null);
                Object obj = method.invoke(variantObj, null);
                if (obj != null) {
                    orgValue = obj.toString();
                }
            }
            catch (SecurityException e) {
                log.warn((Object)"getOrgIDByVariant(Object variantObj)", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)"getOrgIDByVariant(Object variantObj)", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)"getOrgIDByVariant(Object variantObj)", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"getOrgIDByVariant(Object variantObj)", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.warn((Object)"getOrgIDByVariant(Object variantObj)", (Throwable)e);
            }
        } else {
            orgValue = variantObj.toString();
        }
        return orgValue;
    }

    private static Object List2Array(Object varObj) {
        List l = (List)varObj;
        int length = l.size();
        if (length == 0) {
            return new Object();
        }
        Class<?> clazz = null;
        for (int i = 0; i < length; ++i) {
            if (l.get(i) == null) continue;
            clazz = l.get(i).getClass();
        }
        if (clazz == null) {
            return new Object();
        }
        Object[] src = l.toArray();
        Object dest = Array.newInstance(clazz, length);
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    private static void getPersonByVariant(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef) throws WfException {
        block26: {
            Object variantObj;
            WfProcess procInst;
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                block27: {
                                                    String variantId = participantDef.getPerformDatafieldId();
                                                    procInst = ParticipantHelper.getWfProcess(wfExecObj);
                                                    AbstractKpdlElement container = participantDef.getContainer();
                                                    DataFieldDef dataField = null;
                                                    dataField = container != null ? ((ProcessDef)container.getContainer()).getDataFieldDef(variantId) : procInst.getDefinition().getDataFieldDef(variantId);
                                                    String partDefName = participantDef.getName();
                                                    assert (dataField != null);
                                                    variantObj = null;
                                                    variantObj = dataField.getDataType().equals(BasicType.BIZOBJ) || dataField.getDataType().equals(BasicType.APPROVERESULT) ? procInst.getProcessContext().getDataFieldValue(partDefName) : procInst.getProcessContext().getDataFieldValue(dataField.getName());
                                                    if (variantObj == null) break block26;
                                                    if (variantObj instanceof List) {
                                                        variantObj = ParticipantHelper.List2Array(variantObj);
                                                    }
                                                    if (!(variantObj instanceof ParticipantDef)) break block27;
                                                    ParticipantHelper.computeVariant(wfExecObj, persons, participantDef.getPerformDatafieldId());
                                                    break block26;
                                                }
                                                if (!(variantObj instanceof ParticipantDef[])) break block28;
                                                ParticipantDef[] participantDefArray = (ParticipantDef[])variantObj;
                                                for (int i = 0; i < participantDefArray.length; ++i) {
                                                    ParticipantHelper.computeVariant(wfExecObj, persons, participantDefArray[i].getPerformDatafieldId());
                                                }
                                                break block26;
                                            }
                                            if (!(variantObj instanceof String) && !(variantObj instanceof BOSUuid)) break block29;
                                            Person person = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByUserId(wfExecObj.getWfEngine().context(), variantObj.toString());
                                            if (person != null && person.getUserId() != null) {
                                                persons.add(person);
                                            } else {
                                                Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByEmployeeId(wfExecObj.getWfEngine().context(), variantObj.toString());
                                                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                                                    String description = "\u7f16\u7801\u4e3a[" + variantObj.toString() + "]\u7684\u7528\u6237\u548c\u804c\u5458[" + ParticipantHelper.getEmployeeName(wfExecObj.getWfEngine(), variantObj.toString()) + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728";
                                                    WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                                    Person p = new Person();
                                                    p.setEmployeeId(variantObj.toString());
                                                    persons.add(p);
                                                }
                                                for (int i = 0; i < personArray.length; ++i) {
                                                    persons.add(personArray[i]);
                                                }
                                            }
                                            break block26;
                                        }
                                        if (!(variantObj instanceof String[])) break block30;
                                        String[] userIdArray = (String[])variantObj;
                                        for (int arrayIndex = 0; arrayIndex < userIdArray.length; ++arrayIndex) {
                                            if (StringUtils.isEmpty((String)userIdArray[arrayIndex])) continue;
                                            Person person = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByUserId(wfExecObj.getWfEngine().context(), userIdArray[arrayIndex]);
                                            if (person != null && person.getUserId() != null) {
                                                persons.add(person);
                                                continue;
                                            }
                                            Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByEmployeeId(wfExecObj.getWfEngine().context(), userIdArray[arrayIndex]);
                                            if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                                                String description = "\u7f16\u7801\u4e3a[" + userIdArray[arrayIndex] + "]\u7684\u7528\u6237\u548c\u804c\u5458[" + ParticipantHelper.getEmployeeName(wfExecObj.getWfEngine(), userIdArray[arrayIndex]) + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728";
                                                WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                                Person p = new Person();
                                                p.setEmployeeId(userIdArray[arrayIndex]);
                                                persons.add(p);
                                            }
                                            for (int i = 0; i < personArray.length; ++i) {
                                                persons.add(personArray[i]);
                                            }
                                        }
                                        break block26;
                                    }
                                    if (!(variantObj instanceof BOSUuid[])) break block31;
                                    BOSUuid[] userIdArray = (BOSUuid[])variantObj;
                                    for (int arrayIndex = 0; arrayIndex < userIdArray.length; ++arrayIndex) {
                                        if (userIdArray[arrayIndex] == null) continue;
                                        String id = userIdArray[arrayIndex].toString();
                                        Person person = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByUserId(wfExecObj.getWfEngine().context(), id);
                                        if (person != null && person.getUserId() != null) {
                                            persons.add(person);
                                            continue;
                                        }
                                        Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByEmployeeId(wfExecObj.getWfEngine().context(), id);
                                        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                                            String description = "\u7f16\u7801\u4e3a[" + id + "]\u7684\u7528\u6237\u548c\u804c\u5458[" + ParticipantHelper.getEmployeeName(wfExecObj.getWfEngine(), id) + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728";
                                            WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                            Person p = new Person();
                                            p.setEmployeeId(id);
                                            persons.add(p);
                                        }
                                        for (int i = 0; i < personArray.length; ++i) {
                                            persons.add(personArray[i]);
                                        }
                                    }
                                    break block26;
                                }
                                if (!(variantObj instanceof Person)) break block32;
                                persons.add(variantObj);
                                break block26;
                            }
                            if (!(variantObj instanceof Person[])) break block33;
                            Person[] personArray = (Person[])variantObj;
                            for (int i = 0; i < personArray.length; ++i) {
                                persons.add(personArray[i]);
                            }
                            break block26;
                        }
                        if (!(variantObj instanceof PositionInfo)) break block34;
                        PositionInfo position = (PositionInfo)variantObj;
                        Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getPositionHolders(wfExecObj.getWfEngine().context(), position.getId());
                        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                            String description = "\u83b7\u53d6\u5c97\u4f4d[" + position.getName(new Locale("L2")) + "][" + position.getId() + "]\u4e0a\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
                            WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                        }
                        for (int i = 0; i < personArray.length; ++i) {
                            persons.add(personArray[i]);
                        }
                        break block26;
                    }
                    if (!(variantObj instanceof PositionInfo[])) break block35;
                    PositionInfo[] positionArray = (PositionInfo[])variantObj;
                    for (int j = 0; j < positionArray.length; ++j) {
                        Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getPositionHolders(wfExecObj.getWfEngine().context(), positionArray[j].getId());
                        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                            String description = "\u83b7\u53d6\u5c97\u4f4d[" + positionArray[j].getName(new Locale("L2")) + "][" + positionArray[j].getId() + "]\u4e0a\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
                            WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                        }
                        for (int i = 0; i < personArray.length; ++i) {
                            persons.add(personArray[i]);
                        }
                    }
                    break block26;
                }
                if (!(variantObj instanceof OrgUnitInfo)) break block36;
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)variantObj;
                Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getOrgMember(wfExecObj.getWfEngine().context(), orgUnitInfo.getId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + orgUnitInfo.getName(new Locale("L2")) + "][" + orgUnitInfo.getId() + "]\u7684\u6210\u5458\u5217\u8868\uff08\u4e0d\u5305\u6d3b\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
                    WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                break block26;
            }
            if (!(variantObj instanceof OrgUnitInfo[])) break block26;
            OrgUnitInfo[] orgUnitInfoArray = (OrgUnitInfo[])variantObj;
            for (int j = 0; j < orgUnitInfoArray.length; ++j) {
                Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getOrgMember(wfExecObj.getWfEngine().context(), orgUnitInfoArray[j].getId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + orgUnitInfoArray[j].getName(new Locale("L2")) + "][" + orgUnitInfoArray[j].getId() + "]\u7684\u6210\u5458\u5217\u8868\uff08\u4e0d\u5305\u6d3b\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
                    WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null) continue;
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
            }
        }
    }

    private static void getPersonByProcResponsibility(WfExecutionObject wfExecObj, List persons) throws WfParticipantException, WfException {
        ResponsibleCollection respons = ParticipantHelper.getWfProcess(wfExecObj).getDefinition().getProcessHeader().getResponsibles();
        if (respons != null) {
            for (int i = 0; i < respons.size(); ++i) {
                Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getPersonByEmployeeId(wfExecObj.getWfEngine().context(), respons.get(i).getID());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
                    String description = "\u804c\u5458[" + ParticipantHelper.getEmployeeName(wfExecObj.getWfEngine(), respons.get(i).getID()) + "]\u5bf9\u5e94\u7684\u7cfb\u7edf\u7528\u6237\u4e0d\u5b58\u5728";
                    WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null) continue;
                for (int j = 0; j < personArray.length; ++j) {
                    persons.add(personArray[j]);
                }
            }
        }
    }

    private static void getPersonByProcResponsibility(WfEngine wfEngine, ProcessDef procDef, List persons) throws WfParticipantException, WfException {
        ResponsibleCollection respons = procDef.getProcessHeader().getResponsibles();
        if (respons != null) {
            for (int i = 0; i < respons.size(); ++i) {
                Person[] personArray = wfEngine.getPariticipantProvider().getPersonByEmployeeId(wfEngine.context(), respons.get(i).getID());
                for (int j = 0; j < personArray.length; ++j) {
                    persons.add(personArray[j]);
                }
            }
        }
    }

    private static void getPersonByPermissionOwner(WfExecutionObject wfExecObj, List persons) throws WfException {
        if (!(wfExecObj instanceof WfActivity)) {
            throw new WfException("invalid execute object type. type:" + wfExecObj.getClass().getName());
        }
        ManpowerActivityDef manpowerDef = (ManpowerActivityDef)((WfActivity)wfExecObj).getDefinition();
        IPermissionProvider permissionProvider = wfExecObj.getWfEngine().getPermissionProvider();
        FunctionDef funcDef = null;
        ApplicationDef appDef = manpowerDef.getRelatedApplication();
        if (appDef != null) {
            funcDef = appDef.getFunction();
        }
        if (funcDef != null) {
            Person[] personArray;
            block8: {
                String packageName = funcDef.getPackageName();
                String operation = funcDef.getOperation();
                String funcName = funcDef.getName();
                personArray = new Person[]{};
                try {
                    PermissionItemCollection permItems = PermissionUtil.getPermissionItemCollection(wfExecObj.getWfEngine().context(), packageName, funcName, operation);
                    String initiatorId = ParticipantHelper.getInitialtorId(wfExecObj);
                    WfEngine engine = wfExecObj.getWfEngine();
                    if (initiatorId == null || initiatorId.length() == 0) break block8;
                    Context ctx = engine.getInitContext();
                    String orgId = engine.getPariticipantProvider().getCurrentOrgIdByUser(ctx, initiatorId, 0);
                    if (orgId != null) {
                        String[] userIds = permissionProvider.getPermissionOwners(ctx, 0, orgId, permItems);
                        personArray = PermissionUtil.usersToPersons(ctx, userIds);
                    }
                    if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                        WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
                        String description = "\u83b7\u53d6\u62e5\u6709\u5bf9\u8c61[" + packageName + "." + funcName + "]\u7684\u64cd\u4f5c[" + operation + "]\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a, \u7ec4\u7ec7\u4e3a[" + orgId + "]";
                        WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    }
                }
                catch (BOSException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonByRole(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef) throws WfParticipantException, WfException {
        String initialtorId = ParticipantHelper.getInitialtorId(wfExecObj);
        Person[] personArray = wfExecObj.getWfEngine().getPariticipantProvider().getRoleMember(wfExecObj.getWfEngine().context(), initialtorId, participantDef.getParticipantValue());
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u89d2\u8272[" + participantDef.getParticipantValue() + "]\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(wfExecObj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonByRelation(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef) throws WfException, WfParticipantException {
        String refObjId = participantDef.getReferenceHumanId();
        ReferenceHumanType refObjType = participantDef.getReferenceHumanType();
        RelationType relationType = participantDef.getRelationType();
        if (relationType == null) {
            throw new WfException("Fatal Error.relationType is null");
        }
        Person[] refPersonArray = ParticipantHelper.getRefPerson(wfExecObj, refObjId, refObjType, participantDef);
        ParticipantHelper.computeAimPerson(wfExecObj, persons, participantDef, refPersonArray);
    }

    private static String getInitialtorId(WfExecutionObject wfExecObj) throws WfException {
        String initialtorId = ParticipantHelper.getWfProcess(wfExecObj).getProcessMeta().getInitiatorId();
        return initialtorId;
    }

    private static WfProcess getWfProcess(WfExecutionObject wfExecObj) throws WfException {
        if (wfExecObj == null) {
            return null;
        }
        if (wfExecObj instanceof WfProcess) {
            return (WfProcess)wfExecObj;
        }
        if (wfExecObj instanceof WfActivity) {
            return ((WfActivity)wfExecObj).container();
        }
        throw new WfException("invalid definition type:" + wfExecObj.getClass().getName());
    }

    public static void getPersonByOrgPermissionOwner(WfEngine wfEngine, List persons, ParticipantDef participantDef, ActivityDef activityDef, String orgId) throws WfException, WfParticipantException {
        IPermissionProvider permissionProvider = wfEngine.getPermissionProvider();
        PermissionItemCollection permItems = new PermissionItemCollection();
        try {
            ExtendedAttributeCollection extendedAttributeCollection = participantDef.getExtendedAttributes();
            ExtendedAttributeDef extendedAttributeDef = extendedAttributeCollection.get("permissionItem");
            if (extendedAttributeDef != null && !StringUtils.isEmpty((String)extendedAttributeDef.getValue())) {
                String permItemName = extendedAttributeDef.getValue();
                PermissionItemInfo permissionItemInfo = new PermissionItemInfo();
                permissionItemInfo.setName(permItemName);
                permItems.add(permissionItemInfo);
            } else if (activityDef instanceof ManpowerActivityDef) {
                FunctionDef funcDef = null;
                ManpowerActivityDef manpowerDef = (ManpowerActivityDef)activityDef;
                ApplicationDef appDef = manpowerDef.getRelatedApplication();
                if (appDef != null) {
                    funcDef = appDef.getFunction();
                }
                if (funcDef != null) {
                    String packageName = funcDef.getPackageName();
                    String operation = funcDef.getOperation();
                    String funcName = funcDef.getName();
                    permItems = PermissionUtil.getPermissionItemCollection(wfEngine.context(), packageName, funcName, operation);
                }
            }
            if (permItems.size() > 0) {
                Context context = wfEngine.context();
                String[] userIds = permissionProvider.getPermissionOwners(context, 1, orgId, permItems);
                for (int i = 0; i < userIds.length; ++i) {
                    persons.add(wfEngine.getPariticipantProvider().getPersonByUserId(context, userIds[i]));
                }
            }
        }
        catch (BOSException e) {
            log.warn((Object)"getPersonByOrgPermissionOwner() occur error: ", (Throwable)e);
            throw new WfException((Throwable)e, true);
        }
    }

    public static void getPersonByOrgPermissionOwner(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef, ActivityDef activityDef) throws WfException, WfParticipantException {
        String orgId = ParticipantHelper.getOrgID(participantDef.getParticipantValue(), wfExecObj, participantDef);
        if (orgId == null || orgId.trim().length() == 0) {
            throw new WfException("Fatal Error. participant definition id is null.");
        }
        ParticipantHelper.getPersonByOrgPermissionOwner(wfExecObj.getWfEngine(), persons, participantDef, activityDef, orgId);
    }

    private static void getPersonByOrgPermissionOwner(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef) throws WfException, WfParticipantException {
        if (!(wfExecObj instanceof WfActivity)) {
            throw new WfException("invalid execute object type. type:" + wfExecObj.getClass().getName());
        }
        ParticipantHelper.getPersonByOrgPermissionOwner(wfExecObj, persons, participantDef, ((WfActivity)wfExecObj).getDefinition());
    }

    private static void getPersonByPrincipal(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef, String orgId) throws WfException {
        Person[] personArray = wfEngine.getPariticipantProvider().getOrgPrincipal(wfEngine.context(), orgId);
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u7ec4\u7ec7[" + orgId + "]\u7684\u8d1f\u8d23\u4eba\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonByPosition(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef) throws WfParticipantException, WfException {
        Person[] personArray = wfEngine.getPariticipantProvider().getPositionHolders(wfEngine.context(), participantDef.getParticipantValue());
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u5c97\u4f4d[" + participantDef.getParticipantValue() + "]\u4e0a\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonByOrgAllMember(WfExecutionObject wfExecObj, WfEngine WfEngine2, List persons, ParticipantDef participantDef, String orgID) throws WfException {
        Person[] personArray = null;
        try {
            personArray = WfEngine2.getPariticipantProvider().getOrgAllMember(WfEngine2.context(), orgID);
        }
        catch (Throwable e) {
            throw new FatalInterruptException("ParticipantProvider getOrgAllMember error!", e);
        }
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + orgID + "]\u7684\u6210\u5458\u5217\u8868\uff08\u5305\u6d3b\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(WfEngine2, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonByOrgMember(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef, String orgID) throws WfException {
        Person[] personArray = wfEngine.getPariticipantProvider().getOrgMember(wfEngine.context(), orgID);
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + orgID + "]\u7684\u6210\u5458\u5217\u8868\uff08\u4e0d\u5305\u6d3b\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonsByHuman(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef) throws WfParticipantException, WfException {
        Person[] personArray = wfEngine.getPariticipantProvider().getPersonByEmployeeId(wfEngine.context(), participantDef.getParticipantValue());
        if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u804c\u5458[" + ParticipantHelper.getEmployeeName(wfEngine, participantDef.getParticipantValue()) + "]\u5bf9\u5e94\u7684\u7cfb\u7edf\u7528\u6237\u4e0d\u5b58\u5728";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        if (personArray != null) {
            for (int i = 0; i < personArray.length; ++i) {
                persons.add(personArray[i]);
            }
        }
    }

    private static void getPersonsByUser(WfExecutionObject wfExecObj, WfEngine wfEngine, List persons, ParticipantDef participantDef) throws WfParticipantException, WfException {
        Person person = wfEngine.getPariticipantProvider().getPersonByUserId(wfEngine.context(), participantDef.getParticipantValue());
        if (person == null && wfExecObj != null) {
            WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
            String description = "\u7528\u6237[" + participantDef.getParticipantValue() + "]\u4e0d\u5b58\u5728";
            WorkflowUtils.addWfProcessInstWarn(wfEngine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        persons.add(person);
    }

    public static List participantsToPersons(WfActivity wfActivity, ParticipantCollection participants) throws WfException {
        ArrayList<Object> persons = new ArrayList<Object>();
        Iterator iterator = participants.iterator();
        IParticipantProvider participantProvider = wfActivity.getWfEngine().getPariticipantProvider();
        if (participantProvider == null || wfActivity == null) {
            return persons;
        }
        while (iterator.hasNext()) {
            Person[] personArray;
            Person[] personArray2;
            ParticipantDef participantDef = (ParticipantDef)iterator.next();
            if (participantDef.getParticipantType() == ParticipantType.USER) {
                Person person = participantProvider.getPersonByUserId(wfActivity.getWfEngine().context(), participantDef.getParticipantValue());
                persons.add(person);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.HUMAN) {
                personArray2 = participantProvider.getPersonByEmployeeId(wfActivity.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray2.length; ++i) {
                    persons.add(personArray2[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                personArray2 = participantProvider.getOrgMember(wfActivity.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray2.length; ++i) {
                    persons.add(personArray2[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                personArray2 = new Person[]{};
                try {
                    personArray2 = participantProvider.getOrgAllMember(wfActivity.getWfEngine().context(), participantDef.getParticipantValue());
                }
                catch (Throwable e) {
                    log.warn((Object)"ParticipantProvider getOrgAllMember error!", e);
                }
                for (int i = 0; i < personArray2.length; ++i) {
                    persons.add(personArray2[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.POSITION) {
                personArray2 = participantProvider.getPositionHolders(wfActivity.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray2.length; ++i) {
                    persons.add(personArray2[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                personArray2 = participantProvider.getOrgPrincipal(wfActivity.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray2.length; ++i) {
                    persons.add(personArray2[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                PermissionItemCollection permItems;
                String orgId = participantDef.getParticipantValue();
                if (orgId == null) {
                    log.error((Object)"Fatal Error.ParticipantDef is bad,can not get org id");
                    continue;
                }
                Person[] personArray3 = participantProvider.getOrgAllMember(wfActivity.getWfEngine().context(), orgId);
                ManpowerActivityDef manpowerDef = (ManpowerActivityDef)wfActivity.getDefinition();
                IPermissionProvider permissionProvider = wfActivity.getWfEngine().getPermissionProvider();
                FunctionDef funcDef = null;
                ApplicationDef appDef = manpowerDef.getRelatedApplication();
                if (appDef != null) {
                    funcDef = appDef.getFunction();
                }
                Person[] permissionPersonArray = new Person[]{};
                if (funcDef == null) continue;
                String packageName = funcDef.getPackageName();
                String operation = funcDef.getOperation();
                String funcName = funcDef.getName();
                try {
                    permItems = PermissionUtil.getPermissionItemCollection(wfActivity.getWfEngine().context(), packageName, funcName, operation);
                    if (permItems.size() > 0) {
                        String[] userIds = permissionProvider.getPermissionOwners(wfActivity.getWfEngine().context(), 1, orgId, permItems);
                        permissionPersonArray = PermissionUtil.usersToPersons(wfActivity.getWfEngine().context(), userIds);
                    }
                }
                catch (BOSException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    permItems = null;
                }
                if (permItems != null && permItems.size() > 0) {
                    for (int i = 0; i < permissionPersonArray.length; ++i) {
                        boolean flag = false;
                        for (int j = 0; j < personArray3.length; ++j) {
                            String personUserId = personArray3[j].getUserId();
                            if (personUserId == null || !personUserId.equalsIgnoreCase(permissionPersonArray[i].getUserId())) continue;
                            flag = true;
                            break;
                        }
                        if (!flag) continue;
                        persons.add(permissionPersonArray[i]);
                    }
                    continue;
                }
                for (int i = 0; i < personArray3.length; ++i) {
                    persons.add(personArray3[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.RELATION) {
                String refObjId = participantDef.getReferenceHumanId();
                ReferenceHumanType refObjType = participantDef.getReferenceHumanType();
                RelationType relationType = participantDef.getRelationType();
                if (relationType == null) {
                    log.error((Object)"Fatal Error.ParticipantDef is bad,can not get relation type");
                    continue;
                }
                Person[] refPersonArray = ParticipantHelper.getRefPerson(wfActivity, refObjId, refObjType);
                for (int i = 0; i < refPersonArray.length; ++i) {
                    String empId;
                    if (relationType.equals((Object)RelationType.SELF)) {
                        persons.add(refPersonArray[i]);
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.FELLOW)) {
                        personArray = participantProvider.getFellow(wfActivity.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                        for (int j = 0; j < personArray.length; ++j) {
                            persons.add(personArray[j]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SAMELEVEL_ALLPOSITION)) {
                        personArray = participantProvider.getAllPosFellow(wfActivity.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                        for (int j = 0; j < personArray.length; ++j) {
                            persons.add(personArray[j]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SAMELEVEL_OTHERPOSITION)) {
                        personArray = participantProvider.getOtherPosFellow(wfActivity.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                        for (int j = 0; j < personArray.length; ++j) {
                            persons.add(personArray[j]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SUBORDINATOR)) {
                        personArray = null;
                        String bostype = ParticipantHelper.getbosType(refPersonArray[i].getEmployeeId());
                        personArray = "80EF7DED".equalsIgnoreCase(bostype) ? participantProvider.getSubordinate(wfActivity.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId()) : participantProvider.getSubordinate(wfActivity.getWfEngine().context(), null, refPersonArray[i].getEmployeeId(), participantDef.getHierarchyId());
                        if (personArray == null) continue;
                        for (int j = 0; j < personArray.length; ++j) {
                            persons.add(personArray[j]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SUPERVISOR)) {
                        String positionId = participantDef.getRefPositionId();
                        if (positionId != null && positionId.trim().length() == 0) {
                            positionId = null;
                        }
                        Person[] personArray4 = null;
                        String bostype = ParticipantHelper.getbosType(refPersonArray[i].getEmployeeId());
                        personArray4 = "80EF7DED".equalsIgnoreCase(bostype) ? participantProvider.getSupervisor(wfActivity.getWfEngine().context(), refPersonArray[i].getEmployeeId(), positionId, participantDef.getHierarchyId()) : participantProvider.getSupervisor(wfActivity.getWfEngine().context(), null, refPersonArray[i].getEmployeeId(), participantDef.getHierarchyId());
                        if (personArray4 == null) continue;
                        for (int j = 0; j < personArray4.length; ++j) {
                            persons.add(personArray4[j]);
                        }
                        continue;
                    }
                    if (RelationType.PRIMARY_POSITION_SUPERVISOR.equals((Object)relationType)) {
                        empId = refPersonArray[i].getEmployeeId();
                        String positionId = ParticipantHelper.getPrimaryPositionId(wfActivity.getWfEngine(), empId);
                        Person[] personArray5 = wfActivity.getWfEngine().getPariticipantProvider().getSupervisor(wfActivity.getWfEngine().context(), null, positionId, participantDef.getHierarchyId());
                        for (int j = 0; j < personArray5.length; ++j) {
                            persons.add(personArray5[j]);
                        }
                        continue;
                    }
                    if (RelationType.PRIMARY_POSITION_INDIRECT_SUPERVISOR.equals((Object)relationType)) {
                        empId = refPersonArray[i].getEmployeeId();
                        String positionId = ParticipantHelper.getPrimaryPositionId(wfActivity.getWfEngine(), empId);
                        String parentid = "'" + positionId + "'";
                        for (int j = 0; j < 2; ++j) {
                            String sql = "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where A.FchildID in(" + parentid + ") and B.fid='" + participantDef.getHierarchyId() + "' ";
                            try {
                                IRowSet rowSet = DbUtil.executeQuery((Context)wfActivity.getWfEngine().context(), (String)sql);
                                parentid = new String();
                                while (rowSet.next()) {
                                    if (rowSet.getString("fparentid") == null) continue;
                                    parentid = parentid + "'" + rowSet.getString("fparentid") + "',";
                                }
                                if (parentid.length() == 0) {
                                    parentid = "'',";
                                }
                                if (parentid == null || parentid.length() <= 0) continue;
                                parentid = parentid.substring(0, parentid.length() - 1);
                                continue;
                            }
                            catch (BOSException e) {
                                log.error((Object)("\u67e5\u8be2\u4e3b\u8981\u804c\u4f4d\u95f4\u63a5\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                                e.printStackTrace();
                                continue;
                            }
                            catch (SQLException e) {
                                log.error((Object)("\u67e5\u8be2\u4e3b\u8981\u804c\u4f4d\u95f4\u63a5\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                                e.printStackTrace();
                            }
                        }
                        PersonToWFAdapter adapter = new PersonToWFAdapter();
                        String[] parentidStrings = (parentid = parentid.replace("'", "")).split(",");
                        if (parentidStrings == null || parentidStrings.length == 0) {
                            String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                            WorkflowUtils.addWfProcessInstWarn(wfActivity.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, null, description);
                        }
                        for (int j = 0; j < parentidStrings.length; ++j) {
                            Person[] personArray6 = adapter.getPositionHolders(wfActivity.getWfEngine().context(), parentidStrings[j]);
                            if ((personArray6 == null || personArray6.length == 0) && wfActivity != null) {
                                String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                                WorkflowUtils.addWfProcessInstWarn(wfActivity.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, null, description);
                            }
                            for (int k = 0; k < personArray6.length; ++k) {
                                persons.add(personArray6[k]);
                            }
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.FELLOWBESIDESSELF)) {
                        personArray = participantProvider.getFellow(wfActivity.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                        for (int j = 0; j < personArray.length; ++j) {
                            if (personArray[j].getUserId() == null || personArray[j].getUserId().equals(refPersonArray[i].getUserId())) continue;
                            persons.add(personArray[j]);
                        }
                        continue;
                    }
                    log.error((Object)"Fatal Error.ParticipantDef is bad,Invalid relationType");
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ROLE) {
                personArray2 = participantProvider.getRoleMember(wfActivity.getWfEngine().context(), wfActivity.container().getData().getInitiatorId(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray2.length; ++i) {
                    persons.add(personArray2[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER) {
                ManpowerActivityDef manpowerDef = (ManpowerActivityDef)wfActivity.getDefinition();
                IPermissionProvider permissionProvider = wfActivity.getWfEngine().getPermissionProvider();
                FunctionDef funcDef = null;
                ApplicationDef appDef = manpowerDef.getRelatedApplication();
                if (appDef != null) {
                    funcDef = appDef.getFunction();
                }
                if (funcDef == null) continue;
                String packageName = funcDef.getPackageName();
                String operation = funcDef.getOperation();
                String funcName = funcDef.getName();
                Person[] personArray7 = new Person[]{};
                try {
                    PermissionItemCollection permItems = PermissionUtil.getPermissionItemCollection(wfActivity.getWfEngine().context(), packageName, funcName, operation);
                    String initiatorId = wfActivity.container().getProcessMeta().getInitiatorId();
                    WfEngine engine = wfActivity.getWfEngine();
                    if (initiatorId != null && initiatorId.length() != 0) {
                        Context ctx = engine.getInitContext();
                        String orgId = engine.getPariticipantProvider().getCurrentOrgIdByUser(ctx, initiatorId, 0);
                        if (orgId != null) {
                            String[] userIds = permissionProvider.getPermissionOwners(ctx, 0, orgId, permItems);
                            personArray7 = PermissionUtil.usersToPersons(wfActivity.getWfEngine().context(), userIds);
                        }
                    }
                }
                catch (BOSException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                for (int i = 0; i < personArray7.length; ++i) {
                    persons.add(personArray7[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.VARIANT) {
                String variantId = participantDef.getPerformDatafieldId();
                ProcessDef procDef = wfActivity.container().getDefinition();
                DataFieldDef dataField = procDef.getDataFieldDef(variantId);
                if (dataField.isArray()) {
                    // empty if block
                }
                if (dataField == null) {
                    wfActivity.suspend("exec method 'ParticipantHelper.participantsToPersons', participant Type is VARIANT, datafield not found, variantId '" + variantId + "'");
                    log.error((Object)"get participant person error. because refToDataField is null.");
                    break;
                }
                Object variantObj = wfActivity.container().getProcessContext().getDataFieldValue(dataField.getName());
                if (variantObj == null) continue;
                if (variantObj instanceof ParticipantDef) {
                    ParticipantHelper.computeVariant(wfActivity, persons, participantDef.getPerformDatafieldId());
                    continue;
                }
                if (variantObj instanceof ParticipantDef[]) {
                    ParticipantDef[] participantDefArray = (ParticipantDef[])variantObj;
                    for (int i = 0; i < participantDefArray.length; ++i) {
                        ParticipantHelper.computeVariant(wfActivity, persons, participantDefArray[i].getPerformDatafieldId());
                    }
                    continue;
                }
                if (variantObj instanceof String || variantObj instanceof BOSUuid) {
                    Person person = participantProvider.getPersonByUserId(wfActivity.getWfEngine().context(), variantObj.toString());
                    if (person != null && person.getUserId() != null) {
                        persons.add(person);
                        continue;
                    }
                    personArray = participantProvider.getPersonByEmployeeId(wfActivity.getWfEngine().context(), variantObj.toString());
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                    continue;
                }
                if (variantObj instanceof String[]) {
                    String[] userIdArray = (String[])variantObj;
                    for (int arrayIndex = 0; arrayIndex < userIdArray.length; ++arrayIndex) {
                        Person person = participantProvider.getPersonByUserId(wfActivity.getWfEngine().context(), userIdArray[arrayIndex]);
                        if (person != null && person.getUserId() != null) {
                            persons.add(person);
                            continue;
                        }
                        Person[] personArray8 = participantProvider.getPersonByEmployeeId(wfActivity.getWfEngine().context(), userIdArray[arrayIndex]);
                        for (int i = 0; i < personArray8.length; ++i) {
                            persons.add(personArray8[i]);
                        }
                    }
                    continue;
                }
                if (variantObj instanceof BOSUuid[]) {
                    BOSUuid[] userIdArray = (BOSUuid[])variantObj;
                    for (int arrayIndex = 0; arrayIndex < userIdArray.length; ++arrayIndex) {
                        Person person = participantProvider.getPersonByUserId(wfActivity.getWfEngine().context(), userIdArray[arrayIndex].toString());
                        if (person != null && person.getUserId() != null) {
                            persons.add(person);
                            continue;
                        }
                        Person[] personArray9 = participantProvider.getPersonByEmployeeId(wfActivity.getWfEngine().context(), userIdArray[arrayIndex].toString());
                        for (int i = 0; i < personArray9.length; ++i) {
                            persons.add(personArray9[i]);
                        }
                    }
                    continue;
                }
                if (variantObj instanceof Person) {
                    persons.add(variantObj);
                    continue;
                }
                if (variantObj instanceof Person[]) {
                    Person[] personArray10 = (Person[])variantObj;
                    for (int i = 0; i < personArray10.length; ++i) {
                        persons.add(personArray10[i]);
                    }
                    continue;
                }
                if (variantObj instanceof PositionInfo) {
                    PositionInfo position = (PositionInfo)variantObj;
                    personArray = participantProvider.getPositionHolders(wfActivity.getWfEngine().context(), position.getId());
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                    continue;
                }
                if (variantObj instanceof PositionInfo[]) {
                    PositionInfo[] positionArray = (PositionInfo[])variantObj;
                    for (int j = 0; j < positionArray.length; ++j) {
                        Person[] personArray11 = participantProvider.getPositionHolders(wfActivity.getWfEngine().context(), positionArray[j].getId());
                        for (int i = 0; i < personArray11.length; ++i) {
                            persons.add(personArray11[i]);
                        }
                    }
                    continue;
                }
                if (variantObj instanceof OrgUnitInfo) {
                    OrgUnitInfo orgUnitInfo = (OrgUnitInfo)variantObj;
                    personArray = participantProvider.getOrgMember(wfActivity.getWfEngine().context(), orgUnitInfo.getId());
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                    continue;
                }
                if (!(variantObj instanceof OrgUnitInfo[])) continue;
                OrgUnitInfo[] orgUnitInfoArray = (OrgUnitInfo[])variantObj;
                for (int j = 0; j < orgUnitInfoArray.length; ++j) {
                    Person[] personArray12 = participantProvider.getOrgMember(wfActivity.getWfEngine().context(), orgUnitInfoArray[j].getId());
                    for (int i = 0; i < personArray12.length; ++i) {
                        persons.add(personArray12[i]);
                    }
                }
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY)) {
                ResponsibleCollection respons = wfActivity.container().getDefinition().getProcessHeader().getResponsibles();
                if (respons == null) continue;
                for (int i = 0; i < respons.size(); ++i) {
                    Person[] personArray13 = participantProvider.getPersonByEmployeeId(wfActivity.getWfEngine().context(), respons.get(i).getID());
                    for (int j = 0; j < personArray13.length; ++j) {
                        persons.add(personArray13[j]);
                    }
                }
                continue;
            }
            throw new WfException("NOT SUPPORT." + participantDef.getParticipantType().getName());
        }
        return persons;
    }

    public static List participantsToPersons(WfProcess procInst, ParticipantCollection participants) throws WfException {
        ArrayList<Person> persons = new ArrayList<Person>();
        Iterator iterator = participants.iterator();
        IParticipantProvider participantProvider = procInst.getWfEngine().getPariticipantProvider();
        if (participantProvider == null || procInst == null) {
            return persons;
        }
        while (iterator.hasNext()) {
            Person[] personArray;
            ParticipantDef participantDef = (ParticipantDef)iterator.next();
            if (participantDef.getParticipantType() == ParticipantType.USER) {
                Person person = participantProvider.getPersonByUserId(procInst.getWfEngine().context(), participantDef.getParticipantValue());
                persons.add(person);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.HUMAN) {
                personArray = participantProvider.getPersonByEmployeeId(procInst.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                personArray = participantProvider.getOrgMember(procInst.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                personArray = participantProvider.getOrgAllMember(procInst.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.POSITION) {
                personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                personArray = participantProvider.getOrgPrincipal(procInst.getWfEngine().context(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.RELATION) {
                String refObjId = participantDef.getReferenceHumanId();
                ReferenceHumanType refObjType = participantDef.getReferenceHumanType();
                RelationType relationType = participantDef.getRelationType();
                if (relationType == null) {
                    log.error((Object)"participantDef is bad,relationType is null");
                    continue;
                }
                Person[] refPersonArray = ParticipantHelper.getRefPerson(procInst, refObjId, refObjType);
                for (int i = 0; i < refPersonArray.length; ++i) {
                    int j;
                    Person[] personArray2;
                    String positionId = participantDef.getRefPositionId();
                    if (positionId != null && positionId.trim().length() == 0) {
                        positionId = null;
                    }
                    if (relationType.equals((Object)RelationType.SELF)) {
                        persons.add(refPersonArray[i]);
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.FELLOW)) {
                        personArray2 = participantProvider.getFellow(procInst.getWfEngine().context(), refPersonArray[i].getEmployeeId(), positionId, participantDef.getHierarchyId());
                        for (int j2 = 0; j2 < personArray2.length; ++j2) {
                            persons.add(personArray2[j2]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SAMELEVEL_ALLPOSITION)) {
                        personArray2 = participantProvider.getAllPosFellow(procInst.getWfEngine().context(), refPersonArray[i].getEmployeeId(), positionId, participantDef.getHierarchyId());
                        for (int j3 = 0; j3 < personArray2.length; ++j3) {
                            persons.add(personArray2[j3]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SAMELEVEL_OTHERPOSITION)) {
                        personArray2 = participantProvider.getOtherPosFellow(procInst.getWfEngine().context(), refPersonArray[i].getEmployeeId(), positionId, participantDef.getHierarchyId());
                        for (int j4 = 0; j4 < personArray2.length; ++j4) {
                            persons.add(personArray2[j4]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SUBORDINATOR)) {
                        personArray2 = null;
                        String bostype = ParticipantHelper.getbosType(refPersonArray[i].getEmployeeId());
                        personArray2 = "80EF7DED".equalsIgnoreCase(bostype) ? participantProvider.getSubordinate(procInst.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId()) : participantProvider.getSubordinate(procInst.getWfEngine().context(), null, refPersonArray[i].getEmployeeId(), participantDef.getHierarchyId());
                        if (personArray2 == null) continue;
                        for (j = 0; j < personArray2.length; ++j) {
                            persons.add(personArray2[j]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.SUPERVISOR)) {
                        personArray2 = null;
                        String bostype = ParticipantHelper.getbosType(refPersonArray[i].getEmployeeId());
                        personArray2 = "80EF7DED".equalsIgnoreCase(bostype) ? participantProvider.getSubordinate(procInst.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId()) : participantProvider.getSubordinate(procInst.getWfEngine().context(), null, refPersonArray[i].getEmployeeId(), participantDef.getHierarchyId());
                        if (personArray2 == null) continue;
                        for (j = 0; j < personArray2.length; ++j) {
                            persons.add(personArray2[j]);
                        }
                        continue;
                    }
                    if (relationType.equals((Object)RelationType.FELLOWBESIDESSELF)) {
                        personArray2 = participantProvider.getFellow(procInst.getWfEngine().context(), refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                        for (int j5 = 0; j5 < personArray2.length; ++j5) {
                            if (personArray2[j5].getUserId() == null || personArray2[j5].getUserId().equals(refPersonArray[i].getUserId())) continue;
                            persons.add(personArray2[j5]);
                        }
                        continue;
                    }
                    log.error((Object)"pariticpantDef is bad , Invalid RalationType");
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ROLE) {
                personArray = participantProvider.getRoleMember(procInst.getWfEngine().context(), procInst.getData().getInitiatorId(), participantDef.getParticipantValue());
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER) {
                log.error((Object)"TODO:Not Support Yet");
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.VARIANT) {
                ParticipantHelper.computeVariant(procInst, persons, participantDef.getPerformDatafieldId());
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY)) {
                ResponsibleCollection respons = procInst.getDefinition().getProcessHeader().getResponsibles();
                if (respons == null) continue;
                for (int i = 0; i < respons.size(); ++i) {
                    Person[] personArray3 = participantProvider.getPersonByEmployeeId(procInst.getWfEngine().context(), respons.get(i).getID());
                    for (int j = 0; j < personArray3.length; ++j) {
                        persons.add(personArray3[j]);
                    }
                }
                continue;
            }
            throw new WfException("NOT SUPPORT.");
        }
        return persons;
    }

    private static void computeVariant(WfExecutionObject obj, List persons, String dataFieldId) throws WfException, WfParticipantException {
        WfProcess procInst;
        IParticipantProvider participantProvider = obj.getWfEngine().getPariticipantProvider();
        if (obj instanceof WfActivity) {
            procInst = ((WfActivity)obj).container();
        } else if (obj instanceof WfProcess) {
            procInst = (WfProcess)obj;
        } else {
            log.error((Object)"TODO:not support yet");
            return;
        }
        DataFieldDef dataField = procInst.getDefinition().getDataFieldDef(dataFieldId);
        String dataFieldName = dataField.getName();
        Object variantObj = procInst.getProcessContext().getDataFieldValue(dataFieldName);
        if (variantObj != null) {
            ParticipantHelper.innerComputeVar(obj, persons, participantProvider, procInst, variantObj);
        }
    }

    private static void computeVariant(WfExecutionObject obj, List persons, String dataFieldId, ParticipantDef pdef) throws WfException, WfParticipantException {
        WfProcess procInst;
        IParticipantProvider participantProvider = obj.getWfEngine().getPariticipantProvider();
        if (obj instanceof WfActivity) {
            procInst = ((WfActivity)obj).container();
        } else if (obj instanceof WfProcess) {
            procInst = (WfProcess)obj;
        } else {
            log.error((Object)"TODO:not support yet");
            return;
        }
        DataFieldDef dataField = procInst.getDefinition().getDataFieldDef(dataFieldId);
        String dataFieldName = null;
        dataFieldName = !StringUtils.isEmpty((String)pdef.getName()) ? pdef.getName() : dataField.getName();
        Object variantObj = procInst.getProcessContext().getDataFieldValue(dataFieldName);
        if (variantObj != null) {
            ParticipantHelper.innerComputeVar(obj, persons, participantProvider, procInst, variantObj);
        }
    }

    private static void innerComputeVar(WfExecutionObject obj, List persons, IParticipantProvider participantProvider, WfProcess procInst, Object variantObj) throws WfParticipantException, WfException {
        block49: {
            block55: {
                block56: {
                    block47: {
                        block54: {
                            ParticipantDef participantDefVariant;
                            block53: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block48: {
                                                if (!(variantObj instanceof ParticipantDef)) break block47;
                                                participantDefVariant = (ParticipantDef)variantObj;
                                                if (!participantDefVariant.getParticipantType().equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER)) break block48;
                                                Person[] personArray = participantProvider.getOrgAllMember(procInst.getWfEngine().context(), participantDefVariant.getParticipantValue());
                                                if ((personArray == null || personArray.length == 0) && obj != null) {
                                                    String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + participantDefVariant.getParticipantValue() + "]\u7684\u6210\u5458\u5217\u8868\uff08\u5305\u6d3b\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
                                                    WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                                }
                                                for (int i = 0; i < personArray.length; ++i) {
                                                    persons.add(personArray[i]);
                                                }
                                                break block49;
                                            }
                                            if (!participantDefVariant.getParticipantType().equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_MEMBER)) break block50;
                                            Person[] personArray = participantProvider.getOrgMember(procInst.getWfEngine().context(), participantDefVariant.getParticipantValue());
                                            if ((personArray == null || personArray.length == 0) && obj != null) {
                                                String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + participantDefVariant.getParticipantValue() + "]\u7684\u6210\u5458\u5217\u8868\uff08\u4e0d\u5305\u6d3b\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
                                                WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                            }
                                            for (int i = 0; i < personArray.length; ++i) {
                                                persons.add(personArray[i]);
                                            }
                                            break block49;
                                        }
                                        if (!participantDefVariant.getParticipantType().equals((Object)ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL)) break block51;
                                        Person[] personArray = participantProvider.getOrgPrincipal(procInst.getWfEngine().context(), participantDefVariant.getParticipantValue());
                                        if ((personArray == null || personArray.length == 0) && obj != null) {
                                            String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + participantDefVariant.getParticipantValue() + "]\u7684\u8d1f\u8d23\u4eba\u8fd4\u56de\u4e3a\u7a7a";
                                            WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                        }
                                        for (int i = 0; i < personArray.length; ++i) {
                                            persons.add(personArray[i]);
                                        }
                                        break block49;
                                    }
                                    if (!participantDefVariant.getParticipantType().equals((Object)ParticipantType.HUMAN)) break block52;
                                    Person[] personArray = participantProvider.getPersonByEmployeeId(procInst.getWfEngine().context(), participantDefVariant.getParticipantValue());
                                    if ((personArray == null || personArray.length == 0) && obj != null) {
                                        String description = "\u804c\u5458[" + ParticipantHelper.getEmployeeName(obj.getWfEngine(), participantDefVariant.getParticipantValue()) + "]\u5bf9\u5e94\u7684\u7cfb\u7edf\u7528\u6237\u4e0d\u5b58\u5728";
                                        WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                    }
                                    for (int i = 0; i < personArray.length; ++i) {
                                        persons.add(personArray[i]);
                                    }
                                    break block49;
                                }
                                if (!participantDefVariant.getParticipantType().equals((Object)ParticipantType.POSITION)) break block53;
                                Person[] personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), participantDefVariant.getParticipantValue());
                                if ((personArray == null || personArray.length == 0) && obj != null) {
                                    String description = "\u83b7\u53d6\u5c97\u4f4d[" + participantDefVariant.getParticipantValue() + "]\u4e0a\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
                                    WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                                }
                                for (int i = 0; i < personArray.length; ++i) {
                                    persons.add(personArray[i]);
                                }
                                break block49;
                            }
                            if (!participantDefVariant.getParticipantType().equals((Object)ParticipantType.USER)) break block54;
                            Person person = participantProvider.getPersonByUserId(procInst.getWfEngine().context(), participantDefVariant.getParticipantValue());
                            if (person == null && obj != null) {
                                String description = "\u7528\u6237[" + participantDefVariant.getParticipantValue() + "]\u4e0d\u5b58\u5728";
                                WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                            }
                            persons.add(person);
                            break block49;
                        }
                        throw new WfException("TODO");
                    }
                    if (!(variantObj instanceof String) && !(variantObj instanceof BOSUuid)) break block55;
                    Person person = participantProvider.getPersonByUserId(procInst.getWfEngine().context(), variantObj.toString());
                    if (person == null || person.getUserId() == null) break block56;
                    persons.add(person);
                    break block49;
                }
                Person[] personArray = participantProvider.getPersonByEmployeeId(procInst.getWfEngine().context(), variantObj.toString());
                if (!(personArray != null && personArray.length != 0 || obj == null || (personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), variantObj.toString())) != null && personArray.length != 0 || obj == null)) {
                    String description = "\u7f16\u7801\u4e3a[" + variantObj.toString() + "]\u7684\u7528\u6237\u548c\u804c\u5458[" + ParticipantHelper.getEmployeeName(obj.getWfEngine(), variantObj.toString()) + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728";
                    WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    Person p = new Person();
                    p.setEmployeeId(variantObj.toString());
                    persons.add(p);
                }
                if (personArray == null) break block49;
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
                break block49;
            }
            if (variantObj instanceof String[]) {
                String[] userIdArray = (String[])variantObj;
                for (int arrayIndex = 0; arrayIndex < userIdArray.length; ++arrayIndex) {
                    Person person = participantProvider.getPersonByUserId(procInst.getWfEngine().context(), userIdArray[arrayIndex]);
                    if (person != null && person.getUserId() != null) {
                        persons.add(person);
                        continue;
                    }
                    Person[] personArray = participantProvider.getPersonByEmployeeId(procInst.getWfEngine().context(), userIdArray[arrayIndex]);
                    if (!(personArray != null && personArray.length != 0 || obj == null || (personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), userIdArray[arrayIndex])) != null && personArray.length != 0 || obj == null)) {
                        String description = "\u7f16\u7801\u4e3a[" + userIdArray[arrayIndex] + "]\u7684\u7528\u6237\u548c\u804c\u5458[" + ParticipantHelper.getEmployeeName(obj.getWfEngine(), userIdArray[arrayIndex]) + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728";
                        WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                        Person p = new Person();
                        p.setEmployeeId(userIdArray[arrayIndex]);
                        persons.add(p);
                    }
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                }
            } else if (variantObj instanceof BOSUuid[]) {
                BOSUuid[] userIdArray = (BOSUuid[])variantObj;
                for (int arrayIndex = 0; arrayIndex < userIdArray.length; ++arrayIndex) {
                    Person person = participantProvider.getPersonByUserId(procInst.getWfEngine().context(), userIdArray[arrayIndex].toString());
                    if (person != null && person.getUserId() != null) {
                        persons.add(person);
                        continue;
                    }
                    Person[] personArray = participantProvider.getPersonByEmployeeId(procInst.getWfEngine().context(), userIdArray[arrayIndex].toString());
                    if (!(personArray != null && personArray.length != 0 || obj == null || (personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), userIdArray[arrayIndex].toString())) != null && personArray.length != 0 || obj == null)) {
                        String description = "\u7f16\u7801\u4e3a[" + userIdArray[arrayIndex] + "]\u7684\u7528\u6237\u548c\u804c\u5458[" + ParticipantHelper.getEmployeeName(obj.getWfEngine(), userIdArray[arrayIndex].toString()) + "]\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728";
                        WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                        Person p = new Person();
                        p.setEmployeeId(userIdArray[arrayIndex].toString());
                        persons.add(p);
                    }
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                }
            } else if (variantObj instanceof Person) {
                persons.add(variantObj);
            } else if (variantObj instanceof Person[]) {
                Person[] personArray = (Person[])variantObj;
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
            } else if (variantObj instanceof PositionInfo) {
                PositionInfo position = (PositionInfo)variantObj;
                Person[] personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), position.getId());
                if ((personArray == null || personArray.length == 0) && obj != null) {
                    String description = "\u83b7\u53d6\u5c97\u4f4d[" + position.getName(new Locale("L2")) + "][" + position.getId() + "]\u4e0a\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
                    WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
            } else if (variantObj instanceof PositionInfo[]) {
                PositionInfo[] positionArray = (PositionInfo[])variantObj;
                for (int j = 0; j < positionArray.length; ++j) {
                    Person[] personArray = participantProvider.getPositionHolders(procInst.getWfEngine().context(), positionArray[j].getId());
                    if ((personArray == null || personArray.length == 0) && obj != null) {
                        String description = "\u83b7\u53d6\u5c97\u4f4d[" + positionArray[j].getName(new Locale("L2")) + "][" + positionArray[j].getId() + "]\u4e0a\u7684\u4eba\u5458\u5217\u8868\u4e3a\u7a7a";
                        WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    }
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                }
            } else if (variantObj instanceof OrgUnitInfo) {
                OrgUnitInfo orgUnitInfo = (OrgUnitInfo)variantObj;
                Person[] personArray = participantProvider.getOrgMember(procInst.getWfEngine().context(), orgUnitInfo.getId());
                if ((personArray == null || personArray.length == 0) && obj != null) {
                    String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + orgUnitInfo.getName(new Locale("L2")) + "][" + orgUnitInfo.getId() + "]\u7684\u6210\u5458\u5217\u8868\uff08\u4e0d\u5305\u62ec\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
                    WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                for (int i = 0; i < personArray.length; ++i) {
                    persons.add(personArray[i]);
                }
            } else if (variantObj instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] orgUnitInfoArray = (OrgUnitInfo[])variantObj;
                for (int j = 0; j < orgUnitInfoArray.length; ++j) {
                    Person[] personArray = participantProvider.getOrgMember(procInst.getWfEngine().context(), orgUnitInfoArray[j].getId());
                    if ((personArray == null || personArray.length == 0) && obj != null) {
                        String description = "\u83b7\u53d6\u7ec4\u7ec7\u5355\u5143[" + orgUnitInfoArray[j].getName(new Locale("L2")) + "][" + orgUnitInfoArray[j].getId() + "]\u7684\u6210\u5458\u5217\u8868\uff08\u4e0d\u5305\u62ec\u4e0b\u7ea7\u7ec4\u7ec7\u5355\u5143\uff09\u4e3a\u7a7a";
                        WorkflowUtils.addWfProcessInstWarn(obj.getWfEngine(), LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    }
                    for (int i = 0; i < personArray.length; ++i) {
                        persons.add(personArray[i]);
                    }
                }
            }
        }
    }

    private static Person[] getRefPerson(WfExecutionObject obj, String refObjId, ReferenceHumanType refObjType) throws WfException {
        WfProcess procInst;
        if (!(refObjId != null && refObjId.length() != 0 || refObjType.equals((Object)ReferenceHumanType.PROCESS_INITIATOR))) {
            return new Person[0];
        }
        IParticipantProvider participantProvider = obj.getWfEngine().getPariticipantProvider();
        if (obj instanceof WfActivity) {
            procInst = ((WfActivity)obj).container();
        } else if (obj instanceof WfProcess) {
            procInst = (WfProcess)obj;
        } else {
            log.error((Object)"TODO:not support yet");
            return new Person[0];
        }
        boolean isFirstActivity = false;
        if (refObjType.equals((Object)ReferenceHumanType.ACTIVITY_PERFORMER)) {
            WfActivity appActInst;
            WfAssignment[] compleleAssigns;
            WfActivity refActInst = procInst.getActInstByDefId(refObjId);
            if (refActInst == null) {
                log.error((Object)"can not found actInst");
                return new Person[0];
            }
            String parentActInstid = refActInst.getMeta().getParentActInstId();
            if (!StringUtils.isEmpty((String)parentActInstid) && (compleleAssigns = (appActInst = procInst.getActInstByInstId(parentActInstid)).getAssignmentsInState(WfAssignmentState.COMPLETED)).length > 0) {
                refActInst = appActInst;
            }
            if (!(isFirstActivity = ParticipantHelper.isFirstActivity(refActInst.getDefinition()))) {
                WfAssignment[] refActInstAssignList = refActInst.getAssignmentsInState(WfAssignmentState.COMPLETED);
                if (refActInstAssignList.length == 0) {
                    String performerInfoList = refActInst.getMeta().getPerformerInfoList();
                    if (performerInfoList != null && performerInfoList.length() != 0) {
                        String[] strArray = performerInfoList.split(",");
                        String userId = strArray[0];
                        Person person = participantProvider.getPersonByUserId(obj.getWfEngine().context(), userId);
                        return new Person[]{person};
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"refActInstAssignList == 0");
                    }
                }
                ArrayList<Person> refPersonList = new ArrayList<Person>();
                for (int i = 0; i < refActInstAssignList.length; ++i) {
                    WfAssignment assign = refActInstAssignList[i];
                    Person person = ParticipantHelper.getPerformer(assign, participantProvider, obj.getWfEngine().context());
                    if (person == null) continue;
                    refPersonList.add(person);
                }
                Person[] personArray = new Person[refPersonList.size()];
                refPersonList.toArray(personArray);
                return personArray;
            }
        } else {
            if (refObjType.equals((Object)ReferenceHumanType.EMPLOYEE)) {
                Person[] rtn = participantProvider.getPersonByEmployeeId(obj.getWfEngine().context(), refObjId);
                if (rtn == null || rtn.length == 0) {
                    Person p = new Person();
                    p.setEmployeeId(refObjId);
                    rtn = new Person[]{p};
                }
                return rtn;
            }
            if (refObjType.equals((Object)ReferenceHumanType.POSITION)) {
                return participantProvider.getPositionHolders(obj.getWfEngine().context(), refObjId);
            }
        }
        if (isFirstActivity || refObjType.equals((Object)ReferenceHumanType.PROCESS_INITIATOR)) {
            String initiatorId = procInst.getProcessMeta().getInitiatorId();
            if (initiatorId == null || initiatorId.trim().length() == 0) {
                log.warn((Object)("initiatorId is null." + procInst.getId()));
                return new Person[0];
            }
            ArrayList<Person> persons = new ArrayList<Person>();
            Person person = participantProvider.getPersonByUserId(obj.getWfEngine().context(), initiatorId);
            if (person == null) {
                Person[] persons2 = null;
                try {
                    persons2 = participantProvider.getPersonsByUserId(obj.getWfEngine().context(), initiatorId);
                }
                catch (Throwable ex) {
                    log.warn((Object)ex.getMessage(), ex);
                }
                if (persons2 != null && persons2.length != 0 && persons2[0] != null) {
                    int len = persons2.length;
                    for (int i = 0; i < len; ++i) {
                        if (persons.contains(persons2[i])) continue;
                        persons.add(persons2[i]);
                    }
                } else {
                    log.error((Object)("can not get participant info from participant provider. id is :'" + initiatorId + "'"));
                }
            } else {
                persons.add(person);
            }
            Person[] rtnValue = new Person[persons.size()];
            persons.toArray(rtnValue);
            return rtnValue;
        }
        if (refObjType.equals((Object)ReferenceHumanType.ORGNIZATION)) {
            throw new WfException("TODO");
        }
        if (refObjType.equals((Object)ReferenceHumanType.PROCESS_VARIABLE)) {
            ArrayList list = new ArrayList();
            ParticipantHelper.computeVariant(obj, list, refObjId);
            Person[] rtnValue = new Person[list.size()];
            list.toArray(rtnValue);
            return rtnValue;
        }
        throw new WfException("TODO");
    }

    private static Person[] getRefPerson(WfExecutionObject obj, String refObjId, ReferenceHumanType refObjType, ParticipantDef pdef) throws WfException {
        WfProcess procInst;
        if (!(refObjId != null && refObjId.length() != 0 || refObjType.equals((Object)ReferenceHumanType.PROCESS_INITIATOR))) {
            return new Person[0];
        }
        IParticipantProvider participantProvider = obj.getWfEngine().getPariticipantProvider();
        if (obj instanceof WfActivity) {
            procInst = ((WfActivity)obj).container();
        } else if (obj instanceof WfProcess) {
            procInst = (WfProcess)obj;
        } else {
            log.error((Object)"TODO:not support yet");
            return new Person[0];
        }
        boolean isFirstActivity = false;
        if (refObjType.equals((Object)ReferenceHumanType.ACTIVITY_PERFORMER)) {
            WfActivity appActInst;
            WfAssignment[] compleleAssigns;
            WfActivity refActInst = procInst.getActInstByDefId(refObjId);
            if (refActInst == null) {
                log.error((Object)"can not found actInst");
                return new Person[0];
            }
            String parentActInstid = refActInst.getMeta().getParentActInstId();
            if (!StringUtils.isEmpty((String)parentActInstid) && (compleleAssigns = (appActInst = procInst.getActInstByInstId(parentActInstid)).getAssignmentsInState(WfAssignmentState.COMPLETED)).length > 0) {
                refActInst = appActInst;
            }
            if (!(isFirstActivity = ParticipantHelper.isFirstActivity(refActInst.getDefinition()))) {
                Person person;
                WfAssignment[] refActInstAssignList = refActInst.getAssignmentsInState(WfAssignmentState.COMPLETED);
                if (refActInstAssignList.length == 0) {
                    Set assignids = refActInst.getassignid();
                    IWfCacheManager cacheMgr = obj.getWfEngine().getCacheManager();
                    for (String assignid : assignids) {
                        Object o = ThreadCache.get(assignid);
                        if (o != null) {
                            ThreadCache.put(assignid, null);
                        }
                        cacheMgr.assignmentExpired(assignid);
                    }
                    refActInstAssignList = refActInst.getAssignmentsInState(WfAssignmentState.COMPLETED);
                }
                if (refActInstAssignList.length == 0) {
                    String performerInfoList = refActInst.getMeta().getPerformerInfoList();
                    if (performerInfoList != null && performerInfoList.length() != 0) {
                        String[] strArray = performerInfoList.split(",");
                        String userId = strArray[0];
                        person = participantProvider.getPersonByUserId(obj.getWfEngine().context(), userId);
                        return new Person[]{person};
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"refActInstAssignList == 0");
                    }
                }
                ArrayList<Person> refPersonList = new ArrayList<Person>();
                for (int i = 0; i < refActInstAssignList.length; ++i) {
                    WfAssignment assign = refActInstAssignList[i];
                    person = ParticipantHelper.getPerformer(assign, participantProvider, obj.getWfEngine().context());
                    if (person == null) continue;
                    refPersonList.add(person);
                }
                Person[] personArray = new Person[refPersonList.size()];
                refPersonList.toArray(personArray);
                return personArray;
            }
        } else {
            if (refObjType.equals((Object)ReferenceHumanType.EMPLOYEE)) {
                Person[] rtn = participantProvider.getPersonByEmployeeId(obj.getWfEngine().context(), refObjId);
                if (rtn == null || rtn.length == 0) {
                    Person p = new Person();
                    p.setEmployeeId(refObjId);
                    rtn = new Person[]{p};
                }
                return rtn;
            }
            if (refObjType.equals((Object)ReferenceHumanType.POSITION)) {
                return participantProvider.getPositionHolders(obj.getWfEngine().context(), refObjId);
            }
        }
        if (isFirstActivity || refObjType.equals((Object)ReferenceHumanType.PROCESS_INITIATOR)) {
            String initiatorId = procInst.getProcessMeta().getInitiatorId();
            if (initiatorId == null || initiatorId.trim().length() == 0) {
                log.warn((Object)("initiatorId is null." + procInst.getId()));
                return new Person[0];
            }
            ArrayList<Person> persons = new ArrayList<Person>();
            Person person = participantProvider.getPersonByUserId(obj.getWfEngine().context(), initiatorId);
            if (person == null) {
                Person[] persons2 = null;
                try {
                    persons2 = participantProvider.getPersonsByUserId(obj.getWfEngine().context(), initiatorId);
                }
                catch (Throwable ex) {
                    log.warn((Object)ex.getMessage(), ex);
                }
                if (persons2 != null && persons2.length != 0 && persons2[0] != null) {
                    int len = persons2.length;
                    for (int i = 0; i < len; ++i) {
                        if (persons.contains(persons2[i])) continue;
                        persons.add(persons2[i]);
                    }
                } else {
                    log.error((Object)("can not get participant info from participant provider. id is :'" + initiatorId + "'"));
                }
            } else {
                persons.add(person);
            }
            Person[] rtnValue = new Person[persons.size()];
            persons.toArray(rtnValue);
            return rtnValue;
        }
        if (refObjType.equals((Object)ReferenceHumanType.ORGNIZATION)) {
            throw new WfException("TODO");
        }
        if (refObjType.equals((Object)ReferenceHumanType.PROCESS_VARIABLE)) {
            ArrayList list = new ArrayList();
            ParticipantHelper.computeVariant(obj, list, refObjId, pdef);
            Person[] rtnValue = new Person[list.size()];
            list.toArray(rtnValue);
            return rtnValue;
        }
        throw new WfException("TODO");
    }

    private static boolean isFirstActivity(ActivityDef definition) throws WfException {
        if (definition instanceof ApproveActivityDef) {
            return false;
        }
        if (definition == null || definition.getPreviousActivities() == null || definition.getPreviousActivities().size() == 0) {
            return false;
        }
        ActivityCollection ac = definition.getPreviousActivities();
        if (ac != null && ac.size() > 0) {
            for (int i = 0; i < ac.size(); ++i) {
                ActivityDef adef = ac.get(i);
                if (!(adef instanceof StartActivityDef)) continue;
                return true;
            }
        }
        return false;
    }

    private static Person getPerformer(WfAssignment assign, IParticipantProvider participantProvider, Context ctx) throws WfParticipantException {
        String responsiblePersonId = assign.getMeta().getResponsibleEmpId();
        Person person = null;
        if (responsiblePersonId == null) {
            String assignUserId = assign.getMeta().getUserId().toString();
            person = participantProvider.getPersonByUserId(ctx, assignUserId);
        } else {
            Person[] persons = participantProvider.getPersonByEmployeeId(ctx, responsiblePersonId);
            if (persons != null && persons.length > 0) {
                person = persons[0];
            }
        }
        return person;
    }

    private static Person[] getRefPerson(WfExecutionObject obj, String refObjId, ReferenceHumanType refObjType, String currentUserId) throws WfException {
        WfProcess procInst;
        if (currentUserId == null || currentUserId.equals("")) {
            return ParticipantHelper.getRefPerson(obj, refObjId, refObjType);
        }
        if (!(refObjId != null && refObjId.length() != 0 || refObjType.equals((Object)ReferenceHumanType.PROCESS_INITIATOR))) {
            return new Person[0];
        }
        IParticipantProvider participantProvider = obj.getWfEngine().getPariticipantProvider();
        if (obj instanceof WfActivity) {
            procInst = ((WfActivity)obj).container();
        } else if (obj instanceof WfProcess) {
            procInst = (WfProcess)obj;
        } else {
            log.error((Object)"TODO:not support yet");
            return new Person[0];
        }
        if (refObjType.equals((Object)ReferenceHumanType.ACTIVITY_PERFORMER)) {
            WfActivity refActInst = procInst.getActInstByDefId(refObjId);
            if (refActInst == null) {
                log.error((Object)"can not found actInst");
                return new Person[0];
            }
            WfAssignment[] refActInstAssignList = refActInst.getAssignmentsInState(WfAssignmentState.COMPLETED);
            if (refActInstAssignList.length == 0) {
                Person person = participantProvider.getPersonByUserId(obj.getWfEngine().context(), currentUserId);
                return new Person[]{person};
            }
            ArrayList<Person> refPersonList = new ArrayList<Person>();
            for (int i = 0; i < refActInstAssignList.length; ++i) {
                WfAssignment assign = refActInstAssignList[i];
                Person person = ParticipantHelper.getPerformer(assign, participantProvider, obj.getWfEngine().context());
                refPersonList.add(person);
            }
            Person[] personArray = new Person[refPersonList.size()];
            refPersonList.toArray(personArray);
            return personArray;
        }
        return ParticipantHelper.getRefPerson(obj, refObjId, refObjType);
    }

    public static List getPersonsByParticipants(WfExecutionObject wfExecObj, ParticipantCollection participants, String currentUserId) throws WfException {
        LowTimer lowTimer = new LowTimer();
        ArrayList<Person> persons = new ArrayList<Person>();
        Iterator iterator = participants.iterator();
        if (wfExecObj == null) {
            return new ArrayList();
        }
        WfEngine wfEngine = wfExecObj.getWfEngine();
        while (iterator.hasNext()) {
            List<Person> ps;
            String billId;
            String orgPropertyName;
            ParticipantDef participantDef = (ParticipantDef)iterator.next();
            String orgId = ParticipantHelper.getOrgID(participantDef.getParticipantValue(), wfExecObj, participantDef);
            if (participantDef.getParticipantType() == ParticipantType.USER) {
                ParticipantHelper.getPersonsByUser(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.HUMAN) {
                ParticipantHelper.getPersonsByHuman(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_MEMBER) {
                ParticipantHelper.getPersonByOrgMember(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_ALLMEMBER) {
                ParticipantHelper.getPersonByOrgAllMember(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.POSITION) {
                ParticipantHelper.getPersonByPosition(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PRINCIPAL) {
                ParticipantHelper.getPersonByPrincipal(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ORGANIZATIONAL_UNIT_PERMISSION_OWNER) {
                ParticipantHelper.getPersonByOrgPermissionOwner(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.RELATION) {
                ParticipantDef pdef = ParticipantHelper.getParticipantDef4Position(wfExecObj, participantDef);
                if (ReferenceHumanType.POSITION.equals((Object)pdef.getReferenceHumanType())) {
                    ParticipantHelper.computePositionAimPerson(wfEngine, persons, pdef);
                    continue;
                }
                ParticipantHelper.getPersonByRelation(wfExecObj, persons, participantDef, currentUserId);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.ROLE) {
                ParticipantHelper.getPersonByRole(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.PERMISSION_OWNER) {
                ParticipantHelper.getPersonByPermissionOwner(wfExecObj, persons);
                continue;
            }
            if (participantDef.getParticipantType() == ParticipantType.VARIANT) {
                ParticipantHelper.getPersonByVariant(wfExecObj, persons, participantDef);
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.PROCESS_RESPONSIBILITY)) {
                ParticipantHelper.getPersonByProcResponsibility(wfExecObj, persons);
                continue;
            }
            if (participantDef.getParticipantType().equals((Object)ParticipantType.ALL)) {
                ParticipantHelper.getPersonByALL(wfExecObj, persons, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_JOB.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByOrgJob(wfExecObj, wfEngine, persons, participantDef, orgId);
                continue;
            }
            if (ParticipantType.GROUP.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.getPersonByGroup(wfExecObj, wfEngine, persons, participantDef);
                continue;
            }
            if (ParticipantType.ORGANIZATIONAL_UNIT_SCOPE.equals((Object)participantDef.getParticipantType())) {
                wfEngine.getPariticipantProvider().getOrgAllMember(wfEngine.context(), orgId);
                continue;
            }
            if (ParticipantType.WFROLE.equals((Object)participantDef.getParticipantType())) {
                String roleId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                billId = ParticipantHelper.getBillId(wfExecObj, wfEngine);
                ps = WfRoleInvoke.getInstance().getRolePersons(wfEngine.context(), roleId, billId, orgPropertyName);
                if (ps == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFROLE_GROUP.equals((Object)participantDef.getParticipantType())) {
                String roleGroupId = participantDef.getParticipantValue();
                orgPropertyName = participantDef.getWFROrgAttribute();
                billId = ParticipantHelper.getBillId(wfExecObj, wfEngine);
                ps = WfRoleInvoke.getInstance().getRoleGroupPersons(wfEngine.context(), roleGroupId, billId, orgPropertyName);
                if (ps == null || ps.size() <= 0) continue;
                persons.addAll(ps);
                continue;
            }
            if (ParticipantType.WFFunction.equals((Object)participantDef.getParticipantType())) {
                ParticipantHelper.invokeFunction(wfExecObj, persons, wfEngine, participantDef);
                continue;
            }
            throw new WfException("NOT SUPPORT." + participantDef.getParticipantType().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("inner getPersonsByParticipants cacu cost " + lowTimer.msValue() + "ms,  participants.size " + participants.size()));
        }
        return ParticipantHelper.distinctPersons(persons);
    }

    private static void getPersonByRelation(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef, String currentUserId) throws WfException, WfParticipantException {
        if (currentUserId == null || currentUserId.equals("")) {
            ParticipantHelper.getPersonByRelation(wfExecObj, persons, participantDef);
            return;
        }
        String refObjId = participantDef.getReferenceHumanId();
        ReferenceHumanType refObjType = participantDef.getReferenceHumanType();
        RelationType relationType = participantDef.getRelationType();
        if (relationType == null) {
            throw new WfException("Fatal Error.relationType is null");
        }
        Person[] refPersonArray = ParticipantHelper.getRefPerson(wfExecObj, refObjId, refObjType, currentUserId);
        ParticipantHelper.computeAimPerson(wfExecObj, persons, participantDef, refPersonArray);
    }

    private static void computeAimPerson(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef, Person[] refPersonArray) throws WfException {
        WfEngine engine = wfExecObj.getWfEngine();
        ParticipantHelper.computeAimPerson(wfExecObj, engine, persons, participantDef, refPersonArray);
    }

    private static void computePositionAimPerson(WfEngine engine, List persons, ParticipantDef participantDef) throws WfException {
        Context ctx = engine.context();
        RelationType relationType = participantDef.getRelationType();
        if (relationType.equals((Object)RelationType.SUBORDINATOR)) {
            Person[] personArray = engine.getPariticipantProvider().getSubordinate(ctx, null, participantDef.getReferenceHumanId(), participantDef.getHierarchyId());
            for (int j = 0; j < personArray.length; ++j) {
                persons.add(personArray[j]);
            }
        } else if (relationType.equals((Object)RelationType.SUPERVISOR)) {
            Person[] personArray = engine.getPariticipantProvider().getSupervisor(ctx, null, participantDef.getReferenceHumanId(), participantDef.getHierarchyId());
            for (int j = 0; j < personArray.length; ++j) {
                persons.add(personArray[j]);
            }
        } else if (relationType.equals((Object)RelationType.INDIRECTSUPERVISOR)) {
            String positionId = "'" + participantDef.getReferenceHumanId() + "'";
            String[] parentidStrings = ParticipantHelper.getParentPositionId(ctx, positionId, participantDef.getHierarchyId());
            if (parentidStrings == null || parentidStrings.length == 0) {
                String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a,RefPositionId: " + participantDef.getReferenceHumanId() + ", HierarchyId: " + participantDef.getHierarchyId();
                log.error((Object)description);
                return;
            }
            for (int j = 0; j < parentidStrings.length; ++j) {
                Person[] personArray = engine.getPariticipantProvider().getPositionHolders(ctx, parentidStrings[j]);
                if (personArray == null || personArray.length <= 0) continue;
                for (int k = 0; k < personArray.length; ++k) {
                    persons.add(personArray[k]);
                }
            }
        } else if (relationType.equals((Object)RelationType.SELF)) {
            participantDef.setParticipantValue(participantDef.getReferenceHumanId());
            ParticipantHelper.getPersonByPosition(null, engine, persons, participantDef);
        } else {
            throw new WfException("Invalid relationType");
        }
    }

    private static void computeAimPerson(WfExecutionObject wfExecObj, WfEngine engine, List persons, ParticipantDef participantDef, Person[] refPersonArray) throws WfException {
        Context ctx = engine.context();
        WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
        if ((refPersonArray == null || refPersonArray.length == 0) && wfExecObj != null) {
            String description = "\u6839\u636e\u5173\u7cfb\u83b7\u53d6\u4eba\u5458, \u53c2\u7167\u4eba\u4e3a\u7a7a";
            WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
        }
        RelationType relationType = participantDef.getRelationType();
        if (refPersonArray == null) {
            return;
        }
        for (int i = 0; i < refPersonArray.length; ++i) {
            String parentid;
            String empId;
            Person[] personArray;
            if (relationType.equals((Object)RelationType.SELF)) {
                persons.add(refPersonArray[i]);
                continue;
            }
            if (relationType.equals((Object)RelationType.FELLOW)) {
                personArray = engine.getPariticipantProvider().getFellow(ctx, refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u540c\u7ea7_\u540c\u804c\u4f4d_\u975e\u672c\u4eba\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null || personArray.length <= 0) continue;
                for (int j = 0; j < personArray.length; ++j) {
                    persons.add(personArray[j]);
                }
                continue;
            }
            if (relationType.equals((Object)RelationType.SAMELEVEL_ALLPOSITION)) {
                personArray = engine.getPariticipantProvider().getAllPosFellow(ctx, refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u540c\u7ea7_\u6240\u6709\u804c\u4f4d_\u975e\u672c\u4eba\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null || personArray.length <= 0) continue;
                for (int j = 0; j < personArray.length; ++j) {
                    persons.add(personArray[j]);
                }
                continue;
            }
            if (relationType.equals((Object)RelationType.SAMELEVEL_OTHERPOSITION)) {
                personArray = engine.getPariticipantProvider().getOtherPosFellow(ctx, refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u540c\u7ea7_\u5176\u5b83\u804c\u4f4d_\u975e\u672c\u4eba\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null || personArray.length <= 0) continue;
                for (int j = 0; j < personArray.length; ++j) {
                    persons.add(personArray[j]);
                }
                continue;
            }
            if (relationType.equals((Object)RelationType.SAME_JOB_GRADE)) {
                Person[] retPersons = engine.getPariticipantProvider().getSameJobGradePersonFellow(ctx, refPersonArray[i].getEmployeeId());
                if ((retPersons == null || retPersons.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u540c\u4e00\u804c\u7b49\u7684\u4eba\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (retPersons == null) continue;
                for (int j = 0; j < retPersons.length; ++j) {
                    persons.add(retPersons[j]);
                }
                continue;
            }
            if (relationType.equals((Object)RelationType.SUBORDINATOR)) {
                personArray = null;
                String bostype = ParticipantHelper.getbosType(refPersonArray[i].getEmployeeId());
                personArray = "80EF7DED".equalsIgnoreCase(bostype) ? engine.getPariticipantProvider().getSubordinate(ctx, refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId()) : engine.getPariticipantProvider().getSubordinate(ctx, null, refPersonArray[i].getEmployeeId(), participantDef.getHierarchyId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u4e0b\u7ea7\u4eba\u5458\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null) continue;
                for (int j = 0; j < personArray.length; ++j) {
                    persons.add(personArray[j]);
                }
                continue;
            }
            if (relationType.equals((Object)RelationType.SUPERVISOR)) {
                String positionId = participantDef.getRefPositionId();
                if (positionId != null && positionId.trim().length() == 0) {
                    positionId = null;
                }
                Person[] personArray2 = null;
                String bostype = ParticipantHelper.getbosType(refPersonArray[i].getEmployeeId());
                personArray2 = "80EF7DED".equalsIgnoreCase(bostype) ? engine.getPariticipantProvider().getSupervisor(ctx, refPersonArray[i].getEmployeeId(), positionId, participantDef.getHierarchyId()) : engine.getPariticipantProvider().getSupervisor(ctx, null, refPersonArray[i].getEmployeeId(), participantDef.getHierarchyId());
                if ((personArray2 == null || personArray2.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u4eba\u5458\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray2 == null) continue;
                for (int j = 0; j < personArray2.length; ++j) {
                    persons.add(personArray2[j]);
                }
                continue;
            }
            if (RelationType.PRIMARY_POSITION_SUPERVISOR.equals((Object)relationType)) {
                empId = refPersonArray[i].getEmployeeId();
                String positionId = ParticipantHelper.getPrimaryPositionId(engine, empId);
                Person[] personArray3 = engine.getPariticipantProvider().getSupervisor(engine.context(), null, positionId, participantDef.getHierarchyId());
                if ((personArray3 == null || personArray3.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u4e3b\u8981\u804c\u4f4d\u76f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray3 == null || personArray3.length <= 0) continue;
                for (int j = 0; j < personArray3.length; ++j) {
                    persons.add(personArray3[j]);
                }
                continue;
            }
            if (RelationType.PRIMARY_POSITION_INDIRECT_SUPERVISOR.equals((Object)relationType)) {
                empId = refPersonArray[i].getEmployeeId();
                String positionId = ParticipantHelper.getPrimaryPositionId(engine, empId);
                parentid = "'" + positionId + "'";
                for (int j = 0; j < 2; ++j) {
                    String sql = "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where A.FchildID in(" + parentid + ") and B.fid='" + participantDef.getHierarchyId() + "' ";
                    try {
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                        parentid = new String();
                        while (rowSet.next()) {
                            if (rowSet.getString("fparentid") == null) continue;
                            parentid = parentid + "'" + rowSet.getString("fparentid") + "',";
                        }
                        if (parentid.length() == 0) {
                            parentid = "'',";
                        }
                        if (parentid == null || parentid.length() <= 0) continue;
                        parentid = parentid.substring(0, parentid.length() - 1);
                        continue;
                    }
                    catch (BOSException e) {
                        log.error((Object)("\u67e5\u8be2\u4e3b\u8981\u804c\u4f4d\u95f4\u63a5\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                        e.printStackTrace();
                        continue;
                    }
                    catch (SQLException e) {
                        log.error((Object)("\u67e5\u8be2\u4e3b\u8981\u804c\u4f4d\u95f4\u63a5\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                PersonToWFAdapter adapter = new PersonToWFAdapter();
                String[] parentidStrings = (parentid = parentid.replace("'", "")).split(",");
                if (parentidStrings == null || parentidStrings.length == 0) {
                    String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                for (int j = 0; j < parentidStrings.length; ++j) {
                    Person[] personArray4 = adapter.getPositionHolders(ctx, parentidStrings[j]);
                    if ((personArray4 == null || personArray4.length == 0) && wfExecObj != null) {
                        String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                        WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    }
                    for (int k = 0; k < personArray4.length; ++k) {
                        persons.add(personArray4[k]);
                    }
                }
                continue;
            }
            if (RelationType.INDIRECTSUPERVISOR.equals((Object)relationType)) {
                String[] parentidStrings;
                empId = refPersonArray[i].getEmployeeId();
                String positionId = ParticipantHelper.getPositionId(engine, empId);
                if (positionId == null || positionId.trim().length() == 0) {
                    positionId = null;
                }
                if ((parentidStrings = ParticipantHelper.getParentPositionId(ctx, positionId, participantDef.getHierarchyId())) == null || parentidStrings.length == 0) {
                    String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                for (int j = 0; j < parentidStrings.length; ++j) {
                    Person[] personArray5 = engine.getPariticipantProvider().getPositionHolders(ctx, parentidStrings[j]);
                    if ((personArray5 == null || personArray5.length == 0) && wfExecObj != null) {
                        String description = "\u83b7\u53d6\u95f4\u63a5\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                        WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    }
                    if (personArray5 == null || personArray5.length <= 0) continue;
                    for (int k = 0; k < personArray5.length; ++k) {
                        persons.add(personArray5[k]);
                    }
                }
                continue;
            }
            if (RelationType.INDIRECTALLSUPERVISOR.equals((Object)relationType)) {
                empId = refPersonArray[i].getEmployeeId();
                String positionId = ParticipantHelper.getPositionId(engine, empId);
                if (positionId == null || positionId.trim().length() == 0) {
                    positionId = null;
                }
                parentid = positionId;
                String sql = null;
                sql = parentid == null || parentid.length() == 0 ? "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where  B.fid='" + participantDef.getHierarchyId() + "' " : "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where A.FchildID in(" + parentid + ") and B.fid='" + participantDef.getHierarchyId() + "' ";
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    parentid = new String();
                    while (rowSet.next()) {
                        if (rowSet.getString("fparentid") == null) continue;
                        parentid = parentid + "'" + rowSet.getString("fparentid") + "',";
                    }
                    if (parentid.length() == 0) {
                        parentid = "'',";
                    }
                    if (parentid != null && parentid.length() > 0) {
                        parentid = parentid.substring(0, parentid.length() - 1);
                    }
                }
                catch (BOSException e) {
                    log.error((Object)("\u67e5\u8be2\u95f4\u63a5\u6240\u6709\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    log.error((Object)("\u67e5\u8be2\u95f4\u63a5\u6240\u6709\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                    e.printStackTrace();
                }
                String lastParentId = new String();
                while (parentid.replace("'", "").length() > 0) {
                    sql = "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where A.FchildID in(" + parentid + ") and B.fid='" + participantDef.getHierarchyId() + "' ";
                    try {
                        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                        parentid = new String();
                        while (rowSet2.next()) {
                            if (rowSet2.getString("fparentid") == null || lastParentId.indexOf(rowSet2.getString("fparentid")) >= 0) continue;
                            parentid = parentid + "'" + rowSet2.getString("fparentid") + "',";
                        }
                        if (parentid.length() == 0) {
                            parentid = "'',";
                        }
                        lastParentId = lastParentId + parentid;
                        if (parentid == null || parentid.length() <= 0) continue;
                        parentid = parentid.substring(0, parentid.length() - 1);
                    }
                    catch (BOSException e) {
                        log.error((Object)("\u67e5\u8be2\u95f4\u63a5\u6240\u6709\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                        e.printStackTrace();
                    }
                    catch (SQLException e) {
                        log.error((Object)("\u67e5\u8be2\u95f4\u63a5\u6240\u6709\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                if (lastParentId == null || lastParentId.length() <= 0) continue;
                lastParentId = lastParentId.substring(0, lastParentId.length() - 1);
                PersonToWFAdapter adapter = new PersonToWFAdapter();
                parentid = lastParentId.replace("'", "");
                String[] parentidStrings = parentid.split(",");
                if (parentidStrings == null || parentidStrings.length == 0) {
                    String description = "\u83b7\u53d6\u95f4\u63a5\u6240\u6709\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                for (int j = 0; j < parentidStrings.length; ++j) {
                    Person[] personArray6 = adapter.getPositionHolders(ctx, parentidStrings[j]);
                    if ((personArray6 == null || personArray6.length == 0) && wfExecObj != null) {
                        String description = "\u83b7\u53d6\u95f4\u63a5\u6240\u6709\u4e0a\u7ea7\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + positionId + ", HierarchyId: " + participantDef.getHierarchyId();
                        WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                    }
                    if (personArray6 == null || personArray6.length <= 0) continue;
                    for (int k = 0; k < personArray6.length; ++k) {
                        persons.add(personArray6[k]);
                    }
                }
                continue;
            }
            if (relationType.equals((Object)RelationType.FELLOWBESIDESSELF)) {
                personArray = engine.getPariticipantProvider().getFellow(ctx, refPersonArray[i].getEmployeeId(), participantDef.getRefPositionId(), participantDef.getHierarchyId());
                if ((personArray == null || personArray.length == 0) && wfExecObj != null) {
                    String description = "\u83b7\u53d6\u540c\u4e8b\u975e\u672c\u4eba\u8fd4\u56de\u4e3a\u7a7a, EmployeeId:" + refPersonArray[i].getEmployeeId() + ", RefPositionId: " + participantDef.getRefPositionId() + ", HierarchyId: " + participantDef.getHierarchyId();
                    WorkflowUtils.addWfProcessInstWarn(engine, LogTypeEnum.WARN, ProcessInstEventEnum.COMMON, procInst.getId(), description);
                }
                if (personArray == null) continue;
                for (int j = 0; j < personArray.length; ++j) {
                    if (personArray[j].getUserId() == null || personArray[j].getUserId().equals(refPersonArray[i].getUserId())) continue;
                    persons.add(personArray[j]);
                }
                continue;
            }
            throw new WfException("Invalid relationType");
        }
    }

    private static String[] getParentPositionId(Context ctx, String positionId, String hierarchyId) {
        String parentid = positionId;
        String sql = null;
        for (int j = 0; j < 2; ++j) {
            sql = parentid == null || parentid.length() == 0 ? "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where  B.fid='" + hierarchyId + "' " : "select distinct A.fparentid from t_Org_Positionhierarchy A inner join t_org_hierarchy B on A.FHierarchyID=B.FID   where A.FchildID in(" + parentid + ") and B.fid='" + hierarchyId + "' ";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                parentid = new String();
                while (rowSet.next()) {
                    if (rowSet.getString("fparentid") == null) continue;
                    parentid = parentid + "'" + rowSet.getString("fparentid") + "',";
                }
                if (parentid.length() == 0) {
                    parentid = "'',";
                }
                if (parentid == null || parentid.length() <= 0) continue;
                parentid = parentid.substring(0, parentid.length() - 1);
                continue;
            }
            catch (BOSException e) {
                log.error((Object)("\u67e5\u8be2\u95f4\u63a5\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                e.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                log.error((Object)("\u67e5\u8be2\u95f4\u63a5\u4e0a\u7ea7\u5931\u8d25" + e.getMessage()));
                e.printStackTrace();
            }
        }
        parentid = parentid.replace("'", "");
        String[] parentidStrings = parentid.split(",");
        return parentidStrings;
    }

    private static String getPrimaryPositionId(WfEngine wfEngine, String empId) throws WfException {
        String string;
        ResultSet rs;
        Statement smt;
        Connection cn;
        block7: {
            block6: {
                cn = null;
                smt = null;
                rs = null;
                String bostype = ParticipantHelper.getbosType(empId);
                if ("80EF7DED".equalsIgnoreCase(bostype)) break block6;
                String string2 = empId;
                SQLUtils.cleanup(rs, smt, (Connection)cn);
                return string2;
            }
            cn = EJBFactory.getConnection((Context)wfEngine.context());
            String sql = "select fpositionid from T_ORG_PositionMember where fpersonid='" + empId + "' and fisprimary=1";
            smt = cn.createStatement();
            rs = ParticipantHelper.executeQuery(smt, sql);
            if (!rs.next()) break block7;
            String string3 = rs.getString(1);
            SQLUtils.cleanup((ResultSet)rs, (Statement)smt, (Connection)cn);
            return string3;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                throw new WfException("ParticipantHelper.getPrimaryPositionId(" + empId + ") failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, smt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)smt, (Connection)cn);
        return string;
    }

    private static String getPositionId(WfEngine wfEngine, String empId) throws WfException {
        String positionid;
        ResultSet rs;
        Statement smt;
        Connection cn;
        block8: {
            String bostype;
            cn = null;
            smt = null;
            rs = null;
            positionid = new String();
            if (empId == null || "80EF7DED".equalsIgnoreCase(bostype = ParticipantHelper.getbosType(empId))) break block8;
            String string = "'" + empId + "'";
            SQLUtils.cleanup(rs, (Statement)smt, (Connection)cn);
            return string;
        }
        try {
            cn = EJBFactory.getConnection((Context)wfEngine.context());
            String sql = "select fpositionid from T_ORG_PositionMember where fpersonid='" + empId + "' ";
            smt = cn.createStatement();
            rs = ParticipantHelper.executeQuery(smt, sql);
            while (rs.next()) {
                if (rs.getString("fpositionid") == null) continue;
                positionid = positionid + "'" + rs.getString("fpositionid") + "',";
            }
            if (positionid == null || positionid.length() == 0) {
                positionid = "'',";
            }
            if (positionid != null && positionid.length() != 0) {
                positionid = positionid.substring(0, positionid.length() - 1);
            }
        }
        catch (SQLException e) {
            try {
                throw new WfException("ParticipantHelper.getPrimaryPositionId(" + empId + ") failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, smt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)smt, (Connection)cn);
        return positionid;
    }

    public static List getPersonsByProcessExecutor(WfProcess procInst, String processExecutorType) throws WfException {
        ArrayList rtn = new ArrayList();
        if (procInst == null) {
            return rtn;
        }
        if (processExecutorType.equalsIgnoreCase("executed") || processExecutorType.equalsIgnoreCase("allocated")) {
            WfEngine wfEngine = procInst.getWfEngine();
            procInst = ParticipantHelper.getRootWfProcess(procInst, wfEngine);
            ParticipantHelper.getPersonByProcessExecutorDfs(procInst, wfEngine, rtn, processExecutorType);
            return ParticipantHelper.distinctPersons(rtn);
        }
        return rtn;
    }

    private static void getPersonByProcessExecutor(WfExecutionObject wfExecObj, List persons, ParticipantDef participantDef) throws WfException {
        WfEngine wfEngine = wfExecObj.getWfEngine();
        WfProcess procInst = ParticipantHelper.getWfProcess(wfExecObj);
        procInst = ParticipantHelper.getRootWfProcess(procInst, wfEngine);
        ParticipantHelper.getPersonByProcessExecutorDfs(procInst, wfEngine, persons, participantDef.getProcessExecutorType());
    }

    private static void getPersonByProcessExecutorDfs(WfProcess procInst, WfEngine wfEngine, List persons, String processExecutorType) throws WfException {
        int len;
        if (StringUtils.isEmpty((String)processExecutorType)) {
            return;
        }
        IParticipantProvider participantProvider = wfEngine.getPariticipantProvider();
        String initiatorId = procInst.getProcessMeta().getInitiatorId();
        if (initiatorId == null || initiatorId.trim().length() == 0) {
            log.warn((Object)("initiatorId is null." + procInst.getId()));
        } else {
            Person person = participantProvider.getPersonByUserId(wfEngine.context(), initiatorId);
            if (person == null) {
                Person[] persons2 = null;
                try {
                    persons2 = participantProvider.getPersonsByUserId(wfEngine.context(), initiatorId);
                }
                catch (Throwable ex) {
                    log.warn((Object)ex.getMessage(), ex);
                }
                if (persons2 != null && persons2.length != 0 && persons2[0] != null) {
                    len = persons2.length;
                    for (int i = 0; i < len; ++i) {
                        if (persons.contains(persons2[i])) continue;
                        persons.add(persons2[i]);
                    }
                } else {
                    log.error((Object)("can not get participant info from participant provider. id is :'" + initiatorId + "'"));
                }
            } else {
                persons.add(person);
            }
        }
        AssignmentInfo[] assignmentInfos = wfEngine.getAssignmentAllByProcInstId(procInst.getId());
        if (processExecutorType.equalsIgnoreCase("executed")) {
            int len2 = assignmentInfos.length;
            for (int i = 0; i < len2; ++i) {
                Person person;
                if (!assignmentInfos[i].getState().equals((Object)WfAssignmentState.COMPLETED) || persons.contains(person = participantProvider.getPersonByUserId(wfEngine.context(), assignmentInfos[i].getUserId()))) continue;
                persons.add(person);
            }
        } else if (processExecutorType.equalsIgnoreCase("allocated")) {
            int len3 = assignmentInfos.length;
            for (int i = 0; i < len3; ++i) {
                Person person = participantProvider.getPersonByUserId(wfEngine.context(), assignmentInfos[i].getUserId());
                if (persons.contains(person)) continue;
                persons.add(person);
            }
        }
        List activitiesList = procInst.getActivitiesInState(WfState.COMPLETED);
        len = activitiesList.size();
        for (int i = 0; i < len; ++i) {
            WfActivity wfActivity = (WfActivity)activitiesList.get(i);
            if (!(wfActivity.getDefinition() instanceof SubflowActivityDef) || wfActivity.getSubProcessInstance() == null) continue;
            ParticipantHelper.getPersonByProcessExecutorDfs(wfActivity.getSubProcessInstance(), wfEngine, persons, processExecutorType);
        }
    }

    private static WfProcess getRootWfProcess(WfProcess procInst, WfEngine wfEngine) {
        WfProcess rtn = procInst;
        while (!StringUtils.isEmpty((String)rtn.getProcessMeta().getParentProcInstId())) {
            String id = rtn.getProcessMeta().getParentProcInstId();
            WfProcess temp = null;
            try {
                rtn = temp = wfEngine.getProcessInst(id);
            }
            catch (WfException e) {
                log.error((Object)("can not get parent process. id is :'" + id + "'"));
                temp = null;
                break;
            }
        }
        return rtn;
    }

    public static List getPersonsByCCParticipants(WfProcess wfProcess, ActivityDef actDef) throws WfException {
        ParticipantCase pCase;
        int i;
        ParticipantCollection includeCol = new ParticipantCollection();
        ParticipantCollection excludeCol = new ParticipantCollection();
        CCParticipantBlock block = new CCParticipantBlock(actDef);
        ArrayList<ParticipantCase> executeCaseList = new ArrayList<ParticipantCase>();
        List caseList = block.getChildren();
        ArrayList<Person> rtnList = new ArrayList<Person>();
        int n = caseList.size();
        for (i = 0; i < n; ++i) {
            String script;
            pCase = (ParticipantCase)caseList.get(i);
            if (pCase.isDefault() || !ScriptUtil.evalCondition(script = pCase.getCondition().getScriptDefWrapper().getScriptDef().getScriptContent(), wfProcess.getProcessContext(), wfProcess.getDefinition())) continue;
            executeCaseList.add(pCase);
        }
        if (executeCaseList.size() == 0) {
            executeCaseList.add(block.getDefaultCase());
        }
        n = executeCaseList.size();
        for (i = 0; i < n; ++i) {
            pCase = (ParticipantCase)executeCaseList.get(i);
            List unitList = pCase.getChildren();
            int m = unitList.size();
            for (int j = 0; j < m; ++j) {
                ParticipantUnit pUnit = (ParticipantUnit)unitList.get(j);
                ParticipantDef def = pUnit.getIncludeParticpant().getParticpantDefWrapper().getParticipantDef();
                includeCol.clear();
                excludeCol.clear();
                includeCol.addObject(def.getID(), (Object)def);
                if (pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef() != null) {
                    excludeCol.addObject(def.getID(), (Object)pUnit.getExcludeParticpant().getParticpantDefWrapper().getParticipantDef());
                }
                List includeList = ParticipantHelper.getPersonsByParticipants(wfProcess, includeCol);
                List excludeList = ParticipantHelper.getPersonsByParticipants(wfProcess, excludeCol);
                for (int index = 0; index < includeList.size(); ++index) {
                    Person inPerson = (Person)includeList.get(index);
                    if (excludeList.size() != 0 && excludeList.contains(inPerson)) continue;
                    rtnList.add(inPerson);
                }
            }
        }
        return ParticipantHelper.distinctPersons(rtnList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEmployeeName(WfEngine wfEngine, String empId) throws WfException {
        String string;
        Connection cn = null;
        Statement smt = null;
        ResultSet rs = null;
        try {
            cn = EJBFactory.getConnection((Context)wfEngine.context());
            String sql = "select fname_l2 from t_bd_person where fid='" + empId + "'";
            smt = cn.createStatement();
            rs = ParticipantHelper.executeQuery(smt, sql);
            if (rs.next()) {
                String string2 = rs.getString(1) + "][" + empId;
                SQLUtils.cleanup((ResultSet)rs, (Statement)smt, (Connection)cn);
                return string2;
            }
            string = empId;
            SQLUtils.cleanup((ResultSet)rs, (Statement)smt, (Connection)cn);
        }
        catch (SQLException e) {
            String string3 = empId;
            return string3;
        }
        finally {
            SQLUtils.cleanup(rs, smt, (Connection)cn);
        }
        return string;
    }

    private static ResultSet executeQuery(Statement smt, String sql) throws SQLException {
        return smt.executeQuery(sql);
    }

    private static String getbosType(String personId) {
        String bosType = null;
        try {
            BOSUuid boid = BOSUuid.read((String)personId);
            bosType = boid.getType().toString();
        }
        catch (UuidException uuidException) {
            // empty catch block
        }
        return bosType;
    }

    private static void computeProcessVariablePerson(WfEngine wfEngine, List persons, ParticipantDef participantDef, ProcessDef procDef, IObjectValue bizBillObject) {
        try {
            Map propMap = ParticipantHelper.getProcessPropMap(procDef, wfEngine, bizBillObject);
            if (propMap == null || propMap.size() < 1) {
                return;
            }
            Context cxt = wfEngine.context();
            Object dataValue = WfBizObjUtils.getDataFieldValueInMap(propMap, participantDef.getName(), cxt);
            if (dataValue == null) {
                return;
            }
            Person person = wfEngine.getPariticipantProvider().getPersonByUserId(cxt, dataValue.toString());
            if (person == null || StringUtils.isEmpty((String)person.getUserId())) {
                return;
            }
            persons.add(person);
        }
        catch (Exception e) {
            log.error((Object)" computeProcessVariablePerson - \u63d0\u4ea4\u65f6\u83b7\u53d6\u53d8\u91cf\u53c2\u4e0e\u4eba\u5f02\u5e38, err : ", (Throwable)e);
        }
    }
}

