/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.axis.RequestKeyGenerater;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.CorrelationPropertyCollection;
import com.kingdee.bos.workflow.define.CorrelationPropertyDef;
import com.kingdee.bos.workflow.define.CorrelationSetCollection;
import com.kingdee.bos.workflow.define.CorrelationSetDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TaskServiceReceiveActivityDef;
import com.kingdee.bos.workflow.define.WSOperationDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.CorrMatchDataFieldInfo;
import com.kingdee.bos.workflow.metas.CorrelationMatchCollection;
import com.kingdee.bos.workflow.metas.CorrelationMatchInfo;
import com.kingdee.bos.workflow.metas.CorrelationMatchTypeEnum;
import com.kingdee.bos.workflow.store.CorrMatchDataFieldStorer;
import com.kingdee.bos.workflow.store.CorrelationMatchStorer;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class WfCorrelationMatchMgr {
    private static final Logger logger = Logger.getLogger(WfCorrelationMatchMgr.class);
    private final WfEngine engine;

    public WfCorrelationMatchMgr(WfEngine engine) {
        this.engine = engine;
    }

    public void cleanProcessCorrelationMatches(ProcessDef processDef) throws WfException {
        CorrelationMatchStorer correlationMatchStorer = this.engine.getStoreManager().getCorrelationMatchStorer();
        correlationMatchStorer.deleteProcessCorrelationesMatchByProcDefId(processDef.getID());
    }

    public void cleanCorrelationMatches(WfProcess wfProcess) throws WfException {
        CorrelationMatchStorer correlationMatchStorer = this.engine.getStoreManager().getCorrelationMatchStorer();
        correlationMatchStorer.deleteCorrelationMatchesByProcInstId(wfProcess.getId());
    }

    public void cleanCorrelationMatches(WfActivity activity) throws WfException {
        ActivityDef activityDef = activity.getDefinition();
        if (activityDef instanceof TaskServiceReceiveActivityDef) {
            CorrelationMatchStorer correlationMatchStorer = this.engine.getStoreManager().getCorrelationMatchStorer();
            correlationMatchStorer.deleteCorrelationMatchesByActInstId(activity.getId());
        }
    }

    public void createProcessCorrelationMatches(ProcessDef processDef) throws WfException {
        this.cleanProcessCorrelationMatches(processDef);
        ActivityCollection activities = processDef.getStartupActivities();
        CorrelationMatchCollection correlationMatchCollection = new CorrelationMatchCollection();
        int size = activities.size();
        for (int i = 0; i < size; ++i) {
            TaskServiceReceiveActivityDef receiveActivityDef;
            CorrelationMatchInfo correlationMatchInfo;
            ActivityDef activityDef = activities.get(i);
            if (!(activityDef instanceof TaskServiceReceiveActivityDef) || (correlationMatchInfo = this.createProcessServiceCorrelationMatchInfo(receiveActivityDef = (TaskServiceReceiveActivityDef)activityDef)) == null) continue;
            correlationMatchCollection.add(correlationMatchInfo);
        }
        CorrelationMatchStorer correlationMatchStorer = this.engine.getStoreManager().getCorrelationMatchStorer();
        correlationMatchStorer.addCorrelationMatches(correlationMatchCollection);
    }

    public void createActivityCorrelationMatches(WfActivity wfActivity) throws WfException {
        ActivityDef activityDef = wfActivity.getDefinition();
        if (activityDef instanceof TaskServiceReceiveActivityDef) {
            this.createTaskServiceReceiveCorrelationMatch(wfActivity);
            this.syncCorrMatchDataFields(wfActivity.container());
        }
    }

    private void createTaskServiceReceiveCorrelationMatch(WfActivity wfActivity) throws WfException {
        CorrelationMatchStorer correlationMatchStorer = this.engine.getStoreManager().getCorrelationMatchStorer();
        if (!correlationMatchStorer.exist(wfActivity.getId())) {
            TaskServiceReceiveActivityDef receiveActivityDef = (TaskServiceReceiveActivityDef)wfActivity.getDefinition();
            ProcessDef processDef = receiveActivityDef.getProcessDef();
            ApplicationDef applicationDef = receiveActivityDef.getRelatedApplication();
            WSOperationDef operationDef = applicationDef.getWSOperationDef();
            String requestDesc = RequestKeyGenerater.generateWSRequestDesc(operationDef);
            String requestKey = RequestKeyGenerater.generateWSRequestKey(requestDesc);
            CorrelationMatchInfo correlationMatchInfo = new CorrelationMatchInfo();
            correlationMatchInfo.setId(BOSUuid.create((BOSObjectType)correlationMatchInfo.getBOSType()));
            correlationMatchInfo.setProcInstId(BOSUuid.read((String)wfActivity.getProcInstId()));
            correlationMatchInfo.setProcDefHash(processDef.getHashValue());
            correlationMatchInfo.setProcDefId(BOSUuid.read((String)processDef.getID()));
            correlationMatchInfo.setActDefId(BOSUuid.read((String)receiveActivityDef.getID()));
            correlationMatchInfo.setActInstId(BOSUuid.read((String)wfActivity.getId()));
            correlationMatchInfo.setType(CorrelationMatchTypeEnum.ACTIVITY);
            correlationMatchInfo.setRequestDesc(requestDesc);
            correlationMatchInfo.setRequestKey(requestKey);
            correlationMatchStorer.addCorrelationMatch(correlationMatchInfo);
        }
    }

    public void syncCorrMatchDataFields(WfProcess wfProcess) throws WfException {
        ProcessDef processDef = wfProcess.getDefinition();
        CorrelationSetCollection correlationSetCollection = processDef.getCorrelationSets();
        ProcessContext processContext = wfProcess.getProcessContext();
        CorrMatchDataFieldStorer corrMatchDataFieldStorer = this.engine.getStoreManager().getCorrMatchDataFieldStorer();
        int size = correlationSetCollection.size();
        for (int i = 0; i < size; ++i) {
            CorrelationSetDef correlationSetDef = correlationSetCollection.getCorrelationSetDef(i);
            CorrelationPropertyCollection correlationPropertyCollection = correlationSetDef.getCorrelationProperties();
            int size1 = correlationPropertyCollection.size();
            for (int j = 0; j < size1; ++j) {
                CorrMatchDataFieldInfo corrMatchDataFieldInfo;
                CorrelationPropertyDef correlationPropertyDef = correlationPropertyCollection.get(i);
                String dataFieldName = correlationPropertyDef.getName();
                Object objDataFieldValue = processContext.getDataFieldValue(dataFieldName);
                String dataFieldValue = null;
                if (objDataFieldValue != null) {
                    dataFieldValue = objDataFieldValue.toString();
                }
                if ((corrMatchDataFieldInfo = corrMatchDataFieldStorer.getCorrMatchDataFieldInfo(wfProcess.getId(), dataFieldName)) == null) {
                    corrMatchDataFieldInfo = new CorrMatchDataFieldInfo();
                    corrMatchDataFieldInfo.setId(BOSUuid.create((BOSObjectType)WfBOSObjectTypeUtil.CORRMATCHDATAFIELD));
                    corrMatchDataFieldInfo.setProcInstId(BOSUuid.read((String)wfProcess.getId()));
                    corrMatchDataFieldInfo.setDataFieldName(dataFieldName);
                    corrMatchDataFieldInfo.setDataFieldVaue(dataFieldValue);
                    corrMatchDataFieldStorer.addCorrMatchDataFieldInfo(corrMatchDataFieldInfo);
                    continue;
                }
                if (StringUtils.equals((String)dataFieldValue, (String)corrMatchDataFieldInfo.getDataFieldVaue())) continue;
                corrMatchDataFieldInfo.setDataFieldVaue(dataFieldValue);
                corrMatchDataFieldStorer.updateCorrMatchDataFieldInfo(corrMatchDataFieldInfo);
            }
        }
    }

    private CorrelationMatchInfo createProcessServiceCorrelationMatchInfo(TaskServiceReceiveActivityDef receiveActivityDef) throws WfException {
        ProcessDef processDef = receiveActivityDef.getProcessDef();
        ApplicationDef applicationDef = receiveActivityDef.getRelatedApplication();
        WSOperationDef operationDef = applicationDef.getWSOperationDef();
        String requestDesc = RequestKeyGenerater.generateWSRequestDesc(operationDef);
        String requestKey = RequestKeyGenerater.generateWSRequestKey(requestDesc);
        CorrelationMatchInfo correlationMatchInfo = new CorrelationMatchInfo();
        correlationMatchInfo.setId(BOSUuid.create((BOSObjectType)correlationMatchInfo.getBOSType()));
        correlationMatchInfo.setProcDefHash(processDef.getHashValue());
        correlationMatchInfo.setProcDefId(BOSUuid.read((String)processDef.getID()));
        correlationMatchInfo.setActDefId(BOSUuid.read((String)receiveActivityDef.getID()));
        correlationMatchInfo.setType(CorrelationMatchTypeEnum.PROCESS);
        correlationMatchInfo.setRequestKey(requestKey);
        correlationMatchInfo.setRequestDesc(requestDesc);
        return correlationMatchInfo;
    }
}

