/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.util.LowTimer;
import org.apache.log4j.Logger;

public class ProcessMgrCacheLoader
implements com.kingdee.bos.cache.CacheLoader,
CacheLoader {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.ProcessMgrCacheLoader");
    private WfEngine engine;

    public ProcessMgrCacheLoader(WfEngine engine) {
        this.engine = engine;
    }

    public Object load(Object argument) throws CacheException {
        try {
            LowTimer lowTimer = new LowTimer();
            StringBuffer buffer = new StringBuffer();
            String originalArg = (String)argument;
            String[] argArray = new String[2];
            for (int i = 0; i < originalArg.length(); ++i) {
                char c = originalArg.charAt(i);
                if (c == ',') {
                    argArray[0] = buffer.toString();
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(c);
            }
            argArray[1] = buffer.toString();
            WfProcessMgr rtnObj = this.loadProcessMgr(argArray[0], Integer.parseInt(argArray[1]));
            if (rtnObj == null) {
                throw new WfException("rtnObj is null. can not load " + argument + " from DB. at " + this.engine.context().getAIS());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ProcessMgrCacheLoader load " + originalArg + "] cost: " + lowTimer.msValue()));
            }
            return rtnObj;
        }
        catch (Exception ex) {
            String str = "can not load process manager from cache. argument : '" + argument + "' at " + this.engine.context().getAIS();
            log.warn((Object)str, (Throwable)ex);
            throw new CacheException(str, (Throwable)ex);
        }
    }

    private WfProcessMgr loadProcessMgr(String procDefId, int innerVersion) throws WfException {
        ProcessDefInfo procDefInfo = this.engine.getDefinitionMgr().getProcessDefInfo(procDefId, innerVersion);
        if (procDefInfo == null) {
            procDefInfo = this.engine.getDefinitionMgr().getProcessDefInfo(procDefId);
        }
        return new WfProcessMgr(this.engine, procDefInfo);
    }

    public void cleanUp() {
    }

    public Object load(ObjectRef ref) throws Exception {
        return this.load(ref.name());
    }

    public void unload(ObjectRef ref, Object value) {
        log.info((Object)("cache item " + ref + " unload value " + value));
    }
}

