/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.cbos.process.vm.builder.NodeBuilder;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.util.Collection;
import java.util.Set;

public class Util {
    public static WfActivity getWfActivity(Execution e) throws Exception {
        String id = e.getId();
        return Util.getWfActivity(e, id);
    }

    public static WfActivity getWfActivity(Execution e, String actId) throws WfException {
        FlowContext ctx = e.getContext();
        WfActivity act = (WfActivity)ctx.getTransientProperty(actId);
        if (act != null) {
            return act;
        }
        WfProcess process = Util.getWfProcess(e);
        WfEngine engine = process.getWfEngine();
        if (actId.endsWith(WfBOSObjectTypeUtil.ACTIVITYINSTBOT.toString())) {
            act = engine.getActivityInst(actId);
            Util.bind(act, e);
            return act;
        }
        throw new UnsupportedOperationException();
    }

    public static WfActivity getWfActivity(FlowContext ctx, String actInstId) throws WfException {
        WfActivity act = (WfActivity)ctx.getTransientProperty(actInstId);
        if (act != null) {
            return act;
        }
        WfProcess process = Util.getWfProcess(ctx);
        WfEngine engine = process.getWfEngine();
        act = engine.getActivityInst(actInstId);
        ctx.setTransientProperty(actInstId, (Object)act);
        return act;
    }

    public static void bind(WfProcess process, FlowContext ctx) {
        ctx.setTransientProperty("$process", (Object)process);
    }

    public static void bind(WfActivity act, Execution e) {
        if (e.getId().equals(act.getId())) {
            String id = e.getId();
            e.getContext().setTransientProperty(id, (Object)act);
        }
    }

    public static WfProcess getWfProcess(FlowContext ctx) {
        return (WfProcess)ctx.getTransientProperty("$process");
    }

    public static WfProcess getWfProcess(Execution e) {
        return Util.getWfProcess(e.getContext());
    }

    public static void setMutexRouterId(Execution e) {
        e.getContext().setProperty("mutex-router-id", e.getId());
    }

    public static String getMutexRouterId(FlowContext ctx) {
        return (String)ctx.getProperty("mutex-router-id");
    }

    public static void bind(NodeBuilder node, ActivityDef def) {
        node.setAttribute("$node_def", (Object)def);
    }

    public static ActivityDef getActivityDef(NodeBuilder node) {
        return (ActivityDef)node.getAttribute("$node_def");
    }

    public static ActivityDef getDefine(VariableScope define) {
        return (ActivityDef)define.getAttribute("$node_def");
    }

    public static void setFirstActivity(FlowContext runtime, ActivityDef firstAct, boolean omitFirstAct) {
        if (omitFirstAct) {
            runtime.setProperty("$omit_first_act", "true");
        }
        runtime.setProperty("$first_act_id", firstAct.getID());
    }

    public static boolean shouldOmitFirstActivity(FlowContext runtime) {
        return "true".equals(runtime.getProperty("$omit_first_act"));
    }

    public static void clearOmitFirstActivityFlag(FlowContext runtime) {
        runtime.setProperty("$omit_first_act", (String)null);
    }

    public static void setShouldTransit(FlowContext runtime, String dest) {
        String key = "$transit-" + dest;
        runtime.setProperty(key, "true");
    }

    public static boolean shouldTransit(FlowContext runtime, String dest) {
        String key = "$transit-" + dest;
        return "true".equals(runtime.getProperty(key));
    }

    public static void clearShouldTransit(FlowContext runtime, String dest) {
        String key = "$transit-" + dest;
        runtime.setProperty(key, (String)null);
    }

    public static String getFirstActId(FlowContext runtime) {
        return (String)runtime.getProperty("$first_act_id");
    }

    public static void setOmittedActInstId(FlowContext runtime, String actInstId) {
        runtime.setTransientProperty("$omitted", (Object)actInstId);
    }

    public static String getOmittedActInstId(FlowContext runtime) {
        return (String)runtime.getTransientProperty("$omitted");
    }

    public static boolean isJumped(Execution e) {
        return e.getProperty("$jumped") != null;
    }

    public static void jump(Execution e, String[] nodes) {
        Execution root = e.getContext().getRootExecution();
        while (e.getParent() != root) {
            e = e.getParent();
        }
        for (int i = 0; i < nodes.length; ++i) {
            e.activate(nodes[i]);
        }
        Util.setJumped(e);
        if (!e.isClosed()) {
            e.terminate();
        }
    }

    public static void setJumped(Execution e) {
        e.setProperty("$jumped", "true");
    }

    public static void setAborted(FlowContext runtime) {
        runtime.setProperty("$aborted", "true");
    }

    public static boolean isAborted(FlowContext runtime) {
        return runtime.getProperty("$aborted") != null;
    }

    public static void setSyncSubFlow(FlowContext runtime) {
        runtime.setProperty("$is-sync-sub-flow$", "true");
    }

    public static boolean isSyncSubFlow(FlowContext runtime) {
        return "true".equals(runtime.getProperty("$is-sync-sub-flow$"));
    }

    public static void setLastSignal(FlowContext runtime, String actInstId) {
        runtime.setProperty("$signal", actInstId);
    }

    public static String getLastSignal(FlowContext runtime) {
        return (String)runtime.getProperty("$signal");
    }

    public static void setAppended(Execution e, String group) {
        e.setProperty("$appended", "true");
        e.setProperty("$append-group", group);
    }

    public static String getAppendedGroup(Execution e) {
        return (String)e.getProperty("$append-group");
    }

    public static boolean isAppended(Execution e) {
        return "true".equals(e.getProperty("$appended"));
    }

    public static void setParticipants(Execution e, Set personIds) {
        e.setProperty("$participants", (Collection)personIds);
    }

    public static Collection getParticipants(Execution e) {
        return (Collection)e.getProperty("$participants");
    }

    public static void setMessageTitle(Execution e, String title) {
        e.setProperty("$msg_title", title);
    }

    public static String getMessageTitle(Execution e) {
        return (String)e.getProperty("$msg_title");
    }

    public static void setActivityIsCreated(Execution e) {
        e.setProperty("$act_is_created", "true");
    }

    public static boolean activityIsCreated(Execution e) {
        return "true".equals(e.getProperty("$act_is_created"));
    }

    public static boolean isBackTransition(TransitionDef transitionDef, Flow flow) {
        if (transitionDef.getFrom() == null || transitionDef.getTo() == null) {
            return false;
        }
        String transitionPatch = transitionDef.getFrom().getID() + "->" + transitionDef.getTo().getID();
        Set backTranSet = (Set)flow.getAttribute("BACKTRANSET");
        if (backTranSet == null || backTranSet.isEmpty()) {
            backTranSet = flow.getGraph().getBackwardEdges();
            flow.setAttribute("BACKTRANSET", (Object)backTranSet);
        }
        return backTranSet.contains(transitionPatch);
    }
}

