/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.shell.trace.ConnectionInfo;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.WfLogConfig;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.service.IMonitorService;
import com.kingdee.bos.workflow.timeliness.TimelinessProvider;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MonitorService
extends AbstractBOSObject
implements IMonitorService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFMONTRS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.MonitorService");
    private static final String WORKFLOW_CONFIG_NAME = "Workflow";
    public static final String LOGCONFIG_LOGLEVEL = "LogLevel";
    public static final String LOGCONFIG_ENABLEENGINELOG = "EnableEngineLog";
    public static final String LOGCONFIG_ENABLEQUEUELOG = "EnableQueueLog";
    public static final String LOGCONFIG_ENABLEPROCESSDEFLOG = "EnableProcessDefLog";
    public static final String LOGCONFIG_ENABLEPROCESSINSTLOG = "EnableProcessInstLog";

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public static IMonitorService getService(Context ctx) {
        return new MonitorService(ctx);
    }

    public MonitorService() {
        this.registerInterface(IMonitorService.class, (Object)this);
    }

    public MonitorService(Context ctx) {
        super(ctx);
        this.registerInterface(IMonitorService.class, (Object)this);
    }

    public HashMap getKSQLTraceInfo() {
        HashMap activateConnInfoMap = (HashMap)KSqlMonitor.getActivateConnectionMap();
        HashMap<String, ConnectionInfo> resultMap = new HashMap<String, ConnectionInfo>();
        int i = 0;
        for (ConnectionInfo connInfo : activateConnInfoMap.values()) {
            resultMap.put(Integer.toString(i), connInfo);
            ++i;
        }
        return resultMap;
    }

    public String checkParticipantProvider() {
        String provideName = "";
        try {
            WfEngine wfEngine = WfEngine.getEngine(this.getContext());
            provideName = wfEngine.getPariticipantProvider().getClass().getName();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return provideName;
    }

    public String checkPermissionProvider() {
        String provideName = "";
        try {
            WfEngine wfEngine = WfEngine.getEngine(this.getContext());
            provideName = wfEngine.getPermissionProvider().getClass().getName();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return provideName;
    }

    public boolean checkMessageProvider(String userId) {
        try {
            WfMessage message = new WfMessage();
            Context ctx = WfEngine.getEngine(this.getContext()).context();
            message.setContext(ctx);
            Locale[] locales = ApplicationUtil.getContextLocales((Context)ctx);
            for (int i = 0; i < locales.length; ++i) {
                message.addSubject("Monitor Center test Message.", locales[i]);
                message.addContent("this message sended by Monitor Center.", locales[i]);
            }
            message.send(userId);
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String checkTimelinessProvider() {
        String provideName = "";
        try {
            WfEngine wfEngine = WfEngine.getEngine(this.getContext());
            String ais = wfEngine.getEngineAis();
            String solution = wfEngine.getEngineSolution();
            provideName = TimelinessProvider.getProvider(ais, solution).getClass().getName();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return provideName;
    }

    public ConfigurationItem getWfConfigItem() {
        IDeployInfoManager deploy = DeployInfoManagerFactory.getDeployInfoManager();
        ConfigurationItem workflowItem = deploy.getConfigItem(WORKFLOW_CONFIG_NAME);
        return workflowItem;
    }

    public WfLogConfig getLogConfig() {
        WfLogConfig logConfig = EngineConfig.getInstance().getLogConfig();
        return logConfig;
    }

    public void setLogConfig(Map logConfigMap) {
        boolean enableProcessDefLog;
        boolean enableQueueLog;
        boolean enableEngineLog;
        WfLogConfig logConfig = EngineConfig.getInstance().getLogConfig();
        if (logConfigMap == null || logConfigMap.size() == 0) {
            return;
        }
        int logLevel = Integer.parseInt((String)logConfigMap.get(LOGCONFIG_LOGLEVEL));
        LogTypeEnum logType = LogTypeEnum.getEnum((int)logLevel);
        if (logType != null) {
            logConfig.logLevel = logType;
        }
        logConfig.enableEngineLog = enableEngineLog = ((Boolean)logConfigMap.get(LOGCONFIG_ENABLEENGINELOG)).booleanValue();
        logConfig.enableQueueLog = enableQueueLog = ((Boolean)logConfigMap.get(LOGCONFIG_ENABLEQUEUELOG)).booleanValue();
        logConfig.enableProcessDefLog = enableProcessDefLog = ((Boolean)logConfigMap.get(LOGCONFIG_ENABLEPROCESSDEFLOG)).booleanValue();
    }

    public Map getEngineProperty() throws WfException {
        HashMap engineMap = new HashMap();
        Set engineKeySet = WfEngine.getEngineKeySet();
        WfEngine engine = null;
        Iterator iter = engineKeySet.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            engine = WfEngine.getEngine(key);
            HashMap<String, Object> property = new HashMap<String, Object>();
            property.put("ThreadGroupCreateDate", engine.createdDate);
            property.put("CreatedDate", engine.createdDate);
            property.put("UserName", engine.context().getUserName());
            engineMap.put(key, property);
        }
        return engineMap;
    }

    public Map getWfCacheProperty(String ais, String solution) throws WfException {
        Map cacheMap = new HashMap();
        WfEngine wfEngine = WfEngine.getEngine(ais, solution);
        cacheMap = wfEngine.getCacheManager().getCacheProperty();
        return cacheMap;
    }

    public String getServerKey(String ais, String solution) throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(ais, solution);
        return wfEngine.getServerKey();
    }

    public String getDbType() throws SQLException {
        Connection conn = WfDbUtil.getConnection((Context)this.getContext());
        String dbTypeName = KSqlUtil.getDbTypeName((Connection)conn);
        SQLUtils.cleanup((Connection)conn);
        return dbTypeName;
    }

    public boolean enableKSQLTrace(boolean enabled) {
        Map map = KSqlMonitor.getTraceInfoMap();
        for (Map.Entry entry : map.entrySet()) {
            TraceInfo traceInfo = (TraceInfo)entry.getValue();
            traceInfo.enable = true;
        }
        return false;
    }

    public boolean enableKSQLTrace(boolean enabled, String logFileUrl) {
        Map map = KSqlMonitor.getTraceInfoMap();
        for (Map.Entry entry : map.entrySet()) {
            TraceInfo traceInfo = (TraceInfo)entry.getValue();
            traceInfo.enable = true;
            traceInfo.logFileUrl = logFileUrl;
            log.info((Object)(traceInfo.url + "trace turn on, logfile:" + logFileUrl));
        }
        return false;
    }

    public void resetWorkerThread() throws WfException {
        WfEngine wfEngine = WfEngine.getEngine(this.getContext());
        wfEngine.resetWorkerThread();
        WfLogger wfLogger = new WfLogger(wfEngine.getStoreManager());
        wfLogger.addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.STOP, "", "Workflow engine thread reset.");
    }
}

