/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.EventProcMetaCollection;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.metas.EventTypeEnum;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class EventStorer
extends AbstractBaseStorer {
    private static final Logger logger = Logger.getLogger(EventStorer.class);

    public EventStorer(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEventProcRelation(String eventProcMetaId) throws WfException, SQLException {
        boolean bl;
        if (StringUtils.isEmpty((String)eventProcMetaId)) {
            throw new WfException("deleteEventProcRelation args eventProcMetaId is null");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "DELETE FROM T_WFR_EventProcMeta WHERE (FEventProcId = ?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, eventProcMetaId);
            bl = stmt.executeUpdate() == 1;
        }
        catch (Throwable throwable) {
            this.cleanup(stmt, conn);
            throw throwable;
        }
        this.cleanup(stmt, conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEventProcRelation(String processDefId) throws SQLException, WfException {
        if (StringUtils.isEmpty((String)processDefId)) {
            throw new WfException("clearEventProcRelation args processdefId is null");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "DELETE FROM T_WFR_EventProcMeta WHERE (FProcDefId = ? and FEventType = ?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, processDefId);
            stmt.setString(2, EventTypeEnum.PROCESSTRIGGER.getValue());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.cleanup(stmt, conn);
            throw throwable;
        }
        this.cleanup(stmt, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEventProcRelation(EventProcMetaInfo[] eventProcMetaInfos) throws SQLException, WfException, DataAccessException {
        if (eventProcMetaInfos == null || eventProcMetaInfos.length <= 0) {
            logger.error((Object)"createEventProcRelation args eventProcMetaInfos is null");
            throw new WfException("createEventProcRelation args eventProcMetaInfos is null");
        }
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.EVENTPROCMETABOT, cn);
            for (int i = 0; i < eventProcMetaInfos.length; ++i) {
                ormdao.addNewBatch((IObjectValue)eventProcMetaInfos[i]);
            }
            ormdao.executeBatch();
        }
        finally {
            this.cleanup(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventProcMetaInfo[] getEventProcMetaInfos(String oql) throws WfException, SQLException, DataAccessException {
        if (StringUtils.isEmpty((String)oql)) {
            throw new WfException("getEventProcMetaInfos args oql is null");
        }
        Connection conn = null;
        EventProcMetaInfo[] eventProcMetaInfos = new EventProcMetaInfo[]{};
        try {
            conn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.EVENTPROCMETABOT, conn);
            EventProcMetaCollection epmCol = (EventProcMetaCollection)ormdao.getCollection(oql);
            if (epmCol != null && epmCol.size() > 0) {
                eventProcMetaInfos = new EventProcMetaInfo[epmCol.size()];
                for (int i = 0; i < epmCol.size(); ++i) {
                    eventProcMetaInfos[i] = epmCol.get(i);
                }
            }
        }
        finally {
            this.cleanup(conn);
        }
        return eventProcMetaInfos;
    }
}

