/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.transaction.IBatchPersistence;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LazyPersistentMgr {
    private static final Logger logger = Logger.getLogger(LazyPersistentMgr.class);
    private final Context ctx;
    private final Map mapNewObjects;
    private final Map mapChangedObjects;
    private final Map batchPersistences;
    private final Set affectedProcIds;
    private final Set affectedActIds;
    private final Set affectedAssignIds;

    LazyPersistentMgr(Context ctx) {
        this.ctx = ctx;
        this.mapNewObjects = new HashMap();
        this.mapChangedObjects = new HashMap();
        this.batchPersistences = new HashMap();
        this.affectedProcIds = new HashSet();
        this.affectedActIds = new HashSet();
        this.affectedAssignIds = new HashSet();
    }

    void register(IBatchPersistence impl) {
        this.batchPersistences.put(impl.getBOSObjectType(), impl);
    }

    public Set getAffectedProcIds() {
        return Collections.unmodifiableSet(this.affectedProcIds);
    }

    public Set getAffectedActIds() {
        return Collections.unmodifiableSet(this.affectedActIds);
    }

    public Set getAffectedAssignIds() {
        return Collections.unmodifiableSet(this.affectedAssignIds);
    }

    void createNew(IObjectValue newObject) {
        BOSObjectType bosObjectType = newObject.getBOSType();
        ArrayList<IObjectValue> newObjects = (ArrayList<IObjectValue>)this.mapNewObjects.get(bosObjectType);
        if (newObjects != null) {
            boolean found = false;
            int size = newObjects.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue existNewObject = (IObjectValue)newObjects.get(i);
                if (!this.getID(existNewObject).equals((Object)this.getID(newObject))) continue;
                found = true;
                if (logger.isEnabledFor(Priority.WARN)) {
                    logger.warn((Object)("newObjectValue[" + this.getID(newObject) + "] is exist!"));
                }
                this.overwriteObjectValue(existNewObject, newObject);
            }
            if (!found) {
                newObjects.add(newObject);
            }
        } else {
            newObjects = new ArrayList<IObjectValue>();
            newObjects.add(newObject);
            this.mapNewObjects.put(bosObjectType, newObjects);
        }
    }

    private BOSUuid getID(IObjectValue objectValue) {
        String pkField = objectValue.getPKField();
        return objectValue.getBOSUuid(pkField);
    }

    private void overwriteObjectValue(IObjectValue baseObject, IObjectValue newObject) {
        Enumeration keys = newObject.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            baseObject.put(key, newObject.get(key));
        }
    }

    private void recordAffectedIds(IObjectValue obj) {
        if (obj instanceof AssignInfo) {
            AssignInfo a = (AssignInfo)obj;
            this.affectedAssignIds.add(a.getAssignID().toString());
            this.affectedProcIds.add(a.getProcInstID().toString());
            this.affectedActIds.add(a.getActInstID().toString());
        } else if (obj instanceof ActInstInfo) {
            ActInstInfo a = (ActInstInfo)obj;
            this.affectedActIds.add(a.getActInstID().toString());
            this.affectedProcIds.add(a.getProcInstID().toString());
        } else if (obj instanceof ProcInstInfo) {
            ProcInstInfo p = (ProcInstInfo)obj;
            this.affectedProcIds.add(p.getProcInstID().toString());
        }
    }

    public void procInstChanged(String procInstId) {
        this.affectedProcIds.add(procInstId);
    }

    void update(IObjectValue baseObject, IObjectValue changedObject) {
        BOSObjectType bosObjectType = baseObject.getBOSType();
        List newObjects = (List)this.mapNewObjects.get(bosObjectType);
        if (newObjects != null) {
            int size = newObjects.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue existNewObject = (IObjectValue)newObjects.get(i);
                if (!this.getID(existNewObject).equals((Object)this.getID(changedObject))) continue;
                this.overwriteObjectValue(existNewObject, changedObject);
                return;
            }
        }
        this.recordAffectedIds(changedObject);
        ArrayList<ObjectValuePair> changedObjectPairs = (ArrayList<ObjectValuePair>)this.mapChangedObjects.get(bosObjectType);
        if (changedObjectPairs != null) {
            int size = changedObjectPairs.size();
            for (int i = 0; i < size; ++i) {
                ObjectValuePair existChangedObjectValuePair = (ObjectValuePair)changedObjectPairs.get(i);
                if (!this.getID(existChangedObjectValuePair.getBase()).equals((Object)this.getID(changedObject))) continue;
                IObjectValue existChangedObjectValue = existChangedObjectValuePair.getChange();
                this.overwriteObjectValue(existChangedObjectValue, changedObject);
                existChangedObjectValuePair.setChange(existChangedObjectValue);
                return;
            }
            changedObjectPairs.add(new ObjectValuePair(baseObject, changedObject));
        } else {
            changedObjectPairs = new ArrayList<ObjectValuePair>();
            changedObjectPairs.add(new ObjectValuePair(baseObject, changedObject));
            this.mapChangedObjects.put(bosObjectType, changedObjectPairs);
        }
    }

    private Map getObjectValues4AddNew() {
        return this.mapNewObjects;
    }

    private Map getObjectValues4Update() {
        HashMap retVal = new HashMap();
        Set entrySet = this.mapChangedObjects.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            ArrayList<IObjectValue> mergedObjectValues = new ArrayList<IObjectValue>();
            Map.Entry entry = iterator.next();
            BOSObjectType bosObjectType = (BOSObjectType)entry.getKey();
            List changedObjectPairs = (List)entry.getValue();
            int size = changedObjectPairs.size();
            for (int i = 0; i < size; ++i) {
                ObjectValuePair objectValuePair = (ObjectValuePair)changedObjectPairs.get(i);
                IObjectValue base = objectValuePair.getBase();
                IObjectValue change = objectValuePair.getChange();
                IObjectValue objectValue = this.newInstance(bosObjectType);
                objectValue.put(base.getPKField(), (Object)this.getID(base));
                Enumeration keys = change.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (this.equals(base.get(key), change.get(key))) continue;
                    objectValue.put(key, change.get(key));
                }
                mergedObjectValues.add(objectValue);
            }
            retVal.put(bosObjectType, mergedObjectValues);
        }
        return retVal;
    }

    private IObjectValue newInstance(BOSObjectType bosObjectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        EntityObjectInfo entity = loader.getEntity(bosObjectType);
        String className = entity.getObjectValueClassRuntime();
        try {
            return (IObjectValue)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean equals(Object aObject, Object bObject) {
        if (aObject == null) {
            return bObject == null;
        }
        return aObject.equals(bObject);
    }

    public void commit() throws WfException {
        LowTimer lowTimer = new LowTimer();
        Set setBatchPersistences = this.batchPersistences.entrySet();
        Map mapNewObjects = this.getObjectValues4AddNew();
        Map mapChangedObjects = this.getObjectValues4Update();
        for (Map.Entry entry : setBatchPersistences) {
            List changedObjects;
            BOSObjectType bosObjectType = (BOSObjectType)entry.getKey();
            IBatchPersistence persistence = (IBatchPersistence)entry.getValue();
            List newObjects = (List)mapNewObjects.get(bosObjectType);
            int count = (newObjects != null ? newObjects.size() : 0) + ((changedObjects = (List)mapChangedObjects.get(bosObjectType)) != null ? changedObjects.size() : 0);
            if (count <= 0) continue;
            persistence.executeBatch(newObjects, changedObjects);
        }
        this.mapNewObjects.clear();
        this.mapChangedObjects.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("LazyPersistentMgr.commit() cost: " + lowTimer.msValue()));
        }
    }

    void wfExecutionExpired() throws WfException {
        if (this.affectedProcIds.size() == 0 && this.affectedActIds.size() == 0 && this.affectedAssignIds.size() == 0) {
            return;
        }
        IWfCacheManager cache = WfEngine.getEngine(this.ctx).getCacheManager();
        for (String procInstId : this.affectedProcIds) {
            cache.processInstExpired(procInstId);
        }
        for (String actInstId : this.affectedActIds) {
            cache.activityInstExpired(actInstId);
        }
        for (String assignId : this.affectedAssignIds) {
            cache.assignmentExpired(assignId);
        }
    }

    private static class ObjectValuePair {
        private IObjectValue base = null;
        private IObjectValue change = null;

        ObjectValuePair(IObjectValue base) {
            this.base = base;
        }

        ObjectValuePair(IObjectValue base, IObjectValue change) {
            this.base = base;
            this.change = change;
        }

        IObjectValue getBase() {
            return this.base;
        }

        void setBase(IObjectValue base) {
            this.base = base;
        }

        IObjectValue getChange() {
            return this.change;
        }

        void setChange(IObjectValue change) {
            this.change = change;
        }
    }
}

