/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.transaction;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.transaction.LazyPersistentMgr;
import com.kingdee.bos.workflow.transaction.WfTxContext;

public class SnapshotRecorder {
    private final LazyPersistentMgr lazyPersistentMgr;
    private AbstractObjectValue original = null;
    private AbstractObjectValue change = null;
    private BOSObjectType type = null;

    private SnapshotRecorder(LazyPersistentMgr lazyPersistentMgr) {
        this.lazyPersistentMgr = lazyPersistentMgr;
    }

    public static SnapshotRecorder create() {
        return new SnapshotRecorder(WfTxContext.current().getLazyPersistentMgr());
    }

    public void snapshoot(AbstractObjectValue objectValue) {
        assert (objectValue != null);
        if (this.type == null) {
            this.type = objectValue.getBOSType();
        } else if (!this.type.equals((Object)objectValue.getBOSType())) {
            throw new IllegalArgumentException("type error:original's type[" + this.original.getBOSType() + "],  change's type[" + objectValue.getBOSType() + "]");
        }
        if (this.original == null) {
            this.original = (AbstractObjectValue)objectValue.clone();
        } else {
            this.change = (AbstractObjectValue)objectValue.clone();
        }
    }

    public void recordSnapshots() {
        if (this.original != null && this.change == null) {
            this.lazyPersistentMgr.createNew((IObjectValue)this.original);
        } else if (this.original != null && this.change != null) {
            this.lazyPersistentMgr.update((IObjectValue)this.original, (IObjectValue)this.change);
        }
    }
}

