/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.util.InvocationDesc;
import com.kingdee.bos.workflow.util.MethodDesc;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class InvocationExecutor {
    private static final Logger logger = Logger.getLogger(InvocationExecutor.class);

    private InvocationExecutor() {
    }

    public static Object execute(InvocationDesc invocationDesc) throws WfException {
        Object retVal = null;
        MethodDesc methodDesc = invocationDesc.getMethodDesc();
        Object obj = invocationDesc.getObj();
        Class clazz = methodDesc.getMethodClass();
        String methodName = methodDesc.getMethodName();
        Class[] parameterTypes = methodDesc.getParamTypes();
        Object[] params = invocationDesc.getParams();
        try {
            Method method = clazz.getMethod(methodName, parameterTypes);
            retVal = method.invoke(obj, params);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            logger.error((Object)t.getMessage(), t);
            if (t instanceof WfException) {
                throw (WfException)t;
            }
            throw new WfException(t);
        }
        return retVal;
    }
}

