/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.microflow;

import com.kingdee.bos.Context;
import com.kingdee.bos.microflow.FlowLoader;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.LocalCache;
import com.kingdee.cbos.process.vm.utils.cache.SmartCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MicroFlowEngine {
    private static final int CACHE_SIZE = 500;
    private static final int CACHE_TIMEOUT = 1800;
    private Cache<String, Flow> cache;
    private Context ctx;
    private static Map<String, MicroFlowEngine> engines = new ConcurrentHashMap<String, MicroFlowEngine>();

    private MicroFlowEngine(Context ctx) {
        this.ctx = Ctx.newShadowContext((String)ctx.getAIS());
        this.cache = new SmartCache((Cache)new LocalCache("MF", 500, 1800), (SmartCache.Loader)new FlowLoader(ctx));
    }

    public Context getContext() {
        return this.ctx;
    }

    public Flow getFlow(String id) {
        Flow flow = (Flow)this.cache.get((Object)id);
        return flow;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public static MicroFlowEngine getEngine(Context ctx) {
        MicroFlowEngine engine = engines.get(ctx.getAIS());
        if (engine == null) {
            engine = MicroFlowEngine.newEngine(ctx);
        }
        return engine;
    }

    private static synchronized MicroFlowEngine newEngine(Context ctx) {
        MicroFlowEngine engine = engines.get(ctx.getAIS());
        if (engine == null) {
            engine = new MicroFlowEngine(ctx);
            engines.put(ctx.getAIS(), engine);
        }
        return engine;
    }
}

