/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.adapter;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleAdapter;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleTestHelper;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.runtime.Execution;

public final class WfRoleTransitCondition
implements Condition {
    private TransitionDef trans;

    public WfRoleTransitCondition(TransitionDef trans) {
        this.trans = trans;
    }

    public void compile(VariableScope scope) {
    }

    public boolean test(Execution<? extends VariableScope> e) throws Exception {
        ConditionDef condition = this.trans.getCondition();
        if (condition == null || condition.getWfRoleId() == null && condition.getOrgWfRoleId() == null) {
            return true;
        }
        WfProcess process = Util.getWfProcess(e);
        return WfRoleTransitCondition.test(process, condition);
    }

    public static boolean test(WfProcess process, ConditionDef condition) throws Exception {
        if (condition == null) {
            return true;
        }
        String instId = process.getId();
        String billId = process.getWfEngine().getBizObjIdByProcessInstanceId(instId);
        Context ctx = process.getContext();
        return WfRoleTransitCondition.roleConditionTest(ctx, condition, billId);
    }

    public static boolean roleConditionTest(Context ctx, ConditionDef condition, String billId) throws WfException {
        if (condition == null) {
            return true;
        }
        boolean isFromRole = condition.isFromRole();
        boolean org_isFromRole = condition.isOrg_isFromRole();
        String roleId = condition.getWfRoleId();
        String applierPropertyName = condition.getWfrAppl();
        String orgRoleId = condition.getOrgWfRoleId();
        String orgPropertyName = condition.getWFROrgAttribute();
        boolean isApplierNull = false;
        boolean isOrgNull = false;
        if (roleId == null || roleId.trim().length() <= 0 || applierPropertyName == null || applierPropertyName.trim().length() == 0) {
            isApplierNull = true;
        }
        if (orgRoleId == null || orgRoleId.trim().length() <= 0 || orgPropertyName == null || orgPropertyName.trim().length() == 0) {
            isOrgNull = true;
        }
        if (isApplierNull && isOrgNull) {
            return true;
        }
        boolean applierTest = false;
        boolean orgTest = false;
        WfRoleAdapter roleAdapter = new WfRoleAdapter();
        if (!isApplierNull) {
            boolean bInclude = condition.isIncludeRole();
            applierTest = isFromRole ? roleAdapter.test(ctx, roleId, billId, applierPropertyName, bInclude) : WfRoleTestHelper.getInstance().test4RoleGroupByApplier(ctx, roleId, billId, applierPropertyName, bInclude);
        }
        if (!isOrgNull) {
            boolean orgIsInclude = condition.isOrgIncludeRole();
            orgTest = org_isFromRole ? roleAdapter.testByOrgProName(ctx, orgRoleId, billId, orgPropertyName, orgIsInclude) : WfRoleTestHelper.getInstance().testByOrgProName(ctx, orgRoleId, billId, orgPropertyName, orgIsInclude);
        }
        if (!isApplierNull && !isOrgNull) {
            return applierTest && orgTest;
        }
        return applierTest || orgTest;
    }
}

