/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.parser;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ConditionDef;
import com.kingdee.bos.workflow.define.ConditionType;
import com.kingdee.bos.workflow.define.ExpressionCollection;
import com.kingdee.bos.workflow.define.ExpressionDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.engine.adapter.ActivitySynchronizer;
import com.kingdee.bos.workflow.engine.adapter.DefaultErrorTransitCondition;
import com.kingdee.bos.workflow.engine.adapter.ErrorTransitCondition;
import com.kingdee.bos.workflow.engine.adapter.NormalTransitCondition;
import com.kingdee.bos.workflow.engine.adapter.WfProfileLogger;
import com.kingdee.bos.workflow.engine.adapter.WfRoleTransitCondition;
import com.kingdee.bos.workflow.engine.core.IFlowParser;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.listener.ActivityInstInited;
import com.kingdee.bos.workflow.engine.listener.ActivityPostHandler;
import com.kingdee.bos.workflow.engine.listener.AutoApproveForward;
import com.kingdee.bos.workflow.engine.listener.GetPostParticipant;
import com.kingdee.bos.workflow.engine.listener.ProcessCompleted;
import com.kingdee.bos.workflow.engine.listener.ProcessResumed;
import com.kingdee.bos.workflow.engine.listener.ProcessSuspended;
import com.kingdee.bos.workflow.engine.listener.ProcessTerminated;
import com.kingdee.bos.workflow.engine.listener.ShareCenterCreateAssignment;
import com.kingdee.bos.workflow.engine.listener.SubFlowAborted;
import com.kingdee.bos.workflow.engine.listener.SubFlowCompleted;
import com.kingdee.bos.workflow.engine.listener.SubFlowPartialCompleted;
import com.kingdee.bos.workflow.engine.listener.SubFlowResumed;
import com.kingdee.bos.workflow.engine.listener.SubFlowSuspend;
import com.kingdee.bos.workflow.engine.parser.ActivityParser;
import com.kingdee.bos.workflow.engine.parser.Parsers;
import com.kingdee.cbos.process.vm.builder.FlowBuilder;
import com.kingdee.cbos.process.vm.builder.NodeBuilder;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.FlowEvents;
import com.kingdee.cbos.process.vm.model.NodeEvents;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.plugin.Synchronizer;
import com.kingdee.cbos.process.vm.runtime.ProfileLogger;
import com.kingdee.cbos.process.vm.utils.cache.SmartCache;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FlowParser
implements SmartCache.Loader<String, Flow>,
IFlowParser {
    private static Logger logger = Logger.getLogger(FlowParser.class);
    private static Locale l = new Locale("L2");
    private WfEngine engine;

    public FlowParser() {
        ProfileLogger.Ref.set((Object)new WfProfileLogger());
    }

    public FlowParser(WfEngine engine) {
        this.engine = engine;
    }

    public Flow load(String id) {
        ProcessDef def;
        try {
            def = this.engine.getProcessDef(id);
        }
        catch (WfException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.parse(def);
    }

    public Flow parse(ProcessDef def) {
        ActivitySynchronizer sync = ActivitySynchronizer.INS;
        FlowBuilder builder = FlowBuilder.newBuilder((Synchronizer)sync, (String)def.getDocHash(), (String)def.getName());
        this.setDefaultListeners(builder);
        if (this.engine == null) {
            FlowParser.createNodes(def, builder);
        } else {
            Context ctx = this.engine.context();
            FlowParser.createNodes(ctx, def, builder);
        }
        FlowParser.createTransitions(def, builder);
        return builder.end();
    }

    private void setDefaultListeners(FlowBuilder builder) {
        builder.listener(FlowEvents.ON_COMPLETED, (Listener)ProcessCompleted.INS);
        builder.listener(FlowEvents.ON_TERMINATED, (Listener)ProcessTerminated.INS);
        builder.listener(FlowEvents.ON_SUSPENDED, (Listener)ProcessSuspended.INS);
        builder.listener(FlowEvents.ON_FAILED, (Listener)ProcessSuspended.INS);
        builder.listener(FlowEvents.ON_RESUMED, (Listener)ProcessResumed.INS);
        builder.listener(FlowEvents.ON_RETRIED, (Listener)ProcessResumed.INS);
        builder.listener(FlowEvents.ON_COMPLETED, (Listener)SubFlowCompleted.INS);
        builder.listener(FlowEvents.ON_TERMINATED, (Listener)SubFlowAborted.INS);
        builder.listener(FlowEvents.ON_SUSPENDED, (Listener)SubFlowSuspend.INS);
        builder.listener(FlowEvents.ON_FAILED, (Listener)SubFlowSuspend.INS);
        builder.listener(FlowEvents.ON_RESUMED, (Listener)SubFlowResumed.INS);
        builder.listener(FlowEvents.ON_RETRIED, (Listener)SubFlowResumed.INS);
    }

    private static void createTransitions(ProcessDef def, FlowBuilder builder) {
        TransitionCollection transitions = def.getTransitions();
        for (int i = 0; i < transitions.size(); ++i) {
            TransitionDef trans = transitions.get(i);
            String id = trans.getID();
            String nextId = null;
            nextId = i + 1 < transitions.size() ? transitions.get(i + 1).getID() : null;
            if (id.equals(nextId)) continue;
            String name = trans.getName(l);
            String from = trans.getFrom().getID();
            String to = trans.getTo().getID();
            ConditionDef condition = trans.getCondition();
            FlowParser.createTransition(builder, trans, id, name, from, to, condition);
        }
    }

    private static void createTransition(FlowBuilder builder, TransitionDef trans, String id, String name, String from, String to, ConditionDef conditionDef) {
        if (conditionDef == null || conditionDef.getConditionType() == null) {
            builder.transition(id, name, from, to, Condition.TRUE);
        } else {
            ConditionType type = conditionDef.getConditionType();
            if (type.equals((Object)ConditionType.DEFAULTEXCEPTION)) {
                builder.transition(id, name, Transition.Type.ERROR, from, to, (Condition)new DefaultErrorTransitCondition(trans));
            } else if (type.equals((Object)ConditionType.OTHERWISE)) {
                if (conditionDef.getWfRoleId() != null || conditionDef.getOrgWfRoleId() != null) {
                    builder.transition(id, name, from, to, (Condition)new WfRoleTransitCondition(trans));
                } else {
                    builder.transition(id, name, from, to, null);
                }
            } else if (type.equals((Object)ConditionType.CONDITION)) {
                Condition condition = FlowParser.getCondition(trans, conditionDef);
                builder.transition(id, name, from, to, condition);
            } else if (type.equals((Object)ConditionType.EXCEPTION)) {
                builder.transition(id, name, Transition.Type.ERROR, from, to, (Condition)new ErrorTransitCondition(trans));
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static Condition getCondition(TransitionDef trans, ConditionDef conditionDef) {
        ExpressionCollection expressionCollection = conditionDef.getXpressionList();
        if ((expressionCollection == null || expressionCollection.size() == 0) && conditionDef.getWfRoleId() == null && conditionDef.getOrgWfRoleId() == null) {
            return Condition.TRUE;
        }
        ExpressionDef express = expressionCollection.get(0);
        if ((express == null || express.toString().trim().length() == 0) && conditionDef.getWfRoleId() == null && conditionDef.getOrgWfRoleId() == null) {
            return Condition.TRUE;
        }
        return new NormalTransitCondition(trans);
    }

    private static void createNodes(Context ctx, ProcessDef def, FlowBuilder builder) {
        ActivityCollection activities = def.getActivitys();
        HashMap<String, NodeBuilder> nodes = new HashMap<String, NodeBuilder>(activities.size() * 2);
        ActivityDef start = null;
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef act = activities.get(i);
            if (act instanceof StartActivityDef) {
                if (start == null) {
                    start = act;
                } else {
                    throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49(" + def.getID() + ")\u6709\u591a\u4e2a\u5f00\u59cb\u6d3b\u52a8!");
                }
            }
            NodeBuilder node = builder.node(act.getID(), act.getName(l));
            Util.bind((NodeBuilder)node, (ActivityDef)act);
            FlowParser.checkStartup(act, node);
            FlowParser.setDefaultListeners(node);
            FlowParser.setInitListener(act, node);
            FlowParser.setSplitMode(act, node);
            FlowParser.setMergeMode(act, node);
            FlowParser.otherSettings(ctx, act, node);
            nodes.put(node.getNodeId(), node);
        }
        if (start == null) {
            logger.error((Object)("\u6d41\u7a0b\u5b9a\u4e49(" + def.getID() + ")\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8!\n" + def.toXml()));
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49(" + def.getID() + ")\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8!");
        }
        FlowParser.removeStart(start, nodes);
        for (NodeBuilder node : nodes.values()) {
            FlowParser.addListenerForSubFlow(node, nodes);
        }
        FlowParser.addAutoApproveForwardListener(nodes, def);
    }

    private static void createNodes(ProcessDef def, FlowBuilder builder) {
        ActivityCollection activities = def.getActivitys();
        HashMap<String, NodeBuilder> nodes = new HashMap<String, NodeBuilder>(activities.size() * 2);
        ActivityDef start = null;
        for (int i = 0; i < activities.size(); ++i) {
            ActivityDef act = activities.get(i);
            if (act instanceof StartActivityDef) {
                if (start == null) {
                    start = act;
                } else {
                    throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49(" + def.getID() + ")\u6709\u591a\u4e2a\u5f00\u59cb\u6d3b\u52a8!");
                }
            }
            NodeBuilder node = builder.node(act.getID(), act.getName(l));
            Util.bind((NodeBuilder)node, (ActivityDef)act);
            FlowParser.checkStartup(act, node);
            FlowParser.setDefaultListeners(node);
            FlowParser.setInitListener(act, node);
            FlowParser.setSplitMode(act, node);
            FlowParser.setMergeMode(act, node);
            FlowParser.otherSettings(act, node);
            nodes.put(node.getNodeId(), node);
        }
        if (start == null) {
            logger.error((Object)("\u6d41\u7a0b\u5b9a\u4e49(" + def.getID() + ")\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8!\n" + def.toXml()));
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49(" + def.getID() + ")\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8!");
        }
        FlowParser.removeStart(start, nodes);
        for (NodeBuilder node : nodes.values()) {
            FlowParser.addListenerForSubFlow(node, nodes);
        }
        FlowParser.addAutoApproveForwardListener(nodes, def);
    }

    private static void addAutoApproveForwardListener(HashMap<String, NodeBuilder> nodes, ProcessDef def) {
        ExtendedAttributeDef ead = def.getExtendedAttributes().get("autoMergeApproveForward");
        if (ead == null || ead.getValue() == null || "false".equals(ead.getValue())) {
            return;
        }
        for (NodeBuilder node : nodes.values()) {
            ActivityDef act = Util.getActivityDef((NodeBuilder)node);
            if (act instanceof ManpowerActivityDef && ((ManpowerActivityDef)act).isFirstManpowerActivity()) {
                node.listener(NodeEvents.ON_BIZ_COMPLETED, (Listener)GetPostParticipant.INS);
            }
            if (!(act instanceof ApproveActivityDef)) continue;
            ExtendedAttributeCollection extAttr = act.getActivityHeader().getExtendedAttributes();
            boolean isappend = false;
            if (extAttr != null && extAttr.get("appendActivity") != null) {
                isappend = Boolean.valueOf(extAttr.get("appendActivity").getValue());
            }
            if (isappend) continue;
            node.listener(NodeEvents.ON_READY, (Listener)AutoApproveForward.INS);
        }
    }

    private static void setInitListener(ActivityDef act, NodeBuilder node) {
        if (act instanceof ManpowerActivityDef) {
            node.listener(NodeEvents.ON_CHILDREN_STARTED, (Listener)ActivityInstInited.INS);
            if (act instanceof ApproveActivityDef) {
                node.listener(NodeEvents.ON_CHILDREN_STARTED, (Listener)ShareCenterCreateAssignment.INS);
            }
        } else {
            node.listener(NodeEvents.ON_BIZ_STARTED, (Listener)ActivityInstInited.INS);
        }
    }

    private static void removeStart(ActivityDef act, HashMap<String, NodeBuilder> nodes) {
        TransitionCollection trans;
        nodes.remove(act.getID());
        try {
            trans = act.getOutgoingTransitions();
        }
        catch (WfException e) {
            throw new RuntimeException("\u4e0d\u53ef\u80fd\u7684\u9519\u8bef\uff01", e);
        }
        for (int j = 0; j < trans.size(); ++j) {
            ActivityDef to = trans.get(j).getTo();
            if (!(to instanceof RouterActivityDef) && !(to instanceof ToolActivityDef) || !nodes.containsKey(to.getID())) continue;
            FlowParser.removeStart(to, nodes);
        }
    }

    private static void addListenerForSubFlow(NodeBuilder node, HashMap<String, NodeBuilder> nodes) {
        TransitionCollection trans;
        ActivityDef act = Util.getActivityDef((NodeBuilder)node);
        try {
            trans = act.getIncomingTransitions();
        }
        catch (WfException e) {
            throw new RuntimeException("\u4e0d\u53ef\u80fd\u7684\u9519\u8bef\uff01", e);
        }
        for (int j = 0; j < trans.size(); ++j) {
            ActivityDef from = trans.get(j).getFrom();
            if (nodes.containsKey(from.getID())) continue;
            node.listener(NodeEvents.ON_PARTIAL_COMPLETED, (Listener)SubFlowPartialCompleted.INS);
            return;
        }
    }

    private static void checkStartup(ActivityDef act, NodeBuilder node) {
        try {
            if (act.getIncomingTransitions().size() == 0 && !(act instanceof StartActivityDef)) {
                node.asNotStart();
            }
        }
        catch (WfException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setDefaultListeners(NodeBuilder node) {
        node.listener(NodeEvents.ON_BIZ_COMPLETED, (Listener)ActivityPostHandler.INS);
    }

    private static void otherSettings(Context ctx, ActivityDef act, NodeBuilder node) {
        ActivityParser p = Parsers.getParser(act);
        if (p != null) {
            p.parse(ctx, act, node);
        }
    }

    private static void otherSettings(ActivityDef act, NodeBuilder node) {
        ActivityParser p = Parsers.getParser(act);
        if (p != null) {
            p.parse(act, node);
        }
    }

    private static void setMergeMode(ActivityDef act, NodeBuilder node) {
        if (act instanceof RouterActivityDef && ((RouterActivityDef)act).isSync()) {
            node.synchronization();
            return;
        }
        JoinType type = act.getActivityHeader().getJoinType();
        if (type.equals((Object)JoinType.AND)) {
            node.join();
        } else if (type.equals((Object)JoinType.OR)) {
            node.synchronization();
        } else if (!type.equals((Object)JoinType.XOR)) {
            throw new UnsupportedOperationException();
        }
    }

    private static void setSplitMode(ActivityDef act, NodeBuilder node) {
        SplitType type = act.getActivityHeader().getSplitType();
        if (type.equals((Object)SplitType.AND)) {
            node.fork();
        } else if (type.equals((Object)SplitType.OR)) {
            node.multiChoice();
        } else if (type.equals((Object)SplitType.XOR)) {
            node.exclusiveChoice();
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

