/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.ws;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.workflow.engine.ws.Util;

public class ProcessWsdl {
    public static String getWsdl(String dataCenter, String procCode) throws Exception {
        Context ctx = Ctx.getDefaultContext((String)dataCenter);
        String procDefHash = Util.findHashCode(procCode, ctx);
        if (procDefHash == null) {
            return null;
        }
        String serviceURL = Util.getServiceURL(dataCenter, procCode);
        StringBuilder wsdl = new StringBuilder(8000);
        ProcessWsdl.addNameSpace(procCode, serviceURL, wsdl);
        ProcessWsdl.addOuterTypes(serviceURL, wsdl);
        ProcessWsdl.addMessages(wsdl);
        ProcessWsdl.addPortType(procCode, wsdl);
        ProcessWsdl.addBinding(procCode, serviceURL, wsdl);
        ProcessWsdl.addServiceDeclaration(procCode, serviceURL, wsdl);
        wsdl.append("</definitions>");
        return wsdl.toString();
    }

    private static void addMessages(StringBuilder wsdl) {
        ProcessWsdl.addStartMessage(wsdl);
        ProcessWsdl.addPullMessage(wsdl);
        ProcessWsdl.addStateMessage(wsdl);
    }

    private static void addStartMessage(StringBuilder wsdl) {
        wsdl.append("<message name='start'>");
        wsdl.append("<part name='input' type='tns:input'></part>");
        wsdl.append("</message>");
        wsdl.append("<message name='startResponse'>");
        wsdl.append("<part name='procInstId' type='xsd:string'/>");
        wsdl.append("</message>");
    }

    private static void addPullMessage(StringBuilder wsdl) {
        wsdl.append("<message name='pull'>");
        wsdl.append("<part name='procInstId' type='xsd:string'/>");
        wsdl.append("</message>");
        wsdl.append("<message name='pullResponse'>");
        wsdl.append("<part name='output' type='tns:output'/>");
        wsdl.append("</message>");
    }

    private static void addStateMessage(StringBuilder wsdl) {
        wsdl.append("<message name='state'>");
        wsdl.append("<part name='procInstId' type='xsd:string'/>");
        wsdl.append("</message>");
        wsdl.append("<message name='stateResponse'>");
        wsdl.append("<part name='state' type='xsd:string'/>");
        wsdl.append("</message>");
    }

    private static void addOuterTypes(String serviceURL, StringBuilder wsdl) {
        wsdl.append("<types>");
        wsdl.append("<xsd:schema>");
        wsdl.append("<xsd:import namespace='");
        wsdl.append(serviceURL);
        wsdl.append("' ");
        wsdl.append("schemaLocation='");
        wsdl.append(serviceURL);
        wsdl.append("?xsd'></xsd:import>");
        wsdl.append("</xsd:schema>");
        wsdl.append("</types>");
    }

    private static void addNameSpace(String procCode, String serviceURL, StringBuilder wsdl) {
        wsdl.append("<?xml version='1.0' encoding='UTF-8'?>");
        wsdl.append("<definitions");
        wsdl.append(" xmlns:soap='http://schemas.xmlsoap.org/wsdl/soap/'");
        wsdl.append(" xmlns:tns='").append(serviceURL).append("'");
        wsdl.append(" xmlns:xsd='http://www.w3.org/2001/XMLSchema'");
        wsdl.append(" xmlns='http://schemas.xmlsoap.org/wsdl/'");
        wsdl.append(" targetNamespace='").append(serviceURL).append("'");
        wsdl.append(" name='").append(procCode).append("'>");
    }

    private static void addPortType(String procCode, StringBuilder wsdl) {
        wsdl.append("<portType name='").append(procCode).append("'>");
        ProcessWsdl.addPortOperation("start", wsdl);
        ProcessWsdl.addPortOperation("pull", wsdl);
        ProcessWsdl.addPortOperation("state", wsdl);
        wsdl.append("</portType>");
    }

    private static void addPortOperation(String op, StringBuilder wsdl) {
        wsdl.append("<operation name='").append(op).append("'>");
        wsdl.append("<input message='tns:").append(op).append("'/>");
        wsdl.append("<output message='tns:").append(op).append("Response'/>");
        wsdl.append("</operation>");
    }

    private static void addServiceDeclaration(String procCode, String serviceURL, StringBuilder wsdl) {
        wsdl.append("<service name='").append(procCode).append("'>");
        wsdl.append("<port name='").append(procCode).append("'");
        wsdl.append(" binding='tns:").append(procCode).append("Binding'>");
        wsdl.append("<soap:address location='").append(serviceURL).append("'>");
        wsdl.append("</soap:address>");
        wsdl.append("</port>");
        wsdl.append("</service>");
    }

    private static void addBinding(String procCode, String serviceURL, StringBuilder wsdl) {
        wsdl.append("<binding name='").append(procCode).append("Binding'");
        wsdl.append(" type='tns:").append(procCode).append("'>");
        wsdl.append("<soap:binding");
        wsdl.append(" transport='http://schemas.xmlsoap.org/soap/http'");
        wsdl.append(" style='rpc'></soap:binding>");
        ProcessWsdl.addOperationBinding("start", serviceURL, wsdl);
        ProcessWsdl.addOperationBinding("pull", serviceURL, wsdl);
        ProcessWsdl.addOperationBinding("state", serviceURL, wsdl);
        wsdl.append("</binding>");
    }

    private static void addOperationBinding(String op, String serviceURL, StringBuilder wsdl) {
        wsdl.append("<operation name='").append(op).append("'>");
        wsdl.append("<soap:operation soapAction='").append(op).append("'/>");
        wsdl.append("<input>");
        wsdl.append("<soap:body use='literal' namespace='");
        wsdl.append(serviceURL);
        wsdl.append("'></soap:body>");
        wsdl.append("</input>");
        wsdl.append("<output>");
        wsdl.append("<soap:body use='literal' namespace='");
        wsdl.append(serviceURL);
        wsdl.append("'></soap:body>");
        wsdl.append("</output>");
        wsdl.append("</operation>");
    }
}

