/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.z.test;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.wrapper.InterfaceWrapper;
import com.kingdee.bos.workflow.engine.z.test.TestCase;
import com.kingdee.bos.workflow.engine.z.test.cases.AutomicProcessStart;
import com.kingdee.bos.workflow.engine.z.test.cases.EventProcessStart;
import com.kingdee.bos.workflow.engine.z.test.cases.ManualProcessStart;
import com.kingdee.bos.workflow.engine.z.test.cases.ManualProcessStartFirstAct;
import com.kingdee.bos.workflow.engine.z.test.cases.ManualProcessStartFirstActWithPerformer;
import com.kingdee.bos.workflow.engine.z.test.cases.ManualProcessSubmitFirstAct;
import com.kingdee.bos.workflow.engine.z.test.cases.TaskServiceSendProcessStart;
import com.kingdee.bos.workflow.engine.z.test.cases.WebBillProcessStart;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class TestStart
implements ServletContextListener,
IJobHandler {
    private static final long serialVersionUID = 1L;

    public static void registerCases(Context ctx) throws Exception {
        IJobService svc = JobServiceFactory.getLocalInstance((Context)ctx);
        TestStart.createJobDef(ctx, svc, new AutomicProcessStart());
        TestStart.createJobDef(ctx, svc, new ManualProcessStart());
        TestStart.createJobDef(ctx, svc, new ManualProcessStartFirstAct());
        TestStart.createJobDef(ctx, svc, new ManualProcessStartFirstActWithPerformer());
        TestStart.createJobDef(ctx, svc, new ManualProcessSubmitFirstAct());
        TestStart.createJobDef(ctx, svc, new WebBillProcessStart());
        TestStart.createJobDef(ctx, svc, new EventProcessStart());
        TestStart.createJobDef(ctx, svc, new TaskServiceSendProcessStart());
    }

    private static void createJobDef(Context ctx, IJobService svc, TestCase testCase) throws BOSException {
        InterfaceWrapper wrapper = new InterfaceWrapper((Object)testCase);
        JobDef def = new JobDef(testCase.getJobDefId(), ctx, TestStart.class.getPackage().getName(), testCase.getClass().getSimpleName(), null, null, null, true, (Wrapper)wrapper, false, null, 0, -1, JobIsolationLevel.Instance, null);
        svc.createJobDef(def);
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent arg0) {
        Job job = new Job(null, (IJobHandler)this, null, false);
        JobManager.instance().add(job);
    }

    public Object execute(Job job) throws Exception {
        String[] dcs = DbConnector.getDataCenters();
        for (int i = 0; i < dcs.length; ++i) {
            if (!ClusterStateManager.isReady((String)dcs[i])) continue;
            Context ctx = Ctx.getDefaultContext((String)dcs[i]);
            TestStart.registerCases(ctx);
            return null;
        }
        return new Delay(10);
    }
}

