/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ws.demo;

import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.util.CryptoTean;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EASLoginWS {
    public static final String EAS_DEFAULT_AUTH_PATTERN = "BaseDB";
    private static final Logger logger = Logger.getLogger((Class)EASLoginWS.class);

    public String login(String userName, String password, String dataCenterName, String language) {
        return this.loginMultiPattern(userName, password, dataCenterName, language, EAS_DEFAULT_AUTH_PATTERN);
    }

    public String loginMultiPattern(String userName, String password, String dataCenterName, String language, String authPattern) {
        String sessionId;
        String encodePwd = EASLoginWS.encodePassword(userName, password);
        try {
            String loginUrl = "tcp://localhost:" + ORMRPConfig.getTcpConnectionPort();
            ILoginModule loginModule = LoginModuleFactory.getRemoteInstance((String)loginUrl);
            if (loginModule == null) {
                return null;
            }
            Locale locale = new Locale(language);
            LoginContext ctx = new LoginContext(userName, encodePwd, "eas", dataCenterName, locale);
            ctx.put("UserAuthPattern", (Object)authPattern);
            try {
                sessionId = loginModule.login(ctx);
            }
            catch (RPCConnectException rpce) {
                RemoteBOSObjectFactory.getInstance((String)loginUrl).clearSession();
                loginModule = LoginModuleFactory.getRemoteInstance((String)loginUrl);
                sessionId = loginModule.login(ctx);
            }
            ORMRPCServiceLocator.setCurrentServiceURL((String)loginUrl);
        }
        catch (Throwable e) {
            logger.error((Object)"WebService login fail:", e);
            throw new RuntimeException(e);
        }
        return sessionId;
    }

    private static String encodePassword(String userName, String password) {
        String encodedPassword = null;
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (Exception e) {
            logger.error((Object)"encodePassword fail:", (Throwable)e);
        }
        if (encodedPassword == null) {
            encodedPassword = "";
        }
        return encodedPassword;
    }
}

