/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.chart.AxisGroup;
import com.kingdee.bos.ctrl.chart.AxisType;
import com.kingdee.bos.ctrl.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.Axes;
import com.kingdee.bos.ctrl.swing.chart.Axis;
import com.kingdee.bos.ctrl.swing.chart.BawDrawingSupplier;
import com.kingdee.bos.ctrl.swing.chart.ChartArea;
import com.kingdee.bos.ctrl.swing.chart.ChartData;
import com.kingdee.bos.ctrl.swing.chart.ChartDataUtil;
import com.kingdee.bos.ctrl.swing.chart.ChartGroup;
import com.kingdee.bos.ctrl.swing.chart.ChartGroups;
import com.kingdee.bos.ctrl.swing.chart.ChartTitle;
import com.kingdee.bos.ctrl.swing.chart.InterChartType;
import com.kingdee.bos.ctrl.swing.chart.Legend;
import com.kingdee.bos.ctrl.swing.chart.MajorType;
import com.kingdee.bos.ctrl.swing.chart.PlotArea;
import com.kingdee.bos.ctrl.swing.chart.Series;
import com.kingdee.bos.ctrl.swing.chart.SeriesCollection;
import com.kingdee.bos.ctrl.swing.chart.SubType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.KeyedValues;
import org.jfree.data.KeyedValues2D;
import org.jfree.data.PieDataset;
import org.jfree.data.XYDataset;

public class Chart
extends JPanel
implements com.kingdee.bos.ctrl.chart.Chart {
    private ChartType chartType;
    private boolean displayLegend = true;
    private boolean displayBlackAndWhite = false;
    protected ChartArea chartArea;
    protected PlotArea plotArea;
    protected ChartTitle chartTitle;
    protected Axes axes;
    protected Legend legend;
    protected SeriesCollection seriesCollection;
    protected ChartGroups chartGroups;
    private ChartData chartData;
    private InterChartType interChartType;
    private boolean initDefaults = false;
    private JFreeChart chart;
    private ChartPanel panel;

    public Chart() {
        this(ChartType.CT_COLUMNCLUSTERED);
    }

    public Chart(ChartType type) {
        this.setChartType(type);
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType type) {
        if (this.chartType == type) {
            return;
        }
        this.chartType = type;
        this.setInterChartType(InterChartType.getInterType(type));
        this.updatePlot();
    }

    public boolean isDisplayLegend() {
        return this.displayLegend;
    }

    public void setDisplayLegend(boolean b) {
        this.displayLegend = b;
        org.jfree.chart.Legend curLegend = this.chart.getLegend();
        if (this.displayLegend) {
            if (curLegend == null) {
                this.chart.setLegend(this.createLegend());
            }
        } else if (curLegend != null) {
            this.chart.setLegend(null);
        }
    }

    public void setDisplayBlackAndWhite(boolean baw) {
        if (this.displayBlackAndWhite == baw) {
            return;
        }
        this.displayBlackAndWhite = baw;
        this.updatePlot();
    }

    public boolean isDisplayBlackAndWhite() {
        return this.displayBlackAndWhite;
    }

    public ChartArea getChartArea() {
        return this.chartArea;
    }

    public PlotArea getPlotArea() {
        return this.plotArea;
    }

    public com.kingdee.bos.ctrl.chart.ChartTitle getChartTitle() {
        return this.chartTitle;
    }

    public com.kingdee.bos.ctrl.chart.Axis getAxis(AxisType type, AxisGroup axisGroup) {
        return this.axes.get(type, axisGroup);
    }

    public Legend getLegend() {
        return this.legend;
    }

    public Series getSeries(int index) {
        return this.seriesCollection.get(index);
    }

    public Series getSeries(Object key) {
        return this.seriesCollection.get(key);
    }

    public ChartGroup getChartGroup(int index) {
        return this.chartGroups.get(index);
    }

    public ChartGroup getChartGroup(Object key) {
        return this.chartGroups.get(key);
    }

    public void setChartData(String[] seriesKeys, String[] groupKeys, double[][] values) {
        this.chartData = new ChartData(seriesKeys, groupKeys, values);
        this.seriesCollection = this.chartData.getSeriesCollection();
        this.chartGroups = this.chartData.getChartGroups();
        this.updateData();
    }

    public BufferedImage createBufferedImage(int width, int height) {
        return this.chart.createBufferedImage(width, height);
    }

    public void saveAsPng(File file, int width, int height) {
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final String[] getSeriesKeys() {
        return this.chartData.getSeriesKeys();
    }

    public final String[] getGroupKeys() {
        return this.chartData.getGroupKeys();
    }

    public final double[][] getValues() {
        return this.chartData.getValues();
    }

    private void setInterChartType(InterChartType type) {
        this.interChartType = type;
    }

    private InterChartType getInterChartType() {
        return this.interChartType;
    }

    private void initDefaults() {
        if (this.initDefaults) {
            return;
        }
        this.chartArea = new ChartArea();
        this.plotArea = new PlotArea();
        this.chartTitle = new ChartTitle();
        this.axes = new Axes();
        Axis categoryAxis = new Axis();
        Axis valueAxis = new Axis();
        this.axes.add(AxisType.CATEGORY, AxisGroup.PRIMARY, categoryAxis);
        this.axes.add(AxisType.VALUE, AxisGroup.PRIMARY, valueAxis);
        this.legend = new Legend();
        this.setLayout(ChartLayout.createLayout());
        this.setPreferredSize(new Dimension(450, 300));
        this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        this.initDefaults = true;
    }

    private void initChartView() {
        this.chart = this.createChart();
        if (this.panel != null) {
            this.remove((Component)this.panel);
        }
        this.panel = new ChartPanel(this.chart);
        this.panel.setPopupMenu(null);
        this.add((Component)this.panel);
        this.validate();
        this.configDelegates(this.chart);
    }

    private void configDelegates(JFreeChart chart) {
        this.chartTitle.setDelegate(chart.getTitle());
        ValueAxis xAxis = null;
        ValueAxis yAxis = null;
        Plot plot = chart.getPlot();
        if (plot instanceof XYPlot) {
            XYPlot p = (XYPlot)plot;
            xAxis = p.getDomainAxis();
            yAxis = p.getRangeAxis();
            this.axes.get(AxisType.CATEGORY, AxisGroup.PRIMARY).setDelegate((org.jfree.chart.axis.Axis)xAxis);
            this.axes.get(AxisType.VALUE, AxisGroup.PRIMARY).setDelegate((org.jfree.chart.axis.Axis)yAxis);
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot p = (CategoryPlot)plot;
            xAxis = p.getDomainAxis();
            yAxis = p.getRangeAxis();
            this.axes.get(AxisType.CATEGORY, AxisGroup.PRIMARY).setDelegate((org.jfree.chart.axis.Axis)xAxis);
            this.axes.get(AxisType.VALUE, AxisGroup.PRIMARY).setDelegate((org.jfree.chart.axis.Axis)yAxis);
        }
        this.legend.setDelegate(chart.getLegend());
    }

    private void updatePlot() {
        this.initDefaults();
        this.initChartView();
        this.updateData();
    }

    JPanel getChartPanel() {
        return this.panel;
    }

    private JFreeChart createChart() {
        String title = this.getChartTitle().getText();
        String categoryLabel = this.getAxis(AxisType.CATEGORY, AxisGroup.PRIMARY).getTitle().getText();
        String valueLabel = this.getAxis(AxisType.VALUE, AxisGroup.PRIMARY).getTitle().getText();
        PlotOrientation orient = PlotOrientation.VERTICAL;
        boolean legend = this.isDisplayLegend();
        boolean tooltips = true;
        boolean urls = true;
        if (categoryLabel != null && categoryLabel.length() <= 0) {
            categoryLabel = null;
        }
        if (valueLabel != null && valueLabel.length() <= 0) {
            valueLabel = null;
        }
        InterChartType interType = this.getInterChartType();
        MajorType mt = interType.getMajorType();
        SubType st = interType.getSubType();
        JFreeChart chart = null;
        if (mt == MajorType.PIECHART) {
            chart = ChartFactory.createPieChart((String)title, null, (boolean)legend, (boolean)tooltips, (boolean)urls);
            if (this.isDisplayBlackAndWhite()) {
                chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
            }
        } else if (mt != MajorType.PIECHART_EXTRACT) {
            if (mt == MajorType.PIECHART3D) {
                chart = ChartFactory.createPieChart3D((String)title, null, (boolean)legend, (boolean)tooltips, (boolean)urls);
                Pie3DPlot plot = (Pie3DPlot)chart.getPlot();
                plot.setStartAngle(270.0);
                plot.setForegroundAlpha(0.75f);
                plot.setRadius(0.7);
                if (this.isDisplayBlackAndWhite()) {
                    plot.setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
                }
            } else if (mt != MajorType.AREACHART && mt != MajorType.STACKEDAREACHART) {
                if (mt == MajorType.BARCHART) {
                    chart = ChartFactory.createBarChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
                    if (this.isDisplayBlackAndWhite()) {
                        chart.getPlot().setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getDefault());
                    }
                } else if (mt != MajorType.STACKEDBARCHART && mt != MajorType.BARCHART3D && mt != MajorType.STACKEDBARCHART3D) {
                    if (mt == MajorType.LINECHART) {
                        chart = ChartFactory.createLineChart((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
                        CategoryPlot plot = chart.getCategoryPlot();
                        StandardLegend stdlegend = null;
                        if (legend) {
                            stdlegend = (StandardLegend)chart.getLegend();
                        }
                        if (st == SubType.LINEMARKERS || st == SubType.LINEMARKERSSTACKED) {
                            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
                            renderer.setDrawShapes(true);
                            if (stdlegend != null) {
                                stdlegend.setDisplaySeriesShapes(true);
                            }
                        }
                        if (this.isDisplayBlackAndWhite()) {
                            plot.setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getSolid());
                            if (stdlegend != null) {
                                stdlegend.setDisplaySeriesLines(true);
                            }
                        }
                    } else if (mt != MajorType.GANTTCHART && mt != MajorType.WATERFALLCHART && mt != MajorType.LINEXYCHART && mt != MajorType.XYLINECHART && mt != MajorType.AREAXYCHART && mt != MajorType.XYAREACHART) {
                        if (mt == MajorType.SCATTERPLOT) {
                            chart = ChartFactory.createScatterPlot((String)title, (String)categoryLabel, (String)valueLabel, null, (PlotOrientation)orient, (boolean)legend, (boolean)tooltips, (boolean)urls);
                            XYPlot plot = chart.getXYPlot();
                            StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
                            StandardLegend stdlegend = null;
                            if (legend) {
                                stdlegend = (StandardLegend)chart.getLegend();
                            }
                            if (st == SubType.SCATTERLINES) {
                                renderer.setPlotLines(true);
                            } else if (st == SubType.SCATTERNOMARKERS) {
                                renderer.setPlotShapes(false);
                                renderer.setPlotLines(true);
                            }
                            if (this.isDisplayBlackAndWhite()) {
                                plot.setDrawingSupplier((DrawingSupplier)BawDrawingSupplier.getSolid());
                            }
                            if (stdlegend != null && this.isDisplayBlackAndWhite()) {
                                if (st == SubType.SCATTERLINES) {
                                    stdlegend.setDisplaySeriesShapes(true);
                                    stdlegend.setDisplaySeriesLines(true);
                                } else if (st == SubType.SCATTERNOMARKERS) {
                                    stdlegend.setDisplaySeriesShapes(false);
                                    stdlegend.setDisplaySeriesLines(true);
                                } else {
                                    stdlegend.setDisplaySeriesShapes(true);
                                    stdlegend.setDisplaySeriesLines(false);
                                }
                            }
                        } else if (mt == MajorType.BUBBLECHART || mt == MajorType.WINDPLOT || mt == MajorType.TIMESERIESCHART || mt == MajorType.XYBARCHART || mt == MajorType.HIGHLOWCHART || mt == MajorType.HIGHLOWCHART_TIMELINE || mt == MajorType.CANDLESTICKCHART || mt == MajorType.SIGNALCHART || mt == MajorType.XYSTEPCHART || mt == MajorType.XYSTEPAREACHART || mt == MajorType.HISTOGRAM || mt == MajorType.STACKEDAREAXYCHART || mt != MajorType.BOXANDWHISKERCHART) {
                            // empty if block
                        }
                    }
                }
            }
        }
        return chart;
    }

    private void updateData() {
        boolean nullData = true;
        String[] seriesKeys = null;
        String[] groupKeys = null;
        double[][] values = null;
        if (this.chartData != null) {
            seriesKeys = this.chartData.getSeriesKeys();
            groupKeys = this.chartData.getGroupKeys();
            values = this.chartData.getValues();
            nullData = false;
        }
        InterChartType interType = this.getInterChartType();
        MajorType mt = interType.getMajorType();
        SubType st = interType.getSubType();
        if (mt == MajorType.PIECHART) {
            PiePlot plot = (PiePlot)this.chart.getPlot();
            PieDataset dataset = null;
            if (!nullData) {
                dataset = ChartDataUtil.createPieDataset(groupKeys, values[0]);
                this.seriesCollection.setDelegate((KeyedValues)dataset);
            }
            plot.setDataset(dataset);
        } else if (mt != MajorType.PIECHART_EXTRACT) {
            if (mt == MajorType.PIECHART3D) {
                Pie3DPlot plot = (Pie3DPlot)this.chart.getPlot();
                PieDataset dataset = null;
                if (!nullData) {
                    dataset = ChartDataUtil.createPieDataset(groupKeys, values[0]);
                    this.seriesCollection.setDelegate((KeyedValues)dataset);
                }
                plot.setDataset(dataset);
            } else if (mt != MajorType.AREACHART && mt != MajorType.STACKEDAREACHART) {
                if (mt == MajorType.BARCHART) {
                    CategoryPlot plot = this.chart.getCategoryPlot();
                    CategoryDataset dataset = null;
                    if (!nullData) {
                        dataset = ChartDataUtil.createCategoryDataset(groupKeys, seriesKeys, values);
                        this.seriesCollection.setDelegate((KeyedValues2D)dataset);
                    }
                    plot.setDataset(dataset);
                } else if (mt != MajorType.STACKEDBARCHART && mt != MajorType.BARCHART3D && mt != MajorType.STACKEDBARCHART3D) {
                    if (mt == MajorType.LINECHART) {
                        CategoryPlot plot = this.chart.getCategoryPlot();
                        CategoryDataset dataset = null;
                        if (!nullData) {
                            dataset = st == SubType.LINESTACKED || st == SubType.LINEMARKERSSTACKED ? ChartDataUtil.createStackedCategoryDataset(groupKeys, seriesKeys, values) : ChartDataUtil.createCategoryDataset(groupKeys, seriesKeys, values);
                            this.seriesCollection.setDelegate((KeyedValues2D)dataset);
                        }
                        plot.setDataset(dataset);
                    } else if (mt != MajorType.GANTTCHART && mt != MajorType.WATERFALLCHART && mt != MajorType.LINEXYCHART && mt != MajorType.XYLINECHART && mt != MajorType.AREAXYCHART && mt != MajorType.XYAREACHART) {
                        if (mt == MajorType.SCATTERPLOT) {
                            XYPlot plot = this.chart.getXYPlot();
                            XYDataset dataset = null;
                            if (!nullData) {
                                dataset = ChartDataUtil.createScatterDataset(seriesKeys, values);
                                this.seriesCollection.setDelegate(dataset);
                            }
                            plot.setDataset(dataset);
                        } else if (mt == MajorType.BUBBLECHART || mt == MajorType.WINDPLOT || mt == MajorType.TIMESERIESCHART || mt == MajorType.XYBARCHART || mt == MajorType.HIGHLOWCHART || mt == MajorType.HIGHLOWCHART_TIMELINE || mt == MajorType.CANDLESTICKCHART || mt == MajorType.SIGNALCHART || mt == MajorType.XYSTEPCHART || mt == MajorType.XYSTEPAREACHART || mt == MajorType.HISTOGRAM || mt == MajorType.STACKEDAREAXYCHART || mt != MajorType.BOXANDWHISKERCHART) {
                            // empty if block
                        }
                    }
                }
            }
        }
    }

    private org.jfree.chart.Legend createLegend() {
        InterChartType interType = this.getInterChartType();
        MajorType mt = interType.getMajorType();
        SubType st = interType.getSubType();
        StandardLegend stdlegend = (StandardLegend)org.jfree.chart.Legend.createInstance((JFreeChart)this.chart);
        if (mt != MajorType.PIECHART && mt != MajorType.PIECHART_EXTRACT && mt != MajorType.PIECHART3D && mt != MajorType.AREACHART && mt != MajorType.STACKEDAREACHART && mt != MajorType.BARCHART && mt != MajorType.STACKEDBARCHART && mt != MajorType.BARCHART3D && mt != MajorType.STACKEDBARCHART3D) {
            if (mt == MajorType.LINECHART) {
                if (st == SubType.LINEMARKERS || st == SubType.LINEMARKERSSTACKED) {
                    stdlegend.setDisplaySeriesShapes(true);
                }
                if (this.isDisplayBlackAndWhite()) {
                    stdlegend.setDisplaySeriesLines(true);
                }
            } else if (mt != MajorType.GANTTCHART && mt != MajorType.WATERFALLCHART && mt != MajorType.LINEXYCHART && mt != MajorType.XYLINECHART && mt != MajorType.AREAXYCHART && mt != MajorType.XYAREACHART) {
                if (mt == MajorType.SCATTERPLOT) {
                    if (this.isDisplayBlackAndWhite()) {
                        if (st == SubType.SCATTERLINES) {
                            stdlegend.setDisplaySeriesShapes(true);
                            stdlegend.setDisplaySeriesLines(true);
                        } else if (st == SubType.SCATTERNOMARKERS) {
                            stdlegend.setDisplaySeriesShapes(false);
                            stdlegend.setDisplaySeriesLines(true);
                        } else {
                            stdlegend.setDisplaySeriesShapes(true);
                            stdlegend.setDisplaySeriesLines(false);
                        }
                    }
                } else if (mt == MajorType.BUBBLECHART || mt == MajorType.WINDPLOT || mt == MajorType.TIMESERIESCHART || mt == MajorType.XYBARCHART || mt == MajorType.HIGHLOWCHART || mt == MajorType.HIGHLOWCHART_TIMELINE || mt == MajorType.CANDLESTICKCHART || mt == MajorType.SIGNALCHART || mt == MajorType.XYSTEPCHART || mt == MajorType.XYSTEPAREACHART || mt == MajorType.HISTOGRAM || mt == MajorType.STACKEDAREAXYCHART || mt != MajorType.BOXANDWHISKERCHART) {
                    // empty if block
                }
            }
        }
        return stdlegend;
    }

    static class ChartLayout
    implements LayoutManager {
        public static final ChartLayout layout = new ChartLayout();

        ChartLayout() {
        }

        public static ChartLayout createLayout() {
            return layout;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Chart chart = (Chart)parent;
            JPanel pane = chart.getChartPanel();
            if (pane != null) {
                Insets insets = chart.getInsets();
                int w = chart.getWidth();
                int h = chart.getHeight();
                pane.setBounds(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(10, 10);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(450, 300);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

