/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialGraduator;
import com.kingdee.bos.ctrl.swing.dial.DialScale;
import com.kingdee.bos.ctrl.swing.dial.DialTickValueGenerator;
import com.kingdee.bos.ctrl.swing.dial.KpiRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;

public class KpiScale
extends DialScale {
    protected boolean drawLabel = true;
    protected Font labelFont = new Font("Arial", 1, 11);
    protected static final Paint DEFAULTPAINT = new Color(0x414142);
    protected static final Paint NORMALPAINT = Color.GREEN;
    protected static final Paint WARNINGPAINT = Color.YELLOW;
    protected static final Paint CRITICALPAINT = Color.RED;
    protected Paint defaultPaint = DEFAULTPAINT;
    protected Paint normalPaint = NORMALPAINT;
    protected Paint warningPaint = WARNINGPAINT;
    protected Paint criticalPaint = CRITICALPAINT;
    protected Paint labelShadowPaint = this.defaultPaint;
    protected static final double SCALEPOS = 0.8615384615384615;
    protected static final double TICKSWIDTH = 0.12307692307692308;
    protected static final int RADIUSMEDIUM = 60;
    public static final int TOTAL = 0;
    public static final int NORMAL = 1;
    public static final int WARNING = 2;
    public static final int CRITICAL = 3;
    protected Ranges nrs = new Ranges();
    protected Ranges wrs = new Ranges();
    protected Ranges crs = new Ranges();

    public KpiScale() {
    }

    public KpiScale(Point pt, int r) {
        super(pt, r);
    }

    public KpiScale(Point pt, int r, int minAngle, int arcAngle) {
        super(pt, r, minAngle, arcAngle);
    }

    public KpiScale(Point pt, int r, int minAngle, int arcAngle, boolean cw) {
        super(pt, r, minAngle, arcAngle, cw);
    }

    public void setMaximumValue(Object maxValue) {
        if (maxValue instanceof Number) {
            this.maximumValue = new Double(((Number)maxValue).doubleValue());
            this.setDirty(true);
        }
    }

    public void setMinimumValue(Object minValue) {
        if (minValue instanceof Number) {
            this.minimumValue = new Double(((Number)minValue).doubleValue());
            this.setDirty(true);
        }
    }

    public void setTotalRange(KpiRange range) {
        if (range == null) {
            range = new KpiRange(0.0, 0.0);
        }
        this.setMinimumValue(new Double(range.getLowerBound()));
        this.setMaximumValue(new Double(range.getUpperBound()));
    }

    public void setNormalRange(KpiRange range) {
        this.clearRanges(1);
        this.addRange(range, 1);
    }

    public void setWarningRange(KpiRange range) {
        this.clearRanges(2);
        this.addRange(range, 2);
    }

    public void setCriticalRange(KpiRange range) {
        this.clearRanges(3);
        this.addRange(range, 3);
    }

    public KpiRange getTotalRange() {
        Double min = (Double)this.getMinimumValue();
        Double max = (Double)this.getMaximumValue();
        if (min == null || max == null) {
            return null;
        }
        return new KpiRange(min, max);
    }

    public KpiRange getNormalRange() {
        return this.getRange(1);
    }

    public KpiRange getWarningRange() {
        return this.getRange(2);
    }

    public KpiRange getCriticalRange() {
        return this.getRange(3);
    }

    public KpiRange getRange(int type) {
        if (type == 0) {
            return this.getTotalRange();
        }
        Ranges rs = null;
        rs = this.getRangesAsObject(type);
        if (rs != null && rs.size() > 0) {
            return rs.get(0);
        }
        return null;
    }

    public void setRange(KpiRange range, int type) {
        switch (type) {
            case 0: {
                this.setTotalRange(range);
                break;
            }
            case 1: {
                this.setNormalRange(range);
                break;
            }
            case 2: {
                this.setWarningRange(range);
                break;
            }
            case 3: {
                this.setCriticalRange(range);
            }
        }
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    protected Paint getBackgroundPaint() {
        return Color.DARK_GRAY;
    }

    public void setDefaultPaint(Paint paint) {
        this.defaultPaint = paint;
    }

    public void setNormalPaint(Paint p) {
        this.normalPaint = p;
    }

    public void setWarningPaint(Paint p) {
        this.warningPaint = p;
    }

    public void setCriticalPaint(Paint p) {
        this.criticalPaint = p;
    }

    public Paint getNormalPaint() {
        return this.normalPaint;
    }

    public Paint getWarningPaint() {
        return this.warningPaint;
    }

    public Paint getCriticalPaint() {
        return this.criticalPaint;
    }

    public Paint getPaint(int type) {
        Paint paint = null;
        switch (type) {
            case 0: {
                paint = this.getDefaultPaint();
                break;
            }
            case 1: {
                paint = this.getNormalPaint();
                break;
            }
            case 2: {
                paint = this.getWarningPaint();
                break;
            }
            case 3: {
                paint = this.getCriticalPaint();
            }
        }
        return paint;
    }

    public void setPaint(Paint paint, int type) {
        switch (type) {
            case 0: {
                this.setDefaultPaint(paint);
                break;
            }
            case 1: {
                this.setNormalPaint(paint);
                break;
            }
            case 2: {
                this.setWarningPaint(paint);
                break;
            }
            case 3: {
                this.setCriticalPaint(paint);
            }
        }
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
    }

    protected DialTickValueGenerator createGenerator() {
        return new KpiTicker();
    }

    protected void drawTicks(Graphics2D g2, double amin, double as, JComponent c) {
        Paint oldPaint = g2.getPaint();
        Font oldFont = g2.getFont();
        g2.setFont(this.labelFont);
        int LOWANGLE = 20;
        int UPANGLE = 160;
        int GAP = 2;
        int tickLen = this.getTickLength();
        Format ft = this.getTickLabelFormat();
        String label = "";
        FontMetrics fm = g2.getFontMetrics();
        int w = 0;
        int h = fm.getAscent() - fm.getLeading();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double rcos = 0.0;
        double rsin = 0.0;
        int r = this.getRadius();
        double angle = 0.0;
        double temp = 0.0;
        Object val = null;
        while (this.generator.hasNext()) {
            val = this.generator.next();
            angle = this.getAngle(val);
            rcos = Math.cos(Math.toRadians(angle));
            rsin = Math.sin(Math.toRadians(angle));
            x1 = (double)this.getAxle().x - rcos * (double)r;
            y1 = (double)this.getAxle().y - rsin * (double)r;
            x2 = (double)this.getAxle().x - rcos * (double)(r - tickLen);
            y2 = (double)this.getAxle().y - rsin * (double)(r - tickLen);
            g2.setPaint(this.getTicksPaint());
            g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            if (!this.isTickLabelVisible() || !this.isDrawLabel()) continue;
            label = ft != null ? ft.format(val) : val.toString();
            w = fm.stringWidth(label);
            angle = Math.abs(angle % 180.0);
            temp = angle > 20.0 && angle < 160.0 ? (double)h / (2.0 * rsin) : (double)w / (2.0 * rcos);
            temp = Math.abs(temp) + 2.0;
            x3 = x2 + temp * rcos;
            y3 = y2 + temp * rsin;
            x3 -= (double)(w / 2);
            if ((y3 += (double)(h / 2)) >= (double)this.getAxle().y && y3 <= (double)(this.getAxle().y + h / 2)) {
                y3 = this.getAxle().y;
            }
            g2.setPaint(this.getLabelShadowPaint());
            g2.drawString(label, (float)x3, (float)y3);
            g2.setPaint(this.getTickLabelPaint());
            g2.drawString(label, (float)x3 - 1.0f, (float)y3 - 1.0f);
        }
        g2.setPaint(oldPaint);
        g2.setFont(oldFont);
    }

    protected void drawArcs(Graphics2D g2, double start, double arc, JComponent c) {
        int r = this.getRadius();
        int x = this.getAxle().x;
        int y = this.getAxle().y;
        int w = this.getTickLength();
        r -= w / 2;
        Stroke old = g2.getStroke();
        BasicStroke stk = new BasicStroke(w, 0, 2);
        g2.setStroke(stk);
        Paint paint = null;
        paint = this.getDefaultPaint();
        start = 0.0;
        arc = 180.0;
        this.drawArc(g2, x, y, r, start, arc, paint);
        paint = this.getDefaultPaint();
        start = this.graduator.getAngle(this.getMinimumValue());
        arc = this.graduator.getAngle(this.getMaximumValue()) - start;
        this.drawArc(g2, x, y, r, start, arc, paint);
        if (--w < 1) {
            w = 1;
        }
        stk = new BasicStroke(w, 0, 2);
        g2.setStroke(stk);
        this.drawArc(g2, x, y, r, 1);
        this.drawArc(g2, x, y, r, 2);
        this.drawArc(g2, x, y, r, 3);
        g2.setStroke(old);
    }

    private void drawArc(Graphics2D g2, int x, int y, int r, int type) {
        KpiRange range = null;
        Paint paint = null;
        double start = 0.0;
        double arc = 0.0;
        Ranges rs = this.getRangesAsObject(type);
        if (rs != null) {
            int i = 0;
            while (i < rs.size()) {
                range = rs.get(i);
                if (range != null) {
                    paint = this.getPaint(type);
                    start = this.graduator.getAngle(new Double(range.getLowerBound()));
                    arc = this.graduator.getAngle(new Double(range.getUpperBound())) - start;
                    this.drawArc(g2, x, y, r, start, arc, paint);
                }
                ++i;
            }
        }
    }

    private void drawArc(Graphics2D g2, int x, int y, int r, double start, double arc, Paint paint) {
        g2.setPaint(paint);
        Arc2D.Double arcShape = null;
        arcShape = this.isClockWise() ? new Arc2D.Double(x - r, y - r, 2 * r, 2 * r, DialScale.DialUtils.cwToGeom(start, arc), arc, 0) : new Arc2D.Double(x - r, y - r, 2 * r, 2 * r, start, arc, 0);
        g2.draw(arcShape);
    }

    public void draw(Graphics g, Rectangle area, JComponent c) {
        int panRadius = area.width / 2;
        int sclRadius = (int)(0.8615384615384615 * (double)panRadius);
        int tickWidth = (int)(0.12307692307692308 * (double)panRadius) + 1;
        int x = area.x + panRadius;
        int y = area.y + panRadius;
        if (panRadius < 60) {
            this.setDrawLabel(false);
        } else {
            this.setDrawLabel(true);
        }
        this.setRadius(sclRadius);
        this.setAxle(new Point(x, y));
        this.setTickLength(tickWidth);
        if (this.isDirty()) {
            this.normalizeRange();
        }
        super.draw(g, area, c);
    }

    private void normalizeRange() {
        ArrayList<Double> values = new ArrayList<Double>();
        int[] types = new int[]{1, 2, 3};
        KpiRange[] rs = null;
        Double value = null;
        KpiGraduator graduator = (KpiGraduator)this.getGraduator();
        KpiTicker generator = (KpiTicker)this.getGenerator();
        int t = 0;
        while (t < types.length) {
            rs = this.getRanges(types[t]);
            if (rs != null) {
                int i = 0;
                while (i < rs.length) {
                    if (rs[i] != null) {
                        value = new Double(rs[i].getLowerBound());
                        if (!values.contains(value)) {
                            values.add(value);
                        }
                        if (!values.contains(value = new Double(rs[i].getUpperBound()))) {
                            values.add(value);
                        }
                    }
                    ++i;
                }
            }
            ++t;
        }
        double vmin = 0.0;
        double vmax = 0.0;
        if (values.size() <= 0) {
            vmin = Double.POSITIVE_INFINITY;
            vmax = Double.NEGATIVE_INFINITY;
        } else {
            Collections.sort(values);
            vmin = (Double)values.get(0);
            vmax = (Double)values.get(values.size() - 1);
        }
        boolean changed = false;
        KpiRange r = this.getTotalRange();
        if (r == null) {
            r = new KpiRange(0.0, 0.0);
            changed = true;
        }
        double rmin = r.getLowerBound();
        double rmax = r.getUpperBound();
        if (rmin > vmin) {
            rmin = vmin;
            changed = true;
        }
        if (rmax < vmax) {
            rmax = vmax;
            changed = true;
        }
        if (changed) {
            this.setTotalRange(new KpiRange(rmin, rmax));
        }
        value = new Double(rmin);
        if (values.isEmpty() || !values.get(0).equals(value)) {
            values.add(0, value);
        }
        value = new Double(rmax);
        if (values.isEmpty() || !values.get(values.size() - 1).equals(value)) {
            values.add(value);
        }
        double SCALE = 0.15;
        if (graduator != null || generator != null) {
            short temp = this.trimInfinity(values);
            Double fmin = null;
            Double fmax = null;
            if (temp != 0) {
                int size = values.size();
                double delta = 0.0;
                double left = 0.0;
                double right = 0.0;
                if (temp == 3) {
                    left = 1.0;
                    right = 1.0;
                } else if (temp == 1) {
                    left = 1.0;
                } else if (temp == 2) {
                    right = 1.0;
                }
                double DEFAULTMIN = 0.0;
                double DEFAULTMAX = 100.0;
                double DEFAULTDELTA = 100.0;
                if (size > 1) {
                    vmin = (Double)values.get(0);
                    vmax = (Double)values.get(values.size() - 1);
                } else if (size == 1) {
                    vmax = vmin = ((Double)values.get(0)).doubleValue();
                } else {
                    vmin = 0.0;
                    vmax = 100.0;
                }
                delta = (vmax - vmin) * 0.15;
                if (delta == 0.0) {
                    delta = 100.0;
                }
                fmin = new Double(vmin - delta * left);
                fmax = new Double(vmax + delta * right);
            } else {
                fmin = null;
                fmax = null;
            }
            if (graduator != null) {
                graduator.setFinite(fmin, fmax);
            }
            if (generator != null) {
                generator.setFinite(fmin, fmax);
            }
        }
    }

    private short trimInfinity(List values) {
        short ret = 0;
        if (values.remove(KpiRange.INFINITESIMAL)) {
            ret = 1;
        }
        if (values.remove(KpiRange.INFINITY)) {
            ret = (short)(ret | 2);
        }
        return ret;
    }

    protected boolean isDrawLabel() {
        return this.drawLabel;
    }

    protected void setDrawLabel(boolean b) {
        this.drawLabel = b;
    }

    public void addRange(KpiRange range, int type) {
        if (type == 0) {
            this.setTotalRange(range);
        } else {
            Ranges rs = this.getRangesAsObject(type);
            if (rs != null) {
                rs.addRange(range);
                this.setDirty(true);
            }
        }
    }

    public void removeRange(KpiRange range, int type) {
        if (type == 0) {
            KpiRange total = this.getTotalRange();
            if (total != null && total.equals(range)) {
                this.setTotalRange(null);
            }
        } else {
            Ranges rs = this.getRangesAsObject(type);
            if (rs != null) {
                rs.removeRange(range);
                this.setDirty(true);
            }
        }
    }

    public void clearRanges(int type) {
        if (type == 0) {
            this.setTotalRange(null);
        } else {
            Ranges rs = this.getRangesAsObject(type);
            if (rs != null) {
                rs.clear();
                this.setDirty(true);
            }
        }
    }

    public KpiRange[] getRanges(int type) {
        if (type == 0) {
            return new KpiRange[]{this.getTotalRange()};
        }
        Ranges rs = this.getRangesAsObject(type);
        if (rs != null) {
            return rs.toArray();
        }
        return null;
    }

    private Ranges getRangesAsObject(int type) {
        Ranges rs = null;
        switch (type) {
            case 1: {
                rs = this.nrs;
                break;
            }
            case 2: {
                rs = this.wrs;
                break;
            }
            case 3: {
                rs = this.crs;
            }
        }
        return rs;
    }

    public double getAngle(Object value) {
        double angle = super.getAngle(value);
        if (angle > 180.0) {
            return 180.0;
        }
        if (angle < 0.0) {
            return 0.0;
        }
        return angle;
    }

    protected DialGraduator createGraduator() {
        return new KpiGraduator();
    }

    public static class KpiGraduator
    extends DialGraduator {
        private Double finiteMin = null;
        private Double finiteMax = null;

        public double getAngle(Object value) {
            double v = 0.0;
            if (value instanceof Number) {
                v = ((Number)value).doubleValue();
                if (this.finiteMin != null && v < this.finiteMin) {
                    return 0.0;
                }
                if (this.finiteMax != null && v > this.finiteMax) {
                    return 180.0;
                }
            }
            return super.getAngle(value);
        }

        public void setParameters(Object vmin, Object vmax, double as) {
            if (this.finiteMin != null) {
                vmin = this.finiteMin;
            }
            if (this.finiteMax != null) {
                vmax = this.finiteMax;
            }
            super.setParameters(vmin, vmax, as);
        }

        public void setFinite(Double vmin, Double vmax) {
            this.finiteMin = vmin;
            this.finiteMax = vmax;
        }
    }

    public class KpiTicker
    implements DialTickValueGenerator {
        private Double finiteMin = null;
        private Double finiteMax = null;
        private int index = 0;
        private List values = new ArrayList();
        private static final int TICKSCOUNT = 10;

        public boolean hasNext() {
            if (this.index > 0) {
                return true;
            }
            this.reverse();
            return false;
        }

        public Object next() {
            --this.index;
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
            return this.values.get(this.index);
        }

        public void setParameters(Object min, Object max) {
            this.values.clear();
            this.index = 0;
            if (min.equals(max)) {
                return;
            }
            this.addValue(1);
            this.addValue(2);
            this.addValue(3);
            if (this.values.isEmpty()) {
                int mini = ((Number)min).intValue();
                int maxi = ((Number)max).intValue();
                if (this.finiteMin != null) {
                    mini = this.finiteMin.intValue();
                }
                if (this.finiteMax != null) {
                    maxi = this.finiteMax.intValue();
                }
                long step = ((long)maxi - (long)mini) / 10L;
                long temp = (long)mini - (long)mini % (step = this.getStdStep(step));
                if (temp <= (long)mini) {
                    temp += step;
                }
                while (temp < (long)maxi) {
                    this.values.add(new Double(temp));
                    temp += step;
                }
            }
            this.addValue(new KpiRange((Double)min, (Double)max));
            this.reverse();
        }

        private long getStdStep(long step) {
            if (step == 0L) {
                return 1L;
            }
            int STD_STEP2 = 2;
            int STD_STEP5 = 5;
            int STD_STEP10 = 10;
            int n = 0;
            while (step > 14L) {
                step /= 10L;
                ++n;
            }
            step = step <= 3L ? 2L : (step <= 7L ? 5L : 10L);
            int i = 0;
            while (i < n) {
                step *= 10L;
                ++i;
            }
            return step;
        }

        private void addValue(int type) {
            Ranges rs = KpiScale.this.getRangesAsObject(type);
            if (rs != null) {
                KpiRange range = null;
                int i = 0;
                while (i < rs.size()) {
                    range = rs.get(i);
                    if (range != null) {
                        this.addValue(range);
                    }
                    ++i;
                }
            }
        }

        private void addValue(KpiRange range) {
            Double val = null;
            if (range != null) {
                val = new Double(range.getLowerBound());
                if (this.values.indexOf(val) == -1) {
                    this.values.add(val);
                }
                if (this.values.indexOf(val = new Double(range.getUpperBound())) == -1) {
                    this.values.add(val);
                }
            }
        }

        private void reverse() {
            this.index = this.values.size();
        }

        public void setFinite(Double vmin, Double vmax) {
            this.finiteMin = vmin;
            this.finiteMax = vmax;
        }
    }

    private static interface DomainType {
        public static final short CLOSE = 0;
        public static final short INFINITESIMAL = 1;
        public static final short INFINITY = 2;
        public static final short BOTHOPEN = 3;
    }

    protected static class Ranges {
        private List ranges;

        protected Ranges() {
        }

        public void addRange(KpiRange range) {
            if (range == null) {
                return;
            }
            if (this.ranges == null) {
                this.ranges = new ArrayList(1);
            }
            boolean toAdd = true;
            int i = 0;
            while (i < this.ranges.size()) {
                if (((KpiRange)this.ranges.get(i)).equals(range)) {
                    toAdd = false;
                    break;
                }
                ++i;
            }
            if (toAdd) {
                this.ranges.add(range);
            }
        }

        public void removeRange(KpiRange range) {
            if (this.ranges == null) {
                return;
            }
            int i = 0;
            while (i < this.ranges.size()) {
                if (((KpiRange)this.ranges.get(i)).equals(range)) {
                    this.ranges.remove(i);
                }
                ++i;
            }
        }

        public void clear() {
            if (this.ranges == null) {
                return;
            }
            this.ranges.clear();
        }

        public int size() {
            if (this.ranges == null) {
                return 0;
            }
            return this.ranges.size();
        }

        public KpiRange get(int index) {
            if (this.ranges == null) {
                return null;
            }
            return (KpiRange)this.ranges.get(index);
        }

        public KpiRange[] toArray() {
            int size = this.size();
            if (size <= 0) {
                return null;
            }
            KpiRange[] krs = new KpiRange[size];
            int i = 0;
            while (i < this.ranges.size()) {
                krs[i] = (KpiRange)this.ranges.get(i);
                ++i;
            }
            return krs;
        }
    }
}

