/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.ButtonGroup;
import com.kingdee.bos.web.anole.controls.ButtonModel;
import com.kingdee.bos.web.anole.event.ActionEvent;
import com.kingdee.bos.web.anole.event.ActionListener;
import com.kingdee.bos.web.anole.event.ChangeEvent;
import com.kingdee.bos.web.anole.event.ChangeListener;
import com.kingdee.bos.web.anole.event.EventListenerList;
import com.kingdee.bos.web.anole.event.ItemEvent;
import com.kingdee.bos.web.anole.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;

public class DefaultButtonModel
implements ButtonModel,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ARMED = 1;
    public static final int SELECTED = 2;
    public static final int PRESSED = 4;
    public static final int ENABLED = 8;
    public static final int ROLLOVER = 16;
    protected int stateMask = 0;
    protected String actionCommand = null;
    protected ButtonGroup group = null;
    protected int mnemonic = 0;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DefaultButtonModel() {
        this.setEnabled(true);
    }

    public boolean isArmed() {
        return (this.stateMask & 1) != 0;
    }

    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    public boolean isEnabled() {
        return (this.stateMask & 8) != 0;
    }

    public boolean isPressed() {
        return (this.stateMask & 4) != 0;
    }

    public boolean isRollover() {
        return (this.stateMask & 0x10) != 0;
    }

    public void setArmed(boolean b) {
        if (this.isArmed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    public void setSelected(boolean b) {
        if (this.isSelected() == b) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireItemStateChanged(new ItemEvent(this, 701, this, b ? 1 : 2));
        this.fireStateChanged();
    }

    public void setEnabled(boolean b) {
        if (this.isEnabled() == b) {
            return;
        }
        if (b) {
            this.stateMask |= 8;
        } else {
            this.stateMask &= 0xFFFFFFF7;
            this.stateMask &= 0xFFFFFFFE;
            this.stateMask &= 0xFFFFFFFB;
        }
        this.fireStateChanged();
    }

    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!this.isPressed() && this.isArmed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), 0L, 0));
        }
        this.fireStateChanged();
    }

    public void setRollover(boolean b) {
        if (this.isRollover() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    public void setActionCommand(String s) {
        this.actionCommand = s;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }

    public void setGroup(ButtonGroup group) {
        this.group = group;
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.removeListener(clazz, l);
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.removeListener(clazz, l);
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.kingdee.bos.web.anole.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.kingdee.bos.web.anole.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.removeListener(clazz, l);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    protected void fireActionPerformed(ActionEvent e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.listenerList.getListeners(clazz);
        int i = listeners.length - 1;
        while (i >= 0) {
            ((ActionListener)listeners[i]).actionPerformed(e);
            --i;
        }
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.listenerList.getListeners(clazz);
        int i = listeners.length - 1;
        while (i >= 0) {
            ((ItemListener)listeners[i]).itemStateChanged(e);
            --i;
        }
    }

    protected void fireStateChanged() {
    }
}

