/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.AbstractListModel;
import com.kingdee.bos.web.anole.controls.MutableComboBoxModel;
import java.io.Serializable;
import java.util.Vector;

public class DefaultComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private static final long serialVersionUID = 1L;
    Vector objects;
    Object selectedObject;

    public DefaultComboBoxModel() {
        this.objects = new Vector();
    }

    public DefaultComboBoxModel(Object[] items) {
        this.objects = new Vector();
        this.objects.ensureCapacity(items.length);
        int i = 0;
        int c = items.length;
        while (i < c) {
            this.objects.addElement(items[i]);
            ++i;
        }
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public DefaultComboBoxModel(Vector v) {
        this.objects = v;
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.objects.size();
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.elementAt(index);
        }
        return null;
    }

    public int getIndexOf(Object anObject) {
        return this.objects.indexOf(anObject);
    }

    public void addElement(Object anObject) {
        this.objects.addElement(anObject);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.objects.size() == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.objects.insertElementAt(anObject, index);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.objects.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElement(Object anObject) {
        int index = this.objects.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.objects.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.objects.size() - 1;
            this.objects.removeAllElements();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedObject = null;
        }
    }
}

