/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.Document;
import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.plaf.TextUI;
import com.kingdee.bos.web.anole.runtime.RequestOptions;
import com.kingdee.bos.web.anole.style.Color;
import com.kingdee.bos.web.anole.utils.CharsetConvertor;

public abstract class KDTextComponent
extends KDComponent {
    private Document model;
    private Color selectedTextColor;
    private Color selectionColor;
    private Color disabledTextColor;
    private boolean editable;

    public KDTextComponent() {
        this.setEditable(true);
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((TextUI)this.UIManager.getUI(this));
        this.invalidate();
    }

    public void setDocument(Document doc) {
        Document old = this.model;
        this.model = doc;
        this.firePropertyChange("document", old, doc);
    }

    public Document getDocument() {
        return this.model;
    }

    public String getSelectedText() {
        return this.model.getText();
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color c) {
        Color old = this.selectedTextColor;
        this.selectedTextColor = c;
        this.firePropertyChange("selectedTextColor", old, this.selectedTextColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color c) {
        Color old = this.selectionColor;
        this.selectionColor = c;
        this.firePropertyChange("selectionColor", old, this.selectionColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color c) {
        Color old = this.disabledTextColor;
        this.disabledTextColor = c;
        this.firePropertyChange("disabledTextColor", old, this.disabledTextColor);
    }

    public String getText() {
        return this.model.getText();
    }

    public String getText(int start, int length) {
        return this.model.getText(start, length);
    }

    public void setText(String t) {
        this.model.setText(t);
    }

    public void setEditable(boolean b) {
        if (b != this.editable) {
            boolean oldVal = this.editable;
            this.editable = b;
            this.firePropertyChange("editable", (Object)oldVal, (Object)this.editable);
        }
    }

    public void updateContent(RequestOptions opt) {
        super.updateContent(opt);
        String strText = opt.getParameter(this.getIdentifier());
        if (strText != null) {
            String charset = this.getAppInstance().getLocaleInfo().getCharset();
            strText = CharsetConvertor.convertEncoding(strText, charset);
            this.setText(strText);
        }
    }
}

