/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.ButtonGroup;
import com.kingdee.bos.web.anole.controls.DefaultButtonModel;
import com.kingdee.bos.web.anole.controls.KDAbstractButton;
import com.kingdee.bos.web.anole.event.ItemEvent;
import com.kingdee.bos.web.anole.image.Icon;
import com.kingdee.bos.web.anole.plaf.ButtonUI;
import com.kingdee.bos.web.anole.runtime.RequestOptions;
import com.kingdee.bos.web.anole.utils.CharsetConvertor;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

public class KDToggleButton
extends KDAbstractButton
implements Accessible {
    private static final String uiClassID = "ToggleButtonUI";

    public KDToggleButton() {
        this(null, null, false);
    }

    public KDToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public KDToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public KDToggleButton(String text) {
        this(text, null, false);
    }

    public KDToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public KDToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public KDToggleButton(String text, Icon icon, boolean selected) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(selected);
        this.init(text, icon);
    }

    public int getLength() {
        if (this.getText() != null) {
            return this.getText().length();
        }
        return 0;
    }

    public void updateUI() {
        this.setUI((ButtonUI)this.UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateContent(RequestOptions opt) {
        super.updateContent(opt);
        String strText = this.getModel().getGroup() != null ? opt.getParameter(this.getModel().getGroup().getName()) : opt.getParameter(this.getIdentifier());
        if (strText != null) {
            this.setSelected((strText = CharsetConvertor.convertEncoding(strText, this.getAppInstance().getLocaleInfo().getCharset())).equals(this.getText()));
        }
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = 1L;

        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }
}

