/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY = new Object[0];
    private static final EventListener[] NO_LISTENERS = new EventListener[0];
    private static final int INCREMENT = 3;
    private static final int DECREMENT = 5;
    private transient Object[] listeners = EMPTY;
    private transient int size = 0;

    public void addListener(Class listenerClass, EventListener l) {
        if (this.size * 2 == this.listeners.length) {
            Object[] newListeners = new Object[this.listeners.length + 6];
            System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            this.listeners = newListeners;
        }
        this.listeners[this.size * 2] = listenerClass;
        this.listeners[this.size * 2 + 1] = l;
        ++this.size;
    }

    public int getListenerCount(Class listenerClass) {
        int count = 0;
        int index = 0;
        while (index < this.size) {
            if (this.listeners[index * 2] == listenerClass) {
                ++count;
            }
            ++index;
        }
        return count;
    }

    public EventListener[] getListeners(Class listenerClass) {
        int listenerCount = this.getListenerCount(listenerClass);
        if (listenerCount == 0) {
            return NO_LISTENERS;
        }
        EventListener[] matchingListeners = new EventListener[listenerCount];
        int matchIndex = 0;
        int index = 0;
        while (index < this.size) {
            if (this.listeners[index * 2] == listenerClass) {
                matchingListeners[matchIndex++] = (EventListener)this.listeners[index * 2 + 1];
            }
            ++index;
        }
        return matchingListeners;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.listeners = EMPTY;
        this.size = 0;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object listenerClassName = in.readObject();
        while (listenerClassName != null) {
            EventListener listener = (EventListener)in.readObject();
            this.addListener(Class.forName((String)listenerClassName, true, classLoader), listener);
            listenerClassName = in.readObject();
        }
    }

    public void removeListener(Class listenerClass, EventListener l) {
        int index = 0;
        while (index < this.size) {
            if (this.listeners[index * 2] == listenerClass && this.listeners[index * 2 + 1] == l) {
                this.listeners[index * 2] = this.listeners[(this.size - 1) * 2];
                this.listeners[index * 2 + 1] = this.listeners[(this.size - 1) * 2 + 1];
                --this.size;
                break;
            }
            ++index;
        }
        if (this.size == 0) {
            this.listeners = EMPTY;
        } else if (this.listeners.length / 2 - this.size > 5) {
            Object[] newListeners = new Object[this.size * 2];
            System.arraycopy(this.listeners, 0, newListeners, 0, newListeners.length);
            this.listeners = newListeners;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int index = 0;
        while (index < this.size) {
            String listenerClassName = ((Class)this.listeners[index * 2]).getName();
            EventListener listener = (EventListener)this.listeners[index * 2 + 1];
            if (listener instanceof Serializable) {
                out.writeObject(listenerClassName);
                out.writeObject(listener);
            }
            ++index;
        }
        out.writeObject(null);
    }
}

