/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.layout;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.KDContainer;
import com.kingdee.bos.web.anole.layout.LayoutManager2;
import com.kingdee.bos.web.anole.layout.XYConstraints;
import com.kingdee.bos.web.anole.layout.render.ILayoutRender;
import com.kingdee.bos.web.anole.style.Dimension;
import com.kingdee.bos.web.anole.style.Insets;
import com.kingdee.bos.web.anole.style.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class XYLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 200L;
    private int width;
    private int height;
    private Hashtable info;
    private static final XYConstraints defaultConstraints = new XYConstraints();

    public XYLayout() {
    }

    public XYLayout(int width, int height) {
        this.info = new Hashtable();
        this.width = width;
        this.height = height;
    }

    public void addLayoutComponent(KDComponent comp, Object constraints) {
        if (constraints instanceof XYConstraints) {
            this.info.put(comp, constraints);
        }
    }

    public Dimension maximumLayoutSize(KDContainer target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(KDContainer target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(KDContainer target) {
        return 0.5f;
    }

    public void invalidateLayout(KDContainer target) {
    }

    public void addLayoutComponent(String name, KDComponent comp) {
    }

    public void removeLayoutComponent(KDComponent comp) {
        this.info.remove(comp);
    }

    public Dimension preferredLayoutSize(KDContainer parent) {
        return this.getLayoutSize(parent, true);
    }

    public Dimension minimumLayoutSize(KDContainer parent) {
        return this.getLayoutSize(parent, false);
    }

    public void layoutContainer(KDContainer parent) {
        Insets insets = parent.getInsets();
        int count = parent.getComponentCount();
        int i = 0;
        while (i < count) {
            KDComponent component = parent.getComponent(i);
            if (component.isVisible()) {
                Rectangle r = this.getComponentBounds(component, true);
                component.setBounds(insets.getLeft() + r.getX(), insets.getTop() + r.getY(), r.getWidth(), r.getHeight());
            }
            ++i;
        }
    }

    public ILayoutRender getRender() {
        return null;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("XYLayout[width=").append(this.width).append(",height=").append(this.height).append("]")));
    }

    private Dimension getLayoutSize(KDContainer target, boolean doPreferred) {
        Dimension dim = new Dimension(0, 0);
        if (this.width <= 0 || this.height <= 0) {
            int count = target.getComponentCount();
            int i = 0;
            while (i < count) {
                KDComponent component = target.getComponent(i);
                if (component.isVisible()) {
                    Rectangle r = this.getComponentBounds(component, doPreferred);
                    dim.setWidth(Math.max(dim.getWidth(), r.getX() + r.getWidth()));
                    dim.setHeight(Math.max(dim.getHeight(), r.getY() + r.getHeight()));
                }
                ++i;
            }
        }
        if (this.width > 0) {
            dim.setWidth(this.width);
        }
        if (this.height > 0) {
            dim.setHeight(this.height);
        }
        Insets insets = target.getInsets();
        dim.setWidth(dim.getWidth() + insets.getLeft() + insets.getRight());
        dim.setHeight(dim.getHeight() + insets.getTop() + insets.getBottom());
        return dim;
    }

    private Rectangle getComponentBounds(KDComponent component, boolean doPreferred) {
        Rectangle r;
        XYConstraints constraints = (XYConstraints)this.info.get(component);
        if (constraints == null) {
            constraints = defaultConstraints;
        }
        if ((r = new Rectangle(constraints.x, constraints.y, constraints.width, constraints.height)).getWidth() <= 0 || r.getHeight() <= 0) {
            Dimension d;
            Dimension dimension = d = doPreferred ? component.getPreferredSize() : component.getMinimumSize();
            if (r.getWidth() <= 0) {
                r.setWidth(d.getWidth());
            }
            if (r.getHeight() <= 0) {
                r.setHeight(d.getHeight());
            }
        }
        return r;
    }
}

