/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.plaf;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.image.ImageManager;
import com.kingdee.bos.web.anole.layout.LayoutManager;
import com.kingdee.bos.web.anole.layout.XYLayout;
import com.kingdee.bos.web.anole.output.OutputElement;
import com.kingdee.bos.web.anole.style.Dimension;
import com.kingdee.bos.web.anole.style.Rectangle;
import javax.accessibility.Accessible;

public abstract class ComponentUI {
    protected OutputElement parentElement = null;

    public void installUI(KDComponent c) {
    }

    public void uninstallUI(KDComponent c) {
    }

    public OutputElement getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(OutputElement parentElement) {
        this.parentElement = parentElement;
    }

    public void paint(KDComponent c) {
    }

    public void update(KDComponent c) {
        this.paint(c);
    }

    public Dimension getPreferredSize(KDComponent c) {
        return null;
    }

    public Dimension getMinimumSize(KDComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(KDComponent c) {
        return this.getPreferredSize(c);
    }

    public boolean contains(KDComponent c, int x, int y) {
        return c.inside(x, y);
    }

    public static ComponentUI createUI(KDComponent c) {
        throw new Error("ComponentUI.createUI not implemented.");
    }

    public int getAccessibleChildrenCount(KDComponent c) {
        return 0;
    }

    public Accessible getAccessibleChild(KDComponent c, int i) {
        return null;
    }

    protected void renderChildren(KDComponent pCom, OutputElement pElement) {
        if (pCom.getComponentCount() > 0) {
            LayoutManager layout = pCom.getLayout();
            if (layout == null) {
                this.renderNull(pCom, pElement);
                return;
            }
            layout.getRender().render(pCom, pElement);
        }
    }

    protected String convertAlign(int align) {
        switch (align) {
            case 0: {
                return "center";
            }
            case 1: {
                return "top";
            }
            case 2: {
                return "left";
            }
            case 3: {
                return "bottom";
            }
            case 4: {
                return "right";
            }
        }
        return "left";
    }

    protected void renderNull(KDComponent pCom, OutputElement pElement) {
        int icount = pCom.getComponentCount();
        KDComponent[] comps = pCom.getComponents();
        int i = 0;
        while (i < icount) {
            KDComponent comp = comps[i];
            comp.paint(pElement);
            ++i;
        }
    }

    protected void estimateEnabled(KDComponent comp, OutputElement element) {
        if (!comp.isEnabled()) {
            element.addAttribute("disabled ");
        }
    }

    protected OutputElement initProperites(KDComponent comp) {
        OutputElement element = new OutputElement("span");
        this.initPosition(comp, element);
        return element;
    }

    protected void initPosition(KDComponent comp, OutputElement element) {
        KDComponent pCom = (KDComponent)comp.getParent();
        if (pCom != null && (pCom.getLayout() == null || pCom.getLayout() instanceof XYLayout)) {
            Rectangle rect = comp.getBounds();
            StringBuffer sb = new StringBuffer();
            if (pCom.getLayout() == null) {
                sb.append("position:absolute");
            } else if (pCom.getLayout() instanceof XYLayout) {
                sb.append("position:relative");
            }
            sb.append(";top:" + rect.getY());
            sb.append(";left:" + rect.getX());
            sb.append(";width:" + rect.getWidth());
            sb.append(";height:" + rect.getHeight());
            element.addAttribute("style", sb.toString());
        }
    }

    protected void addStyleProperties(KDComponent c, OutputElement element) {
        KDComponent pCom = (KDComponent)c.getParent();
        Rectangle rect = c.getBounds();
        StringBuffer sb = new StringBuffer();
        if (element.getAttribute("style") != null) {
            sb.append(element.getAttribute("style"));
        }
        sb.append(";width:" + rect.getWidth());
        sb.append(";height:" + rect.getHeight());
        if (c.getBackground() != null) {
            sb.append(";background-color:" + c.getBackground().toHexString());
        }
        sb.append(";color:" + c.getForeground().toHexString());
        sb.append(";font-size:" + c.getFont().getSize());
        if (c.getBackgroundImage() != null) {
            String fileName = ImageManager.putImageURL(c.getBackgroundImage());
            fileName = String.valueOf(fileName) + ".kdpng";
            sb.append(";background-image:url('" + fileName + "')");
        }
        element.addAttribute("style", sb.toString());
    }
}

