/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.utils.RegEx;
import com.kingdee.bos.web.anole.xmlparser.TreeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DeviceCapsConfig {
    private TreeNode rootNode = null;
    private Map platforms = null;
    private Map bits = null;
    private Map devices = null;

    public DeviceCapsConfig(TreeNode root) {
        this.rootNode = root;
        this.preLoadConfig();
    }

    public Map getBits() {
        return this.bits;
    }

    public Map getDevices() {
        return this.devices;
    }

    public Map getPlatforms() {
        return this.platforms;
    }

    public Map findDeviceCaps(String key, String version) {
        HashMap<String, String> deviceCaps = new HashMap<String, String>();
        TreeNode deviceNode = this.findDeviceNode(key);
        TreeNode deviceVerNode = this.findVersionNode(deviceNode, version);
        if (deviceVerNode != null) {
            Iterator items = deviceVerNode.findChildren();
            while (items.hasNext()) {
                TreeNode item = (TreeNode)items.next();
                deviceCaps.put(item.getName(), item.getBody());
            }
        }
        return deviceCaps;
    }

    private void preLoadConfig() {
        this.platforms = this.generateMap("platform");
        this.bits = this.generateMap("bit");
        this.devices = this.generateMap("device");
    }

    private Map generateMap(String strNodeName) {
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        TreeNode platformNode = this.rootNode.findChildByName(strNodeName);
        Iterator items = platformNode.findChildren();
        while (items.hasNext()) {
            TreeNode itemCase = (TreeNode)items.next();
            String key = itemCase.findAttribute("key");
            String match = itemCase.findAttribute("match");
            nodeMap.put(key, match);
        }
        return nodeMap;
    }

    private TreeNode findCapsRootNode() {
        TreeNode capsRootNode = this.rootNode.findChildByName("capabilities");
        return capsRootNode;
    }

    private TreeNode findDeviceNode(String key) {
        TreeNode deviceNode = this.findCapsRootNode().findChildByKey(key);
        return deviceNode;
    }

    private TreeNode findVersionNode(TreeNode deviceNode, String version) {
        if (deviceNode == null) {
            return null;
        }
        Iterator items = deviceNode.findChildrenByName("version");
        while (items.hasNext()) {
            TreeNode item = (TreeNode)items.next();
            if (!RegEx.match(item.findAttribute("match"), version)) continue;
            return item;
        }
        return null;
    }
}

