/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.runtime.DeviceCapsConfig;
import com.kingdee.bos.web.anole.runtime.UserAgent;
import java.util.Map;

public class HttpBrowserCapabilities {
    private Map items = null;
    private String browser = "Unknown";
    private String platform = "Unknown";
    private String preferredRenderingType = "html32";
    private String preferredRenderingMime = "text/html";
    private String preferredImageMime = "image/gif";
    private String version = "0";
    private float msdomversion = 0.0f;
    private float w3cdomversion = 0.0f;
    private float minorversion = 0.0f;
    private int majorversion = 0;
    private boolean frames = false;
    private boolean tables = false;
    private boolean cookies = false;
    private boolean backgroundsounds = false;
    private boolean vbscript = false;
    private boolean javascript = false;
    private boolean javaapplets = false;
    private boolean activexcontrols = false;
    private boolean win16 = false;
    private boolean win32 = false;
    private boolean beta = false;
    private boolean aol = false;
    private boolean css1 = false;
    private boolean css2 = false;
    private boolean xml = false;
    private boolean mobileDevice = false;

    public HttpBrowserCapabilities(UserAgent agent, DeviceCapsConfig deviceCapsConfig) {
        this.readUserAgent(agent);
        this.loadCapsConfig(deviceCapsConfig);
    }

    public boolean isActiveXControls() {
        this.activexcontrols = this.findBoolValue(this.frames, "activexcontrols");
        return this.activexcontrols;
    }

    public boolean isAOL() {
        this.aol = this.findBoolValue(this.frames, "aol");
        return this.aol;
    }

    public boolean isBackgroundsounds() {
        this.backgroundsounds = this.findBoolValue(this.frames, "backgroundsounds");
        return this.backgroundsounds;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public String getBrowser() {
        return this.browser;
    }

    public boolean isCookies() {
        return this.cookies;
    }

    public boolean isCss1() {
        return this.css1;
    }

    public boolean isCss2() {
        return this.css2;
    }

    public boolean isFrames() {
        this.frames = this.findBoolValue(this.frames, "frames");
        return this.frames;
    }

    public boolean isMobileDevice() {
        return this.mobileDevice;
    }

    public boolean isJavaapplets() {
        this.javaapplets = this.findBoolValue(this.frames, "javaapplets");
        return this.javaapplets;
    }

    public boolean isJavascript() {
        this.javascript = this.findBoolValue(this.frames, "javascript");
        return this.javascript;
    }

    public int getMajorversion() {
        return this.majorversion;
    }

    public float getMinorversion() {
        return this.minorversion;
    }

    public float getMsdomversion() {
        this.msdomversion = this.findFloatValue(this.msdomversion, "msdomversion");
        return this.msdomversion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPreferredImageMime() {
        return this.preferredImageMime;
    }

    public String getPreferredRenderingMime() {
        return this.preferredRenderingMime;
    }

    public String getPreferredRenderingType() {
        return this.preferredRenderingType;
    }

    public boolean isTables() {
        return this.tables;
    }

    public boolean isVbscript() {
        this.vbscript = this.findBoolValue(this.frames, "vbscript");
        return this.vbscript;
    }

    public String getVersion() {
        return this.version;
    }

    public float getW3cdomversion() {
        this.w3cdomversion = this.findFloatValue(this.w3cdomversion, "w3cdomversion");
        return this.w3cdomversion;
    }

    public boolean isWin16() {
        return this.win16;
    }

    public boolean isWin32() {
        return this.win32;
    }

    public boolean isXml() {
        this.xml = this.findBoolValue(this.frames, "xml");
        return this.xml;
    }

    protected String findStringValue(String var, String strKey) {
        Object o = this.items.get(strKey);
        return o != null ? (String)o : var;
    }

    protected int findIntValue(int var, String strKey) {
        Object o = this.items.get(strKey);
        return o != null ? Integer.valueOf((String)o) : var;
    }

    protected boolean findBoolValue(boolean var, String strKey) {
        Object o = this.items.get(strKey);
        return o != null ? Boolean.valueOf((String)o) : var;
    }

    protected float findFloatValue(float var, String strKey) {
        Object o = this.items.get(strKey);
        return o != null ? Float.valueOf((String)o).floatValue() : var;
    }

    private void readUserAgent(UserAgent agent) {
        this.browser = agent.getBrowser();
        this.version = agent.getVersion();
        this.majorversion = agent.getMajorversion();
        this.minorversion = agent.getMinorversion();
        this.mobileDevice = agent.isMobileDevice();
        this.beta = agent.isBeta();
        this.platform = agent.getPlatform();
        this.win16 = agent.isWin16();
        this.win32 = agent.isWin32();
    }

    private void loadCapsConfig(DeviceCapsConfig deviceCapsConfig) {
        this.items = deviceCapsConfig.findDeviceCaps(this.getBrowser(), this.getVersion());
        if (!this.items.isEmpty()) {
            this.preferredRenderingType = this.findStringValue(this.preferredRenderingType, "preferredRenderingType");
            this.preferredRenderingMime = this.findStringValue(this.preferredRenderingMime, "preferredRenderingMime");
            this.preferredImageMime = this.findStringValue(this.preferredImageMime, "preferredImageMime");
            this.cookies = this.findBoolValue(this.frames, "cookies");
            this.tables = this.findBoolValue(this.frames, "tables");
            this.css1 = this.findBoolValue(this.frames, "css1");
            this.css2 = this.findBoolValue(this.frames, "css2");
        }
    }
}

